// Global variable for margin
var g_ListMargin = "0.5em";

// Initialization of the Tree
function initTree(oList, l_Margin)
{
     // set global variable
     g_ListMargin = l_Margin;

     // collapses the tree
     oList.style.marginLeft = g_ListMargin;
     oList.style.listStyleImage = "url(TreeCollapsed.gif)";
     for (var i=0; i < oList.getElementsByTagName("ul").length; i++)
     {
         oList.getElementsByTagName("ul")[i].style.display = "none";
         oList.getElementsByTagName("ul")[i].style.marginLeft = g_ListMargin;
         oList.getElementsByTagName("ul")[i].style.listStyleImage = "url(TreeCollapsed.gif)";
     }

     // adds the click-event handler to the list items
     if (oList.addEventListener)
     {
         oList.addEventListener("click", onBranchClick, false);
     }
     else if (oList.attachEvent)
     {
         oList.attachEvent("onclick", onBranchClick);
     }
     // prepares the appearence of the tree
     prepareBranches(oList);
}

// Removes selection after click on Tree
function RemoveSelection() 
{
    if (window.getSelection) 
    {  // all browsers, except IE before version 9
        var selection = window.getSelection();                                        
        selection.removeAllRanges();
    }
    else 
    {
        if (document.selection.createRange) 
        {        // Internet Explorer
            var range = document.selection.createRange();
            document.selection.empty();
        }
    }
}

// Click-event handler
function onBranchClick(event)
{
     var oBranch, cSubBranches;
     
	 RemoveSelection();
	 
     if (event.target)
     {
         oBranch = event.target;
     }
     else if (event.srcElement)
     {
         oBranch = event.srcElement;
     }
     cSubBranches = oBranch.getElementsByTagName("ul");
     if (cSubBranches.length > 0)
     {
         if (cSubBranches[0].style.display == "block")
         {
             cSubBranches[0].style.display = "none";
             oBranch.style.marginLeft = g_ListMargin;
             oBranch.style.listStyleImage = "url(TreeCollapsed.gif)";
         }
         else
         {
             cSubBranches[0].style.display = "block";
             oBranch.style.marginLeft = g_ListMargin;
             oBranch.style.listStyleImage = "url(TreeExpanded.gif)";
         }
     }
}

// Prepares the appearance of the tree
function prepareBranches(oList)
{
     var cBranches = oList.getElementsByTagName("li");
     var i, n, cSubBranches;
     if (cBranches.length > 0)
     {
         for (i=0, n = cBranches.length; i < n; i++)
         {
             cSubBranches = cBranches[i].getElementsByTagName("ul");
             if (cSubBranches.length > 0)
             {
                 cBranches[i].style.marginLeft = g_ListMargin;
                 prepareBranches(cSubBranches[0]);
                 cSubBranches[0].style.cursor = "auto";
             }
             else
             {
                 cBranches[i].style.marginLeft = g_ListMargin;
                 cBranches[i].style.listStyleImage = "none";
             }
         }
     }
}
