/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tree
implements Iterator {
    private List Children = new ArrayList();
    private Tree parent = null;
    private Object data = null;
    private int iCurIterChild = 0;

    public Tree() {
    }

    public Tree(Tree parent) {
        this.data = null;
        this.parent = parent;
    }

    public Tree(Object data) {
        this.data = data;
        this.parent = null;
    }

    public Tree(Object data, Tree parent) {
        this.data = data;
        this.parent = parent;
    }

    public boolean isNodeEmpty() {
        return this.data == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isEmpty() {
        return this.data == null && this.parent == null && this.Children.size() == 0;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public Tree getParent() {
        return this.parent;
    }

    public void setParent(Tree parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.Children;
    }

    public void setChildren(List Children) {
        this.Children = Children;
    }

    public int numChildren() {
        return this.Children.size();
    }

    public void addChild(Tree sub) {
        sub.setParent(this);
        this.Children.add(sub);
    }

    public Tree getLastChild() {
        Tree tReturn = null;
        int iNumChilds = this.Children.size();
        if (iNumChilds > 0) {
            tReturn = (Tree)this.Children.get(iNumChilds - 1);
        }
        return tReturn;
    }

    public int getNestingDepth() {
        Tree curNode = this;
        int iDepth = 0;
        while (!curNode.isRoot()) {
            ++iDepth;
            curNode = curNode.getParent();
        }
        return iDepth;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        String sPadding = "";
        int iDepth = this.getNestingDepth();
        int i = 0;
        while (i < iDepth) {
            sPadding = String.valueOf(sPadding) + "  ";
            ++i;
        }
        String sCurValue = "";
        if (!this.isNodeEmpty()) {
            sCurValue = this.data.toString();
        }
        out.println(String.valueOf(sPadding) + sCurValue);
        out.println(String.valueOf(sPadding) + "{ (depth=" + iDepth + ", childs=" + this.Children.size() + ")");
        int i2 = 0;
        while (i2 < this.Children.size()) {
            Tree curChild = (Tree)this.Children.get(i2);
            curChild.print(out);
            ++i2;
        }
        out.println(String.valueOf(sPadding) + "}");
    }

    public Tree find(Object o) {
        Tree tReturn = null;
        if (this.data.equals(o)) {
            tReturn = this;
        } else {
            int iNumChildren = this.Children.size();
            int i = 0;
            while (i < iNumChildren) {
                Tree curChild = (Tree)this.Children.get(i);
                tReturn = curChild.find(o);
                ++i;
            }
        }
        return tReturn;
    }

    public int findDepthOf(Object o) {
        Tree tFound = this.find(o);
        if (tFound != null) {
            return tFound.getNestingDepth();
        }
        return -1;
    }

    public boolean hasNext() {
        boolean bReturn = false;
        if (this.Children.size() > 0 && this.iCurIterChild < this.Children.size()) {
            bReturn = true;
        } else if (this.parent != null) {
            bReturn = this.parent.hasNext();
        }
        return bReturn;
    }

    public Object next() {
        Tree nextNode = null;
        if (this.Children.size() > 0 && this.iCurIterChild < this.Children.size()) {
            nextNode = (Tree)this.Children.get(this.iCurIterChild);
            nextNode.iCurIterChild = 0;
            ++this.iCurIterChild;
        } else if (this.parent != null) {
            nextNode = (Tree)this.parent.next();
        }
        return nextNode;
    }

    public void remove() {
    }
}

