/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.LaTeX;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocListItem;
import de.enache.AutoDoc.AutoDocOutput;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagParameterList;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.Tree;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;

public abstract class AutoDocLaTeXOut
extends AutoDocOutput {
    protected String HeadInsFileStr = "";
    protected String FootInsFileStr = "";
    protected String FileTemplateStr = "";
    protected String OutputTemplateStr = "";
    protected ArrayList vDeletePattern = new ArrayList();
    protected ArrayList vAuthors = new ArrayList();
    protected static final String sReplBackslash = "@?!+!?latbs?!+!?@";
    protected static final String sReplUnderline = "?!+!?latul?!+!?";
    protected static final String sReplPercent = "?!+!?latpc?!+!?";
    protected static final String sReplAmp = "?!+!?latam?!+!?";
    protected static final String sReplDollar = "?!+!?latdo?!+!?";
    protected static final String sReplHash = "?!+!?latha?!+!?";
    protected static final String sReplCirc = "?!+!?latci?!+!?";
    protected static final String sReplCurlOpen = "?!+!?latcbop?!+!?";
    protected static final String sReplCurlClose = "?!+!?latcbcl?!+!?";
    protected static final String sReplCurlLess = "?!+!?latle?!+!?";
    protected static final String sReplCurlGreater = "?!+!?latgr?!+!?";
    protected static final char[] caVerbSymb = new char[]{'|', '@', '\"', '\'', '!', '?', '/', '-', '+', ',', '.'};
    protected static final String sSummarySize = "tiny";

    protected AutoDocLaTeXOut(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
        this.HeadInsFileStr = this.ascFileToString(mySettings.getHeaderInsFile());
        this.FootInsFileStr = this.ascFileToString(mySettings.getFootInsFile());
        this.FileTemplateStr = "%CONTENT%";
        this.OutputTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_LaTeX.tex"));
        this.declareDeletePatterns();
    }

    public int[] preprocessFile(AutoDocFile curFile, String sOutFil, int iFilenum) {
        int[] iaNumLevel = super.preprocessFile(curFile, sOutFil, iFilenum);
        ArrayList treeList = curFile.getTagTreeList();
        int iTreeListSize = treeList.size();
        int i = 0;
        while (i < iTreeListSize) {
            int curLevel;
            Tree curTree = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curTree.getData();
            ArrayList curChilds = (ArrayList)curTree.getChildren();
            if (curTag != null && (curLevel = curTag.getLevel()) == 1 && curChilds != null) {
                int iNumChilds = curChilds.size();
                int j = 0;
                while (j < iNumChilds) {
                    AutoDocTagParameterList curParms;
                    String sAuthor;
                    int iPos;
                    Tree curChildNode = (Tree)curChilds.get(j);
                    AutoDocTag curChildTag = (AutoDocTag)curChildNode.getData();
                    if (curChildTag.getTagInfo().isAuthor() && (iPos = this.vAuthors.indexOf(sAuthor = this.removeGrpWordDelim((curParms = this.getParameters(curChildTag, curFile, sOutFil)).get(0).toString().trim()))) < 0) {
                        this.vAuthors.add(sAuthor);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        Collections.sort(this.vAuthors);
        return iaNumLevel;
    }

    public void declareDeletePatterns() {
        String sResDir;
        File fRes;
        String sTemplate;
        String sLogo;
        this.vDeletePattern.add("AutoDoc.tex");
        this.vDeletePattern.add("AutoDoc.log");
        this.vDeletePattern.add("AutoDoc.aux");
        this.vDeletePattern.add("AutoDoc.dvi");
        this.vDeletePattern.add("AutoDoc.out");
        this.vDeletePattern.add("AutoDoc.toc");
        this.vDeletePattern.add("AutoDoc.pdf");
        String sTemplFile = this.mySettings.getStyleDefFile();
        if (!sTemplFile.equals("")) {
            File fTemplFile = new File(sTemplFile);
            this.vDeletePattern.add(fTemplFile.getName());
        }
        if (!(sLogo = this.mySettings.getLogo()).equals("")) {
            File fLogo = new File(sLogo);
            this.vDeletePattern.add(fLogo.getName());
        }
        if (!(sTemplate = this.mySettings.getTemplateDir()).equals("") && (fRes = new File(sResDir = String.valueOf(sTemplate = FileUtils.toCanonicalPath(sTemplate)) + "/res")).exists() && fRes.isDirectory()) {
            File[] fList = fRes.listFiles();
            int i = 0;
            while (i < fList.length) {
                this.vDeletePattern.add(fList[i].getName());
                ++i;
            }
        }
    }

    protected void prepareOutputLoop() {
        File fDir = new File(this.Outpath);
        if (!fDir.exists()) {
            fDir.mkdirs();
        } else {
            if (!fDir.isDirectory()) {
                throw new Error(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTDIRINVALID", this.Outpath));
            }
            this.cleanOutDir();
        }
        this.copyResources();
        this.copyTemplateFiles();
    }

    public void copyTemplateFile(String sTemplateName, String sOutpath) {
        String sTemplFilename = this.getTemplatePath(sTemplateName);
        try {
            FileUtils.copy(sTemplFilename, String.valueOf(sOutpath) + "/" + sTemplateName);
        }
        catch (Exception e) {
            SystemUtils.println(e.getMessage());
        }
    }

    public void copyResources() {
        String sResDir = String.valueOf(this.mySettings.getTemplateDir()) + "/res";
        try {
            FileUtils.copyDir(sResDir, this.Outpath);
        }
        catch (IOException e) {
            SystemUtils.println(e.getMessage());
        }
    }

    public void copyTemplateFiles() {
        String sTemplFile = this.mySettings.getStyleDefFile();
        try {
            if (!sTemplFile.equals("")) {
                File fTmp = new File(sTemplFile);
                String sShortName = fTmp.getName();
                String sAbsName = FileUtils.toCanonicalPath(fTmp);
                try {
                    FileUtils.copy(sAbsName, String.valueOf(this.Outpath) + "/" + sShortName);
                }
                catch (FileNotFoundException e) {
                    SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("NOTE_LATEXOUTCOPYTEMPLATENOTFOUND", sTemplFile));
                }
                catch (Exception e2) {
                    SystemUtils.println(e2.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mySettings.getMsgHandler().outputWarning("WARN_OUTCOPYTEMPLATEFAILED", sTemplFile);
        }
        String sLogo = this.mySettings.getLogo();
        try {
            if (!sLogo.equals("")) {
                File fTmp = new File(sLogo);
                String sShortName = fTmp.getName();
                String sAbsName = FileUtils.toCanonicalPath(fTmp);
                FileUtils.copy(sAbsName, String.valueOf(this.Outpath) + "/" + sShortName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mySettings.getMsgHandler().outputWarning("WARN_OUTCOPYFILEFAILED", sLogo);
        }
    }

    public String convertCode(String s, boolean bPreserve) {
        String sReturn = "";
        int iCr = s.indexOf("\n");
        if (!bPreserve && iCr >= 0) {
            sReturn = String.valueOf(this.SysNewLine) + sReplBackslash + "begin" + sReplCurlOpen + "verbatim" + sReplCurlClose + this.escapeSpecialChars(s.replaceFirst("\\s*\\n", "")) + this.SysNewLine + sReplBackslash + "end" + sReplCurlOpen + "verbatim" + sReplCurlClose + this.SysNewLine;
        } else if (bPreserve) {
            sReturn = "@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?verbatim?!+!?latcbcl?!+!?" + this.escapeSpecialChars(s.trim()) + sReplBackslash + "end" + sReplCurlOpen + "verbatim" + sReplCurlClose;
        } else {
            String sTmp = s.trim();
            String sVerbDel = this.getVerbDelimiter(sTmp);
            sReturn = "?!+!?latcbop?!+!?@?!+!?latbs?!+!?@verb" + sVerbDel + this.escapeSpecialChars(sTmp) + sVerbDel + sReplCurlClose;
        }
        return sReturn;
    }

    public String getVerbDelimiter(String s) {
        String sVerbDel = "" + caVerbSymb[0];
        int i = 0;
        while (i < caVerbSymb.length) {
            if (s.indexOf(caVerbSymb[i]) < 0) {
                sVerbDel = "" + caVerbSymb[i];
                break;
            }
            ++i;
        }
        return sVerbDel;
    }

    public String convertBold(String s) {
        return "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertItalic(String s) {
        return "@?!+!?latbs?!+!?@textit?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertEmphasized(String s) {
        return "@?!+!?latbs?!+!?@emph?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertTrueType(String s) {
        return "@?!+!?latbs?!+!?@texttt ?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertStrikeThrough(String s) {
        return "@?!+!?latbs?!+!?@sout?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertUnderline(String s) {
        return "@?!+!?latbs?!+!?@underline?!+!?latcbop?!+!?" + s + sReplCurlClose;
    }

    public String convertNewLine() {
        return "@?!+!?latbs?!+!?@@?!+!?latbs?!+!?@";
    }

    public String convertSingleQuote() {
        return "'";
    }

    public String convertDoubleQuote() {
        return "\"";
    }

    public String convertImage(String sImgFileName, String sOrientation) {
        String sReturn = "";
        String sDimTemp = this.getImageDims(String.valueOf(this.Outpath) + "/" + sImgFileName);
        String sDims = "";
        if (!sDimTemp.equals("")) {
            String[] saTmp = sDimTemp.split(";");
            sDims = saTmp.length >= 1 ? String.valueOf(sDims) + "natwidth=" + saTmp[0] + "px, " : String.valueOf(sDims) + "natwidth=0px, ";
            sDims = saTmp.length >= 2 ? String.valueOf(sDims) + "natheight=" + saTmp[1] + "px" : String.valueOf(sDims) + "natheight=0px";
            sReturn = "@?!+!?latbs?!+!?@includegraphics[" + sDims + "]" + sReplCurlOpen + this.escapeSpecialChars(sImgFileName) + sReplCurlClose;
        } else {
            sReturn = "@?!+!?latbs?!+!?@includegraphics?!+!?latcbop?!+!?" + this.escapeSpecialChars(sImgFileName) + sReplCurlClose;
        }
        return sReturn;
    }

    public String convertCitation(String sRef, ArrayList bibList, String sRefFileName, boolean bGlobal) {
        int iFound;
        String sText = "";
        if (bibList != null && (iFound = this.findBibRef(sRef, bibList)) >= 0) {
            String sNewRef = this.createXRefLabel(sRefFileName, sRef);
            sNewRef = this.convertLinkToStringInternal(sNewRef, "{" + sRef + "}", false);
            sText = bGlobal ? "@?!+!?latbs?!+!?@cite?!+!?latcbop?!+!?" + sRef + sReplCurlClose : sNewRef;
        }
        return sText;
    }

    public String convertReferenceTag(String sRef, ArrayList bibList, String sRefFileName, boolean bGlobal) {
        int iFound;
        String sText = "";
        if (bibList != null && (iFound = this.findBibRef(sRef, bibList)) >= 0) {
            sText = bGlobal ? "@?!+!?latbs?!+!?@cite?!+!?latcbop?!+!?" + sRef + sReplCurlClose : "{" + sRef + "}";
        }
        return sText;
    }

    public String forceWellFormedURL(String sLink) {
        String sReturn = sLink;
        try {
            URL url = new URL(sReturn);
            sReturn = url.toString();
        }
        catch (MalformedURLException e) {
            sReturn = "file:///" + sReturn.replaceAll("\\\\", "/");
        }
        return sReturn;
    }

    public String convertLinkToStringInternal(String sLink, String sLabel, boolean bURL) {
        if (bURL) {
            sLink = this.forceWellFormedURL(sLink);
        }
        return "@?!+!?latbs?!+!?@hyperref[" + this.escapeSpecialChars(sLink) + "]" + sReplCurlOpen + sLabel + sReplCurlClose;
    }

    public String convertLinkToStringNavigation(String sLink, String sLabel, boolean bURL) {
        if (bURL) {
            sLink = this.forceWellFormedURL(sLink);
        }
        return "@?!+!?latbs?!+!?@hyperref[" + this.escapeSpecialChars(sLink) + "]" + sReplCurlOpen + sLabel + sReplCurlClose;
    }

    public String convertLinkToStringExternal(String sLink, String sLabel, boolean bURL) {
        if (bURL) {
            sLink = this.forceWellFormedURL(sLink);
        }
        sLabel = AutoDocStringUtils.replaceAll(sLabel, "\\", "/");
        return "@?!+!?latbs?!+!?@href?!+!?latcbop?!+!?" + this.escapeSpecialChars(sLink) + sReplCurlClose + sReplCurlOpen + sReplBackslash + "nolinkurl" + sReplCurlOpen + this.escapeSpecialChars(sLabel) + sReplCurlClose + sReplCurlClose;
    }

    public String convertParagraphs(String s) {
        String sTmp = s;
        if (!this.SysNewLine.equals("\n")) {
            sTmp = AutoDocStringUtils.replaceAll(s, this.SysNewLine, "\n");
        }
        String sResult = sTmp.replaceAll("[ \\t\\x0B\\f\\r]*\\n[ \\t\\x0B\\f\\r]*\\n[ \\t\\x0B\\f\\r]*", "\n");
        if (!this.SysNewLine.equals("\n")) {
            sResult = AutoDocStringUtils.replaceAll(sResult, "\n", this.SysNewLine);
        }
        return sResult;
    }

    public String convertItemList(ArrayList vItems) {
        String sReturn = "";
        boolean bListOpen = false;
        int iType = 0;
        int i = 0;
        while (i < vItems.size()) {
            AutoDocListItem curItem = (AutoDocListItem)vItems.get(i);
            if (curItem.iItemType == 0) {
                if (bListOpen) {
                    sReturn = iType == 1 ? String.valueOf(sReturn) + "@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?enumerate?!+!?latcbcl?!+!?" + this.SysNewLine : String.valueOf(sReturn) + "@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?" + this.SysNewLine;
                    bListOpen = false;
                }
                sReturn = String.valueOf(sReturn) + curItem.sValue + this.SysNewLine;
            } else if (curItem.iItemType == 1) {
                iType = 1;
                if (!bListOpen) {
                    sReturn = String.valueOf(sReturn) + "@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?enumerate?!+!?latcbcl?!+!?" + this.SysNewLine;
                    bListOpen = true;
                }
                sReturn = String.valueOf(sReturn) + "@?!+!?latbs?!+!?@item " + curItem.sValue + this.SysNewLine;
            } else {
                iType = 2;
                if (!bListOpen) {
                    sReturn = String.valueOf(sReturn) + "@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?" + this.SysNewLine;
                    bListOpen = true;
                }
                sReturn = String.valueOf(sReturn) + "@?!+!?latbs?!+!?@item " + curItem.sValue + this.SysNewLine;
            }
            ++i;
        }
        if (bListOpen) {
            sReturn = iType == 1 ? String.valueOf(sReturn) + "@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?enumerate?!+!?latcbcl?!+!?" + this.SysNewLine : String.valueOf(sReturn) + "@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?" + this.SysNewLine;
            bListOpen = false;
        }
        return sReturn;
    }

    public void outputFile(byte[] baRes, String sFullOutFil, String sOrgFile) throws FileNotFoundException, IOException {
        String s1 = this.FileTemplateStr;
        String sCont = new String(baRes);
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sOrgFile;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void processFileHeading(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType) {
        if (!sOrgFile.equals("") && !sFileType.equals("")) {
            psOut.println("@?!+!?latbs?!+!?@subsection?!+!?latcbop?!+!?" + sFileType + ": " + sOrgFile + sReplCurlClose);
        }
    }

    public void processOverview(PrintStream psOut, String sOutFil, int[] iaNumLevel) {
        psOut.println("@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_OVERVIEW") + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?");
        if (iaNumLevel[0] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec1", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_GENERALINFO"), false));
        }
        if (iaNumLevel[1] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec2", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTURE"), false));
        }
        if (iaNumLevel[2] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec3", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONS"), false));
        }
        psOut.println("@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?");
    }

    public String generateOutputFileName(int iIndex) {
        String sOutFil = "Autodoc" + iIndex + ".tex";
        return sOutFil;
    }

    public void processOverviewHeading(PrintStream psOut) {
    }

    public void processOverviewEntry(PrintStream psOut, String sLink, String sDescription) {
    }

    public void processOverviewEnd(PrintStream psOut) {
    }

    public void processStructureHeader(PrintStream psOut, String sTitle, String sTagName, String sRootLabel, String sRootFilnam, String sRootDescription) {
        psOut.println("@?!+!?latbs?!+!?@subsection?!+!?latcbop?!+!?" + sTitle + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sTagName + ":sec2" + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@subsubsection*?!+!?latcbop?!+!?" + sRootLabel + ": " + sRootFilnam + sReplCurlClose);
        psOut.println(String.valueOf(this.processParam(sRootDescription, true, false)) + this.SysNewLine + this.SysNewLine);
    }

    public void processStructDetailHead(PrintStream psOut, String curLabel, String sShort, String sDescription) {
        psOut.println("@?!+!?latbs?!+!?@paragraph?!+!?latcbop?!+!?" + curLabel + ": " + sShort + sReplCurlClose);
        psOut.println(String.valueOf(this.processParam(sDescription, true, false)) + this.SysNewLine + this.SysNewLine);
    }

    public void processStructDetailBegin(PrintStream psOut) {
        psOut.print("");
    }

    public void processStructDetailEnd(PrintStream psOut) {
        psOut.print("");
    }

    public void processStructureDetailsHeading(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTUREDETAIL") + sReplCurlClose);
    }

    public void processParamTableBegin(PrintStream psOut, int iNumPara) {
        psOut.println();
        psOut.print("@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?tabularx?!+!?latcbcl?!+!??!+!?latcbop?!+!?@?!+!?latbs?!+!?@textwidth?!+!?latcbcl?!+!??!+!?latcbop?!+!?");
        int i = 0;
        while (i < iNumPara) {
            psOut.print("X");
            ++i;
        }
        psOut.println(sReplCurlClose);
    }

    public void processParamTableEnd(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?tabularx?!+!?latcbcl?!+!?");
        psOut.println();
    }

    public void processParamRowBegin(PrintStream psOut) {
        psOut.print("");
    }

    public void processParamCell(PrintStream psOut, String sText, int iNumPara, int iIndex) {
        if (iIndex < iNumPara - 1) {
            psOut.print(String.valueOf(sText) + " " + sReplAmp + " ");
        } else {
            psOut.print(sText);
        }
    }

    public void processParamSimple(PrintStream psOut, String sText) {
        psOut.println(String.valueOf(sText) + this.SysNewLine);
    }

    public void processParamRowEnd(PrintStream psOut) {
        psOut.println(" @?!+!?latbs?!+!?@@?!+!?latbs?!+!?@");
    }

    public void processGroupingTreeTitle(PrintStream psOut, String sTitle) {
        psOut.println("@?!+!?latbs?!+!?@section?!+!?latcbop?!+!?" + sTitle + sReplCurlClose);
    }

    public void processGroupingTreeBegin(PrintStream psOut, String sIDOrg, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + sReplBackslash + "begin" + sReplCurlOpen + "itemize" + sReplCurlClose);
    }

    public void processGroupingTreeEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + sReplBackslash + "end" + sReplCurlOpen + "itemize" + sReplCurlClose);
    }

    public void processGroupingTreeItemBegin(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.print(String.valueOf(sPad) + sReplBackslash + "item ");
    }

    public void processGroupingTreeItemEnd(PrintStream psOut, int iDepth) {
        psOut.print("");
    }

    public void processGroupingTreeEntry(PrintStream psOut, String sText, boolean bNewLine) {
        psOut.println(sText);
    }

    public void processStructListBegin(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + sReplBackslash + "begin" + sReplCurlOpen + "itemize" + sReplCurlClose);
    }

    public void processStructListEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + sReplBackslash + "end" + sReplCurlOpen + "itemize" + sReplCurlClose);
    }

    public void processStructItemBegin(PrintStream psOut, String sType, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + sReplBackslash + "item ");
    }

    public void processStructItemEnd(PrintStream psOut, String sType, int iDepth) {
        psOut.print("");
    }

    public void processStructEntry(PrintStream psOut, String sText, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "  " + sText);
    }

    public void processEmptyParagraph(PrintStream psOut) {
        psOut.println();
    }

    public String getDoubleQuote() {
        return "\"";
    }

    public void processFileLink(PrintStream psOut, AutoDocFile curFile) {
        String sAbsName = curFile.getAbsoluteFilenameForOutput();
        String sLabel = curFile.getAbsoluteFilenameLabelForOutput();
        psOut.println(String.valueOf(this.SysNewLine) + this.convertBold(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LINKTOCODE")) + ": " + this.convertLinkToStringExternal(sAbsName, sLabel, true) + this.SysNewLine);
    }

    public void processFileInfoOutput(PrintStream psOut, String curLabel, String sFilnam, String sDescrOut) {
        psOut.println("@?!+!?latbs?!+!?@subsubsection*?!+!?latcbop?!+!?" + curLabel + ": " + sFilnam + sReplCurlClose);
        psOut.println(sDescrOut);
    }

    public void processFileInfoHeading(PrintStream psOut, String sTitle, String sTagName) {
        psOut.println();
        psOut.println("@?!+!?latbs?!+!?@subsection?!+!?latcbop?!+!?" + sTitle + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sTagName + ":sec1" + sReplCurlClose);
    }

    public void processSimpleRowBegin(PrintStream psOut) {
        psOut.print("");
    }

    public void processSimpleRowEnd(PrintStream psOut) {
        psOut.println(" @?!+!?latbs?!+!?@@?!+!?latbs?!+!?@");
        psOut.println("@?!+!?latbs?!+!?@hline");
    }

    public void processSimpleTableCell(PrintStream psOut, String sText, int iNumPara, int iIndex) {
        if (iIndex < iNumPara - 1) {
            psOut.print(String.valueOf(sText) + " " + sReplAmp + " ");
        } else {
            psOut.print(sText);
        }
    }

    public String createVarSummaryTableHeader() {
        String sHead = "@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARSUM") + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplCurlOpen + sReplBackslash + sSummarySize;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplBackslash + "begin" + sReplCurlOpen + "tabularx" + sReplCurlClose + sReplCurlOpen + sReplBackslash + "textwidth" + sReplCurlClose + sReplCurlOpen + "|X|X|X|" + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARFIELD") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARTYPE") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + sReplCurlClose + " " + sReplBackslash + sReplBackslash + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        return sHead;
    }

    public String createVarIndexTableHeader() {
        String sHeaderLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARSUM");
        String sHead = "@?!+!?latbs?!+!?@section*?!+!?latcbop?!+!?" + sHeaderLabel + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@addcontentsline?!+!?latcbop?!+!?toc?!+!?latcbcl?!+!??!+!?latcbop?!+!?section?!+!?latcbcl?!+!??!+!?latcbop?!+!?@?!+!?latbs?!+!?@protect?!+!?latcbop?!+!?" + sHeaderLabel + sReplCurlClose + sReplCurlClose;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplCurlOpen + sReplBackslash + sSummarySize;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplBackslash + "begin" + sReplCurlOpen + "tabularx" + sReplCurlClose + sReplCurlOpen + sReplBackslash + "textwidth" + sReplCurlClose + sReplCurlOpen + "|X|X|X|X|" + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARFIELD") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARTYPE") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILE") + sReplCurlClose + " " + sReplBackslash + sReplBackslash + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        return sHead;
    }

    public String createLibnameSummaryTableHeader() {
        String sHead = "@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMESUM") + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplBackslash + "begin" + sReplCurlOpen + "tabularx" + sReplCurlOpen + sReplBackslash + "textwidth" + sReplCurlClose + sReplCurlClose + sReplCurlOpen + "|X|X|X|X|" + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMELOCATION") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMENAME") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMEDEF") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + sReplCurlClose + " " + sReplBackslash + sReplBackslash + this.SysNewLine + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        return sHead;
    }

    public void processSummaryTableEnd(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?tabularx?!+!?latcbcl?!+!?");
        psOut.println(sReplCurlClose);
        psOut.println();
    }

    public String createFuncSummaryTableHeader() {
        String sHead = "@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONSSUM") + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplCurlOpen + sReplBackslash + sSummarySize;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplBackslash + "begin" + sReplCurlOpen + "tabularx" + sReplCurlClose + sReplCurlOpen + sReplBackslash + "textwidth" + sReplCurlClose + sReplCurlOpen + "|X|X|X|" + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCMETHMAC") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTYPE") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + sReplCurlClose + " " + sReplBackslash + sReplBackslash + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        return sHead;
    }

    public String createFuncIndexTableHeader() {
        String sHeaderLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONSSUM");
        String sHead = "@?!+!?latbs?!+!?@section*?!+!?latcbop?!+!?" + sHeaderLabel + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@addcontentsline?!+!?latcbop?!+!?toc?!+!?latcbcl?!+!??!+!?latcbop?!+!?section?!+!?latcbcl?!+!??!+!?latcbop?!+!?@?!+!?latbs?!+!?@protect?!+!?latcbop?!+!?" + sHeaderLabel + sReplCurlClose + sReplCurlClose;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplCurlOpen + sReplBackslash + sSummarySize;
        sHead = String.valueOf(sHead) + this.SysNewLine + sReplBackslash + "begin" + sReplCurlOpen + "tabularx" + sReplCurlClose + sReplCurlOpen + sReplBackslash + "textwidth" + sReplCurlClose + sReplCurlOpen + "|X|X|X|X|" + sReplCurlClose + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCMETHMAC") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTYPE") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + sReplCurlClose + " " + sReplAmp + " " + sReplBackslash + "textbf" + sReplCurlOpen + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILE") + sReplCurlClose + " " + sReplBackslash + sReplBackslash + this.SysNewLine;
        sHead = String.valueOf(sHead) + "@?!+!?latbs?!+!?@hline" + this.SysNewLine;
        return sHead;
    }

    public void processLocalRefTableCell(PrintStream psOut, String sLink, String sText, int iNumPara, int iIndex) {
        if (iIndex < iNumPara - 1) {
            psOut.print("@?!+!?latbs?!+!?@hyperref[" + this.escapeSpecialChars(sLink) + "]" + sReplCurlOpen + sText + sReplCurlClose + " " + sReplAmp + " ");
        } else {
            psOut.print("@?!+!?latbs?!+!?@hyperref[" + this.escapeSpecialChars(sLink) + "]" + sReplCurlOpen + sText + sReplCurlClose);
        }
    }

    public void processRefTableCell(PrintStream psOut, String sOutFile, String sLink, String sText, int iNumPara, int iIndex) {
        String sHyperRef = this.escapeSpecialChars(String.valueOf(sOutFile) + ":" + sLink);
        if (iIndex < iNumPara - 1) {
            psOut.print("@?!+!?latbs?!+!?@hyperref[" + sHyperRef + "]" + sReplCurlOpen + sText + sReplCurlClose + " " + sReplAmp + " ");
        } else {
            psOut.print("@?!+!?latbs?!+!?@hyperref[" + sHyperRef + "]" + sReplCurlOpen + sText + sReplCurlClose);
        }
    }

    public void processFuncDetailFuncHead(PrintStream psOut, String curLabel, String sFuncDef, String sDescription, String sLinkLabel) {
        psOut.println("@?!+!?latbs?!+!?@paragraph?!+!?latcbop?!+!?" + curLabel + ": " + sFuncDef + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sLinkLabel + sReplCurlClose + this.SysNewLine);
        psOut.println(String.valueOf(this.processParam(sDescription, true, false)) + this.SysNewLine);
    }

    public void processFuncDetailBegin(PrintStream psOut) {
        psOut.print("");
    }

    public void processFuncDetailEnd(PrintStream psOut) {
        psOut.print("");
    }

    public void processFunctionDetailsHeading(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONSDETAIL") + sReplCurlClose);
    }

    public void processFuncSectionHeader(PrintStream psOut, String sTitle, String sTagName) {
        psOut.println("@?!+!?latbs?!+!?@subsection?!+!?latcbop?!+!?" + sTitle + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sTagName + ":sec3" + sReplCurlClose);
        psOut.println();
    }

    public void processClassHeader(PrintStream psOut, String sCurClass, String sDescription, String sClassLabel, String sTagName) {
        String sDescOut = this.processParam(sDescription, true, false);
        psOut.println("@?!+!?latbs?!+!?@subsubsection?!+!?latcbop?!+!?" + sClassLabel + ": " + sCurClass + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sCurClass + sReplCurlClose);
        psOut.println(String.valueOf(this.SysNewLine) + sDescOut + this.SysNewLine);
    }

    public void processSubTagHeading(PrintStream psOut, String curLabel) {
        psOut.println("@?!+!?latbs?!+!?@textbf?!+!?latcbop?!+!?" + curLabel + sReplCurlClose);
        psOut.println();
    }

    public void processSubTagBegin(PrintStream psOut, String curTag) {
        psOut.print("");
    }

    public void processSubTagEnd(PrintStream psOut) {
        psOut.print("");
    }

    public void cleanOutDir() {
        SystemUtils.println();
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCLEANOUTDIR", this.Outpath));
        this.cleanDir(this.Outpath);
    }

    public void cleanDir(String sDir) {
        File fOutPath = new File(sDir);
        if (fOutPath.exists() && fOutPath.isDirectory()) {
            File[] fList = fOutPath.listFiles();
            int i = 0;
            while (i < fList.length) {
                String sSimpleFileName = fList[i].getName();
                if (!fList[i].isDirectory() && !fList[i].isHidden()) {
                    boolean bMatching = false;
                    int j = 0;
                    while (j < this.vDeletePattern.size()) {
                        if (AutoDocStringUtils.isMatch(sSimpleFileName, (String)this.vDeletePattern.get(j))) {
                            bMatching = true;
                            break;
                        }
                        ++j;
                    }
                    if (bMatching) {
                        fList[i].delete();
                    } else {
                        this.mySettings.getMsgHandler().outputNote("NOTE_UNKNOWNDELETEFILE", sSimpleFileName);
                    }
                } else {
                    String sCurFile = FileUtils.toCanonicalPath(fList[i]);
                    if (sSimpleFileName.equals("images")) {
                        FileUtils.cleanDir(sCurFile);
                    }
                    fList[i].delete();
                }
                ++i;
            }
        }
    }

    protected void postprocessOutput() {
        try {
            this.outputIndexFile("AutoDoc.tex");
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public void processFileHeader(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType, int[] iaNumLevel) {
        psOut.println("@?!+!?latbs?!+!?@section?!+!?latcbop?!+!?" + sFileType + ": " + sOrgFile + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sOutFil + sReplCurlClose + this.SysNewLine);
        psOut.println("@?!+!?latbs?!+!?@subsection?!+!?latcbop?!+!?" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_OVERVIEW") + sReplCurlClose);
        psOut.println("@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?");
        if (iaNumLevel[0] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec1", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_GENERALINFO"), false));
        }
        if (iaNumLevel[1] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec2", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTURE"), false));
        }
        if (iaNumLevel[2] > 0) {
            psOut.println("@?!+!?latbs?!+!?@item " + this.convertLinkToStringInternal(String.valueOf(sOutFil) + ":sec3", this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONS"), false));
        }
        psOut.println("@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?itemize?!+!?latcbcl?!+!?");
    }

    public void outputIndexFile(String sOutFil) throws IOException {
        String sTemplFile;
        String sLogo = "";
        String sParaLogo = this.mySettings.getLogo();
        if (!sParaLogo.equals("")) {
            File fTmp = new File(sParaLogo);
            sLogo = this.convertImage(fTmp.getName(), "right");
            sLogo = this.unEscapeSpecialChars(this.toLaTeXSpecial(sLogo));
        }
        if (!(sTemplFile = this.mySettings.getStyleDefFile()).equals("")) {
            File fTmp = new File(sTemplFile);
            String sShortName = fTmp.getName();
            int iPos = sShortName.lastIndexOf(46);
            if (iPos >= 0 && iPos < sShortName.length() - 1) {
                sShortName = sShortName.substring(0, iPos);
            }
            sTemplFile = sShortName;
        } else {
            sTemplFile = "article";
        }
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEINDEX", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.OutputTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        this.processGroupingTreeTitle(psOut, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTINDEX"));
        this.processIndexListTreeContent(psOut);
        this.outputAllSingleFiles(psOut);
        String sBibHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
        this.processAllBibEntries(psOut, sBibHead, sOutFil);
        this.processAllVarEntries(psOut, sOutFil);
        this.processAllFuncEntries(psOut, sOutFil);
        String sCont = baOut.toString();
        psOut.close();
        sCont = this.toLaTeXSpecial(sCont);
        sCont = this.unEscapeSpecialChars(sCont);
        String sTitle = this.unEscapeSpecialChars(this.mySettings.getTitle());
        String sAuthors = this.unEscapeSpecialChars(this.processAuthorsList());
        String sAuthorFirst = "";
        int iPos = sAuthors.indexOf("\\");
        if (iPos > 0) {
            sAuthorFirst = sAuthors.substring(0, iPos - 1).trim();
        }
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%AUTHOR%", sAuthors);
        s1 = AutoDocStringUtils.replaceAll(s1, "%AUTHORFIRST%", sAuthorFirst);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%TEMPLATE%", sTemplFile);
        s1 = AutoDocStringUtils.replaceAll(s1, "%LOGO%", sLogo);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputBibFile(String sOutFil) throws IOException {
    }

    public void outputFuncIndexFile(String sOutFil) throws IOException {
    }

    public void outputAllSingleFiles(PrintStream psOut) {
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sFullInFil = "";
            sFullInFil = this.Outpath.equals("") ? curInfo.Filename : String.valueOf(this.Outpath) + "/" + curInfo.Filename;
            try {
                File fin = new File(sFullInFil);
                BufferedReader rd = new BufferedReader(FileUtils.getInputStreamReader(sFullInFil, "UTF-8"));
                boolean bStreamFinished = false;
                while (!bStreamFinished) {
                    String sLine = rd.readLine();
                    if (sLine != null) {
                        psOut.println(sLine);
                        continue;
                    }
                    bStreamFinished = true;
                }
                rd.close();
                fin.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void processBibHeading(PrintStream psOut, String sBibHead) {
        psOut.println("@?!+!?latbs?!+!?@nocite?!+!?latcbop?!+!?*?!+!?latcbcl?!+!?");
        psOut.println("@?!+!?latbs?!+!?@renewcommand?!+!?latcbop?!+!?@?!+!?latbs?!+!?@refname?!+!?latcbcl?!+!??!+!?latcbop?!+!?" + sBibHead + sReplCurlClose);
    }

    public void processBibBegin(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@begin?!+!?latcbop?!+!?thebibliography?!+!?latcbcl?!+!??!+!?latcbop?!+!?9999?!+!?latcbcl?!+!?");
        psOut.println("@?!+!?latbs?!+!?@addcontentsline?!+!?latcbop?!+!?toc?!+!?latcbcl?!+!??!+!?latcbop?!+!?section?!+!?latcbcl?!+!??!+!?latcbop?!+!?@?!+!?latbs?!+!?@protect?!+!?latcbop?!+!?@?!+!?latbs?!+!?@refname?!+!?latcbcl?!+!??!+!?latcbcl?!+!?");
    }

    public void processBibEnd(PrintStream psOut) {
        psOut.println("@?!+!?latbs?!+!?@end?!+!?latcbop?!+!?thebibliography?!+!?latcbcl?!+!?");
    }

    public void processBibEntry(PrintStream psOut, int iEntryIndex, String sKey, String sEntry) {
        psOut.println("@?!+!?latbs?!+!?@bibitem?!+!?latcbop?!+!?" + sKey + sReplCurlClose + " " + sEntry);
    }

    public String createXRefLabel(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(this.escapeSpecialChars(sOutfile)) + ":" + this.escapeSpecialChars(sMarker);
        }
        return sOutfile;
    }

    public String createXRefLabelLocal(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(this.escapeSpecialChars(sOutfile)) + ":" + this.escapeSpecialChars(sMarker);
        }
        return sOutfile;
    }

    public String createXRefAnchor(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(this.escapeSpecialChars(sOutfile)) + ":" + this.escapeSpecialChars(sMarker);
        }
        return sOutfile;
    }

    public String escapeSpecialChars(String s) {
        String sReturn = s;
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "\\", sReplBackslash);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "_", sReplUnderline);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "%", sReplPercent);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "&", sReplAmp);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "$", sReplDollar);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "#", sReplHash);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "^", sReplCirc);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "{", sReplCurlOpen);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "}", sReplCurlClose);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "<", sReplCurlLess);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, ">", sReplCurlGreater);
        return sReturn;
    }

    public String unEscapeSpecialChars(String s) {
        String sReturn = s;
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplBackslash, "\\");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplUnderline, "_");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplPercent, "%");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplAmp, "&");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplDollar, "$");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplHash, "#");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplCirc, "^");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplCurlOpen, "{");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplCurlClose, "}");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplCurlLess, "<");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, sReplCurlGreater, ">");
        return sReturn;
    }

    public String toLaTeXSpecial(String s) {
        String sReturn = s;
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "\\", "?!+!?latcbop?!+!?\\textbackslash?!+!?latcbcl?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "_", "\\_");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "%", "\\%");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "&", "\\?!+!?latam?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "$", "\\?!+!?latdo?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "#", "\\#");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "^", "\\^?!+!?latcbop?!+!??!+!?latcbcl?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "{", "\\?!+!?latcbop?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "}", "\\?!+!?latcbcl?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "<", "?!+!?latcbop?!+!?\\textless?!+!?latcbcl?!+!?");
        sReturn = AutoDocStringUtils.replaceAll(sReturn, ">", "?!+!?latcbop?!+!?\\textgreater?!+!?latcbcl?!+!?");
        return sReturn;
    }

    protected String getImageDims(String sFilename) {
        String sReturn = "";
        try {
            BufferedImage bimg = ImageIO.read(new File(sFilename));
            int width = bimg.getWidth();
            int height = bimg.getHeight();
            sReturn = String.valueOf(width) + ";" + height;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sReturn;
    }

    public String processAuthorsList() {
        String sReturn = "";
        int iNum = this.vAuthors.size();
        int i = 0;
        while (i < iNum) {
            String s = (String)this.vAuthors.get(i);
            sReturn = i < iNum - 1 ? String.valueOf(sReturn) + s + this.SysNewLine + sReplBackslash + "and" + this.SysNewLine : String.valueOf(sReturn) + s;
            ++i;
        }
        return sReturn;
    }

    public String generateLinkAnchor(String sName) {
        return "@?!+!?latbs?!+!?@label?!+!?latcbop?!+!?" + sName + sReplCurlClose + this.SysNewLine;
    }

    public String generateSectionLinkLabel(String sOutFileName, String sSectionName) {
        return sSectionName;
    }
}

