/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.HTML;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.HTML.AutoDocCHMProject;
import de.enache.AutoDoc.HTML.AutoDocHTMLOut;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class AutoDocHTMLOutSingle
extends AutoDocHTMLOut {
    public AutoDocHTMLOutSingle(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
        this.TargetWinMain = "";
        this.FileTemplateStr = "%CONTENT%";
    }

    protected void postprocessOutput() {
        try {
            this.outputBibFile(this.sRefFileName);
            this.outputFuncIndexFile(this.sFuncIndexFileName);
            this.outputIndexFile("index.htm");
            if (!this.CHMProj.equals("")) {
                ArrayList<String> vFileList = new ArrayList<String>();
                vFileList.add("index.htm");
                ArrayList vFuncIdx = this.createAndSortFuncVarIndex();
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                PrintStream psOut = new PrintStream(baOut);
                this.processIndexListTreeContent(psOut);
                if (this.bibrefList != null && this.bibrefList.size() > 0) {
                    String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
                    this.processIndexListEntryStandalone(psOut, this.sRefFileName, sBibText, this.sListStandaloneClass);
                }
                if (this.varFuncList != null && this.varFuncList.size() > 0) {
                    String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
                    this.processIndexListEntryStandalone(psOut, this.sFuncIndexFileName, sIdxText, this.sListStandaloneClass);
                }
                String sCont = baOut.toString();
                psOut.close();
                AutoDocCHMProject chmProj = new AutoDocCHMProject(this.CHMProj, this.Outpath, this.mySettings.getLocale(), vFileList, sCont, "index.htm", vFuncIdx, this.mySettings.getMsgHandler().getTexts());
                chmProj.output();
            }
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public void processFileHeader(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType, int[] iaNumLevel) {
        this.processFileHeading(psOut, sOutFil, sOrgFile, sFileType);
        psOut.println("<h2 class=\"docsection\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_OVERVIEW") + "</h2>");
        psOut.println("<ul>");
        if (iaNumLevel[0] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec1\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_GENERALINFO") + "</a></li>");
        }
        if (iaNumLevel[1] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec2\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTURE") + "</a></li>");
        }
        if (iaNumLevel[2] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec3\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONS") + "</a></li>");
        }
        psOut.println("</ul>");
        psOut.println("<p>&nbsp;</p>");
    }

    public void processFileHeading(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType) {
        psOut.println(this.generateLinkAnchor(sOutFil));
        if (!sOrgFile.equals("") && !sFileType.equals("")) {
            psOut.println("<h1 class=\"fileheading\">" + sFileType + ": " + sOrgFile + "</h1>");
        }
    }

    public void outputIndexFile(String sOutFil) throws IOException {
        String sLogo = "";
        String sParaLogo = this.mySettings.getLogo();
        if (!sParaLogo.equals("")) {
            File fTmp = new File(sParaLogo);
            sLogo = "<img src=\"" + fTmp.getName() + "\" class=\"logo\" />";
        }
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEINDEX", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.IndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        psOut.println(String.valueOf(sLogo) + "<h1 class=\"docsection\">" + this.mySettings.getTitle() + "</h1>");
        this.outputOverView(psOut);
        psOut.println("<hr class=\"docsection\"/>");
        this.processGroupingTreeTitle(psOut, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTINDEX"));
        this.processIndexListTreeContent(psOut);
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
            this.processIndexListEntryStandalone(psOut, "#" + this.sRefFileName, sBibText, this.sListStandaloneClass);
            psOut.println("<p>&nbsp;</p>");
        }
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
            this.processIndexListEntryStandalone(psOut, "#" + this.sFuncIndexFileName, sIdxText, this.sListStandaloneClass);
            psOut.println("<p>&nbsp;</p>");
        }
        psOut.println("<p>&nbsp;</p>");
        psOut.println("<hr class=\"docsection\"/>");
        this.outputAllSingleFiles(psOut);
        psOut.println("<p>&nbsp;</p>");
        String sCont = baOut.toString();
        psOut.close();
        String sHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sHead;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%INDEXCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputAllSingleFiles(PrintStream psOut) {
        String sOutPrefix = "";
        if (!this.Outpath.equals("")) {
            sOutPrefix = String.valueOf(this.Outpath) + "/";
        }
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sFullInFil = String.valueOf(sOutPrefix) + curInfo.Filename;
            this.appendFileAndDelete(psOut, sFullInFil);
            ++i;
        }
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            String sFullInFil = String.valueOf(sOutPrefix) + this.sRefFileName;
            this.appendFileAndDelete(psOut, sFullInFil);
        }
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            String sFullInFil = String.valueOf(sOutPrefix) + this.sFuncIndexFileName;
            this.appendFileAndDelete(psOut, sFullInFil);
        }
    }

    protected void appendFileAndDelete(PrintStream psOut, String sFullInFil) {
        try {
            File fin = new File(sFullInFil);
            BufferedReader rd = new BufferedReader(FileUtils.getInputStreamReader(sFullInFil, "UTF-8"));
            boolean bStreamFinished = false;
            while (!bStreamFinished) {
                String sLine = rd.readLine();
                if (sLine != null) {
                    psOut.println(sLine);
                    continue;
                }
                bStreamFinished = true;
            }
            rd.close();
            fin.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String createXRefLabel(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return "#" + sOutfile + "_" + sMarker;
        }
        return "#" + sOutfile;
    }

    public String createXRefLabelLocal(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return "#" + sOutfile + "_" + sMarker;
        }
        return "#" + sOutfile;
    }

    public String createXRefAnchor(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(sOutfile) + "_" + sMarker;
        }
        return sOutfile;
    }
}

