/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.HTML;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.HTML.AutoDocCHMProject;
import de.enache.AutoDoc.HTML.AutoDocHTMLOut;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class AutoDocHTMLOutNoFrames
extends AutoDocHTMLOut {
    public AutoDocHTMLOutNoFrames(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
        this.TargetWinMain = "";
    }

    public void outputIndexFile(String sOutFil) throws IOException {
        String sLogo = "";
        String sParaLogo = this.mySettings.getLogo();
        if (!sParaLogo.equals("")) {
            File fTmp = new File(sParaLogo);
            sLogo = "<img src=\"" + fTmp.getName() + "\" class=\"logo\" />";
        }
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEINDEX", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.IndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        psOut.println(String.valueOf(sLogo) + "<h1 class=\"docsection\">" + this.mySettings.getTitle() + "</h1>");
        this.outputOverView(psOut);
        psOut.println("<hr class=\"docsection\"/>");
        this.processGroupingTreeTitle(psOut, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTINDEX"));
        this.processIndexListTreeContent(psOut);
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
            this.processIndexListEntryStandalone(psOut, this.sRefFileName, sBibText, this.sListStandaloneClass);
        }
        psOut.println("<p>&nbsp;</p>");
        psOut.println("<hr class=\"docsection\"/>");
        String sCont = baOut.toString();
        psOut.close();
        String sHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sHead;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%INDEXCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    protected void postprocessOutput() {
        try {
            this.outputIndexFile("index.htm");
            this.outputBibFile(this.sRefFileName);
            this.outputFuncIndexFile(this.sFuncIndexFileName);
            if (!this.CHMProj.equals("")) {
                ArrayList<String> vFileList = new ArrayList<String>();
                vFileList.add("index.htm");
                int i = 0;
                while (i < this.IndexEntries.size()) {
                    AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
                    vFileList.add(curInfo.Filename);
                    ++i;
                }
                if (this.bibrefList != null && this.bibrefList.size() > 0) {
                    vFileList.add(this.sRefFileName);
                }
                if (this.varFuncList != null && this.varFuncList.size() > 0) {
                    vFileList.add(this.sFuncIndexFileName);
                }
                ArrayList vFuncIdx = this.createAndSortFuncVarIndex();
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                PrintStream psOut = new PrintStream(baOut);
                this.processIndexListTreeContent(psOut);
                if (this.bibrefList != null && this.bibrefList.size() > 0) {
                    String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
                    this.processIndexListEntryStandalone(psOut, this.sRefFileName, sBibText, this.sListStandaloneClass);
                }
                if (this.varFuncList != null && this.varFuncList.size() > 0) {
                    String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
                    this.processIndexListEntryStandalone(psOut, this.sFuncIndexFileName, sIdxText, this.sListStandaloneClass);
                }
                String sCont = baOut.toString();
                psOut.close();
                AutoDocCHMProject chmProj = new AutoDocCHMProject(this.CHMProj, this.Outpath, this.mySettings.getLocale(), vFileList, sCont, "", vFuncIdx, this.mySettings.getMsgHandler().getTexts());
                chmProj.output();
            }
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }
}

