/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.HTML;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.HTML.AutoDocCHMProject;
import de.enache.AutoDoc.HTML.AutoDocHTMLOut;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class AutoDocHTMLOutFrames
extends AutoDocHTMLOut {
    protected String ListIndexTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_List.htm"));
    protected String FramesTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_Frames.htm"));
    protected String TreeInitializer = "";
    protected String SearchFrame = "";

    public AutoDocHTMLOutFrames(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
    }

    public void copyTemplateFiles() {
        super.copyTemplateFiles();
        this.copyTemplateFile("Treeview.js", this.Outpath);
    }

    protected void postprocessOutput() {
        this.TreeInitializer = this.buildTreeInitializer();
        this.SearchFrame = this.buildSearchFrame();
        try {
            this.outputIndexFile("Autodoc_Index.htm");
            this.outputIndexListFile("Autodoc_List.htm");
            this.outputFramesetFile("index.htm");
            this.outputBibFile(this.sRefFileName);
            this.outputFuncIndexFile(this.sFuncIndexFileName);
            if (!this.CHMProj.equals("")) {
                ArrayList<String> vFileList = new ArrayList<String>();
                vFileList.add("Autodoc_Index.htm");
                int i = 0;
                while (i < this.IndexEntries.size()) {
                    AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
                    vFileList.add(curInfo.Filename);
                    ++i;
                }
                if (this.bibrefList != null && this.bibrefList.size() > 0) {
                    vFileList.add(this.sRefFileName);
                }
                if (this.varFuncList != null && this.varFuncList.size() > 0) {
                    vFileList.add(this.sFuncIndexFileName);
                }
                ArrayList vFuncIdx = this.createAndSortFuncVarIndex();
                ByteArrayOutputStream baOut = new ByteArrayOutputStream();
                PrintStream psOut = new PrintStream(baOut);
                String sIndexText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
                this.processIndexListEntryStandalone(psOut, "Autodoc_Index.htm", sIndexText, this.sListStandaloneClass);
                this.processIndexListTreeContent(psOut);
                if (this.bibrefList != null && this.bibrefList.size() > 0) {
                    String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
                    this.processIndexListEntryStandalone(psOut, this.sRefFileName, sBibText, this.sListStandaloneClass);
                }
                if (this.varFuncList != null && this.varFuncList.size() > 0) {
                    String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
                    this.processIndexListEntryStandalone(psOut, this.sFuncIndexFileName, sIdxText, this.sListStandaloneClass);
                }
                String sCont = baOut.toString();
                psOut.close();
                AutoDocCHMProject chmProj = new AutoDocCHMProject(this.CHMProj, this.Outpath, this.mySettings.getLocale(), vFileList, sCont, "", vFuncIdx, this.mySettings.getMsgHandler().getTexts());
                chmProj.output();
            }
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public String buildTreeInitializer() {
        return this.buildSearchInitializer();
    }

    public String buildSearchInitializer() {
        String sSearchInit = "";
        if (this.mySettings.getEnableSearch()) {
            String sSearchLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_SEARCH_SEARCH");
            String sResultsLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_SEARCH_RESULTS");
            String sBusyLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_SEARCH_BUSY");
            String sCompaterrLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_SEARCH_COMPATERROR");
            String sIgnoreCaseLabel = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_SEARCH_IGNORECASE");
            sSearchInit = "  initSearch(\"" + sSearchLabel + "\", \"" + sResultsLabel + "\", \"" + sBusyLabel + "\", \"" + sCompaterrLabel + "\", \"" + sIgnoreCaseLabel + "\");" + this.SysNewLine;
        }
        return sSearchInit;
    }

    public String buildSearchFrame() {
        String sRet = "";
        if (this.mySettings.getEnableSearch()) {
            sRet = String.valueOf(sRet) + "\t<hr />" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t<form id=\"searchform\">" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t\t<label for=\"searchstr\">Search:</label>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t\t<input id=\"searchstr\" name=\"searchstr\" onkeypress=\"return checkReturn(event)\"/>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t\t<input type=\"button\" value=\"OK\" onClick=\"submitsearch();\"/><br/>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t\t<label for=\"ignoreflag\">Ignore Case:</label>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t\t<input type=\"checkbox\" id=\"ignoreflag\" name=\"ignoreflag\" value=\"IgnoreCase\"/>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t</form>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t<p id=\"searchhead\"></p>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t<ul id=\"searchresults\" class=\"indexTree\">" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t</ul>" + this.SysNewLine;
            sRet = String.valueOf(sRet) + "\t<div id=\"searchtmp\"><iframe id=\"searchtmpfrm\" name=\"searchtmpfrm\" src=\"Autodoc_SrcIdx.htm\"></iframe></div>" + this.SysNewLine;
        }
        return sRet;
    }

    public void outputIndexListFile(String sOutFil) throws IOException {
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEFRAMESETLIST", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.ListIndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        String sIndex = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTINDEX");
        this.processGroupingTreeTitle(psOut, sIndex);
        String sIndexText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
        this.processIndexListEntryStandalone(psOut, "Autodoc_Index.htm", sIndexText, this.sListStandaloneClass);
        this.processIndexListTreeContent(psOut);
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
            this.processIndexListEntryStandalone(psOut, this.sRefFileName, sBibText, this.sListStandaloneClass);
        }
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
            this.processIndexListEntryStandalone(psOut, this.sFuncIndexFileName, sIdxText, this.sListStandaloneClass);
        }
        String sCont = baOut.toString();
        psOut.close();
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sIndex;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%JSTREELIST%", this.TreeInitializer);
        s1 = AutoDocStringUtils.replaceAll(s1, "%LISTCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%SEARCHFRAME%", this.SearchFrame);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputFramesetFile(String sOutFil) throws IOException {
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEFRAMESET", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.FramesTemplateStr;
        String sTitle = this.mySettings.getTitle();
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    protected void appendToSearchIndex(String s, String sOutFile) throws UnsupportedEncodingException, IOException {
        String sFullSearchIdxName = String.valueOf(this.mySettings.getOutPath()) + "/" + "Autodoc_SrcIdx.htm";
        PrintStream psOutSrc = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullSearchIdxName, true)), true, "UTF-8");
        psOutSrc.print("<div id=\"Src_" + sOutFile + "\">");
        psOutSrc.print(s.replaceAll("\\s+", " "));
        psOutSrc.print("</div>");
        psOutSrc.close();
        if (psOutSrc.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullSearchIdxName));
        }
    }
}

