/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.HTML;

import de.enache.AutoDoc.AutoDocFuncIndexElement;
import de.enache.AutoDoc.AutoDocMessageTexts;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class AutoDocCHMProject {
    protected AutoDocMessageTexts Texts = null;
    protected String ProjectName = "";
    protected String OutDir = "";
    protected ArrayList FileList = null;
    protected String Lang = "en";
    protected String Content = "";
    protected String LinkPrefix = "";
    protected ArrayList IdxList = null;
    private String sDefault = "";
    private String sCompFile = "";
    private String sContFile = "";
    private String sIdxFile = "";
    private String sProjFile = "";
    private String sLangSetting = "0x0409 English (United States)";

    public AutoDocCHMProject(String sProjectName, String sOutDir, String sLang, ArrayList vFileList, String sContent, String sLinkPrefix, ArrayList IdxList, AutoDocMessageTexts Texts) {
        this.Texts = Texts;
        this.ProjectName = sProjectName;
        this.OutDir = sOutDir;
        this.FileList = vFileList;
        this.Lang = sLang;
        this.LinkPrefix = sLinkPrefix;
        this.IdxList = IdxList;
        this.Content = this.convertContents(sContent);
        this.init();
    }

    protected String convertContents(String sContent) {
        String sReturn = sContent;
        sReturn = sReturn.replaceAll("<ul.*>", "<ul>");
        String[] saTmp = sReturn.split("[<>]");
        String sBefore = saTmp[0];
        int iSize = saTmp.length / 2;
        String[][] saTmp2 = new String[iSize][2];
        int i = 1;
        while (i < saTmp.length) {
            int iMod = 1 - i % 2;
            saTmp2[(i - 1) / 2][iMod] = saTmp[i];
            ++i;
        }
        String sReturnNew = "";
        int i2 = 0;
        while (i2 < iSize) {
            String sTextReplace;
            String sName;
            String sTag = saTmp2[i2][0];
            String sText = saTmp2[i2][1];
            if (sTag.toLowerCase().equals("li")) {
                if (!sText.trim().equals("")) {
                    sName = sText.trim();
                    int iPos = sText.indexOf(sName);
                    String sLead = "";
                    String sTrail = "";
                    if (iPos > 0) {
                        sLead = sText.substring(0, iPos);
                    }
                    sTrail = sText.substring(sLead.length() + sName.length());
                    sTextReplace = "<object type=\"text/sitemap\">";
                    sTextReplace = String.valueOf(sTextReplace) + "<param name=\"Name\" value=\"" + sName + "\">";
                    sTextReplace = String.valueOf(sTextReplace) + "</object>";
                    saTmp2[i2][1] = String.valueOf(sLead) + sTextReplace + sTrail;
                }
                saTmp2[i2][0] = "<" + saTmp2[i2][0] + ">";
            } else if (sTag.toLowerCase().startsWith("a")) {
                sName = sText.trim();
                String sLink = "";
                int iPos = sTag.indexOf("\"");
                if (iPos >= 0) {
                    int iNextPos = sTag.indexOf("\"", iPos + 1);
                    sLink = iNextPos >= 0 ? sTag.substring(iPos + 1, iNextPos) : sTag.substring(iPos + 1);
                }
                if (!this.LinkPrefix.equals("")) {
                    sLink = String.valueOf(this.LinkPrefix) + "#" + sLink;
                }
                String sTagReplace = "object type=\"text/sitemap\"";
                sTextReplace = "<param name=\"Name\" value=\"" + sName + "\">";
                sTextReplace = String.valueOf(sTextReplace) + "<param name=\"Local\" value=\"" + sLink + "\">";
                sTextReplace = String.valueOf(sTextReplace) + "</object>";
                saTmp2[i2][0] = sTagReplace;
                saTmp2[i2][1] = sTextReplace;
                saTmp2[i2][0] = "<" + saTmp2[i2][0] + ">";
            } else {
                saTmp2[i2][0] = sTag.toLowerCase().startsWith("/a") ? "" : "<" + saTmp2[i2][0] + ">";
            }
            sReturnNew = String.valueOf(sReturnNew) + saTmp2[i2][0] + saTmp2[i2][1];
            ++i2;
        }
        if (!sReturnNew.equals("")) {
            sReturn = String.valueOf(sBefore) + sReturnNew;
        }
        return sReturn;
    }

    protected void init() {
        if (this.FileList.size() > 0) {
            this.sDefault = (String)this.FileList.get(0);
        }
        this.sProjFile = String.valueOf(this.ProjectName) + ".hhp";
        this.sCompFile = String.valueOf(this.ProjectName) + ".chm";
        this.sContFile = String.valueOf(this.ProjectName) + ".hhc";
        this.sIdxFile = String.valueOf(this.ProjectName) + ".hhk";
        if (this.Lang.equalsIgnoreCase("de")) {
            this.sLangSetting = "0x407 Deutsch (Deutschland)";
        }
    }

    public void output() throws Error {
        if (!this.ProjectName.equals("")) {
            this.outputProjectFile(String.valueOf(this.OutDir) + "/" + this.sProjFile);
            this.outputIndexFile(String.valueOf(this.OutDir) + "/" + this.sIdxFile);
            this.outputContentsFile(String.valueOf(this.OutDir) + "/" + this.sContFile);
        }
    }

    protected void outputProjectFile(String sProjFile) throws Error {
        try {
            BufferedOutputStream baOut = new BufferedOutputStream(new FileOutputStream(sProjFile));
            PrintStream psOut = new PrintStream(baOut);
            psOut.println("[OPTIONS]");
            psOut.println("Compatibility=1.1 or later");
            psOut.println("Compiled file=" + this.sCompFile);
            psOut.println("Contents file=" + this.sContFile);
            psOut.println("Default topic=" + this.sDefault);
            psOut.println("Display compile progress=No");
            psOut.println("Index file=" + this.sIdxFile);
            psOut.println("Language=" + this.sLangSetting);
            psOut.println();
            psOut.println("[FILES]");
            int i = 0;
            while (i < this.FileList.size()) {
                String sCurFile = (String)this.FileList.get(i);
                psOut.println(sCurFile);
                ++i;
            }
            psOut.println();
            psOut.println("[INFOTYPES]");
            psOut.println();
            psOut.close();
        }
        catch (IOException e) {
            String sError = "Output of CHM project file '" + sProjFile + "' failed.";
            if (this.Texts != null) {
                sError = this.Texts.getMessageText("ERR_OUTCHM_OUTPROJFAILED", sProjFile);
            }
            throw new Error(sError);
        }
    }

    protected void outputIndexFile(String sIdxFile) throws Error {
        try {
            BufferedOutputStream baOut = new BufferedOutputStream(new FileOutputStream(sIdxFile));
            PrintStream psOut = new PrintStream(baOut);
            psOut.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
            psOut.println("<html>");
            psOut.println("<head>");
            psOut.println("<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">");
            psOut.println("<!-- Sitemap 1.0 -->");
            psOut.println("</head><body>");
            psOut.println("<ul>");
            int i = 0;
            while (i < this.IdxList.size()) {
                AutoDocFuncIndexElement curSort = (AutoDocFuncIndexElement)this.IdxList.get(i);
                String sFunc = curSort.getFuncText();
                String sLink = curSort.getOutputFile();
                if (!this.LinkPrefix.equals("")) {
                    sLink = String.valueOf(this.LinkPrefix) + sLink;
                }
                psOut.print("<li>");
                psOut.print("<object type=\"text/sitemap\">");
                psOut.print("<param name=\"Name\" value=\"" + sFunc + "\">");
                psOut.print("<param name=\"Local\" value=\"" + sLink + "\">");
                psOut.print("</object>");
                psOut.println("</li>");
                ++i;
            }
            psOut.println("</ul>");
            psOut.println("</body></html>");
            psOut.close();
        }
        catch (IOException e) {
            String sError = "Output of CHM index file '" + sIdxFile + "' failed.";
            if (this.Texts != null) {
                sError = this.Texts.getMessageText("ERR_OUTCHM_OUTINDEXFAILED", sIdxFile);
            }
            throw new Error(sError);
        }
    }

    protected void outputContentsFile(String sContFile) throws Error {
        try {
            BufferedOutputStream baOut = new BufferedOutputStream(new FileOutputStream(sContFile));
            PrintStream psOut = new PrintStream(baOut);
            psOut.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
            psOut.println("<html>");
            psOut.println("<head>");
            psOut.println("<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">");
            psOut.println("<!-- Sitemap 1.0 -->");
            psOut.println("</head><body>");
            psOut.println("<object type=\"text/site properties\">");
            psOut.println("    <param name=\"ImageType\" value=\"Folder\">");
            psOut.println("</object>");
            psOut.println(this.Content);
            psOut.println("</body></html>");
            psOut.close();
        }
        catch (IOException e) {
            String sError = "Output of CHM contents file '" + sContFile + "' failed.";
            if (this.Texts != null) {
                sError = this.Texts.getMessageText("ERR_OUTCHM_OUTCONTFAILED", sContFile);
            }
            throw new Error(sError);
        }
    }
}

