/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.GUI.AutoDocGUINonEditableTableModel;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class AutoDocGUISimpleListDialog
extends JDialog
implements ActionListener,
WindowListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected String sCurSetting = "";
    protected String sOrgSetting = "";
    protected String sSettingName = "";
    protected String sSeparator = ",";
    protected boolean bCaseSensitive = false;
    protected AutoDocMessageTexts myTexts = null;
    protected int WinWidth = 800;
    protected int WinHeight = 600;
    protected ArrayList vList = new ArrayList();
    protected String[][] saGridData = new String[1][1];
    protected String[] saColumns = new String[]{""};
    protected JButton butOK = null;
    protected JButton butCancel = null;
    protected JButton butAdd = null;
    protected JButton butRemove = null;
    protected JButton butEdit = null;
    protected DefaultTableModel tableModel = new AutoDocGUINonEditableTableModel(this.saGridData, this.saColumns);
    protected JTable tExt = null;
    protected JScrollPane DataScrollPane = null;
    protected Container cData = null;

    public AutoDocGUISimpleListDialog(Frame owner, String sCurSetting, String sSettingName, String sSeparator, boolean bCaseSensitive, AutoDocMessageTexts myTexts) {
        super(owner);
        this.initDialog(owner, sCurSetting, sSettingName, sSeparator, bCaseSensitive, myTexts);
    }

    public AutoDocGUISimpleListDialog(Frame owner) {
        super(owner);
    }

    protected void initDialog(Frame owner, String sCurSetting, String sSettingName, String sSeparator, boolean bCaseSensitive, AutoDocMessageTexts myTexts) {
        this.sCurSetting = sCurSetting;
        this.sOrgSetting = sCurSetting;
        this.sSettingName = sSettingName;
        this.sSeparator = sSeparator;
        this.bCaseSensitive = bCaseSensitive;
        this.myTexts = myTexts;
        this.vList = this.convStringToList(sCurSetting, this.sSeparator);
        this.saColumns[0] = sSettingName;
        this.updateGridData();
        this.setModal(true);
        this.setWindowSize();
        this.setTitle(String.valueOf(this.sSettingName) + " " + myTexts.getMessageTextDef("MSG_GUI_LIST", "List"));
        this.addWindowListener(this);
        this.createDialogComponents();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    protected void updateGridData() {
        if (this.vList.size() > 0) {
            this.saGridData = new String[this.vList.size()][1];
            int i = 0;
            while (i < this.vList.size()) {
                this.saGridData[i][0] = (String)this.vList.get(i);
                ++i;
            }
        } else {
            this.saGridData = new String[1][1];
            this.saGridData[0][0] = "";
        }
    }

    protected void createDialogComponents() {
        Container cAll = new Container();
        cAll.setLayout(new BoxLayout(cAll, 1));
        Container cTop = this.createTopContainer();
        cAll.add(cTop);
        Container cBottom = this.createBottomContainer();
        cAll.add(cBottom);
        this.getContentPane().add(cAll);
    }

    protected Container createTopContainer() {
        Container cTop = new Container();
        cTop.setLayout(new FlowLayout(1));
        this.cData = new Container();
        this.cData.setLayout(new BoxLayout(this.cData, 1));
        Container cHead = new Container();
        cHead.setLayout(new FlowLayout(0));
        JLabel lb1 = new JLabel(this.myTexts.getMessageTextDef("MSG_GUI_CURRENT_SETTINGS", "Current settings"));
        cHead.add(lb1);
        this.cData.add(cHead);
        this.updateDataTable();
        cTop.add(this.cData);
        Container cActBut = new Container();
        cActBut.setLayout(new BoxLayout(cActBut, 1));
        this.butAdd = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_ADD", "Add"));
        this.butAdd.setActionCommand("EXTDLG_ADD");
        this.butAdd.addActionListener(this);
        cActBut.add(this.butAdd);
        this.butEdit = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_EDIT", "Edit"));
        this.butEdit.setActionCommand("EXTDLG_EDIT");
        this.butEdit.addActionListener(this);
        this.butEdit.setEnabled(false);
        cActBut.add(this.butEdit);
        this.butRemove = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_REMOVE", "Remove"));
        this.butRemove.setActionCommand("EXTDLG_REMOVE");
        this.butRemove.addActionListener(this);
        this.butRemove.setEnabled(false);
        cActBut.add(this.butRemove);
        cTop.add(cActBut);
        return cTop;
    }

    protected void updateDataTable() {
        if (this.DataScrollPane != null && this.tExt != null) {
            this.DataScrollPane.remove(this.tExt);
        }
        if (this.DataScrollPane != null) {
            this.cData.remove(this.DataScrollPane);
        }
        this.tableModel = new AutoDocGUINonEditableTableModel(this.saGridData, this.saColumns);
        this.tExt = new JTable(this.tableModel);
        JTableHeader head = this.tExt.getTableHeader();
        int i = 0;
        while (i < this.saColumns.length) {
            head.getColumnModel().getColumn(i).setHeaderValue(this.saColumns[i]);
            this.tExt.getColumnModel().getColumn(i).setMinWidth(30);
            ++i;
        }
        head.setVisible(true);
        this.tExt.setCellSelectionEnabled(true);
        ListSelectionModel selModel = this.tExt.getSelectionModel();
        selModel.setSelectionMode(0);
        selModel.addListSelectionListener(this);
        this.DataScrollPane = new JScrollPane(this.tExt);
        this.cData.add(this.DataScrollPane);
        this.cData.validate();
    }

    protected Container createBottomContainer() {
        Container cBottom = new Container();
        cBottom.setLayout(new FlowLayout(1));
        this.butOK = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_OK", "OK"));
        this.butOK.setActionCommand("EXTDLG_OK");
        this.butOK.addActionListener(this);
        cBottom.add(this.butOK);
        this.butCancel = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_CANCEL", "Cancel"));
        this.butCancel.setActionCommand("EXTDLG_CANCEL");
        this.butCancel.addActionListener(this);
        cBottom.add(this.butCancel);
        return cBottom;
    }

    public void setWindowSize() {
        double dAspect = (double)this.WinWidth / (double)this.WinHeight;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40;
        int iDiff_x = iScreenWidth - this.WinWidth;
        int iDiff_y = iScreenHeight - this.WinHeight;
        if (iDiff_x < 0 || iDiff_y < 0) {
            if (iDiff_x < iDiff_y) {
                int iCalc_y;
                this.WinWidth = iScreenWidth;
                this.WinHeight = iCalc_y = (int)((double)this.WinWidth / dAspect);
            } else {
                int iCalc_x;
                this.WinHeight = iScreenHeight;
                this.WinWidth = iCalc_x = (int)((double)this.WinHeight * dAspect);
            }
            dAspect = (double)this.WinWidth / (double)this.WinHeight;
        }
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation((iScreenWidth - this.WinWidth) / 2, (iScreenHeight - this.WinHeight) / 2);
    }

    public String getResult() {
        return this.sCurSetting;
    }

    protected ArrayList convStringToList(String sExt, String sSep) {
        sSep = this.maskRegExChars(sSep.trim());
        String sRegex = "\\s*" + sSep + "\\s*";
        String[] saExt = sExt.split(sRegex);
        ArrayList<String> vList = new ArrayList<String>();
        int i = 0;
        while (i < saExt.length) {
            if (!saExt[i].equals("")) {
                vList.add(this.correctOriginal(saExt[i]));
            }
            ++i;
        }
        return vList;
    }

    protected String convListToString(ArrayList vList, String sSep) {
        String sReturn = "";
        String sPre = sSep;
        int iLen = vList.size();
        if (iLen > 0) {
            String sCur = (String)vList.get(0);
            sReturn = String.valueOf(sReturn) + sCur;
        }
        int i = 1;
        while (i < iLen) {
            String sCur = (String)vList.get(i);
            if (!sCur.equals("")) {
                sReturn = String.valueOf(sReturn) + sPre + sCur;
            }
            ++i;
        }
        return sReturn;
    }

    protected String correctOriginal(String s) {
        return s;
    }

    protected String correctInput(String s) {
        return s;
    }

    protected String maskRegExChars(String sSep) {
        if (sSep.equals("|")) {
            sSep = "\\|";
        }
        return sSep;
    }

    protected boolean checkExists(String s, int iIndex) {
        boolean bExist = false;
        int i = 0;
        while (i < this.vList.size()) {
            String sCur = (String)this.vList.get(i);
            if (i != iIndex && this.customEquals(sCur, s)) {
                bExist = true;
                break;
            }
            ++i;
        }
        return bExist;
    }

    protected boolean customEquals(String s1, String s2) {
        boolean bResult = false;
        bResult = this.bCaseSensitive ? s1.equals(s2) : s1.equalsIgnoreCase(s2);
        return bResult;
    }

    protected String showInputDialog(String sCur) {
        return (String)JOptionPane.showInputDialog(null, String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_NEWVALUE", "New value")) + " :", this.myTexts.getMessageTextDef("MSG_GUI_INPUT", "Input"), -1, null, null, sCur);
    }

    protected void onOK() {
        this.dispose();
    }

    protected void onCancel() {
        this.sCurSetting = this.sOrgSetting;
        this.dispose();
    }

    protected void onAdd() {
        String sRet = this.showInputDialog("");
        if (sRet != null) {
            sRet = sRet.trim();
            if (!(sRet = this.correctInput(sRet)).equals("") && !this.checkExists(sRet, -1)) {
                int iSelRow = this.tExt.getSelectedRow();
                if (iSelRow >= 0) {
                    this.vList.add(iSelRow, sRet);
                } else {
                    this.vList.add(sRet);
                }
                this.sCurSetting = this.convListToString(this.vList, this.sSeparator);
                this.updateGridData();
                this.updateDataTable();
            }
        }
    }

    protected void onRemove() {
        int iSelRow = this.tExt.getSelectedRow();
        if (iSelRow >= 0) {
            this.vList.remove(iSelRow);
            this.sCurSetting = this.convListToString(this.vList, this.sSeparator);
            this.updateGridData();
            this.updateDataTable();
        }
    }

    protected void onEdit() {
        String sCur;
        String sRet;
        int iSelRow = this.tExt.getSelectedRow();
        if (iSelRow >= 0 && (sRet = this.showInputDialog(sCur = (String)this.vList.get(iSelRow))) != null) {
            if (!sRet.equals("") && !this.checkExists(sRet, iSelRow)) {
                sRet = this.correctInput(sRet);
                this.vList.set(iSelRow, sRet);
                this.sCurSetting = this.convListToString(this.vList, this.sSeparator);
                this.updateGridData();
                this.updateDataTable();
            } else {
                this.vList.remove(iSelRow);
                this.sCurSetting = this.convListToString(this.vList, this.sSeparator);
                this.updateGridData();
                this.updateDataTable();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("EXTDLG_OK")) {
            this.onOK();
        } else if (e.getActionCommand().equals("EXTDLG_CANCEL")) {
            this.onCancel();
        } else if (e.getActionCommand().equals("EXTDLG_ADD")) {
            this.onAdd();
        } else if (e.getActionCommand().equals("EXTDLG_EDIT")) {
            this.onEdit();
        } else if (e.getActionCommand().equals("EXTDLG_REMOVE")) {
            this.onRemove();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.sCurSetting = this.sOrgSetting;
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        int iSelRow = this.tExt.getSelectedRow();
        if (iSelRow >= 0) {
            this.butEdit.setEnabled(true);
            this.butRemove.setEnabled(true);
        } else {
            this.butEdit.setEnabled(false);
            this.butRemove.setEnabled(false);
        }
    }
}

