/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.SystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class AutoDocGUIRunThread
extends Thread {
    private String sProgDir = "";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private String sFilename = "";
    private String sWorkDir = "";

    public AutoDocGUIRunThread(String sFilename, String sWorkDir, String sProgDir) {
        this.sFilename = sFilename;
        this.sWorkDir = sWorkDir;
        this.sProgDir = sProgDir;
        PrintStream psOut = new PrintStream(this.baos);
        System.setOut(psOut);
    }

    public void run() {
        System.setProperty("user.dir", this.sWorkDir);
        String[] args = new String[]{"-cfg", this.sFilename};
        try {
            AutoDoc.mainRoutine(args, this.sProgDir);
        }
        catch (Error e) {
            SystemUtils.println(e.getMessage());
        }
        catch (Exception e) {
            String sErr = e.getMessage();
            if (sErr != null && AutoDoc.getSettings() != null) {
                String sMsg = "Fatal error encountered. Please contact " + AutoDoc.ContactAddr + " for support. " + sErr;
                AutoDocMessageTexts Texts = AutoDoc.getSettings().getMsgHandler().getTexts();
                if (Texts != null) {
                    String[] saErr = new String[]{AutoDoc.ContactAddr, sErr};
                    sMsg = Texts.getErrorText("ERR_FATAL", saErr);
                }
                SystemUtils.println(sMsg);
                SystemUtils.println(SystemUtils.getStackTrace(e));
            }
            SystemUtils.println("Fatal error encountered. Please contact " + AutoDoc.ContactAddr + " for support.");
            SystemUtils.println(SystemUtils.getStackTrace(e));
        }
    }

    public synchronized String fetchString() {
        String sReturn = this.baos.toString();
        this.baos.reset();
        return sReturn;
    }
}

