/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.GUI.AutoDocGUIFileNameFilter;
import de.enache.AutoDoc.GUI.AutoDocGUIRunObserver;
import de.enache.AutoDoc.GUI.AutoDocGUIRunThread;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;

public class AutoDocGUIRunDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String sCR = "\n";
    private String sProgDir = "";
    private String sOutDir = "";
    private PrintStream psOrig = null;
    private AutoDocGUIRunThread myThread = null;
    private AutoDocGUIRunObserver myObs = null;
    protected AutoDocMessageTexts myTexts = null;
    private int WinWidth = 800;
    private int WinHeight = 600;
    Frame owner = null;
    private String sFilename = "";
    private String sWorkDir = "";
    private JTextArea taLog = null;
    private JScrollPane scrollPane = null;
    private JButton butOK = null;
    private JButton butCancel = null;
    private JButton butSave = null;
    private JButton butOpen = null;
    private JButton butMini = null;
    private JButton butHidden = null;

    public AutoDocGUIRunDialog(Frame owner, String sFilename, String sWorkDir, String sProgDir, String sOutDir, AutoDocMessageTexts myTexts) {
        super(owner);
        this.owner = owner;
        this.sFilename = sFilename;
        this.sWorkDir = sWorkDir;
        this.sProgDir = sProgDir;
        this.sOutDir = sOutDir;
        this.myTexts = myTexts;
        this.setWindowSize();
        this.setTitle("AutoDoc " + myTexts.getMessageTextDef("MSG_GUI_RUN", "Run") + " (" + sFilename + ")");
        this.addWindowListener((WindowListener)((Object)owner));
        this.createDialogComponents();
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
    }

    public void showDialog() {
        this.setVisible(true);
        this.butOK.setEnabled(false);
        this.butSave.setEnabled(false);
        this.butOpen.setEnabled(false);
        this.butCancel.setEnabled(false);
        this.update(this.getGraphics());
        this.run();
    }

    public void createDialogComponents() {
        Container cAll = new Container();
        cAll.setLayout(new BoxLayout(cAll, 1));
        Container cTop = new Container();
        cTop.setLayout(new FlowLayout(1));
        this.taLog = new JTextArea();
        this.taLog.setFont(new Font("monospaced", 0, this.taLog.getFont().getSize()));
        this.taLog.setEditable(false);
        this.taLog.setText(sCR);
        this.scrollPane = new JScrollPane(this.taLog, 22, 30);
        this.scrollPane.setPreferredSize(new Dimension(750, 500));
        this.scrollPane.setVisible(true);
        cTop.add(this.scrollPane);
        cAll.add(cTop);
        Container cBottom = new Container();
        cBottom.setLayout(new FlowLayout(1));
        this.butOK = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_OK", "OK"));
        this.butOK.setActionCommand("EXEDLG_OK");
        this.butOK.addActionListener(this);
        cBottom.add(this.butOK);
        this.butCancel = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_CANCEL", "Cancel"));
        this.butCancel.setActionCommand("EXEDLG_CANCEL");
        this.butCancel.addActionListener(this);
        cBottom.add(this.butCancel);
        this.butSave = new JButton(String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_SAVE_LOG", "Save log")) + "...");
        this.butSave.setActionCommand("EXEDLG_SAVE");
        this.butSave.addActionListener(this);
        cBottom.add(this.butSave);
        this.butOpen = new JButton(String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_OPEN_BROWSER", "Open in Browser")) + "...");
        this.butOpen.setActionCommand("EXEDLG_OPEN");
        this.butOpen.addActionListener(this);
        cBottom.add(this.butOpen);
        this.butMini = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_MINIMIZE", "Minimize"));
        this.butMini.setActionCommand("EXEDLG_MINI");
        this.butMini.addActionListener(this);
        cBottom.add(this.butMini);
        this.butHidden = new JButton("");
        this.butHidden.setActionCommand("EXEDLG_HIDDEN");
        this.butHidden.addActionListener(this);
        this.butHidden.setVisible(false);
        cBottom.add(this.butHidden);
        cAll.add(cBottom);
        this.getContentPane().add(cAll);
    }

    public void run() {
        this.psOrig = System.out;
        this.myThread = new AutoDocGUIRunThread(this.sFilename, this.sWorkDir, this.sProgDir);
        this.myThread.start();
        this.myObs = new AutoDocGUIRunObserver(this.myThread, this.butHidden);
        this.myObs.start();
        this.butCancel.setEnabled(true);
    }

    public void stop() {
        this.myThread.interrupt();
        this.butCancel.setEnabled(false);
    }

    public void updateLogOutput(String sCurline) {
        this.taLog.append(sCurline);
        int iPos = 0;
        try {
            iPos = this.taLog.getLineStartOffset(this.taLog.getLineCount() - 1);
        }
        catch (BadLocationException e) {
            iPos = this.taLog.getText().length() - 1;
        }
        this.taLog.setCaretPosition(iPos);
    }

    public void setWindowSize() {
        double dAspect = (double)this.WinWidth / (double)this.WinHeight;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40;
        int iDiff_x = iScreenWidth - this.WinWidth;
        int iDiff_y = iScreenHeight - this.WinHeight;
        if (iDiff_x < 0 || iDiff_y < 0) {
            if (iDiff_x < iDiff_y) {
                int iCalc_y;
                this.WinWidth = iScreenWidth;
                this.WinHeight = iCalc_y = (int)((double)this.WinWidth / dAspect);
            } else {
                int iCalc_x;
                this.WinHeight = iScreenHeight;
                this.WinWidth = iCalc_x = (int)((double)this.WinHeight * dAspect);
            }
            dAspect = (double)this.WinWidth / (double)this.WinHeight;
        }
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation((iScreenWidth - this.WinWidth) / 2, (iScreenHeight - this.WinHeight) / 2);
    }

    public String getCurConfDirectory() {
        return this.sWorkDir;
    }

    public void saveLog() {
        String[] saExt = new String[]{"log", "txt"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "Log file " + sExtList);
        JFileChooser ch = new JFileChooser(this.getCurConfDirectory());
        FileFilter allFilter = ch.getAcceptAllFileFilter();
        ch.removeChoosableFileFilter(allFilter);
        ch.addChoosableFileFilter(filter);
        ch.addChoosableFileFilter(allFilter);
        String sDefault = "AutoDoc.log";
        ch.setSelectedFile(new File(sDefault));
        int iRet = ch.showSaveDialog(null);
        if (iRet == 0) {
            String sSelected = FileUtils.toCanonicalPath(ch.getSelectedFile());
            try {
                PrintStream psOut = new PrintStream(new FileOutputStream(sSelected));
                psOut.print(this.taLog.getText());
                psOut.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "Log file could not be written: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public void openBrowser() {
        File f = new File(this.sOutDir, "index.htm");
        Runtime r = Runtime.getRuntime();
        String sOS = System.getProperty("os.name").toLowerCase();
        String sPre = "";
        if (sOS.indexOf("win") >= 0) {
            sPre = "cmd /C";
        } else if (sOS.indexOf("nix") >= 0 || sOS.indexOf("ux") >= 0 || sOS.indexOf("aix") > 0 || sOS.indexOf("sunos") >= 0 || sOS.indexOf("sun os") >= 0 || sOS.indexOf("freebsd") >= 0 || sOS.indexOf("os/390") >= 0 || sOS.indexOf("mpe/ix") >= 0) {
            sPre = "xdg-open";
        } else if (sOS.indexOf("mac") >= 0) {
            sPre = "open";
        }
        try {
            r.exec(String.valueOf(sPre) + " \"" + f.getAbsolutePath() + "\"");
        }
        catch (IOException e) {
            System.out.println("Opening " + f.getName() + " failed.");
        }
    }

    public void cancel() {
        int iRet = JOptionPane.showConfirmDialog(null, "Do you really want to cancel the run?", "Confirm", 0);
        if (iRet == 0) {
            this.stop();
            this.dispose();
        }
    }

    public void minimize() {
        this.owner.setState(1);
    }

    public void doHidden() {
        if (!this.myThread.isAlive()) {
            String sTmp = this.myThread.fetchString();
            this.updateLogOutput(sTmp);
            System.setOut(this.psOrig);
            this.butOK.setEnabled(true);
            this.butSave.setEnabled(true);
            this.butOpen.setEnabled(true);
            this.butCancel.setEnabled(false);
            this.butMini.setEnabled(false);
        } else {
            String sTmp = this.myThread.fetchString();
            this.updateLogOutput(sTmp);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("EXEDLG_OK")) {
            this.dispose();
        } else if (e.getActionCommand().equals("EXEDLG_CANCEL")) {
            this.cancel();
        } else if (e.getActionCommand().equals("EXEDLG_SAVE")) {
            this.saveLog();
        } else if (e.getActionCommand().equals("EXEDLG_OPEN")) {
            this.openBrowser();
        } else if (e.getActionCommand().equals("EXEDLG_HIDDEN")) {
            this.doHidden();
        } else if (e.getActionCommand().equals("EXEDLG_MINI")) {
            this.minimize();
        }
    }
}

