/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocPluginInfo;
import de.enache.AutoDoc.AutoDocPluginUtils;
import de.enache.AutoDoc.GUI.AutoDocGUIPluginTableModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class AutoDocGUIPluginManagerDialog
extends JDialog
implements ActionListener,
WindowListener,
FocusListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    protected int WinWidth = 700;
    protected int WinHeight = 300;
    protected int iDataTableWidth = 470;
    protected int iDataTableHeight = 180;
    protected int iInnerBoundsWidth = 42;
    protected String sProgDir = "";
    protected AutoDocMessageTexts myTexts = null;
    protected boolean bResult = false;
    protected List pluginList = new ArrayList();
    protected List lInstalledPlugins = new ArrayList();
    protected Object[][] saTableData = null;
    protected List lToInstall = new ArrayList();
    protected List lToRemove = new ArrayList();
    protected JButton butOK = null;
    protected JButton butCancel = null;
    protected DefaultTableModel tableModel = null;
    protected JTable dataTable = null;
    protected JScrollPane DataScrollPane = null;
    protected JTextArea curDescription = new JTextArea("");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AutoDocGUIPluginManagerDialog(Frame owner, String sTitle, String sProgDir, List pluginList, List lInstalledPlugins, AutoDocMessageTexts myTexts) {
        super(owner);
        this.myTexts = myTexts;
        this.sProgDir = sProgDir;
        this.pluginList = pluginList;
        this.lInstalledPlugins = lInstalledPlugins;
        this.setModal(true);
        this.setWindowSize();
        this.setTitle(sTitle);
        this.addWindowListener(this);
        this.initDataGrid();
        this.createDialogComponents();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public void createDialogComponents() {
        Container cAll = new Container();
        cAll.setLayout(new BoxLayout(cAll, 1));
        Container cTop = this.createTopContainer();
        cAll.add(cTop);
        Container cBottom = this.createBottomContainer();
        cAll.add(cBottom);
        this.getContentPane().add(cAll);
    }

    protected Container createTopContainer() {
        Container cTop = new Container();
        cTop.setLayout(new FlowLayout(0));
        Container cPluginList = new Container();
        cPluginList.setLayout(new BoxLayout(cPluginList, 1));
        Container cPluginTitle = new Container();
        cPluginTitle.setLayout(new FlowLayout(0));
        cPluginTitle.add(new JLabel(String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_PLUGINS", "Plugins")) + ":"));
        cPluginList.add(cPluginTitle);
        Container cPluginGrid = new Container();
        cPluginGrid.setLayout(new FlowLayout(0));
        cPluginGrid.add(this.DataScrollPane);
        cPluginList.add(cPluginGrid);
        cTop.add(cPluginList);
        Container cDescription = new Container();
        cDescription.setLayout(new BoxLayout(cDescription, 1));
        Container cDescrTitle = new Container();
        cDescrTitle.setLayout(new FlowLayout(0));
        cDescrTitle.add(new JLabel(String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_DESCR", "Description")) + ":"));
        cDescription.add(cDescrTitle);
        int iDescrWidth = this.WinWidth - this.iDataTableWidth - this.iInnerBoundsWidth;
        Container cDescrDescr = new Container();
        cDescrDescr.setLayout(new FlowLayout(0));
        this.curDescription.setEditable(false);
        this.curDescription.setPreferredSize(new Dimension(iDescrWidth, this.iDataTableHeight));
        this.curDescription.setLineWrap(true);
        this.curDescription.setWrapStyleWord(true);
        this.curDescription.setBorder(BorderFactory.createEtchedBorder(0));
        this.curDescription.setBackground(this.getBackground());
        cDescrDescr.add(this.curDescription);
        cDescription.add(cDescrDescr);
        cTop.add(cDescription);
        return cTop;
    }

    protected Container createBottomContainer() {
        Container cBottom = new Container();
        cBottom.setLayout(new FlowLayout(1));
        this.butOK = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_OK", "OK"));
        this.butOK.setActionCommand("PLUGDLG_OK");
        this.butOK.addActionListener(this);
        cBottom.add(this.butOK);
        this.butCancel = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_CANCEL", "Cancel"));
        this.butCancel.setActionCommand("PLUGDLG_CANCEL");
        this.butCancel.addActionListener(this);
        cBottom.add(this.butCancel);
        return cBottom;
    }

    public void initDataGrid() {
        String sStrSelected = this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_INST", "Install");
        String sStrRemove = this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_REMOVE", "Remove");
        String sStrName = this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_NAME", "Name");
        String sStrVersion = this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_VERSION", "Version");
        String sStrInstalled = this.myTexts.getMessageTextDef("MSG_GUI_PLUGMGR_INSTALLED", "Installed");
        Object[] saColumnNames = new String[]{sStrSelected, sStrRemove, sStrName, sStrVersion, sStrInstalled};
        Class[] classArray = new Class[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class[] aColumnClasses = classArray;
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] aIsEditable = blArray;
        int iLen = this.pluginList.size();
        this.saTableData = new Object[iLen][5];
        int i = 0;
        while (i < iLen) {
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)this.pluginList.get(i);
            AutoDocPluginInfo curAutoDocInfo = AutoDocPluginUtils.findMatchingPluginFromList(this.lInstalledPlugins, curInfo);
            this.saTableData[i][0] = new Boolean(false);
            this.saTableData[i][1] = new Boolean(false);
            this.saTableData[i][2] = curInfo.getName();
            this.saTableData[i][3] = curInfo.getVersion();
            this.saTableData[i][4] = "";
            if (curAutoDocInfo == null) {
                this.saTableData[i][0] = new Boolean(false);
            } else {
                this.saTableData[i][4] = curAutoDocInfo.getVersion();
                int iCmp = curAutoDocInfo.compareVersion(curInfo.getVersion());
                if (iCmp == 0) {
                    this.saTableData[i][0] = new Boolean(false);
                } else if (iCmp < 0) {
                    this.saTableData[i][0] = new Boolean(true);
                }
            }
            ++i;
        }
        this.tableModel = new AutoDocGUIPluginTableModel(this.saTableData, saColumnNames, aColumnClasses, aIsEditable);
        this.dataTable = new JTable(this.tableModel);
        this.dataTable.putClientProperty("terminateEditOnFocusLost", new Boolean(true));
        this.dataTable.getModel().addTableModelListener(this);
        this.iDataTableWidth = 0;
        this.setTableColumnWidth(this.dataTable, 0, 50);
        this.iDataTableWidth += 50;
        this.setTableColumnWidth(this.dataTable, 1, 50);
        this.iDataTableWidth += 50;
        this.setTableColumnWidth(this.dataTable, 2, 250);
        this.iDataTableWidth += 250;
        this.setTableColumnWidth(this.dataTable, 3, 60);
        this.iDataTableWidth += 60;
        this.setTableColumnWidth(this.dataTable, 4, 60);
        this.iDataTableWidth += 60;
        JTableHeader header = this.dataTable.getTableHeader();
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)header.getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        this.dataTable.setCellSelectionEnabled(true);
        ListSelectionModel cellSelectionModel = this.dataTable.getSelectionModel();
        cellSelectionModel.setSelectionMode(0);
        cellSelectionModel.addListSelectionListener(this);
        this.DataScrollPane = new JScrollPane(this.dataTable);
        this.DataScrollPane.setPreferredSize(new Dimension(this.iDataTableWidth, this.iDataTableHeight));
    }

    private void setTableColumnWidth(JTable DataGrid, int iIndex, int iWidth) {
        TableColumn column = DataGrid.getColumnModel().getColumn(iIndex);
        column.setMinWidth(iWidth);
        column.setMaxWidth(iWidth);
        column.setPreferredWidth(iWidth);
    }

    public void setWindowSize() {
        double dAspect = (double)this.WinWidth / (double)this.WinHeight;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40;
        int iDiff_x = iScreenWidth - this.WinWidth;
        int iDiff_y = iScreenHeight - this.WinHeight;
        if (iDiff_x < 0 || iDiff_y < 0) {
            if (iDiff_x < iDiff_y) {
                int iCalc_y;
                this.WinWidth = iScreenWidth;
                this.WinHeight = iCalc_y = (int)((double)this.WinWidth / dAspect);
            } else {
                int iCalc_x;
                this.WinHeight = iScreenHeight;
                this.WinWidth = iCalc_x = (int)((double)this.WinHeight * dAspect);
            }
            dAspect = (double)this.WinWidth / (double)this.WinHeight;
        }
        this.setPreferredSize(new Dimension(this.WinWidth, this.WinHeight));
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation((iScreenWidth - this.WinWidth) / 2, (iScreenHeight - this.WinHeight) / 2);
    }

    public boolean getResult() {
        return this.bResult;
    }

    public List getToInstall() {
        this.lToInstall = new ArrayList();
        int iLen = this.pluginList.size();
        int i = 0;
        while (i < iLen) {
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)this.pluginList.get(i);
            boolean bSelected = (Boolean)this.saTableData[i][0];
            if (bSelected) {
                this.lToInstall.add(curInfo);
            }
            ++i;
        }
        return this.lToInstall;
    }

    public List getToRemove() {
        this.lToRemove = new ArrayList();
        int iLen = this.pluginList.size();
        int i = 0;
        while (i < iLen) {
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)this.pluginList.get(i);
            boolean bSelected = (Boolean)this.saTableData[i][1];
            if (bSelected) {
                this.lToRemove.add(curInfo);
            }
            ++i;
        }
        return this.lToRemove;
    }

    public void onOK() {
        this.bResult = true;
        this.dispose();
    }

    public void onCancel() {
        this.bResult = false;
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("PLUGDLG_OK")) {
            this.onOK();
        } else if (e.getActionCommand().equals("PLUGDLG_CANCEL")) {
            this.onCancel();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.bResult = false;
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        int[] selectedRows = this.dataTable.getSelectedRows();
        if (selectedRows.length > 0) {
            int iFirst = selectedRows[0];
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)this.pluginList.get(iFirst);
            this.curDescription.setText(curInfo.getDescription());
        }
    }

    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        AutoDocGUIPluginTableModel model = (AutoDocGUIPluginTableModel)e.getSource();
        Object data = model.getValueAt(row, column);
        int iSelected = this.dataTable.getSelectedColumn();
        this.saTableData[row][column] = data;
        if (column == 0 && column == iSelected && ((Boolean)data).booleanValue()) {
            this.saTableData[row][1] = new Boolean(false);
            model.setValueAt(this.saTableData[row][1], row, 1);
        }
        if (column == 1 && column == iSelected && ((Boolean)data).booleanValue()) {
            this.saTableData[row][0] = new Boolean(false);
            model.setValueAt(this.saTableData[row][0], row, 0);
        }
    }
}

