/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.GUI.AutoDocGUIMainFrame;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class AutoDocGUIMenu {
    private AutoDocGUIMainFrame mainFrame;
    private JMenuBar menuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem fileExitItem = null;
    private JMenuItem fileNewItem = null;
    private JMenuItem fileLoadItem = null;
    private JMenuItem fileSaveItem = null;
    private JMenuItem fileSaveAsItem = null;
    private JMenuItem fileGUIProp = null;
    private JMenuItem filePluginManager = null;
    private JMenu processMenu = null;
    private JMenuItem processRunItem = null;
    private JMenu helpMenu = null;
    private JMenuItem helpAboutItem = null;

    public AutoDocGUIMenu(AutoDocGUIMainFrame parent) {
        this.mainFrame = parent;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        float fFontSize = 11.0f;
        if (iScreenWidth >= 1024) {
            fFontSize = 14.0f;
        }
        this.createMenu(fFontSize);
    }

    private void createMenu(float fFontSize) {
        this.menuBar = new JMenuBar();
        Font f = this.menuBar.getFont();
        UIManager.put("Menu.font", f.deriveFont(fFontSize));
        UIManager.put("MenuItem.font", f.deriveFont(fFontSize));
        AutoDocMessageTexts myTexts = this.mainFrame.getTexts();
        this.fileMenu = new JMenu(myTexts.getMessageTextDef("MSG_GUI_MENU_CONFIGURATION", "Configuration"));
        this.fileLoadItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_LOAD", "Load..."));
        this.fileLoadItem.addActionListener(this.mainFrame);
        this.fileLoadItem.setActionCommand("MENU_CMD_LOAD");
        this.fileMenu.add(this.fileLoadItem);
        this.fileSaveItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_SAVE", "Save..."));
        this.fileSaveItem.addActionListener(this.mainFrame);
        this.fileSaveItem.setActionCommand("MENU_CMD_SAVE");
        this.fileMenu.add(this.fileSaveItem);
        this.fileSaveAsItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_SAVEAS", "Save as..."));
        this.fileSaveAsItem.addActionListener(this.mainFrame);
        this.fileSaveAsItem.setActionCommand("MENU_CMD_SAVEAS");
        this.fileMenu.add(this.fileSaveAsItem);
        this.fileNewItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_CLEAR", "Clear"));
        this.fileNewItem.addActionListener(this.mainFrame);
        this.fileNewItem.setActionCommand("MENU_CMD_CLEAR");
        this.fileMenu.add(this.fileNewItem);
        this.fileMenu.addSeparator();
        this.fileGUIProp = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_GUIPROP", "GUI Properties..."));
        this.fileGUIProp.addActionListener(this.mainFrame);
        this.fileGUIProp.setActionCommand("MENU_CMD_GUIPROP");
        this.fileMenu.add(this.fileGUIProp);
        this.filePluginManager = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_PLUGMGR", "Plugin Manager..."));
        this.filePluginManager.addActionListener(this.mainFrame);
        this.filePluginManager.setActionCommand("MENU_CMD_PLUGMGR");
        this.fileMenu.add(this.filePluginManager);
        this.fileMenu.addSeparator();
        this.fileExitItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_EXIT", "Exit"));
        this.fileExitItem.addActionListener(this.mainFrame);
        this.fileExitItem.setActionCommand("MENU_CMD_EXIT");
        this.fileMenu.add(this.fileExitItem);
        this.menuBar.add(this.fileMenu);
        this.processMenu = new JMenu(myTexts.getMessageTextDef("MSG_GUI_MENU_PROCESS", "Process"));
        this.processRunItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_RUN", "Run"));
        this.processRunItem.addActionListener(this.mainFrame);
        this.processRunItem.setActionCommand("MENU_CMD_RUN");
        this.processRunItem.setEnabled(false);
        this.processMenu.add(this.processRunItem);
        this.menuBar.add(this.processMenu);
        this.helpMenu = new JMenu(myTexts.getMessageTextDef("MSG_GUI_MENU_HELP", "Help"));
        this.helpAboutItem = new JMenuItem(myTexts.getMessageTextDef("MSG_GUI_MENU_ABOUT", "About..."));
        this.helpAboutItem.addActionListener(this.mainFrame);
        this.helpAboutItem.setActionCommand("MENU_CMD_ABOUT");
        this.helpMenu.add(this.helpAboutItem);
        this.menuBar.add(this.helpMenu);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setRunEnabled(boolean bFlag) {
        this.processRunItem.setEnabled(bFlag);
    }
}

