/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocPluginInfo;
import de.enache.AutoDoc.AutoDocPluginUtils;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.GUI.AutoDocGUIExtDefListDialog;
import de.enache.AutoDoc.GUI.AutoDocGUIExtListDialog;
import de.enache.AutoDoc.GUI.AutoDocGUIFileNameFilter;
import de.enache.AutoDoc.GUI.AutoDocGUIInputListDialog;
import de.enache.AutoDoc.GUI.AutoDocGUIMenu;
import de.enache.AutoDoc.GUI.AutoDocGUIPluginManagerDialog;
import de.enache.AutoDoc.GUI.AutoDocGUIRunDialog;
import de.enache.AutoDoc.GUI.AutoDocGUISimpleListDialog;
import de.enache.AutoDoc.GUI.AutoDocGUIWindowListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class AutoDocGUIMainFrame
extends JFrame
implements ActionListener,
ItemListener,
FocusListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private String sProgDir = "";
    private String sPropDir = "";
    private String sPropFilename = "GUISettings.txt";
    private String sTemplFilename = "";
    private int WinWidth = 760;
    private int WinHeight = 580;
    private String sTitlePrefix = "";
    private String sConfFileName = "";
    private boolean isDirty = true;
    private boolean bRun = false;
    private File fTemp = null;
    private String sOrgName = "";
    private boolean bOrgDirty = false;
    private boolean bVirgin = true;
    private String sGuiLocale = "en";
    private String sGuiRes = "";
    private AutoDocMessageTexts guiTexts = null;
    private AutoDocSettings mySettings = null;
    private String sWorkDir = "";
    private String sInputDir = "";
    private boolean bInputRecursive = true;
    private String sOutputDir = "";
    private boolean bOutputRel = false;
    private String sExt = "";
    private String sExclude = "";
    private String sOutType = "";
    private String sTitle = "";
    private String sLogo = "";
    private boolean bLogoRel = false;
    private String sCHM = "";
    private String sCSS = "";
    private boolean bCSSRel = false;
    private String sHeadIns = "";
    private boolean bHeadInsRel = false;
    private String sFootIns = "";
    private boolean bFootInsRel = false;
    private String sRes = "";
    private boolean bResRel = false;
    private String sTempl = "";
    private boolean bTemplRel = false;
    private String sLocale = "";
    private String sExtDef = "";
    private String[] saLocale = new String[]{"", "en", "de"};
    private boolean bEnableSearch = false;
    private AutoDocGUIMenu myMenu = null;
    private AutoDocGUIRunDialog runDialog = null;
    private Font curLabelFont = new Font("Dialog", 1, 11);
    private Font curTfFont = new Font("Dialog", 0, 11);
    private JTextField tfWorkdir = null;
    private Container cmWorkdir = new Container();
    private JTextField tfInputdir = null;
    private JCheckBox cbInputRecurse = null;
    private Container cmInputdir = new Container();
    private JTextField tfOutputdir = null;
    private JCheckBox cbOutputDir = null;
    private Container cmOutputdir = new Container();
    private JTextField tfExt = null;
    private Container cmExt = new Container();
    private JTextField tfExclude = null;
    private Container cmExclude = new Container();
    private JLabel[] lbDirSection = new JLabel[]{new JLabel("Working directory (-wordir):"), new JLabel("Input directories (-in):"), new JLabel("Output directory (-out):"), new JLabel("Extensions (-ext):"), new JLabel("Exclude filter (-exclude):")};
    private Component[] cmDirSection = new Component[]{this.cmWorkdir, this.cmInputdir, this.cmOutputdir, this.cmExt, this.cmExclude};
    private JComboBox cbOutType = null;
    private Container cmOutType = new Container();
    private JCheckBox cbEnableSearch = null;
    private JTextField tfTitle = null;
    private Container cmTitle = new Container();
    private JTextField tfLogo = null;
    private JCheckBox cbLogo = null;
    private Container cmLogo = new Container();
    private JTextField tfCHM = null;
    private Container cmCHM = new Container();
    private JLabel[] lbOutputSection = new JLabel[]{new JLabel("Output type (-outtype):"), new JLabel("Document title (-title):"), new JLabel("Logo file (-logo):"), new JLabel("CHM project file name (-chm):")};
    private Component[] cmOutputSection = new Component[]{this.cmOutType, this.cmTitle, this.cmLogo, this.cmCHM};
    private JTextField tfTempl = null;
    private JCheckBox cbTempl = null;
    private Container cmTempl = new Container();
    private JTextField tfCSS = null;
    private JCheckBox cbCSS = null;
    private Container cmCSS = new Container();
    private JTextField tfHeadIns = null;
    private JCheckBox cbHeadIns = null;
    private Container cmHeadIns = new Container();
    private JTextField tfFootIns = null;
    private JCheckBox cbFootIns = null;
    private Container cmFootIns = new Container();
    private JComboBox cbGuiLocale = null;
    private JTextField tfGuiRes = null;
    private JTextField tfGuiTempl = null;
    private JLabel[] lbStylesheetSection = new JLabel[]{new JLabel("Template directory (-templatedir)"), new JLabel("Style definition file (-styledef)"), new JLabel("Header insert file (-headins):"), new JLabel("Footer insert file (-footins):")};
    private Component[] cmStylesheetSection = new Component[]{this.cmTempl, this.cmCSS, this.cmHeadIns, this.cmFootIns};
    private JTextField tfRes = null;
    private JCheckBox cbRes = null;
    private Container cmRes = new Container();
    private JComboBox cbLocale = null;
    private Container cmLocale = new Container();
    private JTextField tfExtDef = null;
    private Container cmExtDef = new Container();
    private JLabel[] lbOtherSection = new JLabel[]{new JLabel("Ressource directory (-res)"), new JLabel("Locale (-locale)"), new JLabel("Ext Defaults (-extdef)")};
    private Component[] cmOtherSection = new Component[]{this.cmRes, this.cmLocale, this.cmExtDef};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AutoDocGUIMainFrame(String sProgDir, String[] args) {
        this.sProgDir = sProgDir;
        this.sWorkDir = System.getProperty("user.dir");
        this.mySettings = new AutoDocSettings();
        this.mySettings.getMsgHandler().setTexts(new AutoDocMessageTexts());
        this.sPropDir = String.valueOf(System.getProperty("user.home")) + File.separator + ".AutoDoc";
        this.getGUISettingsFromSettingsFile(this.sPropDir, this.sPropFilename);
        String sMsgEnc = AutoDoc.detectUTFCharset(this.getResourceAsStream("/" + this.sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt"));
        String sMsgJarEnc = AutoDoc.detectUTFCharset(this.getResourceAsStreamFromJar("/" + this.sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt"));
        InputStream isMessages = this.getResourceAsStream("/" + this.sGuiLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt");
        InputStream isJarMessages = this.getResourceAsStreamFromJar("/" + this.sGuiLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt");
        if (isMessages == null) {
            this.mySettings.getMsgHandler().getTexts().initMessages(isJarMessages, sMsgJarEnc);
        } else {
            this.mySettings.getMsgHandler().getTexts().initMessages(isMessages, sMsgEnc);
        }
        this.guiTexts = this.mySettings.getMsgHandler().getTexts();
        this.initGUIMessageTexts();
        this.saLocale = this.updateLocaleList(this.sRes, this.saLocale, this.sLocale, this.cbLocale);
        this.setApplicationIcon(sProgDir);
        this.addWindowListener(new AutoDocGUIWindowListener());
        this.setWindowSize();
        this.createGUIElements();
        this.updateDataFieldsFromMembers();
        this.setResizable(false);
        this.setVisible(true);
        this.processCmdArgs(args);
    }

    private String[] updateLocaleList(String sRes, String[] saLocOld, String sLocale, JComboBox cbLocale) {
        String[] saLocale = saLocOld;
        String sResDir = sRes;
        if (sRes.equals("")) {
            sResDir = String.valueOf(this.sProgDir) + "/res";
        }
        if (!FileUtils.isAbsolutePath(sResDir)) {
            sResDir = FileUtils.convertRelativetoAbsolutePath(this.sWorkDir, sResDir);
        }
        if (!sResDir.equals("") && FileUtils.dirExist(sResDir)) {
            File fDir = new File(sResDir);
            File[] fList = fDir.listFiles();
            ArrayList<String> vList = new ArrayList<String>();
            vList.add("");
            int i = 0;
            while (i < fList.length) {
                String sDirName = fList[i].getName();
                if (fList[i].isDirectory() && sDirName.length() == 2) {
                    vList.add(sDirName.toLowerCase());
                }
                ++i;
            }
            int iNum = vList.size();
            saLocale = new String[iNum];
            if (cbLocale != null) {
                int i2 = 0;
                while (i2 < iNum) {
                    saLocale[i2] = (String)vList.get(i2);
                    ++i2;
                }
                this.updateComboListFromList(cbLocale, saLocale, sLocale);
            }
        }
        return saLocale;
    }

    private void updateComboListFromList(JComboBox cb, String[] sa, String sSelected) {
        if (cb != null) {
            cb.removeFocusListener(this);
            cb.removeItemListener(this);
            cb.removeAllItems();
            int i = 0;
            while (i < sa.length) {
                cb.addItem(sa[i]);
                ++i;
            }
            cb.addFocusListener(this);
            cb.addItemListener(this);
            cb.setSelectedItem(sSelected);
        }
    }

    public void updateGuiLocalListFromResDir(String sGuiRes) {
        if (FileUtils.dirExist(sGuiRes)) {
            int iCount = this.cbGuiLocale.getItemCount();
            String[] sa = new String[]{"en", "de"};
            if (iCount > 0) {
                sa = new String[iCount];
            }
            int i = 0;
            while (i < iCount) {
                sa[i] = (String)this.cbGuiLocale.getItemAt(i);
                ++i;
            }
            String sGuiLocale = ((String)this.cbGuiLocale.getSelectedItem()).trim();
            String[] stringArray = this.updateLocaleList(sGuiRes, sa, sGuiLocale, this.cbGuiLocale);
        }
    }

    private void setApplicationIcon(String sProgDir) {
        ImageIcon icon = null;
        URL uIcon = this.getClass().getResource("/res/images/AutoDoc_Icon.png");
        icon = uIcon != null ? new ImageIcon(uIcon) : new ImageIcon(String.valueOf(sProgDir) + "/res/images/AutoDoc_Icon.png");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
    }

    protected void processCmdArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String sTitle;
            String sMsg;
            String sSetting;
            if (args[i].equalsIgnoreCase("-cfg")) {
                if (++i < args.length) {
                    sSetting = args[i].trim();
                    if (FileUtils.fileExist(sSetting = FileUtils.toCanonicalPath(sSetting))) {
                        this.initComboBoxes();
                        try {
                            this.doLoadConf(sSetting);
                        }
                        catch (IOException e) {
                            String sMsg2 = this.guiTexts.getMessageText("WARN_CFGNOTREAD", sSetting);
                            String sTitle2 = this.guiTexts.getMessageTextDef("WARN_WARNING", "Warning");
                            JOptionPane.showMessageDialog(null, sMsg2, sTitle2, 1);
                        }
                        this.setConfFilename(sSetting, false);
                        this.updateDataFieldsFromMembers();
                    } else {
                        sMsg = this.guiTexts.getMessageText("WARN_CFGNOTREAD", sSetting);
                        sTitle = this.guiTexts.getMessageTextDef("WARN_WARNING", "Warning");
                        JOptionPane.showMessageDialog(null, sMsg, sTitle, 1);
                    }
                }
            } else if (args[i].equalsIgnoreCase("-templ") && ++i < args.length) {
                sSetting = args[i].trim();
                if (FileUtils.fileExist(sSetting = FileUtils.toCanonicalPath(sSetting))) {
                    this.sTemplFilename = sSetting;
                } else {
                    sMsg = this.guiTexts.getMessageText("WARN_CFGNOTREAD", sSetting);
                    sTitle = this.guiTexts.getMessageTextDef("WARN_WARNING", "Warning");
                    JOptionPane.showMessageDialog(null, sMsg, sTitle, 1);
                }
            }
            ++i;
        }
        if (!this.sTemplFilename.equals("") && FileUtils.fileExist(this.sTemplFilename)) {
            this.initComboBoxes();
            try {
                this.doLoadConf(this.sTemplFilename);
            }
            catch (IOException e) {
                String sMsg = this.guiTexts.getMessageText("WARN_CFGNOTREAD", this.sTemplFilename);
                String sTitle = this.guiTexts.getMessageTextDef("WARN_WARNING", "Warning");
                JOptionPane.showMessageDialog(null, sMsg, sTitle, 1);
            }
            this.updateDataFieldsFromMembers();
        }
        this.bVirgin = true;
        this.isDirty = false;
    }

    private void saveGUISettingsToSettingsFile(String sDir, String sFilename) {
        String sPropFile = String.valueOf(sDir) + File.separator + sFilename;
        File fPropDir = new File(sDir);
        if (!fPropDir.exists()) {
            fPropDir.mkdirs();
        }
        try {
            PrintStream psOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(sPropFile)));
            psOut.println("# AutoDoc GUI Settings");
            psOut.println("guilocale=" + this.sGuiLocale);
            psOut.println("guires=" + this.sGuiRes);
            psOut.println("guitempl=" + this.sTemplFilename);
            psOut.close();
        }
        catch (IOException e) {
            String sErr = this.guiTexts.getMessageTextDef("ERR_ERROR", "Error");
            String sErrMsg = this.guiTexts.getErrorText("MSG_GUI_ERR_CFGWRITE", sDir);
            JOptionPane.showMessageDialog(null, sErrMsg, sErr, 0);
        }
    }

    private void getGUISettingsFromSettingsFile(String sDir, String sFilename) {
        String sPropFile = String.valueOf(sDir) + File.separator + sFilename;
        File fPropFile = new File(sPropFile);
        if (!fPropFile.exists()) {
            this.saveGUISettingsToSettingsFile(sDir, sFilename);
        } else {
            try {
                BufferedReader in = new BufferedReader(AutoDoc.getInputStreamReader(sPropFile));
                String sCurLine = null;
                while ((sCurLine = in.readLine()) != null) {
                    String sKey = "";
                    String sValue = "";
                    if (sCurLine.trim().equals("") || sCurLine.trim().startsWith("#")) continue;
                    int iPos = sCurLine.indexOf("=");
                    if (iPos >= 0) {
                        sKey = sCurLine.substring(0, iPos).trim();
                        if (iPos < sCurLine.length() + 1) {
                            sValue = sCurLine.substring(iPos + 1).trim();
                        }
                    }
                    if (sKey.equals("guilocale")) {
                        this.sGuiLocale = sValue;
                        continue;
                    }
                    if (sKey.equals("guires")) {
                        this.sGuiRes = sValue;
                        continue;
                    }
                    if (!sKey.equals("guitempl")) continue;
                    this.sTemplFilename = sValue;
                }
                in.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public InputStream getResourceAsStream(String sName, String sDefault) {
        InputStream isDict = null;
        String sResDir = String.valueOf(this.sProgDir) + "/res";
        if (!this.sGuiRes.equals("")) {
            sResDir = this.sGuiRes;
        }
        String sLocDict = String.valueOf(sResDir) + sName;
        String sDefDict = String.valueOf(sResDir) + sDefault;
        File fLocDict = FileUtils.getAbsoluteFile(sLocDict);
        File fDefDict = FileUtils.getAbsoluteFile(sDefDict);
        if (FileUtils.fileExist(sLocDict)) {
            try {
                isDict = new FileInputStream(fLocDict);
            }
            catch (IOException iOException) {}
        } else if (!sDefault.equals("") && FileUtils.fileExist(sDefDict)) {
            try {
                isDict = new FileInputStream(fDefDict);
            }
            catch (IOException iOException) {}
        } else {
            isDict = this.getResourceAsStreamFromJar(sName, sDefault);
        }
        return isDict;
    }

    public InputStream getResourceAsStreamFromJar(String sName, String sDefault) {
        InputStream isDict;
        String sResName = "/res" + sName;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.enache.AutoDoc.GUI.AutoDocGUIMainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((isDict = clazz.getResourceAsStream(sResName)) == null && !sDefault.equals("")) {
            sResName = "/res" + sDefault;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("de.enache.AutoDoc.GUI.AutoDocGUIMainFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            isDict = clazz2.getResourceAsStream(sResName);
        }
        if (isDict == null) {
            String sLocDict = String.valueOf(this.sProgDir) + "/res" + sName;
            String sDefDict = String.valueOf(this.sProgDir) + "/res" + sDefault;
            File fLocDict = FileUtils.getAbsoluteFile(sLocDict);
            File fDefDict = FileUtils.getAbsoluteFile(sDefDict);
            if (FileUtils.fileExist(sLocDict)) {
                try {
                    isDict = new FileInputStream(fLocDict);
                }
                catch (IOException iOException) {}
            } else if (!sDefault.equals("") && FileUtils.fileExist(sDefDict)) {
                try {
                    isDict = new FileInputStream(fDefDict);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return isDict;
    }

    public AutoDocMessageTexts getTexts() {
        return this.guiTexts;
    }

    private void initGUIMessageTexts() {
        if (this.guiTexts != null) {
            this.lbDirSection[0] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_WORKDIR")) + " (-workdir):");
            this.lbDirSection[1] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_INPUTDIR")) + " (-in):");
            this.lbDirSection[2] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_OUTPUTDIR")) + " (-out):");
            this.lbDirSection[3] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_EXT")) + " (-ext):");
            this.lbDirSection[4] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_EXCLUDE")) + " (-exclude):");
            this.lbOutputSection[0] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_OUTTYPE")) + " (-outtype):");
            this.lbOutputSection[1] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_TITLE")) + " (-title):");
            this.lbOutputSection[2] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_LOGO")) + " (-logo):");
            this.lbOutputSection[3] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_CHM")) + " (-chm):");
            this.lbStylesheetSection[0] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_TEMPLDIR")) + " (-templatedir):");
            this.lbStylesheetSection[1] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_STYLEDEF")) + " (-styledef):");
            this.lbStylesheetSection[2] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_HEADERINS")) + " (-headins):");
            this.lbStylesheetSection[3] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_FOOTERINS")) + " (-footins):");
            this.lbOtherSection[0] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_RESDIR")) + " (-res):");
            this.lbOtherSection[1] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_LOCALE")) + " (-locale):");
            this.lbOtherSection[2] = new JLabel(String.valueOf(this.guiTexts.getMessageText("MSG_PARAMOUT_EXTDEF")) + " (-extdef):");
        }
    }

    public void createGUIElements() {
        this.myMenu = new AutoDocGUIMenu(this);
        this.setJMenuBar(this.myMenu.getMenuBar());
        Container cAll = new Container();
        cAll.setLayout(new FlowLayout(0));
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int iFieldSize = 410;
        if (iScreenWidth >= 1024 && iScreenHeight > 720) {
            this.WinWidth = 1020;
            this.WinHeight = 690;
            iFieldSize = 600;
            this.curLabelFont = this.curLabelFont.deriveFont(14.0f);
            this.curTfFont = this.curTfFont.deriveFont(14.0f);
            this.setWindowSize();
        } else if (iScreenHeight <= 600) {
            this.WinWidth = 770;
            this.WinHeight = 590;
            this.curLabelFont = this.curLabelFont.deriveFont(10.0f);
            this.curTfFont = this.curTfFont.deriveFont(10.0f);
            this.setWindowSize();
        }
        int iFontSize = this.curTfFont.getSize();
        Dimension dMaxDim = new Dimension(iFieldSize, (int)(1.7 * (double)iFontSize));
        int iMaxLabel = this.getMaxLabelWidth();
        cAll.add(this.createGUIMainDirSection(dMaxDim, iMaxLabel));
        cAll.add(this.createGUIOutputSection(dMaxDim, iMaxLabel));
        cAll.add(this.createGUIStylesheetSection(dMaxDim, iMaxLabel));
        cAll.add(this.createGUIOtherSection(dMaxDim, iMaxLabel));
        this.initComboBoxes();
        this.getContentPane().add(cAll);
    }

    public int getMaxLabelWidth() {
        int iMaxLabel = this.getMaxCompWidth(this.lbDirSection);
        int iTmp = this.getMaxCompWidth(this.lbOutputSection);
        if (iTmp > iMaxLabel) {
            iMaxLabel = iTmp;
        }
        if ((iTmp = this.getMaxCompWidth(this.lbStylesheetSection)) > iMaxLabel) {
            iMaxLabel = iTmp;
        }
        if ((iTmp = this.getMaxCompWidth(this.lbOtherSection)) > iMaxLabel) {
            iMaxLabel = iTmp;
        }
        return iMaxLabel;
    }

    public Container createGUIMainDirSection(Dimension dMaxDim, int iMaxLabel) {
        this.cmWorkdir.setLayout(new BoxLayout(this.cmWorkdir, 0));
        this.tfWorkdir = new JTextField();
        this.tfWorkdir.setFont(this.curTfFont);
        this.tfWorkdir.addFocusListener(this);
        this.tfWorkdir.setPreferredSize(dMaxDim);
        this.cmWorkdir.add(this.tfWorkdir);
        JButton buWorkDir = new JButton("...");
        buWorkDir.setPreferredSize(new Dimension(buWorkDir.getPreferredSize().width, dMaxDim.height));
        buWorkDir.addActionListener(this);
        buWorkDir.setActionCommand("MAINDIR_BUT_WORKDIR");
        this.cmWorkdir.add(buWorkDir);
        this.cmInputdir.setLayout(new BoxLayout(this.cmInputdir, 0));
        this.tfInputdir = new JTextField();
        this.tfInputdir.setFont(this.curTfFont);
        this.tfInputdir.addFocusListener(this);
        this.tfInputdir.setPreferredSize(dMaxDim);
        this.cmInputdir.add(this.tfInputdir);
        JButton buInputDir = new JButton("...");
        buInputDir.setPreferredSize(new Dimension(buInputDir.getPreferredSize().width, dMaxDim.height));
        buInputDir.addActionListener(this);
        buInputDir.setActionCommand("MAINDIR_BUT_INPUTDIR");
        this.cmInputdir.add(buInputDir);
        this.cbInputRecurse = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RECURSE", "recurse"));
        this.cbInputRecurse.setFont(this.curLabelFont);
        this.cbInputRecurse.setPreferredSize(new Dimension(this.cbInputRecurse.getPreferredSize().width, dMaxDim.height));
        this.cbInputRecurse.setSelected(this.bInputRecursive);
        this.cbInputRecurse.addItemListener(this);
        this.cbInputRecurse.setActionCommand("MAINDIR_CB_INPUTRECURSE");
        this.cmInputdir.add(this.cbInputRecurse);
        this.cmOutputdir.setLayout(new BoxLayout(this.cmOutputdir, 0));
        this.tfOutputdir = new JTextField();
        this.tfOutputdir.setFont(this.curTfFont);
        this.tfOutputdir.addFocusListener(this);
        this.tfOutputdir.setPreferredSize(dMaxDim);
        this.cmOutputdir.add(this.tfOutputdir);
        JButton buOutputDir = new JButton("...");
        buOutputDir.setPreferredSize(new Dimension(buOutputDir.getPreferredSize().width, dMaxDim.height));
        buOutputDir.addActionListener(this);
        buOutputDir.setActionCommand("MAINDIR_BUT_OUTPUTDIR");
        this.cmOutputdir.add(buOutputDir);
        this.cbOutputDir = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbOutputDir.setFont(this.curLabelFont);
        this.cbOutputDir.setPreferredSize(new Dimension(this.cbOutputDir.getPreferredSize().width, dMaxDim.height));
        this.cbOutputDir.setSelected(this.bOutputRel);
        this.cbOutputDir.addItemListener(this);
        this.cbOutputDir.setActionCommand("MAINDIR_CB_OUTPUTDIR");
        this.cmOutputdir.add(this.cbOutputDir);
        this.cmExt.setLayout(new BoxLayout(this.cmExt, 0));
        this.tfExt = new JTextField();
        this.tfExt.setFont(this.curTfFont);
        this.tfExt.addFocusListener(this);
        this.tfExt.setPreferredSize(dMaxDim);
        this.cmExt.add(this.tfExt);
        JButton buExt = new JButton("...");
        buExt.setPreferredSize(new Dimension(buExt.getPreferredSize().width, dMaxDim.height));
        buExt.addActionListener(this);
        buExt.setActionCommand("MAINDIR_BUT_EXT");
        this.cmExt.add(buExt);
        this.cmExclude.setLayout(new BoxLayout(this.cmExclude, 0));
        this.tfExclude = new JTextField();
        this.tfExclude.setFont(this.curTfFont);
        this.tfExclude.addFocusListener(this);
        this.tfExclude.setPreferredSize(dMaxDim);
        this.cmExclude.add(this.tfExclude);
        JButton buExclude = new JButton("...");
        buExclude.setPreferredSize(new Dimension(buExclude.getPreferredSize().width, dMaxDim.height));
        buExclude.addActionListener(this);
        buExclude.setActionCommand("MAINDIR_BUT_EXCLUDE");
        this.cmExclude.add(buExclude);
        JPanel cDirs = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(this.getTexts().getMessageTextDef("MSG_GUI_SETHEAD_BASIC", "Basic processing settings"));
        border.setTitleFont(this.curLabelFont);
        cDirs.setBorder(border);
        cDirs.setLayout(new FlowLayout(0));
        Container cData = new Container();
        this.buildTableDesign(cData, iMaxLabel, this.lbDirSection, this.cmDirSection);
        cDirs.add(cData);
        return cDirs;
    }

    public Container createGUIOutputSection(Dimension dMaxDim, int iMaxLabel) {
        this.cmOutType.setLayout(new BoxLayout(this.cmOutType, 0));
        String[] saList = new String[]{"", "itreeframes", "treeframes", "iframes", "frames", "noframes", "single", "latex", "pdflatex", "epub"};
        this.cbOutType = new JComboBox<String>(saList);
        this.cbOutType.setFont(this.curLabelFont);
        this.cbOutType.addFocusListener(this);
        this.cbOutType.addItemListener(this);
        this.cbOutType.setPreferredSize(new Dimension(200, dMaxDim.height));
        this.cbOutType.setBackground(new Color(255, 255, 255));
        this.cmOutType.add(this.cbOutType);
        this.cbEnableSearch = new JCheckBox(String.valueOf(this.guiTexts.getMessageTextDef("MSG_PARAMOUT_ENABLESEARCH", "Enable Search")) + " (-enablesearch):");
        this.cbEnableSearch.setFont(this.curLabelFont);
        this.cbEnableSearch.setHorizontalTextPosition(2);
        this.cbEnableSearch.setHorizontalAlignment(4);
        this.cbEnableSearch.setPreferredSize(new Dimension(dMaxDim.width - this.cbOutType.getPreferredSize().width, dMaxDim.height));
        this.cbEnableSearch.setSelected(this.bEnableSearch);
        this.cbEnableSearch.addItemListener(this);
        this.cbEnableSearch.setActionCommand("OUTSEC_CB_ENABLESEARCH");
        this.cmOutType.add(this.cbEnableSearch);
        this.cmTitle.setLayout(new BoxLayout(this.cmTitle, 0));
        this.tfTitle = new JTextField();
        this.tfTitle.setFont(this.curTfFont);
        this.tfTitle.addFocusListener(this);
        this.tfTitle.setPreferredSize(dMaxDim);
        this.cmTitle.add(this.tfTitle);
        this.cmLogo.setLayout(new BoxLayout(this.cmLogo, 0));
        this.tfLogo = new JTextField();
        this.tfLogo.setFont(this.curTfFont);
        this.tfLogo.addFocusListener(this);
        this.tfLogo.setPreferredSize(dMaxDim);
        this.cmLogo.add(this.tfLogo);
        JButton buLogo = new JButton("...");
        buLogo.setPreferredSize(new Dimension(buLogo.getPreferredSize().width, dMaxDim.height));
        buLogo.addActionListener(this);
        buLogo.setActionCommand("OUTSEC_BUT_LOGO");
        this.cmLogo.add(buLogo);
        this.cbLogo = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbLogo.setFont(this.curLabelFont);
        this.cbLogo.setPreferredSize(new Dimension(this.cbLogo.getPreferredSize().width, dMaxDim.height));
        this.cbLogo.setSelected(this.bLogoRel);
        this.cbLogo.addItemListener(this);
        this.cbLogo.setActionCommand("OUTSEC_CB_LOGO");
        this.cmLogo.add(this.cbLogo);
        this.cmCHM.setLayout(new BoxLayout(this.cmCHM, 0));
        this.tfCHM = new JTextField();
        this.tfCHM.setFont(this.curTfFont);
        this.tfCHM.addFocusListener(this);
        this.tfCHM.setPreferredSize(dMaxDim);
        this.cmCHM.add(this.tfCHM);
        JPanel cOutOpt = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(this.getTexts().getMessageTextDef("MSG_GUI_SETHEAD_OUTPUT", "Output settings"));
        border.setTitleFont(this.curLabelFont);
        cOutOpt.setBorder(border);
        cOutOpt.setLayout(new FlowLayout(0));
        Container cData = new Container();
        this.buildTableDesign(cData, iMaxLabel, this.lbOutputSection, this.cmOutputSection);
        cOutOpt.add(cData);
        return cOutOpt;
    }

    public Container createGUIStylesheetSection(Dimension dMaxDim, int iMaxLabel) {
        this.cmTempl.setLayout(new BoxLayout(this.cmTempl, 0));
        this.tfTempl = new JTextField();
        this.tfTempl.setFont(this.curTfFont);
        this.tfTempl.addFocusListener(this);
        this.tfTempl.setPreferredSize(dMaxDim);
        this.cmTempl.add(this.tfTempl);
        JButton buTemplDir = new JButton("...");
        buTemplDir.setPreferredSize(new Dimension(buTemplDir.getPreferredSize().width, dMaxDim.height));
        buTemplDir.addActionListener(this);
        buTemplDir.setActionCommand("OTHERSEC_BUT_TEMPL");
        this.cmTempl.add(buTemplDir);
        this.cbTempl = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbTempl.setFont(this.curLabelFont);
        this.cbTempl.setPreferredSize(new Dimension(this.cbTempl.getPreferredSize().width, dMaxDim.height));
        this.cbTempl.setSelected(this.bTemplRel);
        this.cbTempl.addItemListener(this);
        this.cbTempl.setActionCommand("OTHERSEC_CB_TEMPL");
        this.cmTempl.add(this.cbTempl);
        this.cmCSS.setLayout(new BoxLayout(this.cmCSS, 0));
        this.tfCSS = new JTextField();
        this.tfCSS.setFont(this.curTfFont);
        this.tfCSS.addFocusListener(this);
        this.tfCSS.setPreferredSize(dMaxDim);
        this.cmCSS.add(this.tfCSS);
        JButton buCSS = new JButton("...");
        buCSS.setPreferredSize(new Dimension(buCSS.getPreferredSize().width, dMaxDim.height));
        buCSS.addActionListener(this);
        buCSS.setActionCommand("STYLESEC_BUT_CSS");
        this.cmCSS.add(buCSS);
        this.cbCSS = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbCSS.setFont(this.curLabelFont);
        this.cbCSS.setPreferredSize(new Dimension(this.cbCSS.getPreferredSize().width, dMaxDim.height));
        this.cbCSS.setSelected(this.bCSSRel);
        this.cbCSS.addItemListener(this);
        this.cbCSS.setActionCommand("OUTSEC_CB_CSS");
        this.cmCSS.add(this.cbCSS);
        this.cmHeadIns.setLayout(new BoxLayout(this.cmHeadIns, 0));
        this.tfHeadIns = new JTextField();
        this.tfHeadIns.setFont(this.curTfFont);
        this.tfHeadIns.addFocusListener(this);
        this.tfHeadIns.setPreferredSize(dMaxDim);
        this.cmHeadIns.add(this.tfHeadIns);
        JButton buHeadIns = new JButton("...");
        buHeadIns.setPreferredSize(new Dimension(buHeadIns.getPreferredSize().width, dMaxDim.height));
        buHeadIns.addActionListener(this);
        buHeadIns.setActionCommand("STYLESEC_BUT_HEADINS");
        this.cmHeadIns.add(buHeadIns);
        this.cbHeadIns = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbHeadIns.setFont(this.curLabelFont);
        this.cbHeadIns.setPreferredSize(new Dimension(this.cbHeadIns.getPreferredSize().width, dMaxDim.height));
        this.cbHeadIns.setSelected(this.bHeadInsRel);
        this.cbHeadIns.addItemListener(this);
        this.cbHeadIns.setActionCommand("OUTSEC_CB_HEADINS");
        this.cmHeadIns.add(this.cbHeadIns);
        this.cmFootIns.setLayout(new BoxLayout(this.cmFootIns, 0));
        this.tfFootIns = new JTextField();
        this.tfFootIns.setFont(this.curTfFont);
        this.tfFootIns.addFocusListener(this);
        this.tfFootIns.setPreferredSize(dMaxDim);
        this.cmFootIns.add(this.tfFootIns);
        JButton buFootIns = new JButton("...");
        buFootIns.setPreferredSize(new Dimension(buFootIns.getPreferredSize().width, dMaxDim.height));
        buFootIns.addActionListener(this);
        buFootIns.setActionCommand("STYLESEC_BUT_FOOTINS");
        this.cmFootIns.add(buFootIns);
        this.cbFootIns = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbFootIns.setFont(this.curLabelFont);
        this.cbFootIns.setPreferredSize(new Dimension(this.cbFootIns.getPreferredSize().width, dMaxDim.height));
        this.cbFootIns.setSelected(this.bFootInsRel);
        this.cbFootIns.addItemListener(this);
        this.cbFootIns.setActionCommand("OUTSEC_CB_FOOTINS");
        this.cmFootIns.add(this.cbFootIns);
        JPanel cStyleOpt = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(this.getTexts().getMessageTextDef("MSG_GUI_SETHEAD_STYLE", "Template and style settings"));
        border.setTitleFont(this.curLabelFont);
        cStyleOpt.setBorder(border);
        cStyleOpt.setLayout(new FlowLayout(0));
        Container cData = new Container();
        this.buildTableDesign(cData, iMaxLabel, this.lbStylesheetSection, this.cmStylesheetSection);
        cStyleOpt.add(cData);
        return cStyleOpt;
    }

    public Container createGUIOtherSection(Dimension dMaxDim, int iMaxLabel) {
        this.cmRes.setLayout(new BoxLayout(this.cmRes, 0));
        this.tfRes = new JTextField();
        this.tfRes.setFont(this.curTfFont);
        this.tfRes.addFocusListener(this);
        this.tfRes.setPreferredSize(dMaxDim);
        this.cmRes.add(this.tfRes);
        JButton buResDir = new JButton("...");
        buResDir.setPreferredSize(new Dimension(buResDir.getPreferredSize().width, dMaxDim.height));
        buResDir.addActionListener(this);
        buResDir.setActionCommand("OTHERSEC_BUT_RES");
        this.cmRes.add(buResDir);
        this.cbRes = new JCheckBox(this.guiTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbRes.setFont(this.curLabelFont);
        this.cbRes.setPreferredSize(new Dimension(this.cbRes.getPreferredSize().width, dMaxDim.height));
        this.cbRes.setSelected(this.bResRel);
        this.cbRes.addItemListener(this);
        this.cbRes.setActionCommand("OTHERSEC_CB_RES");
        this.cmRes.add(this.cbRes);
        this.cmLocale.setLayout(new BoxLayout(this.cmLocale, 0));
        this.cbLocale = new JComboBox<String>(this.saLocale);
        this.cbLocale.setFont(this.curLabelFont);
        this.cbLocale.addFocusListener(this);
        this.cbLocale.addItemListener(this);
        this.cbLocale.setPreferredSize(new Dimension(200, dMaxDim.height));
        this.cbLocale.setBackground(new Color(255, 255, 255));
        this.cmLocale.add(this.cbLocale);
        this.cmExtDef.setLayout(new BoxLayout(this.cmExtDef, 0));
        this.tfExtDef = new JTextField();
        this.tfExtDef.setFont(this.curTfFont);
        this.tfExtDef.addFocusListener(this);
        this.tfExtDef.setPreferredSize(dMaxDim);
        this.cmExtDef.add(this.tfExtDef);
        JButton buExtDef = new JButton("...");
        buExtDef.setPreferredSize(new Dimension(buExtDef.getPreferredSize().width, dMaxDim.height));
        buExtDef.addActionListener(this);
        buExtDef.setActionCommand("OTHERSEC_BUT_EXTDEF");
        this.cmExtDef.add(buExtDef);
        JPanel cStyleOpt = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(this.getTexts().getMessageTextDef("MSG_GUI_SETHEAD_OTHER", "Other settings"));
        border.setTitleFont(this.curLabelFont);
        cStyleOpt.setBorder(border);
        cStyleOpt.setLayout(new FlowLayout(0));
        Container cData = new Container();
        this.buildTableDesign(cData, iMaxLabel, this.lbOtherSection, this.cmOtherSection);
        cStyleOpt.add(cData);
        return cStyleOpt;
    }

    public void initComboBoxes() {
        this.cbOutType.setSelectedItem("");
        this.cbLocale.setSelectedItem("");
    }

    public int getMaxCompWidth(Component[] cmArray) {
        int iResult = 0;
        int i = 0;
        while (i < cmArray.length) {
            Component cur = cmArray[i];
            cur.setFont(this.curLabelFont);
            int iCurWidth = cur.getPreferredSize().width;
            if (iCurWidth > iResult) {
                iResult = iCurWidth;
            }
            ++i;
        }
        return iResult;
    }

    public void buildTableDesign(Container cData, int iMaxLabel, JLabel[] lbDirSection, Component[] cmDirSection) {
        cData.setLayout(new BoxLayout(cData, 1));
        int iNum = lbDirSection.length;
        if (cmDirSection.length < iNum) {
            iNum = cmDirSection.length;
        }
        int i = 0;
        while (i < iNum) {
            Container cCur = new Container();
            cCur.setLayout(new FlowLayout(0));
            Dimension d = lbDirSection[i].getPreferredSize();
            lbDirSection[i].setPreferredSize(new Dimension(iMaxLabel, d.height));
            cCur.add(lbDirSection[i]);
            cCur.add(cmDirSection[i]);
            Dimension dMax = cmDirSection[i].getPreferredSize();
            cCur.setPreferredSize(new Dimension(iMaxLabel + dMax.width + 20, dMax.height + 5));
            cData.add(cCur);
            ++i;
        }
    }

    public void updateDataMembersFromFields() {
        if (!this.tfWorkdir.getText().equals(this.sWorkDir)) {
            this.sWorkDir = this.tfWorkdir.getText();
            this.mySettings.setWorkDir(this.sWorkDir, true);
            this.setDirty(true);
            this.setTextFileColorWorkDir(this.tfWorkdir, this.sWorkDir);
        }
        if (!this.tfInputdir.getText().equals(this.sInputDir)) {
            this.sInputDir = this.tfInputdir.getText();
            this.mySettings.setInputPath(this.sInputDir);
            this.setDirty(true);
        }
        if (this.cbInputRecurse.isSelected() != this.bInputRecursive) {
            if (this.bInputRecursive) {
                this.mySettings.setRecurse("yes");
            } else {
                this.mySettings.setRecurse("no");
            }
            this.setDirty(true);
        }
        if (!this.tfOutputdir.getText().equals(this.sOutputDir)) {
            this.sOutputDir = this.tfOutputdir.getText();
            this.mySettings.setOutPath(this.sOutputDir, true);
            if (!this.sOutputDir.equals("")) {
                this.bOutputRel = !FileUtils.isAbsolutePath(this.sOutputDir);
            }
            this.cbOutputDir.setSelected(this.bOutputRel);
            this.setDirty(true);
        }
        if (!this.tfExt.getText().equals(this.sExt)) {
            this.sExt = this.tfExt.getText().trim().toLowerCase();
            this.sExt = AutoDocStringUtils.replaceAll(this.sExt, ".", "");
            this.sExt = AutoDocStringUtils.replaceAll(this.sExt, "*", "");
            this.tfExt.setText(this.sExt);
            this.mySettings.setFileFilter(this.sExt);
            this.setDirty(true);
        }
        if (!this.tfExclude.getText().equals(this.sExclude)) {
            this.sExclude = this.tfExclude.getText();
            this.mySettings.setExclude(this.sExclude);
            this.setDirty(true);
        }
        if (!this.cbOutType.getSelectedItem().equals(this.sOutType)) {
            this.sOutType = (String)this.cbOutType.getSelectedItem();
            this.mySettings.setDocType(this.sOutType);
            this.setDirty(true);
        }
        if (this.cbEnableSearch.isSelected() != this.bEnableSearch) {
            this.bEnableSearch = this.cbEnableSearch.isSelected();
            if (this.bEnableSearch) {
                this.mySettings.setEnableSearch("yes");
            } else {
                this.mySettings.setEnableSearch("no");
            }
            this.setDirty(true);
        }
        if (!this.tfTitle.getText().equals(this.sTitle)) {
            this.sTitle = this.tfTitle.getText();
            this.mySettings.setTitle(this.sTitle);
            this.setDirty(true);
        }
        if (!this.tfLogo.getText().equals(this.sLogo)) {
            this.sLogo = this.tfLogo.getText();
            this.mySettings.setLogo(this.sLogo);
            if (!this.sLogo.equals("")) {
                this.bLogoRel = !FileUtils.isAbsolutePath(this.sLogo);
            }
            this.cbLogo.setSelected(this.bLogoRel);
            this.setDirty(true);
        }
        if (!this.tfCHM.getText().equals(this.sCHM)) {
            this.sCHM = this.tfCHM.getText();
            this.mySettings.setCHMProj(this.sCHM);
            this.setDirty(true);
        }
        if (!this.tfCSS.getText().equals(this.sCSS)) {
            this.sCSS = this.tfCSS.getText();
            this.mySettings.setStyleDefFile(this.sCSS, true);
            if (!this.sCSS.equals("")) {
                this.bCSSRel = !FileUtils.isAbsolutePath(this.sCSS);
            }
            this.cbCSS.setSelected(this.bCSSRel);
            this.setDirty(true);
        }
        if (!this.tfHeadIns.getText().equals(this.sHeadIns)) {
            this.sHeadIns = this.tfHeadIns.getText();
            this.mySettings.setHeaderInsFile(this.sHeadIns);
            if (!this.sHeadIns.equals("")) {
                this.bHeadInsRel = !FileUtils.isAbsolutePath(this.sHeadIns);
            }
            this.cbHeadIns.setSelected(this.bHeadInsRel);
            this.setDirty(true);
        }
        if (!this.tfFootIns.getText().equals(this.sFootIns)) {
            this.sFootIns = this.tfFootIns.getText();
            this.mySettings.setFootInsFile(this.sFootIns);
            if (!this.sFootIns.equals("")) {
                this.bFootInsRel = !FileUtils.isAbsolutePath(this.sFootIns);
            }
            this.cbFootIns.setSelected(this.bFootInsRel);
            this.setDirty(true);
        }
        if (!this.tfRes.getText().equals(this.sRes)) {
            this.sRes = this.tfRes.getText();
            this.mySettings.setResDir(this.sRes, true);
            if (!this.sRes.equals("")) {
                this.bResRel = !FileUtils.isAbsolutePath(this.sRes);
            }
            this.cbRes.setSelected(this.bResRel);
            this.setDirty(true);
            this.saLocale = this.updateLocaleList(this.sRes, this.saLocale, this.sLocale, this.cbLocale);
        }
        if (!this.cbLocale.getSelectedItem().equals(this.sLocale)) {
            this.sLocale = (String)this.cbLocale.getSelectedItem();
            this.mySettings.setLocale(this.sLocale);
            this.setDirty(true);
        }
        if (!this.tfTempl.getText().equals(this.sTempl)) {
            this.sTempl = this.tfTempl.getText();
            this.mySettings.setTemplateDir(this.sTempl, true);
            if (!this.sTempl.equals("")) {
                this.bTemplRel = !FileUtils.isAbsolutePath(this.sTempl);
            }
            this.cbTempl.setSelected(this.bTemplRel);
            this.setDirty(true);
        }
        if (!this.tfExtDef.getText().equals(this.sExtDef)) {
            this.sExtDef = this.tfExtDef.getText();
            this.mySettings.setExtDef(this.sExtDef);
            this.setDirty(true);
        }
        if (this.sInputDir.equals("") || this.sOutputDir.equals("")) {
            this.myMenu.setRunEnabled(false);
        } else {
            this.myMenu.setRunEnabled(true);
        }
    }

    public void updateDataFieldsFromMembers() {
        this.sWorkDir = this.mySettings.getWorkDir();
        this.setTextFileColorWorkDir(this.tfWorkdir, this.sWorkDir);
        this.tfWorkdir.setText(this.sWorkDir);
        this.tfWorkdir.setCaretPosition(0);
        this.sInputDir = this.mySettings.getInputPath();
        this.tfInputdir.setText(this.sInputDir);
        this.tfInputdir.setCaretPosition(0);
        this.cbInputRecurse.setSelected(this.bInputRecursive);
        this.sOutputDir = this.mySettings.getOutPath();
        this.tfOutputdir.setText(this.sOutputDir);
        this.tfOutputdir.setCaretPosition(0);
        if (!this.sOutputDir.equals("")) {
            this.bOutputRel = !FileUtils.isAbsolutePath(this.sOutputDir);
        }
        this.cbOutputDir.setSelected(this.bOutputRel);
        this.sExt = this.mySettings.getFileFilter();
        this.tfExt.setText(this.sExt);
        this.tfExt.setCaretPosition(0);
        this.sExclude = this.mySettings.getExclude();
        this.tfExclude.setText(this.sExclude);
        this.tfExclude.setCaretPosition(0);
        this.sOutType = this.mySettings.getDocTypeString();
        this.cbOutType.setSelectedItem(this.sOutType);
        this.sTitle = this.mySettings.getTitle();
        this.tfTitle.setText(this.sTitle);
        this.tfTitle.setCaretPosition(0);
        this.bEnableSearch = this.mySettings.getEnableSearch();
        this.cbEnableSearch.setSelected(this.bEnableSearch);
        this.sLogo = this.mySettings.getLogo();
        this.tfLogo.setText(this.sLogo);
        this.tfLogo.setCaretPosition(0);
        if (!this.sLogo.equals("")) {
            this.bLogoRel = !FileUtils.isAbsolutePath(this.sLogo);
        }
        this.cbLogo.setSelected(this.bLogoRel);
        this.sCHM = this.mySettings.getCHMProj();
        this.tfCHM.setText(this.sCHM);
        this.tfCHM.setCaretPosition(0);
        this.sCSS = this.mySettings.getStyleDefFile();
        this.tfCSS.setText(this.sCSS);
        this.tfCSS.setCaretPosition(0);
        if (!this.sCSS.equals("")) {
            this.bCSSRel = !FileUtils.isAbsolutePath(this.sCSS);
        }
        this.cbCSS.setSelected(this.bCSSRel);
        this.sHeadIns = this.mySettings.getHeaderInsFile();
        this.tfHeadIns.setText(this.sHeadIns);
        this.tfHeadIns.setCaretPosition(0);
        if (!this.sHeadIns.equals("")) {
            this.bHeadInsRel = !FileUtils.isAbsolutePath(this.sHeadIns);
        }
        this.cbHeadIns.setSelected(this.bHeadInsRel);
        this.sFootIns = this.mySettings.getFootInsFile();
        this.tfFootIns.setText(this.sFootIns);
        this.tfFootIns.setCaretPosition(0);
        if (!this.sFootIns.equals("")) {
            this.bFootInsRel = !FileUtils.isAbsolutePath(this.sFootIns);
        }
        this.cbFootIns.setSelected(this.bFootInsRel);
        this.sRes = this.mySettings.getResDir();
        this.tfRes.setText(this.sRes);
        this.tfRes.setCaretPosition(0);
        if (!this.sRes.equals("")) {
            this.bResRel = !FileUtils.isAbsolutePath(this.sRes);
        }
        this.cbRes.setSelected(this.bResRel);
        this.saLocale = this.updateLocaleList(this.sRes, this.saLocale, this.sLocale, this.cbLocale);
        this.sTempl = this.mySettings.getTemplateDir();
        this.tfTempl.setText(this.sTempl);
        this.tfTempl.setCaretPosition(0);
        if (!this.sTempl.equals("")) {
            this.bTemplRel = !FileUtils.isAbsolutePath(this.sTempl);
        }
        this.cbTempl.setSelected(this.bTemplRel);
        this.sLocale = this.mySettings.getLocale();
        this.cbLocale.setSelectedItem(this.sLocale);
        this.sExtDef = this.mySettings.getExtDef();
        this.tfExtDef.setText(this.sExtDef);
        this.tfExtDef.setCaretPosition(0);
        if (this.sInputDir.equals("") || this.sOutputDir.equals("")) {
            this.myMenu.setRunEnabled(false);
        } else {
            this.myMenu.setRunEnabled(true);
        }
    }

    public void setTextFileColorWorkDir(JTextField tfWorkdir, String sWorkDir) {
        if (FileUtils.dirExist(sWorkDir)) {
            tfWorkdir.setForeground(Color.BLACK);
        } else if (!sWorkDir.equals("")) {
            tfWorkdir.setForeground(Color.RED);
        }
    }

    public void setTitle(String sPrefix) {
        String sTitle = this.sTitlePrefix = sPrefix;
        if (!this.sConfFileName.equals("")) {
            sTitle = String.valueOf(sTitle) + " - " + this.sConfFileName;
        }
        if (this.isDirty) {
            sTitle = String.valueOf(sTitle) + " *";
        }
        super.setTitle(sTitle);
    }

    public void setDirty(boolean bDirty) {
        this.isDirty = bDirty;
        if (bDirty && this.bVirgin) {
            this.bVirgin = false;
        }
        this.setTitle(this.sTitlePrefix);
    }

    public void setConfFilename(String sFilename, boolean bDirty) {
        this.sConfFileName = sFilename;
        this.setDirty(bDirty);
    }

    public void setWindowSize() {
        double dAspect = (double)this.WinWidth / (double)this.WinHeight;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40;
        int iDiff_x = iScreenWidth - this.WinWidth;
        int iDiff_y = iScreenHeight - this.WinHeight;
        if (iDiff_x < 0 || iDiff_y < 0) {
            if (iDiff_x < iDiff_y) {
                int iCalc_y;
                this.WinWidth = iScreenWidth;
                this.WinHeight = iCalc_y = (int)((double)this.WinWidth / dAspect);
            } else {
                int iCalc_x;
                this.WinHeight = iScreenHeight;
                this.WinWidth = iCalc_x = (int)((double)this.WinHeight * dAspect);
            }
            dAspect = (double)this.WinWidth / (double)this.WinHeight;
        }
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation((iScreenWidth - this.WinWidth) / 2, (iScreenHeight - this.WinHeight) / 2);
    }

    public void doLoadConf(String sFilename) throws IOException {
        this.mySettings = new AutoDocSettings();
        this.mySettings.getMsgHandler().setTexts(new AutoDocMessageTexts());
        String[] saCfgArgs = this.mySettings.readCfgFile(sFilename);
        this.mySettings.processSettings(saCfgArgs, AutoDoc.ProgDir, false);
    }

    public void doSaveConf(String sFilename, boolean bTemp) {
        try {
            this.mySettings.writeCfgFile(sFilename);
            this.setConfFilename(sFilename, bTemp);
        }
        catch (IOException e) {
            String sMsg = this.guiTexts.getMessageText("ERR_CFGNOTWRITE", sFilename);
            String sTitle = this.guiTexts.getMessageTextDef("ERR_ERROR", "Error");
            JOptionPane.showMessageDialog(null, sMsg, sTitle, 0);
        }
    }

    public void doBeginRun() {
        this.bRun = true;
        this.setEnabled(false);
        this.runDialog = new AutoDocGUIRunDialog(this, this.sConfFileName, this.sWorkDir, this.sProgDir, this.sOutputDir, this.guiTexts);
        this.runDialog.showDialog();
    }

    public void doEndRun() {
        this.runDialog = null;
        this.bRun = false;
        this.setEnabled(true);
        this.requestFocus();
        if (this.fTemp != null) {
            this.fTemp.delete();
            this.setConfFilename(this.sOrgName, this.bOrgDirty);
            this.fTemp = null;
        }
    }

    private String getDefaultAbsDirectoryForChooser(String sNewVal, String sDefault) {
        String sReturn = sDefault;
        sReturn = FileUtils.toCanonicalPath(sReturn);
        if (!sNewVal.trim().equals("")) {
            File fDir;
            File fTmp = new File(sNewVal);
            if (!FileUtils.isAbsolutePath(sNewVal)) {
                fTmp = new File(sReturn, sNewVal);
            }
            if ((fDir = fTmp.getParentFile()).exists()) {
                sReturn = FileUtils.toCanonicalPath(fDir);
            }
        }
        return sReturn;
    }

    public String doDirectoryChooser(String sDir, String sTitle) {
        String sStartDir = sDir;
        if (sStartDir.equals("")) {
            sStartDir = this.sWorkDir;
        } else {
            if (!FileUtils.isAbsolutePath(sStartDir)) {
                sStartDir = FileUtils.convertRelativetoAbsolutePath(this.sWorkDir, sStartDir);
            }
            if (!FileUtils.dirExist(sStartDir)) {
                sStartDir = this.sWorkDir;
            }
        }
        JFileChooser ch = new JFileChooser(sStartDir);
        ch.setFileSelectionMode(1);
        ch.setDialogTitle(sTitle);
        int iRet = ch.showOpenDialog(this);
        String sSelected = "";
        if (iRet == 0) {
            sSelected = FileUtils.toCanonicalPath(ch.getSelectedFile());
        }
        return sSelected;
    }

    public String doOpenFileChooser(String sDir, FileFilter filter) {
        JFileChooser ch = new JFileChooser(sDir);
        FileFilter allFilter = ch.getAcceptAllFileFilter();
        ch.removeChoosableFileFilter(allFilter);
        ch.addChoosableFileFilter(filter);
        ch.addChoosableFileFilter(allFilter);
        String sSelected = "";
        int iRet = ch.showOpenDialog(null);
        if (iRet == 0) {
            sSelected = FileUtils.toCanonicalPath(ch.getSelectedFile());
        }
        return sSelected;
    }

    public void onClear() {
        this.mySettings = new AutoDocSettings();
        this.mySettings.getMsgHandler().setTexts(new AutoDocMessageTexts());
        this.setConfFilename("", true);
        this.sWorkDir = "";
        this.initComboBoxes();
        this.updateDataFieldsFromMembers();
    }

    public String getCurConfDirectory() {
        String sReturn = "";
        if (!this.sConfFileName.equals("")) {
            File f = new File(this.sConfFileName);
            sReturn = f.getParent();
        }
        return sReturn;
    }

    public void onLoad() {
        String sSelected;
        String[] saExt = new String[]{"adc", "ini", "cfg"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "AutoDoc Configuration " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doOpenFileChooser(sDir, filter)).equals("")) {
            this.initComboBoxes();
            try {
                this.doLoadConf(sSelected);
            }
            catch (IOException e) {
                String sMsg = this.guiTexts.getMessageText("WARN_CFGNOTREAD", sSelected);
                String sTitle = this.guiTexts.getMessageTextDef("WARN_WARNING", "Warning");
                JOptionPane.showMessageDialog(null, sMsg, sTitle, 1);
            }
            this.updateDataFieldsFromMembers();
            this.setConfFilename(sSelected, false);
        }
    }

    public void onRun() {
        try {
            this.sOrgName = "";
            this.bOrgDirty = false;
            if (this.sConfFileName.equals("") || this.isDirty) {
                this.sOrgName = this.sConfFileName;
                this.bOrgDirty = this.isDirty;
                this.fTemp = File.createTempFile("Autodoc", ".ag");
                this.sConfFileName = FileUtils.toCanonicalPath(this.fTemp);
                this.doSaveConf(this.sConfFileName, true);
            }
            this.doBeginRun();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSaveAs() {
        String[] saExt = new String[]{"adc", "ini", "cfg"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "AutoDoc Configuration " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        JFileChooser ch = new JFileChooser(sDir);
        FileFilter allFilter = ch.getAcceptAllFileFilter();
        ch.removeChoosableFileFilter(allFilter);
        ch.addChoosableFileFilter(filter);
        ch.addChoosableFileFilter(allFilter);
        String sDefault = "";
        sDefault = this.sConfFileName.equals("") ? "AutoDoc.adc" : this.sConfFileName;
        ch.setSelectedFile(new File(sDefault));
        int iRet = ch.showSaveDialog(null);
        if (iRet == 0) {
            String sSelected = FileUtils.toCanonicalPath(ch.getSelectedFile());
            this.doSaveConf(sSelected, false);
        }
    }

    public void onSave() {
        if (this.sConfFileName.equals("")) {
            this.onSaveAs();
        } else {
            this.doSaveConf(this.sConfFileName, false);
        }
    }

    public void onExit() {
        String sMessage;
        int n;
        this.updateDataMembersFromFields();
        if (this.isDirty && !this.bVirgin && (n = JOptionPane.showOptionDialog(this, sMessage = this.guiTexts.getMessageTextDef("MSG_GUI_CONFNOTSAVED", "Configuration has not been saved. Do you want to save it?"), this.guiTexts.getMessageTextDef("MSG_GUI_MESSAGE", "Message"), 0, 3, null, null, null)) != -1 && n == 0) {
            this.onSave();
        }
        System.exit(0);
    }

    public void onAbout() {
        String sTitle = this.guiTexts.getMessageTextDef("MSG_GUI_MENU_ABOUT", "About...");
        if (sTitle.endsWith("...")) {
            sTitle = sTitle.substring(0, sTitle.length() - 3).trim();
        }
        String sAboutMessage = AutoDoc.genHeaderMsg(this.guiTexts);
        sAboutMessage = String.valueOf(sAboutMessage) + "  " + this.guiTexts.getMessageTextDef("MSG_GUI_ABOUT_WEBSITE", "Project Website") + ": http://sourceforge.net/projects/de-autodoc" + "\n";
        sAboutMessage = String.valueOf(sAboutMessage) + "  " + this.guiTexts.getMessageTextDef("MSG_GUI_ABOUT_SUPPORT", "Support Contact") + ": AutoDoc@Enache.de" + "\n";
        sAboutMessage = String.valueOf(sAboutMessage) + "\n";
        JOptionPane.showMessageDialog(null, sAboutMessage, sTitle, 1);
    }

    public void onGUIProp() {
        String sTitle = this.guiTexts.getMessageTextDef("MSG_GUI_MENU_GUIPROP", "GUI Properties...");
        if (sTitle.endsWith("...")) {
            sTitle = sTitle.substring(0, sTitle.length() - 3).trim();
        }
        Container cmGuiRes = new Container();
        cmGuiRes.setLayout(new BoxLayout(cmGuiRes, 0));
        this.tfGuiRes = new JTextField();
        this.tfGuiRes.setFont(this.curTfFont);
        this.tfGuiRes.setText(this.sGuiRes);
        this.tfGuiRes.addFocusListener(this);
        cmGuiRes.add(this.tfGuiRes);
        JButton buResDir = new JButton("...");
        buResDir.addActionListener(this);
        buResDir.setActionCommand("GUIPREF_BUT_RES");
        cmGuiRes.add(buResDir);
        Container cmGuiTempl = new Container();
        cmGuiTempl.setLayout(new BoxLayout(cmGuiTempl, 0));
        this.tfGuiTempl = new JTextField();
        this.tfGuiTempl.setFont(this.curTfFont);
        this.tfGuiTempl.setText(this.sTemplFilename);
        this.tfGuiTempl.addFocusListener(this);
        cmGuiTempl.add(this.tfGuiTempl);
        JButton buTemplDir = new JButton("...");
        buTemplDir.addActionListener(this);
        buTemplDir.setActionCommand("GUIPREF_BUT_TEMPL");
        cmGuiTempl.add(buTemplDir);
        String[] sa = new String[]{"en", "de"};
        this.cbGuiLocale = new JComboBox();
        this.cbGuiLocale.setFont(this.curTfFont);
        this.cbGuiLocale.addFocusListener(this);
        this.cbGuiLocale.addItemListener(this);
        sa = this.updateLocaleList(this.sGuiRes, sa, this.sGuiLocale, this.cbGuiLocale);
        Object[] aMessage = new Object[]{String.valueOf(this.guiTexts.getMessageTextDef("MSG_PARAMOUT_LOCALE", "Locale")) + ":", this.cbGuiLocale, String.valueOf(this.guiTexts.getMessageTextDef("MSG_PARAMOUT_RESDIR", "Ressource directory")) + ":", cmGuiRes, String.valueOf(this.guiTexts.getMessageTextDef("MSG_GUI_TEMPLATE", "Template file")) + ":", cmGuiTempl};
        int iRet = JOptionPane.showOptionDialog(null, aMessage, sTitle, 2, -1, null, null, null);
        if (iRet == 0) {
            String sLocaleOld = this.sGuiLocale.trim();
            String sResOld = this.sGuiRes.trim();
            String sTemplOld = this.sTemplFilename.trim();
            this.sGuiLocale = ((String)this.cbGuiLocale.getSelectedItem()).trim();
            this.sGuiRes = this.tfGuiRes.getText().trim();
            this.sTemplFilename = this.tfGuiTempl.getText().trim();
            if (!(this.sGuiLocale.equals(sLocaleOld) && this.sGuiRes.equals(sResOld) && this.sTemplFilename.equals(sTemplOld))) {
                this.saveGUISettingsToSettingsFile(this.sPropDir, this.sPropFilename);
                String sMsgTitle = this.guiTexts.getMessageTextDef("MSG_GUI_MESSAGE", "Message");
                String sMsgText = this.guiTexts.getMessageTextDef("MSG_GUI_SETTINGS_RESTART", "GUI settings have been changed.\nPlease re-start AutoDoc GUI for changes to take effect.");
                JOptionPane.showMessageDialog(null, sMsgText, sMsgTitle, 1);
            }
        }
    }

    public void onPlugManager() {
        AutoDocGUIPluginManagerDialog exclDlg;
        boolean bResult;
        String sURLBase = "http://www.enache.de/AutoDocPlugins";
        String sURL = "http://www.enache.de/AutoDocPlugins/Plugins.txt";
        ArrayList lInstalledPlugins = AutoDocPluginUtils.loadInstalledPluginsStandalone(this.sProgDir);
        List pluginList = new ArrayList();
        String sWaitPrompt = this.guiTexts.getMessageTextDef("MSG_GUI_PLUGMGR_WAIT", "Please wait...");
        String sLoad = this.guiTexts.getMessageText("MSG_GUI_PLUGMGR_GETLIST", "http://www.enache.de/AutoDocPlugins");
        if (sLoad.equals("")) {
            sLoad = "Retrieving plugin list from server 'http://www.enache.de/AutoDocPlugins'...";
        }
        JDialog waitLoadDialog = AutoDocGUIMainFrame.openWaitDialog(sWaitPrompt, sLoad);
        try {
            List list = AutoDocPluginUtils.getPluginListFromServer("http://www.enache.de/AutoDocPlugins/Plugins.txt");
            pluginList = AutoDocPluginUtils.getInstallablePlugins(list, lInstalledPlugins, AutoDoc.Version, true);
            AutoDocGUIMainFrame.closeWaitDialog(waitLoadDialog);
        }
        catch (IOException e) {
            AutoDocGUIMainFrame.closeWaitDialog(waitLoadDialog);
            String sErrTitle = this.guiTexts.getMessageTextDef("ERR_ERROR", "Error");
            String sErrorMessage = this.guiTexts.getMessageText("MSG_GUI_PLUGMGR_FAILEDLOAD", e.getMessage());
            if (sErrorMessage.equals("")) {
                sErrorMessage = "Unable to load plugin information from server:\n" + e.getMessage() + "\nPlease check your internet settings.";
            }
            JOptionPane.showMessageDialog(null, sErrorMessage, sErrTitle, 0);
            return;
        }
        String sTitle = this.guiTexts.getMessageTextDef("MSG_GUI_MENU_PLUGMGR", "Plugin Manager...");
        if (sTitle.endsWith("...")) {
            sTitle = sTitle.substring(0, sTitle.length() - 3).trim();
        }
        if (bResult = (exclDlg = new AutoDocGUIPluginManagerDialog(this, sTitle, this.sProgDir, pluginList, lInstalledPlugins, this.guiTexts)).getResult()) {
            List lToBeInstalled = exclDlg.getToInstall();
            this.installPlugins(lToBeInstalled, "http://www.enache.de/AutoDocPlugins", sTitle, sWaitPrompt);
            List lToBeRemoved = exclDlg.getToRemove();
            this.removeInstalledPlugins(lToBeRemoved, sTitle, sWaitPrompt);
        }
    }

    private void installPlugins(List lToBeInstalled, String sURLBase, String sTitle, String sWaitPrompt) {
        int iNumInst = lToBeInstalled.size();
        if (iNumInst > 0) {
            int i = 0;
            while (i < iNumInst) {
                AutoDocPluginInfo curInfo = (AutoDocPluginInfo)lToBeInstalled.get(i);
                String sName = curInfo.getName();
                String sInstalling = String.valueOf(this.guiTexts.getMessageTextDef("MSG_GUI_PLUGMGR_INSTALLING", "Installing plugin")) + ": " + sName;
                JDialog waitInstDialog = AutoDocGUIMainFrame.openWaitDialog(sWaitPrompt, sInstalling);
                try {
                    AutoDocPluginUtils.installPlugin(sURLBase, curInfo, this.sProgDir, true);
                }
                catch (Error e) {
                    String[] saParams;
                    String sErrorMessage;
                    String sErr = e.getMessage();
                    if (sErr.startsWith("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION:")) {
                        String sValue;
                        String sKey = sErr.substring(0, 37);
                        if ((sErr = this.guiTexts.getMessageText(sKey, (sValue = sErr.substring(39)).trim())).equals("")) {
                            sErr = "You do not have write permission for directory " + sValue + ".\nPlease run AutoDoc as administrator.";
                        }
                    } else if (sErr.equals("MSG_GUI_PLUGMGR_ERR_FAILCREATPGDIR")) {
                        sErr = this.guiTexts.getMessageTextDef("MSG_GUI_PLUGMGR_ERR_FAILCREATPGDIR", "Cannot create plugin directory.");
                    }
                    if ((sErrorMessage = this.guiTexts.getMessageText("MSG_GUI_PLUGMGR_ERR_FAILINSTALL", saParams = new String[]{sName, sErr})).equals("")) {
                        sErrorMessage = "Installation of plugin '" + sName + "' failed.\nError message: " + sErr + ".";
                    }
                    JOptionPane.showMessageDialog(null, sErrorMessage, sTitle, 0);
                }
                AutoDocGUIMainFrame.closeWaitDialog(waitInstDialog);
                ++i;
            }
        }
    }

    private void removeInstalledPlugins(List lToBeRemoved, String sTitle, String sWaitPrompt) {
        int iNumRemove = lToBeRemoved.size();
        if (iNumRemove > 0) {
            String sList = "";
            int i = 0;
            while (i < iNumRemove) {
                AutoDocPluginInfo curInfo = (AutoDocPluginInfo)lToBeRemoved.get(i);
                sList = String.valueOf(sList) + "\n" + curInfo.getName();
                ++i;
            }
            String sRemoving = String.valueOf(this.guiTexts.getMessageTextDef("MSG_GUI_PLUGMGR_REMOVING", "Removing selected plugins")) + ":" + sList;
            JDialog waitRemoveDialog = AutoDocGUIMainFrame.openWaitDialog(sWaitPrompt, sRemoving);
            int i2 = 0;
            while (i2 < iNumRemove) {
                AutoDocPluginInfo curInfo = (AutoDocPluginInfo)lToBeRemoved.get(i2);
                String sName = curInfo.getName();
                try {
                    AutoDocPluginUtils.removePlugin(curInfo, this.sProgDir, true);
                }
                catch (Error e) {
                    String[] saParams;
                    String sErrorMessage;
                    String sErr = e.getMessage();
                    if (sErr.startsWith("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION:")) {
                        String sValue;
                        String sKey = sErr.substring(0, 37);
                        if ((sErr = this.guiTexts.getMessageText(sKey, (sValue = sErr.substring(39)).trim())).equals("")) {
                            sErr = "You do not have write permission for directory " + sValue + ".\nPlease run AutoDoc as administrator.";
                        }
                    } else if (sErr.equals("MSG_GUI_PLUGMGR_ERR_FAILCREATPGDIR")) {
                        sErr = this.guiTexts.getMessageTextDef("MSG_GUI_PLUGMGR_ERR_FAILCREATPGDIR", "Cannot create plugin directory.");
                    }
                    if ((sErrorMessage = this.guiTexts.getMessageText("MSG_GUI_PLUGMGR_ERR_FAILREMOVE", saParams = new String[]{sName, sErr})).equals("")) {
                        sErrorMessage = "Removal of plugin '" + sName + "' failed.\nError message: " + sErr + ".";
                    }
                    JOptionPane.showMessageDialog(null, sErrorMessage, sTitle, 0);
                }
                ++i2;
            }
            AutoDocGUIMainFrame.closeWaitDialog(waitRemoveDialog);
        }
    }

    public static JDialog openWaitDialog(String sTitle, String sMessage) {
        JDialog waitInstDialog = new JDialog();
        String sHTML = "<html>" + sMessage.replace("\n", "<br/>") + "</html>";
        JLabel instLabel = new JLabel(sHTML);
        Font f = instLabel.getFont();
        instLabel.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
        instLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        waitInstDialog.setLocationRelativeTo(null);
        waitInstDialog.setTitle(sTitle);
        waitInstDialog.add(instLabel);
        waitInstDialog.pack();
        waitInstDialog.setVisible(true);
        waitInstDialog.update(waitInstDialog.getGraphics());
        return waitInstDialog;
    }

    public static void closeWaitDialog(JDialog dialog) {
        dialog.setVisible(false);
    }

    public void onButWorkdir() {
        String sSelected = this.doDirectoryChooser(this.sWorkDir, this.guiTexts.getMessageTextDef("MSG_GUI_CHOOSE_WORK", "Choose working directory"));
        if (!sSelected.equals("")) {
            if (!sSelected.equals(this.sWorkDir)) {
                this.setDirty(true);
            }
            this.sWorkDir = sSelected;
            this.mySettings.setWorkDir(this.sWorkDir, true);
            this.tfWorkdir.setText(sSelected);
        }
    }

    public void onButInputdir() {
        boolean isCaseSensitive = FileUtils.isCaseSensitivePath();
        AutoDocGUIInputListDialog exclDlg = new AutoDocGUIInputListDialog(this, this.sInputDir, this.guiTexts.getMessageTextDef("MSG_GUI_INPUT_DIRECTORIES", "Input Directories"), File.pathSeparator, isCaseSensitive, this.sWorkDir, this.guiTexts);
        String sInputDir = exclDlg.getResult();
        this.mySettings.setInputPath(sInputDir);
        this.updateDataFieldsFromMembers();
    }

    public void onButOutputdir() {
        String sSelected = this.doDirectoryChooser(this.sOutputDir, this.guiTexts.getMessageTextDef("MSG_GUI_CHOOSE_OUTDIR", "Choose output directory"));
        if (!sSelected.equals("")) {
            if (!sSelected.equals(this.sOutputDir)) {
                this.setDirty(true);
            }
            this.sOutputDir = sSelected;
            this.mySettings.setOutPath(this.sOutputDir, true);
            this.tfOutputdir.setText(sSelected);
            if (!this.sOutputDir.equals("")) {
                this.bOutputRel = !FileUtils.isAbsolutePath(this.sOutputDir);
            }
            this.cbOutputDir.setSelected(this.bOutputRel);
        }
    }

    public void onButExt() {
        AutoDocGUIExtListDialog extDlg = new AutoDocGUIExtListDialog(this, this.sExt, this.guiTexts.getMessageTextDef("MSG_GUI_EXTENSIONS", "Extensions"), ",", false, this.guiTexts);
        String sExt = extDlg.getResult();
        this.mySettings.setFileFilter(sExt);
        this.updateDataFieldsFromMembers();
    }

    public void onButExclude() {
        boolean isCaseSensitive = FileUtils.isCaseSensitivePath();
        AutoDocGUISimpleListDialog exclDlg = new AutoDocGUISimpleListDialog(this, this.sExclude, this.guiTexts.getMessageTextDef("MSG_GUI_EXCLUDES", "Excludes"), File.pathSeparator, isCaseSensitive, this.guiTexts);
        String sExclude = exclDlg.getResult();
        this.mySettings.setExclude(sExclude);
        this.updateDataFieldsFromMembers();
    }

    public void onButLogo() {
        String sSelected;
        String[] saExt = new String[]{"jpg", "jpeg", "png", "gif"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "Image files " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doOpenFileChooser(sDir = this.getDefaultAbsDirectoryForChooser(this.sLogo, sDir), filter)).equals("")) {
            if (!sSelected.equals(this.sLogo)) {
                this.setDirty(true);
            }
            this.sLogo = sSelected;
            this.mySettings.setLogo(this.sLogo);
            this.tfLogo.setText(sSelected);
            if (!this.sLogo.equals("")) {
                this.bLogoRel = !FileUtils.isAbsolutePath(this.sLogo);
            }
            this.cbLogo.setSelected(this.bLogoRel);
        }
    }

    public void onButCSS() {
        String sSelected;
        String[] saExt = new String[]{"css", "cls", "sty"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "Template files " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doOpenFileChooser(sDir = this.getDefaultAbsDirectoryForChooser(this.sCSS, sDir), filter)).equals("")) {
            if (!sSelected.equals(this.sCSS)) {
                this.setDirty(true);
            }
            this.sCSS = sSelected;
            this.mySettings.setStyleDefFile(this.sCSS, true);
            this.tfCSS.setText(sSelected);
            if (!this.sCSS.equals("")) {
                this.bCSSRel = !FileUtils.isAbsolutePath(this.sCSS);
            }
            this.cbCSS.setSelected(this.bCSSRel);
        }
    }

    public void onButHeadIns() {
        String sSelected;
        String[] saExt = new String[]{"htm", "html", "tex"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "Header files " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doOpenFileChooser(sDir = this.getDefaultAbsDirectoryForChooser(this.sHeadIns, sDir), filter)).equals("")) {
            if (!sSelected.equals(this.sHeadIns)) {
                this.setDirty(true);
            }
            this.sHeadIns = sSelected;
            this.mySettings.setHeaderInsFile(this.sHeadIns);
            this.tfHeadIns.setText(sSelected);
            if (!this.sHeadIns.equals("")) {
                this.bHeadInsRel = !FileUtils.isAbsolutePath(this.sHeadIns);
            }
            this.cbHeadIns.setSelected(this.bHeadInsRel);
        }
    }

    public void onButFootIns() {
        String sSelected;
        String[] saExt = new String[]{"htm", "html", "tex"};
        String sExtList = "(" + AutoDocStringUtils.StringArrayToSeparatedListWithPrefix(saExt, "; ", "*.") + ")";
        AutoDocGUIFileNameFilter filter = new AutoDocGUIFileNameFilter(saExt, "Footer files " + sExtList);
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doOpenFileChooser(sDir = this.getDefaultAbsDirectoryForChooser(this.sFootIns, sDir), filter)).equals("")) {
            if (!sSelected.equals(this.sFootIns)) {
                this.setDirty(true);
            }
            this.sFootIns = sSelected;
            this.mySettings.setFootInsFile(this.sFootIns);
            this.tfFootIns.setText(sSelected);
            if (!this.sFootIns.equals("")) {
                this.bFootInsRel = !FileUtils.isAbsolutePath(this.sFootIns);
            }
            this.cbFootIns.setSelected(this.bFootInsRel);
        }
    }

    public void onButRes() {
        String sTmp;
        String sSelected;
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doDirectoryChooser(sDir = !(sTmp = this.sRes.trim()).equals("") && FileUtils.isAbsolutePath(sTmp) ? sTmp : FileUtils.convertRelativetoAbsolutePath(sDir, sTmp), this.guiTexts.getMessageTextDef("MSG_GUI_CHOOSE_RESDIR", "Choose resource directory"))).equals("")) {
            if (!sSelected.equals(this.sRes)) {
                this.setDirty(true);
            }
            this.sRes = sSelected;
            this.mySettings.setResDir(this.sRes, true);
            this.tfRes.setText(sSelected);
            if (!this.sRes.equals("")) {
                this.bResRel = !FileUtils.isAbsolutePath(this.sRes);
            }
            this.cbRes.setSelected(this.bResRel);
            this.saLocale = this.updateLocaleList(this.sRes, this.saLocale, this.sLocale, this.cbLocale);
        }
    }

    public void onButTempl() {
        String sTmp;
        String sSelected;
        String sDir = this.getCurConfDirectory();
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        if (!(sSelected = this.doDirectoryChooser(sDir = !(sTmp = this.sTempl.trim()).equals("") && FileUtils.isAbsolutePath(sTmp) ? sTmp : FileUtils.convertRelativetoAbsolutePath(sDir, sTmp), this.guiTexts.getMessageTextDef("MSG_GUI_CHOOSE_TEMPLDIR", "Choose template directory"))).equals("")) {
            if (!sSelected.equals(this.sTempl)) {
                this.setDirty(true);
            }
            this.sTempl = sSelected;
            this.mySettings.setTemplateDir(this.sTempl, true);
            this.tfTempl.setText(sSelected);
            if (!this.sTempl.equals("")) {
                this.bTemplRel = !FileUtils.isAbsolutePath(this.sTempl);
            }
            this.cbTempl.setSelected(this.bTemplRel);
        }
    }

    public void onButExtDef() {
        AutoDocGUIExtDefListDialog extdefDlg = new AutoDocGUIExtDefListDialog(this, this.sExtDef, this.guiTexts.getMessageTextDef("MSG_GUI_EXTDEFAULTS", "Extension Defaults"), " | ", this.guiTexts);
        String sExtDef = extdefDlg.getResult();
        this.mySettings.setExtDef(sExtDef);
        this.updateDataFieldsFromMembers();
    }

    public void onButGuiRes() {
        String sSelected;
        String sDir = this.sProgDir;
        if (!this.sRes.equals("")) {
            sDir = this.sRes;
        }
        if (!this.tfGuiRes.getText().trim().equals("")) {
            sDir = this.tfGuiRes.getText().trim();
        }
        if (!(sSelected = this.doDirectoryChooser(sDir = FileUtils.toCanonicalPath(sDir), this.guiTexts.getMessageTextDef("MSG_GUI_CHOOSE_RESDIR", "Choose resource directory"))).equals("")) {
            String sGuiRes = sSelected.trim();
            this.tfGuiRes.setText(sGuiRes);
            this.updateGuiLocalListFromResDir(sGuiRes);
            this.tfGuiRes.setCaretPosition(0);
        }
    }

    public void onButGuiTempl() {
        String sSelected;
        String sDir = this.sProgDir;
        if (!this.tfGuiTempl.getText().trim().equals("")) {
            sDir = this.tfGuiTempl.getText().trim();
        }
        if (!(sSelected = this.doOpenFileChooser(sDir = FileUtils.toCanonicalPath(sDir), null)).equals("")) {
            String sGuiTempl = sSelected.trim();
            this.tfGuiTempl.setText(sGuiTempl);
            this.tfGuiTempl.setCaretPosition(0);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.cbOutType)) {
            if (!this.cbOutType.getSelectedItem().equals(this.sOutType)) {
                this.sOutType = (String)this.cbOutType.getSelectedItem();
                this.mySettings.setDocType(this.sOutType);
                this.setDirty(true);
            }
        } else if (e.getSource().equals(this.cbLocale)) {
            if (!this.cbLocale.getSelectedItem().equals(this.sLocale)) {
                this.sLocale = (String)this.cbLocale.getSelectedItem();
                this.mySettings.setLocale(this.sLocale);
                this.setDirty(true);
            }
        } else if (e.getSource().equals(this.cbOutputDir)) {
            this.bOutputRel = this.cbOutputDir.isSelected();
            this.sOutputDir = this.switchRelative(this.sWorkDir, this.sOutputDir, this.tfOutputdir, this.bOutputRel);
            this.mySettings.setOutPath(this.sOutputDir, true);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbInputRecurse)) {
            this.bInputRecursive = this.cbInputRecurse.isSelected();
            if (this.bInputRecursive) {
                this.mySettings.setRecurse("yes");
            } else {
                this.mySettings.setRecurse("no");
            }
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbLogo)) {
            this.bLogoRel = this.cbLogo.isSelected();
            this.sLogo = this.switchRelative(this.sWorkDir, this.sLogo, this.tfLogo, this.bLogoRel);
            this.mySettings.setLogo(this.sLogo);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbCSS)) {
            this.bCSSRel = this.cbCSS.isSelected();
            this.sCSS = this.switchRelative(this.sWorkDir, this.sCSS, this.tfCSS, this.bCSSRel);
            this.mySettings.setStyleDefFile(this.sCSS, true);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbHeadIns)) {
            this.bHeadInsRel = this.cbHeadIns.isSelected();
            this.sHeadIns = this.switchRelative(this.sWorkDir, this.sHeadIns, this.tfHeadIns, this.bHeadInsRel);
            this.mySettings.setHeaderInsFile(this.sHeadIns);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbFootIns)) {
            this.bFootInsRel = this.cbFootIns.isSelected();
            this.sFootIns = this.switchRelative(this.sWorkDir, this.sFootIns, this.tfFootIns, this.bFootInsRel);
            this.mySettings.setFootInsFile(this.sFootIns);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbRes)) {
            this.bResRel = this.cbRes.isSelected();
            this.sRes = this.switchRelative(this.sWorkDir, this.sRes, this.tfRes, this.bResRel);
            this.mySettings.setResDir(this.sRes, true);
            this.setDirty(true);
        } else if (e.getSource().equals(this.cbTempl)) {
            this.bTemplRel = this.cbTempl.isSelected();
            this.sTempl = this.switchRelative(this.sWorkDir, this.sTempl, this.tfTempl, this.bTemplRel);
            this.mySettings.setTemplateDir(this.sTempl, true);
            this.setDirty(true);
        } else {
            e.getSource().equals(this.cbGuiLocale);
        }
    }

    public String switchRelative(String sBaseDir, String sDir, JTextField tf, boolean bRelative) {
        String sResult = sDir;
        if (!sResult.equals("")) {
            if (bRelative && FileUtils.isAbsolutePath(sDir)) {
                sResult = FileUtils.convertAbsolutetoRelativePath(sBaseDir, sDir);
                tf.setText(sResult);
                this.setDirty(true);
            } else if (!bRelative && !FileUtils.isAbsolutePath(sDir)) {
                sResult = FileUtils.convertRelativetoAbsolutePath(sBaseDir, sDir);
                tf.setText(sResult);
                this.setDirty(true);
            }
        }
        return sResult;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.bRun) {
            String sCmd = e.getActionCommand();
            this.updateDataMembersFromFields();
            if (sCmd.equals("MENU_CMD_EXIT")) {
                this.onExit();
            } else if (sCmd.equals("MENU_CMD_CLEAR")) {
                this.onClear();
            } else if (sCmd.equals("MENU_CMD_LOAD")) {
                this.onLoad();
            } else if (sCmd.equals("MENU_CMD_SAVE")) {
                this.onSave();
            } else if (sCmd.equals("MENU_CMD_SAVEAS")) {
                this.onSaveAs();
            } else if (sCmd.equals("MENU_CMD_GUIPROP")) {
                this.onGUIProp();
            } else if (sCmd.equals("MENU_CMD_PLUGMGR")) {
                this.onPlugManager();
            } else if (sCmd.equals("MENU_CMD_RUN")) {
                this.onRun();
            } else if (sCmd.equals("MENU_CMD_ABOUT")) {
                this.onAbout();
            } else if (sCmd.equals("MAINDIR_BUT_WORKDIR")) {
                this.onButWorkdir();
            } else if (sCmd.equals("MAINDIR_BUT_INPUTDIR")) {
                this.onButInputdir();
            } else if (sCmd.equals("MAINDIR_BUT_OUTPUTDIR")) {
                this.onButOutputdir();
            } else if (sCmd.equals("MAINDIR_BUT_EXT")) {
                this.onButExt();
            } else if (sCmd.equals("MAINDIR_BUT_EXCLUDE")) {
                this.onButExclude();
            } else if (sCmd.equals("OUTSEC_BUT_LOGO")) {
                this.onButLogo();
            } else if (sCmd.equals("STYLESEC_BUT_CSS")) {
                this.onButCSS();
            } else if (sCmd.equals("STYLESEC_BUT_HEADINS")) {
                this.onButHeadIns();
            } else if (sCmd.equals("STYLESEC_BUT_FOOTINS")) {
                this.onButFootIns();
            } else if (sCmd.equals("OTHERSEC_BUT_RES")) {
                this.onButRes();
            } else if (sCmd.equals("OTHERSEC_BUT_TEMPL")) {
                this.onButTempl();
            } else if (sCmd.equals("OTHERSEC_BUT_EXTDEF")) {
                this.onButExtDef();
            } else if (sCmd.equals("GUIPREF_BUT_RES")) {
                this.onButGuiRes();
            } else if (sCmd.equals("GUIPREF_BUT_TEMPL")) {
                this.onButGuiTempl();
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (!e.getSource().equals(this.cbGuiLocale) && !e.getSource().equals(this.tfGuiRes)) {
            this.updateDataMembersFromFields();
        }
    }

    public void focusLost(FocusEvent e) {
        if (!e.getSource().equals(this.cbGuiLocale)) {
            if (e.getSource().equals(this.tfGuiRes)) {
                String sGuiRes = this.tfGuiRes.getText().trim();
                this.updateGuiLocalListFromResDir(sGuiRes);
                this.tfGuiRes.setCaretPosition(0);
            } else if (e.getSource().equals(this.tfGuiTempl)) {
                this.tfGuiTempl.setCaretPosition(0);
            } else {
                this.updateDataMembersFromFields();
                Component c = e.getComponent();
                Class<?> clazz = c.getClass();
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("javax.swing.JTextField");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    JTextField tf = (JTextField)c;
                    tf.setCaretPosition(0);
                }
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.doEndRun();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
        this.doEndRun();
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void showDebugMessage(String sMessage) {
        JOptionPane.showMessageDialog(null, sMessage, "Message", 0);
    }
}

