/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.GUI;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.FileUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AutoDocGUIInputDirDialog
extends JDialog
implements ActionListener,
ItemListener,
WindowListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected String sWorkDir = "";
    protected String sCurSetting = "";
    protected String sOrgSetting = "";
    protected boolean bInputRelative = false;
    protected boolean bCaseSensitive = false;
    private AutoDocMessageTexts myTexts = null;
    protected int WinWidth = 800;
    protected int WinHeight = 600;
    protected JButton butOK = null;
    protected JButton butCancel = null;
    protected JTextField tfInput = null;
    protected JButton butInput = null;
    protected JCheckBox cbInput = null;

    public AutoDocGUIInputDirDialog(JDialog owner, String sCurSetting, String sWorkDir, boolean bCaseSensitive, AutoDocMessageTexts myTexts) {
        super(owner);
        this.sWorkDir = sWorkDir;
        this.bCaseSensitive = bCaseSensitive;
        this.sCurSetting = sCurSetting;
        this.sOrgSetting = sCurSetting;
        this.myTexts = myTexts;
        this.setModal(true);
        this.setWindowSize();
        this.setTitle(myTexts.getMessageTextDef("MSG_GUI_INDIR", "Input Directory"));
        this.addWindowListener(this);
        this.createDialogComponents();
        this.updateDataFieldsFromMembers();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public void createDialogComponents() {
        Container cAll = new Container();
        cAll.setLayout(new BoxLayout(cAll, 1));
        Container cTop = this.createTopContainer();
        cAll.add(cTop);
        Container cBottom = this.createBottomContainer();
        cAll.add(cBottom);
        this.getContentPane().add(cAll);
    }

    protected Container createTopContainer() {
        Container cTop = new Container();
        cTop.setLayout(new FlowLayout(0));
        cTop.add(new JLabel(String.valueOf(this.myTexts.getMessageTextDef("MSG_GUI_INDIR", "Input Directory")) + ": "));
        this.tfInput = new JTextField();
        this.tfInput.addFocusListener(this);
        this.tfInput.setPreferredSize(new Dimension(300, 25));
        cTop.add(this.tfInput);
        this.butInput = new JButton("...");
        this.butInput.addActionListener(this);
        this.butInput.setActionCommand("INPUTDLG_BUT_INPUT");
        cTop.add(this.butInput);
        this.cbInput = new JCheckBox(this.myTexts.getMessageTextDef("MSG_GUI_RELATIVE", "relative"));
        this.cbInput.setSelected(this.bInputRelative);
        this.cbInput.addItemListener(this);
        this.cbInput.setActionCommand("INPUTDLG_CB_INPUT");
        cTop.add(this.cbInput);
        return cTop;
    }

    protected Container createBottomContainer() {
        Container cBottom = new Container();
        cBottom.setLayout(new FlowLayout(1));
        this.butOK = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_OK", "OK"));
        this.butOK.setActionCommand("INPUTDLG_OK");
        this.butOK.addActionListener(this);
        cBottom.add(this.butOK);
        this.butCancel = new JButton(this.myTexts.getMessageTextDef("MSG_GUI_CANCEL", "Cancel"));
        this.butCancel.setActionCommand("INPUTDLG_CANCEL");
        this.butCancel.addActionListener(this);
        cBottom.add(this.butCancel);
        return cBottom;
    }

    public void setWindowSize() {
        double dAspect = (double)this.WinWidth / (double)this.WinHeight;
        int iScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
        int iScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 40;
        int iDiff_x = iScreenWidth - this.WinWidth;
        int iDiff_y = iScreenHeight - this.WinHeight;
        if (iDiff_x < 0 || iDiff_y < 0) {
            if (iDiff_x < iDiff_y) {
                int iCalc_y;
                this.WinWidth = iScreenWidth;
                this.WinHeight = iCalc_y = (int)((double)this.WinWidth / dAspect);
            } else {
                int iCalc_x;
                this.WinHeight = iScreenHeight;
                this.WinWidth = iCalc_x = (int)((double)this.WinHeight * dAspect);
            }
            dAspect = (double)this.WinWidth / (double)this.WinHeight;
        }
        this.setSize(this.WinWidth, this.WinHeight);
        this.setLocation((iScreenWidth - this.WinWidth) / 2, (iScreenHeight - this.WinHeight) / 2);
    }

    public String getResult() {
        return this.sCurSetting;
    }

    public String switchRelative(String sBaseDir, String sDir, JTextField tf, boolean bRelative) {
        String sResult = sDir;
        if (!sResult.equals("")) {
            if (bRelative && FileUtils.isAbsolutePath(sDir)) {
                sResult = FileUtils.convertAbsolutetoRelativePath(sBaseDir, sDir);
                tf.setText(sResult);
            } else if (!bRelative && !FileUtils.isAbsolutePath(sDir)) {
                sResult = FileUtils.convertRelativetoAbsolutePath(sBaseDir, sDir);
                tf.setText(sResult);
            }
        }
        return sResult;
    }

    public void updateDataMembersFromFields() {
        if (!this.tfInput.getText().equals(this.sCurSetting)) {
            this.sCurSetting = this.tfInput.getText();
            if (!this.sCurSetting.equals("")) {
                this.bInputRelative = !FileUtils.isAbsolutePath(this.sCurSetting);
            }
            this.cbInput.setSelected(this.bInputRelative);
        }
    }

    public void updateDataFieldsFromMembers() {
        if (!this.sCurSetting.equals("")) {
            this.bInputRelative = !FileUtils.isAbsolutePath(this.sCurSetting);
        }
        this.tfInput.setText(this.sCurSetting);
        this.cbInput.setSelected(this.bInputRelative);
    }

    public String doDirectoryChooser(String sDir, String sTitle) {
        if (sDir.equals("")) {
            sDir = this.sWorkDir;
        }
        JFileChooser ch = new JFileChooser(sDir);
        ch.setFileSelectionMode(1);
        ch.setDialogTitle(sTitle);
        int iRet = ch.showOpenDialog(this);
        String sSelected = "";
        if (iRet == 0) {
            sSelected = FileUtils.toCanonicalPath(ch.getSelectedFile());
        }
        return sSelected;
    }

    public void onOK() {
        this.dispose();
    }

    public void onCancel() {
        this.sCurSetting = null;
        this.dispose();
    }

    public void onInputButton() {
        String sSelected;
        String sDir = this.sCurSetting;
        if (!sDir.equals("")) {
            if (!FileUtils.isAbsolutePath(sDir)) {
                sDir = FileUtils.convertRelativetoAbsolutePath(this.sWorkDir, sDir);
            }
            if (!FileUtils.dirExist(sDir)) {
                sDir = "";
            }
        }
        if (sDir.equals("") && !this.sWorkDir.equals("")) {
            sDir = FileUtils.toCanonicalPath(this.sWorkDir);
        }
        if (!(sSelected = this.doDirectoryChooser(sDir, this.myTexts.getMessageTextDef("MSG_GUI_CHOOSE_INDIR", "Choose input directory"))).equals("")) {
            this.sCurSetting = sSelected;
            this.tfInput.setText(this.sCurSetting);
            this.updateDataMembersFromFields();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("INPUTDLG_OK")) {
            this.onOK();
        } else if (e.getActionCommand().equals("INPUTDLG_CANCEL")) {
            this.onCancel();
        } else if (e.getActionCommand().equals("INPUTDLG_BUT_INPUT")) {
            this.onInputButton();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.sCurSetting = null;
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.updateDataMembersFromFields();
    }

    public void focusLost(FocusEvent e) {
        this.updateDataMembersFromFields();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.cbInput)) {
            this.bInputRelative = this.cbInput.isSelected();
            this.sCurSetting = this.switchRelative(this.sWorkDir, this.sCurSetting, this.tfInput, this.bInputRelative);
        }
    }
}

