/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.AutoDocTagParameterList;
import java.util.ArrayList;

public class AutoDocTagParameter {
    protected String ParamString = "";
    protected ArrayList InlineTags = new ArrayList();
    private AutoDocSettings mySettings = null;
    public static String InlinePlaceHolder = "!$%\u00a7/\u00b5#%!";
    public String TagCharacter = "";
    public String QuoteCharacter = "\"";
    public String Filename = "";

    public AutoDocTagParameter(AutoDocSettings mySettings, String sTagCharacter, String sQuoteChar, String sPara, String sFilename) {
        this.mySettings = mySettings;
        this.ParamString = sPara;
        this.TagCharacter = sTagCharacter;
        this.QuoteCharacter = sQuoteChar;
        this.Filename = sFilename;
        this.parseInlineTag();
    }

    public void parseInlineTag() {
        AutoDocTag curTag = null;
        String s = this.ParamString.trim();
        if (!this.TagCharacter.equals("") && AutoDocStringUtils.isTagCandidate(s, this.TagCharacter.charAt(0), ' ')) {
            String[] sTmp = s.split("\\s+");
            String sTagName = "";
            if (sTmp.length > 0) {
                sTagName = sTmp[0].substring(this.TagCharacter.length()).trim();
            }
            AutoDocTagListElement curElem = this.mySettings.getDict().getElementByName(sTagName);
            String[] saEntries = AutoDocStringUtils.splitBraces(s, this.QuoteCharacter.charAt(0), true);
            if (curElem != null) {
                if (curElem.getNumParms() <= 1) {
                    saEntries = AutoDocStringUtils.splitBraces(s, '\u0000', true);
                }
                AutoDocTagParameterList vPara = new AutoDocTagParameterList();
                int i = 1;
                while (i < saEntries.length) {
                    vPara.add(new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, String.valueOf(saEntries[i]) + " ", this.Filename));
                    ++i;
                }
                vPara = vPara.reduceParamsToSize(this.mySettings.getDict(), sTagName);
                curTag = new AutoDocTag(curElem, vPara);
                String sPad = "";
                int iOffset = this.ParamString.indexOf(this.TagCharacter);
                if (iOffset > 0) {
                    sPad = this.ParamString.substring(0, iOffset);
                }
                this.ParamString = String.valueOf(sPad) + InlinePlaceHolder;
                this.InlineTags.add(curTag);
            } else {
                String[] saMsg = new String[]{sTagName, this.Filename};
                this.mySettings.getMsgHandler().outputWarning("WARN_FILEUNSUPPORTEDINLINETAG", saMsg);
                this.ParamString = this.ParamString.endsWith(" ") ? "{" + this.ParamString.trim() + "} " : "{" + this.ParamString.trim() + "}";
            }
        }
    }

    public void append(AutoDocTagParameter addPara) {
        this.ParamString = String.valueOf(this.ParamString) + addPara.ParamString;
        int i = 0;
        while (i < addPara.InlineTags.size()) {
            this.InlineTags.add(addPara.InlineTags.get(i));
            ++i;
        }
    }

    public String getParamString() {
        return this.ParamString;
    }

    public void setParamString(String s) {
        this.ParamString = s;
    }

    public ArrayList getInlineTags() {
        return this.InlineTags;
    }

    public void setInlineTags(ArrayList InlineTags) {
        this.InlineTags = InlineTags;
    }

    public String toString() {
        if (this.ParamString.startsWith(String.valueOf(this.QuoteCharacter) + this.TagCharacter) && !this.ParamString.endsWith(this.QuoteCharacter)) {
            return this.ParamString.substring(1);
        }
        return this.ParamString;
    }
}

