/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.AutoDocTagParameter;
import de.enache.AutoDoc.AutoDocTagParameterList;
import de.enache.AutoDoc.SystemUtils;

public class AutoDocTag {
    private String Name = "";
    private AutoDocTagParameterList Parameters = new AutoDocTagParameterList();
    private int Level = 0;
    private String Label = "";
    private int SortIndex = 0;
    private AutoDocTagListElement TagInfo = null;

    public AutoDocTag(AutoDocTagListElement TagInfo, AutoDocTagParameterList Parameters) {
        String sAlias = TagInfo.getAliasName();
        this.Name = !sAlias.equals("") ? sAlias : TagInfo.getName();
        this.TagInfo = TagInfo;
        this.Parameters = Parameters;
        this.Level = TagInfo.getLevel();
        this.Label = TagInfo.getLabel();
        this.SortIndex = TagInfo.getSortIndex();
    }

    public String getName() {
        return this.Name;
    }

    public String getLabel() {
        return this.Label;
    }

    public int getLevel() {
        return this.Level;
    }

    public int getSortIndex() {
        return this.SortIndex;
    }

    public AutoDocTagParameterList getParameters() {
        return this.Parameters;
    }

    public void setParameters(AutoDocTagParameterList Parameters) {
        this.Parameters = Parameters;
    }

    public int getNumParameters() {
        return this.Parameters.size();
    }

    public AutoDocTagParameter getParameter(int i) {
        AutoDocTagParameter curPara = null;
        if (i >= 0 && i < this.Parameters.size()) {
            curPara = this.Parameters.get(i);
        }
        return curPara;
    }

    public AutoDocTagListElement getTagInfo() {
        return this.TagInfo;
    }

    public void print() {
        String sIdent = "";
        if (this.Level == 2) {
            sIdent = String.valueOf(sIdent) + "    ";
        }
        if (this.Level == 3) {
            sIdent = String.valueOf(sIdent) + "        ";
        }
        SystemUtils.println(String.valueOf(sIdent) + "Tag: " + this.Name + ", Level: " + this.Level + ", Label: " + this.Label);
        int i = 0;
        while (i < this.Parameters.size()) {
            SystemUtils.println(String.valueOf(sIdent) + "Parameter " + i + ": " + this.Parameters.get(i).toString());
            ++i;
        }
    }

    public String toStringNoDetails() {
        String sReturn = "Tag: " + this.Name + ", Level: " + this.Level + ", Label: " + this.Label;
        return sReturn;
    }

    public String toString() {
        AutoDocTagParameterList vParam = this.Parameters;
        String sReturn = "Tag: " + this.Name + ", Level: " + this.Level + ", Label: " + this.Label;
        int iLen = vParam.size();
        if (iLen > 0) {
            sReturn = String.valueOf(sReturn) + "\n{";
            String sPara = vParam.get(0).toString();
            sReturn = String.valueOf(sReturn) + "\"" + sPara + "\"";
            int i = 1;
            while (i < iLen) {
                sPara = vParam.get(i).toString();
                sReturn = String.valueOf(sReturn) + ",\"" + sPara + "\"";
                ++i;
            }
            sReturn = String.valueOf(sReturn) + "}";
        }
        return sReturn;
    }
}

