/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import java.util.ArrayList;

public class AutoDocStringUtils {
    public static String replaceFirst(String sSrc, String sFind, String sReplace, int iOffset) {
        String sReturn = sSrc;
        int iPos = sSrc.indexOf(sFind, iOffset);
        if (iPos >= 0) {
            int iLabelLen = sFind.length();
            int iTemplLen = sSrc.length();
            String sBefore = "";
            String sAfter = "";
            if (iPos > 0) {
                sBefore = sSrc.substring(0, iPos);
            }
            if (iPos < iTemplLen - iLabelLen) {
                sAfter = sSrc.substring(iPos + iLabelLen, iTemplLen);
            }
            sReturn = String.valueOf(sBefore) + sReplace + sAfter;
        }
        return sReturn;
    }

    public static String replaceFirst(String sSrc, String sFind, String sReplace) {
        return AutoDocStringUtils.replaceFirst(sSrc, sFind, sReplace, 0);
    }

    public static String replaceAll(String sSrc, String sFind, String sReplace) {
        String sReturn = sSrc;
        int iRepLen = sReplace.length();
        int iPos = sReturn.indexOf(sFind);
        while (iPos >= 0) {
            sReturn = AutoDocStringUtils.replaceFirst(sReturn, sFind, sReplace, iPos);
            iPos = sReturn.indexOf(sFind, iPos + iRepLen);
        }
        return sReturn;
    }

    public static String[] splitBraces(String s) {
        return AutoDocStringUtils.splitBraces(s, '\"');
    }

    public static String[] splitBraces(String s, char cQuoteChar) {
        return AutoDocStringUtils.splitBraces(s, cQuoteChar, false);
    }

    public static String[] splitBraces(String s, char cQuoteChar, boolean bPreserveOrg) {
        ArrayList<String> vReturn = new ArrayList<String>();
        int iBraces = 0;
        int iQuotes = 0;
        int iWhiteSp = 0;
        boolean bPreserve = false;
        boolean bOpenQuote = false;
        boolean bFirstCR = true;
        String sCurEntry = "";
        int iSLen = s.length();
        int i = 0;
        while (i < iSLen) {
            char cCur = s.charAt(i);
            char cNext = '\u0000';
            if (i < iSLen - 1) {
                cNext = s.charAt(i + 1);
            }
            if (bFirstCR && (cCur == '\n' || cCur == '\r')) {
                cCur = ' ';
                bFirstCR = false;
                --i;
            }
            if (cCur == ' ' || cCur == '\t' || cCur == '\u000b' || cCur == '\f') {
                bPreserve = iBraces > 0 || bOpenQuote;
                if (bPreserve) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                } else if (iWhiteSp == 0) {
                    if (!bPreserveOrg) {
                        sCurEntry = String.valueOf(sCurEntry) + cCur;
                    }
                    vReturn.add(sCurEntry);
                    sCurEntry = "";
                }
                if (!bPreserveOrg) {
                    ++iWhiteSp;
                }
            } else if (cCur == '{' && !bPreserveOrg) {
                if (iWhiteSp == 0 && iBraces <= 0) {
                    vReturn.add(sCurEntry);
                    sCurEntry = "";
                }
                if (iQuotes > 0 || iBraces > 0) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                }
                ++iBraces;
                iWhiteSp = 0;
            } else if (cCur == '}' && !bPreserveOrg) {
                if (iQuotes > 0 || iBraces > 1) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                }
                if (!bOpenQuote && iBraces == 1) {
                    vReturn.add(sCurEntry);
                    sCurEntry = "";
                    if (!bPreserveOrg) {
                        ++iWhiteSp;
                        if (cNext == ' ' || cNext == '\t' || cNext == '\u000b' || cNext == '\f') {
                            sCurEntry = " ";
                        }
                    }
                }
                --iBraces;
            } else if (cCur == cQuoteChar && !bOpenQuote) {
                if (iBraces > 0) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                }
                ++iQuotes;
                bOpenQuote = true;
                iWhiteSp = 0;
            } else if (cCur == cQuoteChar && bOpenQuote) {
                if (iBraces > 0) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                }
                --iQuotes;
                bOpenQuote = false;
                iWhiteSp = 0;
            } else {
                sCurEntry = String.valueOf(sCurEntry) + cCur;
                iWhiteSp = 0;
            }
            ++i;
        }
        if (!sCurEntry.equals("")) {
            vReturn.add(sCurEntry);
        }
        String[] saReturn = new String[vReturn.size()];
        saReturn = vReturn.toArray(saReturn);
        return saReturn;
    }

    public static String[] splitQuoted(String s, char cSplitChar) {
        return AutoDocStringUtils.splitQuoted(s, cSplitChar, '\"');
    }

    public static String[] splitQuoted(String s, char cSplitChar, char cQuoteChar) {
        ArrayList<String> vReturn = new ArrayList<String>();
        boolean bOpenQuote = false;
        boolean bEscape = false;
        String sCurEntry = "";
        int i = 0;
        while (i < s.length()) {
            char cCur = s.charAt(i);
            if (cCur == cSplitChar) {
                if (bOpenQuote) {
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                } else {
                    vReturn.add(sCurEntry);
                    sCurEntry = "";
                }
                bEscape = false;
            } else if (cCur == '\\') {
                bEscape = true;
            } else if (cCur == cQuoteChar && !bEscape) {
                bOpenQuote = !bOpenQuote;
            } else {
                sCurEntry = String.valueOf(sCurEntry) + cCur;
                bEscape = false;
            }
            ++i;
        }
        if (!sCurEntry.equals("")) {
            vReturn.add(sCurEntry);
        }
        String[] saReturn = new String[vReturn.size()];
        saReturn = vReturn.toArray(saReturn);
        return saReturn;
    }

    public static int toInt(String s, int iDefault) {
        int iRet = iDefault;
        try {
            iRet = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iRet;
    }

    public static String getPrevCharStr(String s, int iCurIdx) {
        String sReturn = "";
        if (iCurIdx > 0 && s.length() > 0) {
            sReturn = String.valueOf(sReturn) + s.charAt(iCurIdx - 1);
        }
        return sReturn;
    }

    public static String getNextCharStr(String s, int iCurIdx) {
        String sReturn = "";
        if (iCurIdx + 1 < s.length()) {
            sReturn = String.valueOf(sReturn) + s.charAt(iCurIdx + 1);
        }
        return sReturn;
    }

    public static boolean isMatch(String s, String sPattern) {
        boolean bResult = false;
        String sPatternCh = sPattern.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*");
        bResult = s.matches(sPatternCh);
        return bResult;
    }

    public static boolean isTagCandidate(String s, char cTagChar, char cPrev) {
        boolean bReturn = false;
        if (!s.equals("")) {
            char cCur = s.charAt(0);
            int cNext = 32;
            if (s.length() > 1) {
                cNext = s.charAt(1);
            }
            if (cCur == cTagChar && (cPrev == ' ' || cPrev == '\t' || cPrev == '\n' || cPrev == '\f' || cPrev == '\r' || cPrev == '\u000b') && (cNext >= 97 && cNext <= 122 || cNext >= 65 && cNext <= 90 || cNext >= 48 && cNext <= 57 || cNext == 95)) {
                bReturn = true;
            }
            if (cTagChar == '\\') {
                String sTmp = s.substring(1);
                String[] saTmp = sTmp.split("\\s+");
                String sTmp2 = "";
                if (saTmp != null && saTmp.length > 0) {
                    sTmp2 = saTmp[0];
                }
                if (sTmp2.indexOf("\\") >= 0) {
                    bReturn = false;
                }
            }
        }
        return bReturn;
    }

    public static String repeat(String s, int n) {
        String sReturn = "";
        if (n >= 0) {
            int i = 0;
            while (i < n) {
                sReturn = String.valueOf(sReturn) + s;
                ++i;
            }
        }
        return sReturn;
    }

    public static String StringArrayToSeparatedList(String[] sa, String sSep) {
        String sRet = "";
        if (sa != null && sa.length > 0) {
            sRet = sa[0];
            int i = 1;
            while (i < sa.length) {
                sRet = String.valueOf(sRet) + sSep + sa[i];
                ++i;
            }
        }
        return sRet;
    }

    public static String StringArrayToSeparatedListWithPrefix(String[] sa, String sSep, String sPre) {
        String sRet = "";
        if (sa != null && sa.length > 0) {
            sRet = String.valueOf(sPre) + sa[0];
            int i = 1;
            while (i < sa.length) {
                sRet = String.valueOf(sRet) + sSep + sPre + sa[i];
                ++i;
            }
        }
        return sRet;
    }

    public static int compareVersions(String s1, String s2) {
        int iRet = 0;
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (s1.length() == 0 && s2.length() != 0) {
            iRet = -1;
        } else if (s1.length() != 0 && s2.length() == 0) {
            iRet = 1;
        } else if (s1.length() != 0 && s2.length() != 0) {
            int i;
            String[] tmp;
            String[] sa2;
            int iLen2;
            String[] sa1 = s1.split("\\.");
            int iLen1 = sa1.length;
            if (iLen1 < (iLen2 = (sa2 = s2.split("\\.")).length)) {
                tmp = new String[iLen2];
                i = 0;
                while (i < iLen2) {
                    tmp[i] = i < iLen1 ? sa1[i] : "0";
                    ++i;
                }
                sa1 = tmp;
                iLen1 = sa1.length;
            } else if (iLen1 > iLen2) {
                tmp = new String[iLen1];
                i = 0;
                while (i < iLen1) {
                    tmp[i] = i < iLen2 ? sa2[i] : "0";
                    ++i;
                }
                sa2 = tmp;
                iLen2 = sa2.length;
            }
            int i2 = 0;
            while (i2 < iLen1) {
                int iV2;
                int iV1 = AutoDocStringUtils.toInt(sa1[i2], 0);
                if (iV1 < (iV2 = AutoDocStringUtils.toInt(sa2[i2], 0))) {
                    iRet = -1;
                } else if (iV1 > iV2) {
                    iRet = 1;
                }
                if (iRet != 0) break;
                ++i2;
            }
        }
        return iRet;
    }
}

