/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocExtDefaults;
import de.enache.AutoDoc.AutoDocGroupingDefinition;
import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocMsgHandler;
import de.enache.AutoDoc.AutoDocMsgParams;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTagDictionary;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.AutoDocTypes;
import de.enache.AutoDoc.AutoDocUserGroupDef;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoDocSettings {
    private AutoDocTagDictionary Dict = null;
    private AutoDocMsgHandler MsgHandler = new AutoDocMsgHandler();
    private String InputPath = "";
    private String ProgPath = "";
    private String DocPath = "";
    private String OrgDocPath = "";
    private String WorkDir = "";
    private String OrgWorkDir = "";
    private String FileFilter = "";
    private String TemplateDir = "";
    private String OrgTemplateDir = "";
    private String StyleDefFile = "";
    private String OrgStyleDefFile = "";
    private String Title = "";
    private String HeaderInsFile = "";
    private String FootInsFile = "";
    private String sOrgDocType = "";
    private String sDocType = "";
    private int DocType = -1;
    private String Locale = "";
    private String ResDir = "";
    private String OrgResDir = "";
    private String Logo = "";
    private String Exclude = "";
    private String CHMProj = "";
    private String sRecurse = "";
    private boolean Recurse = true;
    private String sEnableSearch = "no";
    private boolean bEnableSearch = false;
    private String ExtDef = "";
    private ArrayList vExtDefaults = new ArrayList();
    private ArrayList vExtDefPara = new ArrayList();
    private ArrayList vGroups = new ArrayList();
    private ArrayList vUserGroupDefs = new ArrayList();
    private String sUsage = "";
    private ArrayList lPlugins = new ArrayList();
    private static String SysNewLine = System.getProperty("line.separator");
    private static String sOS = System.getProperty("os.name").toLowerCase();

    public AutoDocSettings() {
        this.sDocType = AutoDocTypes.getTypeString(this.DocType);
    }

    protected void initDictionary(InputStream TagFileStream, String sTagFileEnc, InputStream LabelFileStream, String sLabelFileEnc, InputStream JarTagFileStream, String sTagJarEnc, InputStream JarLabelFileStream, String sLabelJarEnc, boolean bCheckOutOfSynch) throws Error {
        InputStream isTagFileStream = TagFileStream;
        InputStream isLabelFileStream = LabelFileStream;
        if (TagFileStream == null) {
            isTagFileStream = JarTagFileStream;
        }
        if (LabelFileStream == null) {
            isLabelFileStream = JarLabelFileStream;
        }
        AutoDocMessageTexts Texts = this.MsgHandler.getTexts();
        try {
            String sError;
            this.Dict = new AutoDocTagDictionary(isTagFileStream, sTagFileEnc, isLabelFileStream, sLabelFileEnc, Texts, this.vGroups);
            if (bCheckOutOfSynch && !(sError = this.checkDictOutOfSynch(JarTagFileStream, sTagJarEnc, JarLabelFileStream, sLabelJarEnc)).equals("")) {
                SystemUtils.println(sError);
            }
        }
        catch (Exception e) {
            throw new Error(Texts.getMessageText("ERR_INITDICT", e.getMessage()));
        }
    }

    protected String checkDictOutOfSynch(InputStream JarTagFileStream, String sTagFileEnc, InputStream JarLabelFileStream, String sLabelFileEnc) {
        String sError = "";
        try {
            AutoDocMessageTexts Texts = this.MsgHandler.getTexts();
            AutoDocTagDictionary JarDict = new AutoDocTagDictionary(JarTagFileStream, sTagFileEnc, JarLabelFileStream, sLabelFileEnc, Texts, this.vGroups);
            int iNumElem = JarDict.getTagList().size();
            int i = 0;
            while (i < iNumElem) {
                AutoDocTagListElement curElem = JarDict.getElement(i);
                if (curElem != null && this.Dict.getElementByID(curElem.ID) == null) {
                    sError = Texts.getNoteText("WARN_DICTNOSYNCH", curElem.ID);
                    this.MsgHandler.incNumNotes();
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sError;
    }

    protected void initExtDefaults(InputStream isExtDef, String sFileEnc, InputStream isJarExtDef, String sJarEnc) throws Error {
        InputStream isInput = isExtDef;
        String sCharset = sFileEnc;
        if (isExtDef == null) {
            isInput = isJarExtDef;
            sCharset = sJarEnc;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(isInput, sCharset));
            String sLine = br.readLine();
            while (sLine != null) {
                sLine = sLine.trim();
                if (sCharset.equals("UTF-8")) {
                    sLine = FileUtils.removeUTF_8_BOM(sLine);
                }
                if (!sLine.equals("") && !sLine.startsWith("//")) {
                    this.vExtDefaults.add(new AutoDocExtDefaults(sLine));
                }
                sLine = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            throw new Error(this.MsgHandler.getTexts().getMessageText("ERR_INITEXTDEF"));
        }
        if (!this.ExtDef.equals("")) {
            String[] saDefs = this.ExtDef.split("\\|");
            int i = 0;
            while (i < saDefs.length) {
                String sTmp = AutoDocStringUtils.replaceAll(AutoDocStringUtils.replaceAll(saDefs[i], "[", "\""), "]", "\"");
                AutoDocExtDefaults tmpExDef = new AutoDocExtDefaults(sTmp, "User Defined");
                tmpExDef.setExt(this.cleanExtList(tmpExDef.getExt()));
                this.vExtDefPara.add(tmpExDef);
                ++i;
            }
        }
    }

    public String cleanExtList(String sExt) {
        String sReturn = sExt;
        if (!sExt.equals("")) {
            sReturn = sExt.equals("#") ? "*" : AutoDocStringUtils.replaceAll(sExt, "#.", "*.");
            sReturn = AutoDocStringUtils.replaceAll(AutoDocStringUtils.replaceAll(sReturn, ".", ""), "*", "");
        }
        return sReturn;
    }

    protected void initMessages(InputStream isMessages, String sMsgEnc, InputStream isJarMessages, String sMsgJarEnc, boolean bCheckOutOfSynch) throws Error {
        String sError;
        if (isMessages == null) {
            this.MsgHandler.getTexts().initMessages(isJarMessages, sMsgEnc);
        } else {
            this.MsgHandler.getTexts().initMessages(isMessages, sMsgEnc);
        }
        if (isMessages != null && bCheckOutOfSynch && !(sError = this.checkTextsOutOfSynch(isJarMessages, sMsgJarEnc)).equals("")) {
            throw new Error(sError);
        }
    }

    protected void initUsage(InputStream isUsage, String sUsageEnc, InputStream isJarUsage, String sUsageJarEnc) {
        this.sUsage = "";
        try {
            this.sUsage = isUsage != null ? FileUtils.ascFileToString(isUsage, sUsageEnc) : FileUtils.ascFileToString(isJarUsage, sUsageJarEnc);
        }
        catch (IOException e) {
            this.sUsage = "Error: Usage text cannot be loaded.";
        }
    }

    protected void initUserGroupDef(InputStream isUserGroupDef, String sUserGroupDefEnc) {
        if (isUserGroupDef != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(isUserGroupDef, sUserGroupDefEnc));
                String sLine = br.readLine();
                while (sLine != null) {
                    AutoDocUserGroupDef gd;
                    sLine = sLine.trim();
                    if (sUserGroupDefEnc.equals("UTF-8")) {
                        sLine = FileUtils.removeUTF_8_BOM(sLine);
                    }
                    if (!(sLine.equals("") || sLine.startsWith("//") || (gd = new AutoDocUserGroupDef(sLine)).getsID().equals("") || gd.getsGroup().equals(""))) {
                        this.vUserGroupDefs.add(gd);
                    }
                    sLine = br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                throw new Error(this.MsgHandler.getTexts().getMessageText("ERR_INITUSERGROUPDEF"));
            }
        }
    }

    protected String checkTextsOutOfSynch(InputStream isJarMessages, String sMsgEnc) {
        String sError = "";
        AutoDocMessageTexts JarTexts = new AutoDocMessageTexts();
        JarTexts.initMessages(isJarMessages, sMsgEnc);
        HashMap mTexts = this.MsgHandler.getTexts().getTextMap();
        HashMap mJarTexts = JarTexts.getTextMap();
        String[] saTextKeys = new String[mJarTexts.size()];
        saTextKeys = mJarTexts.keySet().toArray(saTextKeys);
        int i = 0;
        while (i < saTextKeys.length) {
            if (!mTexts.containsKey(saTextKeys[i])) {
                sError = "Message ID \"" + saTextKeys[i] + "\" not found in messages file. Probably a user defined file is out of synch with the current system files.";
                break;
            }
            ++i;
        }
        return sError;
    }

    protected void initGroupings(InputStream isGroup, String sGroupEnc, InputStream isJarGroup, String sGroupJarEnc) throws Error {
        InputStream isInput = isGroup;
        String sCharset = sGroupEnc;
        if (isGroup == null) {
            isInput = isJarGroup;
            sCharset = sGroupJarEnc;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(isInput, sCharset));
            String sLine = br.readLine();
            while (sLine != null) {
                sLine = sLine.trim();
                if (sCharset.equals("UTF-8")) {
                    sLine = FileUtils.removeUTF_8_BOM(sLine);
                }
                if (!sLine.equals("") && !sLine.startsWith("//")) {
                    this.vGroups.add(new AutoDocGroupingDefinition(sLine));
                }
                sLine = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            throw new Error(this.MsgHandler.getTexts().getMessageText("ERR_INITGROUPDEF"));
        }
    }

    public AutoDocGroupingDefinition getGroupDefByName(String sName) {
        AutoDocGroupingDefinition groupDef = null;
        int i = 0;
        while (i < this.vGroups.size()) {
            AutoDocGroupingDefinition currDef = (AutoDocGroupingDefinition)this.vGroups.get(i);
            if (currDef.getName() == sName) {
                groupDef = currDef;
                break;
            }
            ++i;
        }
        return groupDef;
    }

    public AutoDocGroupingDefinition getGroupDefByTagKey(String sKey) {
        AutoDocGroupingDefinition groupDef = null;
        int i = 0;
        while (i < this.vGroups.size()) {
            AutoDocGroupingDefinition currDef = (AutoDocGroupingDefinition)this.vGroups.get(i);
            if (currDef.getKey() == sKey) {
                groupDef = currDef;
                break;
            }
            ++i;
        }
        return groupDef;
    }

    public String checkSettings() {
        String sResult = "";
        if (this.InputPath.equals("")) {
            this.InputPath = "input";
            sResult = this.MsgHandler.getTexts().getMessageText("ERR_PARINPUTNOTSET");
        }
        if (this.DocPath.equals("")) {
            this.DocPath = "output";
            sResult = this.MsgHandler.getTexts().getMessageText("ERR_PAROUTPUTNOTSET");
        }
        return sResult;
    }

    public String checkConsitency() {
        String sResult = "";
        if (!(this.isHTMLType() && this.DocType != 61 || this.CHMProj.equals(""))) {
            sResult = String.valueOf(sResult) + this.MsgHandler.getTexts().getNoteText("NOTE_CHMNOHTML") + SysNewLine;
            this.MsgHandler.incNumNotes();
        }
        if ((!this.isHTMLType() || this.DocType == 61 || this.DocType == 0 || this.DocType == 2) && this.sEnableSearch.toLowerCase().equals("yes")) {
            sResult = String.valueOf(sResult) + this.MsgHandler.getTexts().getNoteText("NOTE_ENABLESEARCHNOTEFF", this.sDocType) + SysNewLine;
            this.MsgHandler.incNumNotes();
        }
        return sResult;
    }

    public boolean isHTMLType() {
        boolean bResult = true;
        if (this.DocType == 50 || this.DocType == 51) {
            bResult = false;
        }
        return bResult;
    }

    public boolean isEpubType() {
        boolean bResult = false;
        if (this.DocType == 61) {
            bResult = true;
        }
        return bResult;
    }

    public ArrayList processCfgFile(String sFilename, String ProgDir) {
        ArrayList lWarnings = new ArrayList();
        if (!sFilename.equals("")) {
            String[] saCfgArgs = new String[]{};
            try {
                saCfgArgs = this.readCfgFile(sFilename);
            }
            catch (IOException e) {
                this.getMsgHandler().outputWarning("WARN_CFGNOTREAD", sFilename);
            }
            lWarnings = this.processSettings(saCfgArgs, ProgDir, false);
        }
        return lWarnings;
    }

    public String generateUsage(String sJarFilename) {
        String sResult = this.sUsage;
        sResult = AutoDocStringUtils.replaceAll(sResult, "%1%", sJarFilename);
        return sResult;
    }

    public ArrayList processSettings(String[] args, String ProgDir, boolean bCheck) throws Error {
        String sCheckResult;
        String sCurArg;
        ArrayList<AutoDocMsgParams> lWarnings = new ArrayList<AutoDocMsgParams>();
        int i = 0;
        while (i < args.length) {
            sCurArg = AutoDocSettings.getArgument(args, i, bCheck);
            if (sCurArg.equals("-workdir")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length && !sCurArg.equals("")) {
                    File fDir = new File(sCurArg);
                    if (fDir.exists() && fDir.isDirectory()) {
                        this.setWorkDir(sCurArg, true);
                        System.setProperty("user.dir", sCurArg);
                        break;
                    }
                    if (!bCheck) break;
                    String sError = this.MsgHandler.getTexts().getErrorText("ERR_WORKDIRDOESNOTEXIST", sCurArg);
                    this.MsgHandler.incNumErrors();
                    throw new Error(sError);
                }
                if (i >= args.length) break;
                this.setWorkDir(sCurArg, true);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < args.length) {
            AutoDocMsgParams msgPara;
            sCurArg = AutoDocSettings.getArgument(args, i, bCheck);
            if (sCurArg.equals("-in")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setInputPath(sCurArg);
                }
            } else if (sCurArg.equals("-out")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setOutPath(sCurArg, true);
                }
            } else if (sCurArg.equals("-cfg")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
            } else if (sCurArg.equals("-locale")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setLocale(sCurArg.toLowerCase());
                }
            } else if (sCurArg.equals("-ext")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setFileFilter(sCurArg);
                }
            } else if (sCurArg.equals("-exclude")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setExclude(sCurArg);
                }
            } else if (sCurArg.equals("-templatedir")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setTemplateDir(sCurArg, true);
                }
            } else if (sCurArg.equals("-styledef")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setStyleDefFile(sCurArg, true);
                }
            } else if (sCurArg.equals("-css")) {
                msgPara = new AutoDocMsgParams("WARN_CSSDEPRECATED", null);
                lWarnings.add(msgPara);
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setStyleDefFile(sCurArg, true);
                }
            } else if (sCurArg.equals("-title")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setTitle(sCurArg);
                }
            } else if (sCurArg.equals("-headins")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setHeaderInsFile(sCurArg);
                }
            } else if (sCurArg.equals("-footins")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length) {
                    this.setFootInsFile(sCurArg);
                }
            } else if (sCurArg.equals("-extdef")) {
                boolean bWindows;
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                boolean bl = bWindows = sOS.indexOf("win") >= 0;
                if (bWindows) {
                    sCurArg = AutoDocStringUtils.replaceAll(sCurArg, "^|", "|");
                }
                if (i < args.length) {
                    this.setExtDef(sCurArg);
                }
                if (!sCurArg.equals("")) {
                    String[] sWarnParams = new String[]{"extdef", "AutoDocFileExtensionDefaults.txt"};
                    AutoDocMsgParams msgPara2 = new AutoDocMsgParams("WARN_PARAMDEPRECATED", sWarnParams);
                    lWarnings.add(msgPara2);
                }
            } else if (sCurArg.equals("-res")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length && !sCurArg.equals("")) {
                    this.setResDir(sCurArg, true);
                }
            } else if (sCurArg.equals("-logo")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length && !sCurArg.equals("")) {
                    this.setLogo(sCurArg);
                }
            } else if (sCurArg.equals("-chm")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length && !sCurArg.equals("")) {
                    this.setCHMProj(sCurArg);
                }
            } else if (sCurArg.equals("-workdir")) {
                sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck);
                if (i < args.length && !sCurArg.equals("")) {
                    this.setWorkDir(sCurArg, true);
                }
            } else if (sCurArg.equals("-outtype")) {
                if (!(sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck)).equals("")) {
                    this.setDocType(sCurArg.toLowerCase());
                }
            } else if (sCurArg.equals("-recurse")) {
                if (!(sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck)).equals("")) {
                    this.setRecurse(sCurArg.toLowerCase());
                }
            } else if (sCurArg.equals("-enablesearch")) {
                if (!(sCurArg = AutoDocSettings.getArgument(args, ++i, bCheck)).equals("")) {
                    this.setEnableSearch(sCurArg.toLowerCase());
                }
            } else if (sCurArg.startsWith("-")) {
                msgPara = new AutoDocMsgParams("WARN_PARAMUNKNOWN", sCurArg);
                lWarnings.add(msgPara);
            }
            ++i;
        }
        if (bCheck && !(sCheckResult = this.checkSettings()).equals("")) {
            throw new Error(this.MsgHandler.getTexts().getMessageText("ERR_SETTINGSNCORR", sCheckResult));
        }
        return lWarnings;
    }

    public static String getArgument(String[] args, int i, boolean bQuotes) {
        String sCurArg = args[i];
        if (bQuotes) {
            sCurArg = sCurArg.replaceAll("\\\"", "\\\\\"");
        }
        return sCurArg;
    }

    public String[] readCfgFile(String sFilename) throws IOException {
        String[] saArgs = null;
        ArrayList<String> vArgs = new ArrayList<String>();
        BufferedReader in = new BufferedReader(AutoDoc.getInputStreamReader(sFilename));
        String sCurLine = null;
        while ((sCurLine = in.readLine()) != null) {
            int iPos;
            String sKey = "";
            String sValue = "";
            if (sCurLine.trim().equals("") || sCurLine.trim().startsWith("#") || (iPos = sCurLine.indexOf("=")) < 0) continue;
            sKey = sCurLine.substring(0, iPos).trim();
            if (iPos < sCurLine.length() + 1) {
                sValue = sCurLine.substring(iPos + 1).trim();
            }
            sKey = "-" + sKey;
            vArgs.add(sKey);
            vArgs.add(sValue);
        }
        in.close();
        if (vArgs.size() > 0) {
            saArgs = new String[vArgs.size()];
            saArgs = vArgs.toArray(saArgs);
        }
        return saArgs;
    }

    public void writeCfgFile(String sFilename) throws IOException {
        PrintStream psOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(sFilename)));
        psOut.println("in=" + this.InputPath);
        psOut.println("out=" + this.OrgDocPath);
        psOut.println("workdir=" + this.OrgWorkDir);
        psOut.println("outtype=" + this.sOrgDocType);
        psOut.println("locale=" + this.Locale);
        psOut.println("ext=" + this.FileFilter);
        psOut.println("extdef=" + this.ExtDef);
        psOut.println("exclude=" + this.Exclude);
        psOut.println("templatedir=" + this.OrgTemplateDir);
        psOut.println("res=" + this.OrgResDir);
        psOut.println("styledef=" + this.OrgStyleDefFile);
        psOut.println("title=" + this.Title);
        psOut.println("headins=" + this.HeaderInsFile);
        psOut.println("footins=" + this.FootInsFile);
        psOut.println("logo=" + this.Logo);
        psOut.println("chm=" + this.CHMProj);
        psOut.println("recurse=" + this.sRecurse);
        psOut.println("enablesearch=" + this.sEnableSearch);
        psOut.close();
    }

    public void print() {
        int iCurLen;
        String sResWorkDir = FileUtils.toCanonicalPath(this.WorkDir);
        if (this.WorkDir.equals("")) {
            sResWorkDir = FileUtils.toCanonicalPath(System.getProperty("user.dir"));
        }
        AutoDocMessageTexts Texts = this.MsgHandler.getTexts();
        String[][] saLabelsOrg = new String[][]{{Texts.getMessageText("MSG_PARAMOUT_WORKDIR"), this.OrgWorkDir}, {Texts.getMessageText("MSG_PARAMOUT_INPUTDIR"), this.InputPath}, {Texts.getMessageText("MSG_PARAMOUT_OUTPUTDIR"), this.OrgDocPath}, {Texts.getMessageText("MSG_PARAMOUT_EXCLUDE"), this.Exclude}, {Texts.getMessageText("MSG_PARAMOUT_EXT"), this.FileFilter}, {Texts.getMessageText("MSG_PARAMOUT_EXTDEF"), this.ExtDef}, {Texts.getMessageText("MSG_PARAMOUT_LOCALE"), this.Locale}, {Texts.getMessageText("MSG_PARAMOUT_TEMPLDIR"), this.OrgTemplateDir}, {Texts.getMessageText("MSG_PARAMOUT_RESDIR"), this.OrgResDir}, {Texts.getMessageText("MSG_PARAMOUT_STYLEDEF"), this.OrgStyleDefFile}, {Texts.getMessageText("MSG_PARAMOUT_TITLE"), this.Title}, {Texts.getMessageText("MSG_PARAMOUT_OUTTYPE"), this.sDocType}, {Texts.getMessageText("MSG_PARAMOUT_HEADERINS"), this.HeaderInsFile}, {Texts.getMessageText("MSG_PARAMOUT_FOOTERINS"), this.FootInsFile}, {Texts.getMessageText("MSG_PARAMOUT_LOGO"), this.Logo}, {Texts.getMessageText("MSG_PARAMOUT_CHM"), this.CHMProj}, {Texts.getMessageText("MSG_PARAMOUT_RECURSE"), this.sRecurse}, {Texts.getMessageText("MSG_PARAMOUT_ENABLESEARCH"), this.sEnableSearch}};
        String[][] saLabelsRes = new String[][]{{Texts.getMessageText("MSG_PARAMOUT_WORKDIR"), sResWorkDir, "true"}, {Texts.getMessageText("MSG_PARAMOUT_INPUTDIR"), this.sepListToCanonicalPaths(this.InputPath, ";"), "true"}, {Texts.getMessageText("MSG_PARAMOUT_OUTPUTDIR"), FileUtils.toCanonicalPath(this.DocPath), "true"}, {Texts.getMessageText("MSG_PARAMOUT_TEMPLDIR"), FileUtils.toCanonicalPath(this.TemplateDir), "true"}, {Texts.getMessageText("MSG_PARAMOUT_RESDIR"), FileUtils.toCanonicalPath(this.ResDir), "true"}, {Texts.getMessageText("MSG_PARAMOUT_STYLEDEF"), FileUtils.toCanonicalPath(this.StyleDefFile), "true"}, {Texts.getMessageText("MSG_PARAMOUT_HEADERINS"), FileUtils.toCanonicalPath(this.HeaderInsFile), "" + !this.HeaderInsFile.equals("")}, {Texts.getMessageText("MSG_PARAMOUT_FOOTERINS"), FileUtils.toCanonicalPath(this.FootInsFile), "" + !this.FootInsFile.equals("")}, {Texts.getMessageText("MSG_PARAMOUT_LOGO"), FileUtils.toCanonicalPath(this.Logo), "" + !this.Logo.equals("")}};
        int iMaxOrg = 0;
        int i = 0;
        while (i < saLabelsOrg.length) {
            int iCurLen2 = saLabelsOrg[i][0].length();
            if (iCurLen2 > iMaxOrg) {
                iMaxOrg = iCurLen2;
            }
            ++i;
        }
        SystemUtils.println(String.valueOf(Texts.getMessageText("MSG_PARAMOUT_CURSETTINGS")) + ":");
        SystemUtils.println();
        i = 0;
        while (i < saLabelsOrg.length) {
            String sPad = "";
            iCurLen = saLabelsOrg[i][0].length();
            if (iCurLen < iMaxOrg) {
                sPad = AutoDocStringUtils.repeat(" ", iMaxOrg - iCurLen);
            }
            SystemUtils.println(String.valueOf(saLabelsOrg[i][0]) + sPad + ": \"" + saLabelsOrg[i][1] + "\"");
            ++i;
        }
        SystemUtils.println();
        int iMaxRes = 0;
        int i2 = 0;
        while (i2 < saLabelsRes.length) {
            if (saLabelsRes[i2][2].equals("true") && (iCurLen = saLabelsRes[i2][0].length()) > iMaxRes) {
                iMaxRes = iCurLen;
            }
            ++i2;
        }
        SystemUtils.println(String.valueOf(Texts.getMessageText("MSG_PARAMOUT_RESSETTINGS")) + ":");
        SystemUtils.println();
        i2 = 0;
        while (i2 < saLabelsRes.length) {
            if (saLabelsRes[i2][2].equals("true")) {
                String sPad = "";
                int iCurLen3 = saLabelsRes[i2][0].length();
                if (iCurLen3 < iMaxRes) {
                    sPad = AutoDocStringUtils.repeat(" ", iMaxRes - iCurLen3);
                }
                SystemUtils.println(String.valueOf(saLabelsRes[i2][0]) + sPad + ": \"" + saLabelsRes[i2][1] + "\"");
            }
            ++i2;
        }
        SystemUtils.println();
    }

    public String sepListToCanonicalPaths(String sIn, String sSep) {
        String sResult = "";
        if (!sIn.equals("")) {
            String[] saList = sIn.split(sSep);
            int i = 0;
            while (i < saList.length) {
                String sCur = saList[i].trim();
                sResult = i == 0 ? FileUtils.toCanonicalPath(sCur) : String.valueOf(sResult) + sSep + " " + FileUtils.toCanonicalPath(sCur);
                ++i;
            }
        }
        return sResult;
    }

    public String findUserGroupReplacement(String sKey) {
        String sReturn = "";
        int iNum = this.vUserGroupDefs.size();
        int i = 0;
        while (i < iNum) {
            AutoDocUserGroupDef curDef = (AutoDocUserGroupDef)this.vUserGroupDefs.get(i);
            if (curDef.getsID().equalsIgnoreCase(sKey)) {
                sReturn = curDef.getsGroup();
                break;
            }
            ++i;
        }
        return sReturn;
    }

    public AutoDocTagDictionary getDict() {
        return this.Dict;
    }

    public AutoDocMsgHandler getMsgHandler() {
        return this.MsgHandler;
    }

    public void setMsgHandler(AutoDocMsgHandler oMsgHdl) {
        this.MsgHandler = oMsgHdl;
    }

    public String getInputPath() {
        return this.InputPath;
    }

    public void setInputPath(String s) {
        this.InputPath = s;
    }

    public String getProgPath() {
        return this.ProgPath;
    }

    public void setProgPath(String s) {
        this.ProgPath = s;
    }

    public String getOutPath() {
        return this.DocPath;
    }

    public void setOutPath(String s, boolean bOverwriteOrg) {
        this.DocPath = s;
        if (bOverwriteOrg) {
            this.OrgDocPath = s;
        }
    }

    public String getOrgOutPath() {
        return this.OrgDocPath;
    }

    public String getWorkDir() {
        return this.WorkDir;
    }

    public void setWorkDir(String s, boolean bOverwriteOrg) {
        this.WorkDir = s;
        if (bOverwriteOrg) {
            this.OrgWorkDir = s;
        }
    }

    public String getOrgWorkDir() {
        return this.OrgWorkDir;
    }

    public String getFileFilter() {
        return this.FileFilter;
    }

    public void setFileFilter(String s) {
        this.FileFilter = this.cleanExtList(s);
    }

    public String getTemplateDir() {
        return this.TemplateDir;
    }

    public void setTemplateDir(String s, boolean bOverwriteOrg) {
        this.TemplateDir = s;
        if (bOverwriteOrg) {
            this.OrgTemplateDir = s;
        }
    }

    public String getOrgTemplateDir() {
        return this.OrgTemplateDir;
    }

    public void setOrgTemplateDir(String s) {
        this.OrgTemplateDir = s;
    }

    public String getStyleDefFile() {
        return this.StyleDefFile;
    }

    public void setStyleDefFile(String s, boolean bOverwriteOrg) {
        this.StyleDefFile = s;
        if (bOverwriteOrg) {
            this.OrgStyleDefFile = s;
        }
    }

    public String getOrgStyleDefFile() {
        return this.OrgStyleDefFile;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setTitle(String s) {
        this.Title = s;
    }

    public String getHeaderInsFile() {
        return this.HeaderInsFile;
    }

    public void setHeaderInsFile(String s) {
        this.HeaderInsFile = s;
    }

    public String getFootInsFile() {
        return this.FootInsFile;
    }

    public void setFootInsFile(String s) {
        this.FootInsFile = s;
    }

    public String getDocTypeString() {
        return this.sDocType;
    }

    public String getOrgDocTypeString() {
        return this.sOrgDocType;
    }

    public void setOrgDocTypeString(String s) {
        this.sOrgDocType = s;
    }

    public int getDocType() {
        return this.DocType;
    }

    public void setDocType(int iType) {
        this.sDocType = AutoDocTypes.getTypeString(iType);
        this.DocType = iType;
    }

    public void setDocType(String s) {
        this.sOrgDocType = s.toLowerCase();
        this.DocType = AutoDocTypes.getTypeCode(s);
        this.sDocType = AutoDocTypes.getTypeString(this.DocType);
    }

    public String getLocale() {
        return this.Locale;
    }

    public void setLocale(String s) {
        this.Locale = s;
    }

    public String getResDir() {
        return this.ResDir;
    }

    public void setResDir(String s, boolean bOverwriteOrg) {
        this.ResDir = s;
        if (bOverwriteOrg) {
            this.OrgResDir = s;
        }
    }

    public String getOrgResDir() {
        return this.OrgResDir;
    }

    public String getLogo() {
        return this.Logo;
    }

    public void setLogo(String s) {
        this.Logo = s;
    }

    public String getExclude() {
        return this.Exclude;
    }

    public void setExclude(String s) {
        this.Exclude = s;
    }

    public String getCHMProj() {
        return this.CHMProj;
    }

    public void setCHMProj(String s) {
        this.CHMProj = s;
    }

    public String getExtDef() {
        return this.ExtDef;
    }

    public void setExtDef(String s) {
        this.ExtDef = s;
    }

    public ArrayList getExtDefaultsList() {
        return this.vExtDefaults;
    }

    public ArrayList getExtDefParaList() {
        return this.vExtDefPara;
    }

    public String getRecurseStr() {
        return this.sRecurse;
    }

    public boolean getRecurse() {
        return this.Recurse;
    }

    public void setRecurse(String s) {
        this.sRecurse = s;
        this.Recurse = !this.sRecurse.toLowerCase().equals("no");
    }

    public ArrayList getGroupDef() {
        return this.vGroups;
    }

    public ArrayList getUserGroupDefs() {
        return this.vUserGroupDefs;
    }

    public boolean getEnableSearch() {
        return this.bEnableSearch;
    }

    public void setEnableSearch(String s) {
        this.sEnableSearch = s;
        this.bEnableSearch = !this.sEnableSearch.toLowerCase().equals("no");
    }

    public String getEnableSearchStr() {
        return this.sEnableSearch;
    }

    public ArrayList getPluginList() {
        return this.lPlugins;
    }

    public void setPluginList(ArrayList lPlugins) {
        this.lPlugins = lPlugins;
    }
}

