/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocPluginInterface;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;

public abstract class AutoDocPluginInputPackaged
implements AutoDocPluginInterface {
    protected String sPluginName = "Unknown";
    protected String sPluginVersion = "Unknown";
    protected String sPluginDescription = "Not available";
    protected String sCompatibleWith = "1.2.8";
    protected String sMinCompatible = "1.2.8";
    protected AutoDocSettings mySettings = null;
    protected String sPathToJar;
    protected String sInput = "";
    protected String sOutput = "";
    protected String sVirtualOutput = "";

    public void init(String sPathToJar, AutoDocSettings mySettings) {
        this.mySettings = mySettings;
        this.sPathToJar = sPathToJar;
        this.readPluginInfo();
    }

    public abstract void process() throws Error;

    public abstract void cleanup() throws Error;

    public abstract boolean checkValidInput(String var1);

    public abstract String getExcludePattern();

    public String getStringParameter(String sParamName) {
        String sRes = "";
        if (sParamName.equals("Input")) {
            sRes = this.sInput;
        } else if (sParamName.equals("Output")) {
            sRes = this.sOutput;
        } else if (sParamName.equals("VirtualOutput")) {
            sRes = this.sVirtualOutput;
        }
        return sRes;
    }

    public void setStringParameter(String sParamName, String sValue) {
        if (sParamName.equals("Input")) {
            this.sInput = sValue;
        } else if (sParamName.equals("Output")) {
            this.sOutput = sValue;
        } else if (sParamName.equals("VirtualOutput")) {
            this.sVirtualOutput = sValue;
        }
    }

    public String getCompatibleWithVersion() {
        return this.sCompatibleWith;
    }

    public boolean isOutputDirectory() {
        return true;
    }

    public abstract String getAbsoluteFilenameForOutput(String var1);

    public abstract String getAbsoluteFilenameLabelForOutput(String var1);

    public String getPluginName() {
        return this.sPluginName;
    }

    public String getPluginVersion() {
        return this.sPluginVersion;
    }

    public String getPluginDescription() {
        return this.sPluginDescription;
    }

    public AutoDocSettings getAutoDocSettings() {
        return this.mySettings;
    }

    public void readPluginInfo() {
        File fJar = new File(this.sPathToJar);
        String sPluginInfoName = new File(fJar.getParent(), "plugin_info.txt").getAbsolutePath();
        FileInputStream fin1 = null;
        try {
            fin1 = new FileInputStream(sPluginInfoName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Hashtable tab1 = FileUtils.readParamsFromFile(fin1);
        if (tab1 != null) {
            this.sPluginName = (String)tab1.get("Name");
            this.sPluginVersion = (String)tab1.get("Version");
            this.sPluginDescription = (String)tab1.get("Description");
            String sCompat = (String)tab1.get("CompatibleWith");
            if (AutoDocStringUtils.compareVersions(sCompat, this.sMinCompatible) >= 0) {
                this.sCompatibleWith = sCompat;
            }
        } else {
            this.outputNote("Plugin information cannot be read from file " + sPluginInfoName + ".");
        }
    }

    public void outputWarning(String sMsg) {
        if (this.mySettings != null) {
            String[] saParam = new String[]{this.sPluginName, sMsg};
            this.mySettings.getMsgHandler().outputWarning("MSG_PLUGINMSG", saParam);
        } else {
            SystemUtils.println(sMsg);
        }
    }

    public void outputNote(String sMsg) {
        if (this.mySettings != null) {
            String[] saParam = new String[]{this.sPluginName, sMsg};
            this.mySettings.getMsgHandler().outputNote("MSG_PLUGINMSG", saParam);
        } else {
            SystemUtils.println(sMsg);
        }
    }

    public static String createTempDirectoryName() throws Error {
        String sRet = "";
        File temp = null;
        try {
            temp = FileUtils.createTempDirectory("AutoDocTmp");
            sRet = temp.getAbsolutePath();
        }
        catch (IOException e) {
            throw new Error("Cannot create temporary directory.");
        }
        return sRet;
    }
}

