/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocBibEntry;
import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocFileExtInfo;
import de.enache.AutoDoc.AutoDocFuncIndexElement;
import de.enache.AutoDoc.AutoDocFuncSortElement;
import de.enache.AutoDoc.AutoDocFunctionInfo;
import de.enache.AutoDoc.AutoDocGroupInfo;
import de.enache.AutoDoc.AutoDocGroupingDefinition;
import de.enache.AutoDoc.AutoDocInclude;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocListItem;
import de.enache.AutoDoc.AutoDocOutputInterface;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.AutoDocTagParameter;
import de.enache.AutoDoc.AutoDocTagParameterList;
import de.enache.AutoDoc.Epub.AutoDocEpubOut;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutFrames;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutIFrames;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutITreeFrames;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutNoFrames;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutSingle;
import de.enache.AutoDoc.HTML.AutoDocHTMLOutTreeFrames;
import de.enache.AutoDoc.LaTeX.AutoDocLaTeXOutPDFLaTeX;
import de.enache.AutoDoc.LaTeX.AutoDocLaTeXOutSimple;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.Tree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AutoDocOutput
implements AutoDocOutputInterface {
    protected AutoDocDocument Document = null;
    protected AutoDocSettings mySettings = null;
    protected String Outpath = "";
    protected ArrayList IndexEntries = new ArrayList();
    protected ArrayList vGroupings = new ArrayList();
    protected ArrayList includeTreeList = new ArrayList();
    protected ArrayList bibrefList = new ArrayList();
    protected String sRefFileName = "";
    protected String sFuncIndexFileName = "";
    protected ArrayList varFuncList = new ArrayList();
    protected String SysNewLine = System.getProperty("line.separator");

    protected AutoDocOutput(AutoDocDocument Document, AutoDocSettings mySettings) {
        this.Document = Document;
        this.mySettings = mySettings;
        this.Outpath = mySettings.getOutPath();
    }

    public void doOutput() {
        this.prepareOutputLoop();
        this.doOutputLoop();
        this.postprocessOutput();
    }

    protected void prepareOutputLoop() {
        File fDir = new File(this.Outpath);
        if (!fDir.exists()) {
            fDir.mkdirs();
        } else {
            if (!fDir.isDirectory()) {
                throw new Error(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTDIRINVALID", this.Outpath));
            }
            this.cleanOutDir();
        }
    }

    protected void postprocessOutput() {
    }

    protected void doOutputLoop() {
        ArrayList vFilelist = this.Document.getProcFiles();
        int iNumFiles = vFilelist.size();
        if (iNumFiles > 0) {
            SystemUtils.println();
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_DOCPREPROCESSINDEX"));
            this.IndexEntries = new ArrayList(iNumFiles);
            int i = 0;
            while (i < iNumFiles) {
                AutoDocFile curFile = (AutoDocFile)vFilelist.get(i);
                String sOutFile = this.generateOutputFileName(i);
                this.addFileToIndex(curFile, sOutFile, i);
                ArrayList vCurBibEntries = this.preprocessBibEntries(curFile, sOutFile);
                AutoDocIndexInfo cur = (AutoDocIndexInfo)this.IndexEntries.get(i);
                cur.vBibentries = vCurBibEntries;
                ++i;
            }
            this.sortIndex();
            this.buildGlobalRefList();
            int[][] iaLevelCounts = new int[iNumFiles][];
            int i2 = 0;
            while (i2 < iNumFiles) {
                AutoDocFile curFile = (AutoDocFile)vFilelist.get(i2);
                String sOutFile = this.generateOutputFileName(i2);
                int iFound = this.findIndexEntryIndex(i2);
                iaLevelCounts[i2] = this.preprocessFile(curFile, sOutFile, iFound);
                ++i2;
            }
            this.buildGlobalVarFuncLists();
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_DOCPREPROCESSINCLUDES"));
            this.includeTreeList = this.generateIncludeTreeList();
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_DOCPREPROCESSGROUPS"));
            ArrayList vGroupDef = this.mySettings.getGroupDef();
            this.vGroupings = new ArrayList();
            int iGroupSize = vGroupDef.size();
            int i3 = 0;
            while (i3 < iGroupSize) {
                AutoDocGroupingDefinition curGroup = (AutoDocGroupingDefinition)vGroupDef.get(i3);
                Tree tCurRet = this.getAllofGroup(curGroup, i3);
                this.vGroupings.add(tCurRet);
                ++i3;
            }
            SystemUtils.println();
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEDOCFILES", "" + iNumFiles));
            int iBlockPerc = 10;
            int i4 = 0;
            while (i4 < iNumFiles) {
                AutoDocFile curFile = (AutoDocFile)vFilelist.get(i4);
                String sOutFile = this.generateOutputFileName(i4);
                int[] iaNumLevel = iaLevelCounts[i4];
                try {
                    double dPerc;
                    int iPerc;
                    this.processFile(curFile, sOutFile, iaNumLevel);
                    if (iNumFiles > 10 && (iPerc = (int)(dPerc = 100.0 * ((double)(i4 + 1) / (double)iNumFiles))) >= iBlockPerc) {
                        if ((iPerc = 10 * (iPerc / 10)) >= 100) {
                            SystemUtils.println("  " + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEDOCPERC", String.valueOf(iPerc) + "%"));
                        } else {
                            SystemUtils.println("  " + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEDOCPERC", " " + iPerc + "%"));
                        }
                        iBlockPerc += 10;
                    }
                }
                catch (IOException e) {
                    throw new Error(e.getMessage());
                }
                Thread.yield();
                ++i4;
            }
            SystemUtils.println();
        }
    }

    public void buildGlobalRefList() {
        int iNumFiles = this.IndexEntries.size();
        int i = 0;
        while (i < iNumFiles) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            ArrayList vBibentries = curInfo.vBibentries;
            if (vBibentries != null) {
                int iNumEntries = vBibentries.size();
                int j = 0;
                while (j < iNumEntries) {
                    AutoDocBibEntry curEntry = (AutoDocBibEntry)vBibentries.get(j);
                    String sKey = curEntry.getKey();
                    String sCurValue = curEntry.getEntry().trim();
                    if (curEntry.isGlobal()) {
                        int iFound = this.findBibRef(sKey, this.bibrefList);
                        if (iFound < 0) {
                            this.bibrefList.add(curEntry);
                        } else {
                            AutoDocBibEntry foundEntry = (AutoDocBibEntry)this.bibrefList.get(iFound);
                            String sCurFilename = curEntry.getFilename();
                            String sFoundValue = foundEntry.getEntry().trim();
                            String sFoundFilename = foundEntry.getFilename();
                            if (!sCurValue.equals(sFoundValue)) {
                                String[] saMsg = new String[]{sKey, sCurFilename, sFoundFilename};
                                this.mySettings.getMsgHandler().outputWarning("WARN_REFERENCE_DUPLICATE", saMsg);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected int findBibRef(String sKey, ArrayList bibList) {
        int iFound = -1;
        int iDestNum = bibList.size();
        int k = 0;
        while (k < iDestNum) {
            AutoDocBibEntry curDest = (AutoDocBibEntry)bibList.get(k);
            if (curDest != null && curDest.getKey().equalsIgnoreCase(sKey)) {
                iFound = k;
                break;
            }
            ++k;
        }
        return iFound;
    }

    public void buildGlobalVarFuncLists() {
        ArrayList vFilelist = this.Document.getProcFiles();
        int iNumFiles = this.IndexEntries.size();
        int i = 0;
        while (i < iNumFiles) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            int iOrgIndex = curInfo.iOrgIndex;
            AutoDocFile curFile = (AutoDocFile)vFilelist.get(iOrgIndex);
            ArrayList vVars = curInfo.vVars;
            int iNumVars = vVars.size();
            int j = 0;
            while (j < iNumVars) {
                AutoDocFunctionInfo curFuncInfo = (AutoDocFunctionInfo)vVars.get(j);
                AutoDocFuncSortElement newElem = new AutoDocFuncSortElement(curFuncInfo, curFile, false);
                this.varFuncList.add(newElem);
                ++j;
            }
            ArrayList vFunc = curInfo.vFunc;
            int iNumFunc = vFunc.size();
            int j2 = 0;
            while (j2 < iNumFunc) {
                AutoDocFunctionInfo curFuncInfo = (AutoDocFunctionInfo)vFunc.get(j2);
                AutoDocFuncSortElement newElem = new AutoDocFuncSortElement(curFuncInfo, curFile, false);
                this.varFuncList.add(newElem);
                ++j2;
            }
            ++i;
        }
        Collections.sort(this.varFuncList);
    }

    public String convertCitation(String sRef, ArrayList bibList, String sRefFileName, boolean bGlobal) {
        int iFound;
        String sOpen = "[";
        String sClose = "]";
        if (!bGlobal) {
            sOpen = "{";
            sClose = "}";
        }
        String sText = String.valueOf(sOpen) + sRef + sClose;
        if (bibList != null && (iFound = this.findBibRef(sRef, bibList)) >= 0) {
            if (bGlobal) {
                sText = String.valueOf(sOpen) + (iFound + 1) + sClose;
            }
            if (!sRefFileName.equals("")) {
                String sNewRef = this.createXRefLabel(sRefFileName, sRef);
                sText = this.convertLinkToStringInternal(sNewRef, sText, false);
            }
        }
        return sText;
    }

    public String convertReferenceTag(String sRef, ArrayList bibList, String sRefFileName, boolean bGlobal) {
        int iFound;
        String sOpen = "[";
        String sClose = "]";
        if (!bGlobal) {
            sOpen = "{";
            sClose = "}";
        }
        String sText = String.valueOf(sOpen) + sRef + sClose;
        if (bibList != null && (iFound = this.findBibRef(sRef, bibList)) >= 0) {
            if (bGlobal) {
                sText = String.valueOf(sOpen) + (iFound + 1) + sClose;
            }
            if (!sRefFileName.equals("")) {
                String sNewRef = this.createXRefLabel(sRefFileName, sRef);
                sText = this.convertLinkToStringInternal(sNewRef, sText, false);
            }
        }
        return sText;
    }

    public String ascFileToString(String sFile) {
        String sReturn = "";
        try {
            String sFileEnc = AutoDoc.detectUTFCharset(sFile);
            sReturn = FileUtils.ascFileToString(sFile, sFileEnc);
        }
        catch (IOException e) {
            this.mySettings.getMsgHandler().outputWarning("WARN_OUTREADFAILED", sFile);
        }
        return sReturn;
    }

    public String getTemplatePath(String sTemplateName) {
        String sTemplFilename = String.valueOf(this.mySettings.getTemplateDir()) + "/" + sTemplateName;
        File fTempl = new File(sTemplFilename);
        if (!fTempl.exists()) {
            sTemplFilename = String.valueOf(this.mySettings.getProgPath()) + "/templates/" + sTemplateName;
        }
        return sTemplFilename;
    }

    public void processFile(AutoDocFile curFile, String sOutFile, int[] iaNumLevel) throws IOException {
        AutoDocIndexInfo curInfo = this.findIndexEntry(curFile.getAbsoluteFilename());
        String sOrgFile = curInfo.OrgFilename;
        String sFileType = curInfo.FileType;
        String sFullOutFil = "";
        sFullOutFil = this.Outpath.equals("") ? sOutFile : String.valueOf(this.Outpath) + "/" + sOutFile;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        this.processFileHeader(psOut, sOutFile, sOrgFile, sFileType, iaNumLevel);
        this.processFileInfo(psOut, curFile, sOrgFile, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_GENERALINFO"), sOutFile, "");
        if (iaNumLevel[1] > 0) {
            this.processStructure(psOut, curFile, sOrgFile, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTURE"), sOutFile);
        }
        if (iaNumLevel[2] > 0) {
            this.processClassFunc(psOut, curFile, this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONS"), sOutFile, "");
        }
        psOut.close();
        byte[] baRes = baOut.toByteArray();
        this.outputFile(baRes, sFullOutFil, sOrgFile);
    }

    public void processFileHeader(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType, int[] iaNumLevel) {
        this.processFileHeading(psOut, sOutFil, sOrgFile, sFileType);
        this.processOverview(psOut, sOutFil, iaNumLevel);
    }

    public void processFileInfo(PrintStream psOut, AutoDocFile curFile, String sOrgFile, String sTitle, String sTagName, String sPreFmt) {
        ArrayList treeList = curFile.getTagTreeList();
        this.processFileInfoHeading(psOut, sTitle, sTagName);
        int iCurIdx = 1;
        int i = 0;
        while (i < treeList.size()) {
            Tree curNode = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curNode.getData();
            if (!curNode.isNodeEmpty() && curTag.getLevel() == 1) {
                AutoDocTagParameterList curParms = this.getParameters(curTag, curFile, sTagName);
                String curLabel = curTag.getLabel();
                String sFilnam = "";
                String sDescription = "";
                int iNumPara = curParms.size();
                sFilnam = sOrgFile;
                if (iNumPara >= 1) {
                    sDescription = curParms.get(0).toString().trim();
                }
                this.processFileInfoOutput(psOut, curLabel, sFilnam, this.processParam(sDescription, true, false));
                this.processFileLink(psOut, curFile);
                iCurIdx = this.processSubTags(psOut, curFile, 1, sPreFmt, iCurIdx, curNode, sTagName);
            }
            ++i;
        }
        this.processEmptyParagraph(psOut);
    }

    public void processStructure(PrintStream psOut, AutoDocFile curFile, String sOrgFile, String sTitle, String sOutfile) {
        ArrayList vDetails = this.processStructSummary(psOut, curFile, sOrgFile, sTitle, sOutfile);
        this.processStructDetails(psOut, curFile, sOutfile, vDetails);
    }

    public ArrayList processStructSummary(PrintStream psOut, AutoDocFile curFile, String sOrgFile, String sTitle, String sOutfile) {
        ArrayList<Tree> vDetails = new ArrayList<Tree>();
        ArrayList treeList = curFile.getTagTreeList();
        AutoDocTag rootTag = curFile.getLevel1Tag();
        if (rootTag != null) {
            Tree tCurTree = new Tree();
            int iCurFileIdx = this.findIndexEntryIndex(curFile.getAbsoluteFilename());
            if (iCurFileIdx >= 0) {
                tCurTree = (Tree)this.includeTreeList.get(iCurFileIdx);
            }
            ArrayList vIncludes = (ArrayList)tCurTree.getChildren();
            AutoDocTagParameterList rootParms = this.getParameters(rootTag, curFile, sOutfile);
            String sRootLabel = rootTag.getLabel();
            String sRootFilnam = "";
            String sRootDescription = "";
            int iRootNumPara = rootParms.size();
            sRootFilnam = sOrgFile;
            if (iRootNumPara >= 1) {
                sRootDescription = rootParms.get(0).toString().trim();
            }
            this.processStructureHeader(psOut, sTitle, sOutfile, sRootLabel, sRootFilnam, sRootDescription);
            int iNestingDepth = 0;
            this.processStructListBegin(psOut, iNestingDepth);
            int i = 0;
            while (i < treeList.size()) {
                Tree curNode = (Tree)treeList.get(i);
                AutoDocTag curTag = (AutoDocTag)curNode.getData();
                if (curTag != null) {
                    int curLevel = curTag.getLevel();
                    AutoDocTagParameterList curParms = this.getParameters(curTag, curFile, sOutfile);
                    String curLabel = curTag.getLabel();
                    if (curLevel == 2) {
                        String sNoD;
                        String sWithD;
                        if (curTag.getTagInfo().isInclude()) {
                            String sInStr = this.processParam(curParms.get(0).toString().trim(), true, false);
                            Tree curIncludeNode = this.findIncludeTreeFromList(vIncludes, sInStr);
                            if (curIncludeNode != null) {
                                String sCurrAbsFilename = curFile.getAbsoluteFilename();
                                ArrayList vIncHist = new ArrayList();
                                this.processIncludeStructEntry(psOut, sCurrAbsFilename, curIncludeNode, curLabel, vIncHist);
                            }
                        } else if (curTag.getTagInfo().isClassType()) {
                            this.processClassStructEntry(psOut, curFile, curParms, curLabel, "Class", iNestingDepth);
                        } else if (curTag.getTagInfo().isSection()) {
                            boolean bHasDetails;
                            boolean bl = bHasDetails = curNode.numChildren() > 0;
                            if (!bHasDetails && !(sWithD = this.processParam(curParms.get(0).toString().trim(), true, false).trim()).equals(sNoD = this.processParam(curParms.get(0).toString().trim(), false, false).trim())) {
                                bHasDetails = true;
                            }
                            this.processDefaultStructEntry(psOut, curFile, curParms, curLabel, "Section", iNestingDepth);
                            if (bHasDetails) {
                                vDetails.add(curNode);
                            }
                        } else {
                            boolean bHasDetails;
                            boolean bl = bHasDetails = curNode.numChildren() > 0;
                            if (!bHasDetails && !(sWithD = this.processParam(curParms.get(0).toString().trim(), true, false).trim()).equals(sNoD = this.processParam(curParms.get(0).toString().trim(), false, false).trim())) {
                                bHasDetails = true;
                            }
                            this.processDefaultStructEntry(psOut, curFile, curParms, curLabel, "", iNestingDepth);
                            if (bHasDetails) {
                                vDetails.add(curNode);
                            }
                        }
                    }
                }
                ++i;
            }
            this.processStructListEnd(psOut, iNestingDepth);
            this.processEmptyParagraph(psOut);
        }
        return vDetails;
    }

    public void processStructDetails(PrintStream psOut, AutoDocFile curFile, String sOutfile, ArrayList vDetails) {
        int iDetailSize = vDetails.size();
        if (iDetailSize > 0) {
            this.processStructureDetailsHeading(psOut);
            int iCurIdx = 1;
            int i = 0;
            while (i < iDetailSize) {
                Tree curNode = (Tree)vDetails.get(i);
                AutoDocTag curTag = (AutoDocTag)curNode.getData();
                AutoDocTagParameterList curParms = this.getParameters(curTag, curFile, sOutfile);
                String curLabel = curTag.getLabel();
                String sShort = this.processParam(curParms.get(0).toString().trim(), false, false).trim();
                String sDescription = this.processParam(curParms.get(0).toString().trim(), true, false).trim();
                this.processStructDetailBegin(psOut);
                this.processStructDetailHead(psOut, curLabel, sShort, sDescription);
                iCurIdx = this.processSubTags(psOut, curFile, 3, "", iCurIdx, curNode, "");
                this.processStructDetailEnd(psOut);
                ++i;
            }
            this.processEmptyParagraph(psOut);
        }
    }

    public void processIncludeStructEntry(PrintStream psOut, String sCurrAbsFilename, Tree curNode, String curLabel, ArrayList vIncOrgHist) {
        int iNestingDepth = vIncOrgHist.size();
        ArrayList<String> vIncHist = new ArrayList<String>(vIncOrgHist);
        vIncHist.add(sCurrAbsFilename);
        this.processStructItemBegin(psOut, "Include", iNestingDepth);
        String sOutText = "";
        AutoDocInclude rootInclude = (AutoDocInclude)curNode.getData();
        String sText = rootInclude.sIncludeStr;
        String sLink = rootInclude.sOutFilename;
        vIncHist.add(rootInclude.sAbsFilename);
        if (!sLink.equals("")) {
            sText = this.convertLinkToStringInternal(this.createXRefLabel(sLink, ""), rootInclude.sIncludeStr, false);
        }
        sOutText = vIncHist.size() < 1 ? String.valueOf(curLabel) + ": " + this.getDoubleQuote() + sText + this.getDoubleQuote() : String.valueOf(curLabel) + ": " + this.getDoubleQuote() + sText + this.getDoubleQuote();
        if (!rootInclude.sDescription.equals("")) {
            sOutText = String.valueOf(sOutText) + " - " + rootInclude.sDescription;
        }
        this.processStructEntry(psOut, sOutText, iNestingDepth);
        ArrayList curChilds = (ArrayList)curNode.getChildren();
        int iNumIncludes = curChilds.size();
        int iNewDepth = vIncHist.size();
        if (iNumIncludes > 0) {
            this.processStructListBegin(psOut, iNewDepth);
        }
        int i = 0;
        while (i < iNumIncludes) {
            Tree curChildNode = (Tree)curChilds.get(i);
            AutoDocInclude curInclude = (AutoDocInclude)curChildNode.getData();
            this.processIncludeStructEntry(psOut, curInclude.sAbsFilename, curChildNode, curLabel, vIncHist);
            ++i;
        }
        if (iNumIncludes > 0) {
            this.processStructListEnd(psOut, iNewDepth);
        }
        this.processStructItemEnd(psOut, "Include", iNestingDepth);
    }

    protected Tree findIncludeTreeFromList(ArrayList vIncludes, String sInStr) {
        Tree curIncludeNode = null;
        int j = 0;
        while (j < vIncludes.size()) {
            Tree curChild = (Tree)vIncludes.get(j);
            AutoDocInclude curInc = (AutoDocInclude)curChild.getData();
            if (curInc.sIncludeStr.equals(sInStr)) {
                curIncludeNode = curChild;
                break;
            }
            ++j;
        }
        return curIncludeNode;
    }

    public void processDefaultStructEntry(PrintStream psOut, AutoDocFile curFile, AutoDocTagParameterList curParms, String curLabel, String sType, int iNestingDepth) {
        this.processStructItemBegin(psOut, sType, iNestingDepth);
        String sOutText = "";
        String sText = "";
        int iParaSize = curParms.size();
        if (iParaSize > 0) {
            sText = this.processParam(curParms.get(0).toString().trim(), false, false);
            sOutText = String.valueOf(curLabel) + ": " + sText;
        }
        int k = 1;
        while (k < iParaSize) {
            sText = this.processParam(curParms.get(k).toString().trim(), false, false);
            sOutText = String.valueOf(sOutText) + " - " + sText;
            ++k;
        }
        this.processStructEntry(psOut, sOutText, iNestingDepth);
        this.processStructItemEnd(psOut, sType, iNestingDepth);
    }

    public void processClassStructEntry(PrintStream psOut, AutoDocFile curFile, AutoDocTagParameterList curParms, String curLabel, String sType, int iNestingDepth) {
        this.processStructItemBegin(psOut, sType, iNestingDepth);
        String sOutText = "";
        String sText = "";
        int iParaSize = curParms.size();
        if (iParaSize > 0) {
            sText = this.processParam(curParms.get(0).toString().trim(), false, false);
            String sLink = this.createXRefLabel("", sText);
            if (!sLink.equals("")) {
                sText = this.convertLinkToStringInternal(sLink, sText, false);
            }
            sOutText = String.valueOf(curLabel) + ": " + sText;
        }
        int k = 1;
        while (k < iParaSize) {
            sText = this.processParam(curParms.get(k).toString().trim(), false, false);
            sOutText = String.valueOf(sOutText) + " - " + sText;
            ++k;
        }
        this.processStructEntry(psOut, sOutText, iNestingDepth);
        this.processStructItemEnd(psOut, sType, iNestingDepth);
    }

    public AutoDocFile findProcFileByAbsName(String sFilename) {
        AutoDocFile foundFile = null;
        ArrayList vFilelist = this.Document.getProcFiles();
        int i = 0;
        while (i < vFilelist.size()) {
            AutoDocFile curFile = (AutoDocFile)vFilelist.get(i);
            if (curFile.getAbsoluteFilename().equals(sFilename)) {
                foundFile = curFile;
                break;
            }
            ++i;
        }
        return foundFile;
    }

    public AutoDocIndexInfo findIncludeFile(String sParentAbsFilename, String sFilename) {
        AutoDocIndexInfo foundInfo = null;
        String sSearchFilename = this.generateAbsoluteIncludeName(sParentAbsFilename, sFilename);
        boolean bCaseSensitive = FileUtils.isCaseSensitivePath();
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sAbsFilename = curInfo.OrgAbsFilename.replaceAll("\\\\", "/");
            if (sAbsFilename.equals(sSearchFilename) || !bCaseSensitive && sAbsFilename.equalsIgnoreCase(sSearchFilename)) {
                foundInfo = curInfo;
                break;
            }
            ++i;
        }
        return foundInfo;
    }

    public String generateAbsoluteIncludeName(String sParentAbsFilename, String sInclude) {
        String sTmpFilename = sInclude.replaceAll("\\\\", "/");
        sParentAbsFilename = sParentAbsFilename.replaceAll("\\\\", "/");
        String sCurPath = "";
        int iPosCur = sParentAbsFilename.lastIndexOf("/");
        if (iPosCur >= 0) {
            sCurPath = sParentAbsFilename.substring(0, iPosCur);
        }
        boolean bIsAbsolute = false;
        if (sTmpFilename.startsWith("/")) {
            bIsAbsolute = true;
        } else if (FileUtils.toCanonicalPath(sTmpFilename).replaceAll("\\\\", "/").equals(sTmpFilename)) {
            bIsAbsolute = true;
        }
        if (!bIsAbsolute && sTmpFilename.startsWith("./")) {
            sTmpFilename = sTmpFilename.substring(2);
        }
        String sLongFile = "";
        sLongFile = sCurPath.equals("") ? sTmpFilename : String.valueOf(sCurPath) + "/" + sTmpFilename;
        String sSearchFilename = sLongFile = FileUtils.toCanonicalPath(sLongFile).replaceAll("\\\\", "/");
        if (bIsAbsolute) {
            sSearchFilename = sTmpFilename;
        }
        return sSearchFilename;
    }

    public void processVarSummary(PrintStream psOut, ArrayList vVars) {
        String sHead = this.createVarSummaryTableHeader();
        boolean bAny = false;
        if (vVars.size() > 0) {
            bAny = true;
        }
        if (bAny) {
            psOut.print(sHead);
            bAny = true;
        }
        int i = 0;
        while (i < vVars.size()) {
            AutoDocFuncSortElement curSortElem = (AutoDocFuncSortElement)vVars.get(i);
            AutoDocFunctionInfo funcInfo = curSortElem.getFuncInfo();
            AutoDocTag curTag = funcInfo.getCurTag();
            String sLabel = curTag.getLabel();
            String sVarName = funcInfo.getsFuncDef();
            String sDescription = funcInfo.getsDescription();
            this.processSimpleRowBegin(psOut);
            this.processSimpleTableCell(psOut, sVarName, 3, 0);
            this.processSimpleTableCell(psOut, sLabel, 3, 1);
            this.processSimpleTableCell(psOut, this.processParam(sDescription, false, false), 3, 2);
            this.processSimpleRowEnd(psOut);
            ++i;
        }
        if (bAny) {
            this.processSummaryTableEnd(psOut);
            this.processEmptyParagraph(psOut);
        }
    }

    public void processLibnameSummary(PrintStream psOut, ArrayList vLibname) {
        String sHead = this.createLibnameSummaryTableHeader();
        boolean bAny = false;
        if (vLibname.size() > 0) {
            bAny = true;
        }
        if (bAny) {
            psOut.print(sHead);
            bAny = true;
        }
        this.processLibnameSummaryByType(psOut, vLibname, false);
        this.processLibnameSummaryByType(psOut, vLibname, true);
        if (bAny) {
            this.processSummaryTableEnd(psOut);
            this.processEmptyParagraph(psOut);
        }
    }

    public void processLibnameSummaryByType(PrintStream psOut, ArrayList vLibname, boolean bRemoteFlag) {
        int i = 0;
        while (i < vLibname.size()) {
            AutoDocFuncSortElement curSortElem = (AutoDocFuncSortElement)vLibname.get(i);
            AutoDocFunctionInfo funcInfo = curSortElem.getFuncInfo();
            AutoDocTag curTag = funcInfo.getCurTag();
            AutoDocTagListElement TagInfo = curTag.getTagInfo();
            boolean bRemote = TagInfo.isRemote();
            if (bRemote == bRemoteFlag) {
                String sLocRem = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMELOCAL");
                if (bRemote) {
                    sLocRem = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMEREMOTE");
                }
                String sVarName = funcInfo.getName();
                String sDef = funcInfo.getsFuncDef();
                String sDescription = funcInfo.getsDescription();
                File fDir = new File(sDef);
                if (fDir.exists()) {
                    sDef = this.convertLinkToStringExternal(sDef, sDef, true);
                }
                this.processSimpleRowBegin(psOut);
                this.processSimpleTableCell(psOut, sLocRem, 4, 0);
                this.processSimpleTableCell(psOut, sVarName, 4, 1);
                this.processSimpleTableCell(psOut, sDef, 4, 2);
                this.processSimpleTableCell(psOut, this.processParam(sDescription, false, false), 4, 3);
                this.processSimpleRowEnd(psOut);
            }
            ++i;
        }
    }

    public void processFuncSummary(PrintStream psOut, String sOutfile, ArrayList vFuncs) {
        String sHead = this.createFuncSummaryTableHeader();
        boolean bAny = false;
        if (vFuncs.size() > 0) {
            bAny = true;
        }
        if (bAny) {
            psOut.print(sHead);
            bAny = true;
        }
        int i = 0;
        while (i < vFuncs.size()) {
            AutoDocFuncSortElement curSortElem = (AutoDocFuncSortElement)vFuncs.get(i);
            AutoDocFunctionInfo funcInfo = curSortElem.getFuncInfo();
            String sFuncSig = funcInfo.getSignature();
            String sLinkLabel = sFuncSig.replaceAll("\\s+", "_");
            String sFuncDef = funcInfo.getsFuncDef();
            String sDescription = funcInfo.getsDescription();
            AutoDocTag curTag = funcInfo.getCurTag();
            String sLabel = curTag.getLabel();
            sLinkLabel = this.createXRefLabelLocal(sOutfile, sLinkLabel);
            this.processSimpleRowBegin(psOut);
            this.processLocalRefTableCell(psOut, sLinkLabel, sFuncDef, 3, 0);
            this.processSimpleTableCell(psOut, sLabel, 3, 1);
            this.processSimpleTableCell(psOut, this.processParam(sDescription, false, false), 3, 2);
            this.processSimpleRowEnd(psOut);
            ++i;
        }
        if (bAny) {
            this.processSummaryTableEnd(psOut);
            this.processEmptyParagraph(psOut);
        }
    }

    public void processFunctionDetails(PrintStream psOut, String sOutfile, ArrayList vFuncs, String sTagName, String sPreFmt) {
        boolean bAny = false;
        if (vFuncs.size() > 0) {
            bAny = true;
        }
        if (bAny) {
            this.processFunctionDetailsHeading(psOut);
            bAny = true;
        }
        int iCurIdx = 1;
        int i = 0;
        while (i < vFuncs.size()) {
            AutoDocFuncSortElement curSortElem = (AutoDocFuncSortElement)vFuncs.get(i);
            AutoDocFile curFile = curSortElem.getFileInfo();
            AutoDocFunctionInfo funcInfo = curSortElem.getFuncInfo();
            AutoDocTag curTag = funcInfo.getCurTag();
            String curLabel = curTag.getLabel();
            String sFuncSig = funcInfo.getSignature();
            String sLinkLabel = sFuncSig.replaceAll("\\s+", "_");
            String sFuncDef = funcInfo.getsFuncDef();
            String sDescription = funcInfo.getsDescription();
            sLinkLabel = this.createXRefAnchor(sOutfile, sLinkLabel);
            this.processFuncDetailBegin(psOut);
            this.processFuncDetailFuncHead(psOut, curLabel, sFuncDef, sDescription, sLinkLabel);
            Tree curNode = this.searchNode(curFile, curTag);
            iCurIdx = this.processSubTags(psOut, curFile, 3, sPreFmt, iCurIdx, curNode, sOutfile);
            this.processFuncDetailEnd(psOut);
            ++i;
        }
    }

    public Tree searchNode(AutoDocFile curFile, AutoDocTag curTag) {
        Tree curNode = null;
        ArrayList vTags = curFile.getTagTreeList();
        int j = 0;
        while (j < vTags.size()) {
            Tree searchNode = (Tree)vTags.get(j);
            AutoDocTag searchTag = (AutoDocTag)searchNode.getData();
            if (searchTag.equals(curTag)) {
                curNode = searchNode;
            }
            ++j;
        }
        return curNode;
    }

    public ArrayList createAndSortVarFuncArray(AutoDocFile curFile, String sClass, String sOutfile, int iElemType) {
        AutoDocIndexInfo curEntry = this.findIndexEntry(curFile.getAbsoluteFilename());
        ArrayList vAllFuncs = null;
        vAllFuncs = iElemType == 1 ? curEntry.vVars : (iElemType == 2 ? curEntry.vLibnames : curEntry.vFunc);
        ArrayList<AutoDocFuncSortElement> vFuncs = new ArrayList<AutoDocFuncSortElement>();
        int i = 0;
        while (i < vAllFuncs.size()) {
            AutoDocFunctionInfo curInfo = (AutoDocFunctionInfo)vAllFuncs.get(i);
            if (curInfo.sParent.equals(sClass) && curInfo.iType == iElemType) {
                AutoDocFuncSortElement curSortElem = new AutoDocFuncSortElement(curInfo, curFile, true);
                vFuncs.add(curSortElem);
            }
            ++i;
        }
        Collections.sort(vFuncs);
        return vFuncs;
    }

    public void processClassFunc(PrintStream psOut, AutoDocFile curFile, String sTitle, String sOutfile, String sPreFmt) {
        this.processFuncSectionHeader(psOut, sTitle, sOutfile);
        ArrayList treeList = curFile.getTagTreeList();
        ArrayList<Tree> newTreeList = new ArrayList<Tree>();
        Tree lev1Node = null;
        Tree clsNode = null;
        int iNumOut = 0;
        int i = 0;
        while (i < treeList.size()) {
            Tree curNode = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curNode.getData();
            AutoDocTagListElement curElement = curTag.getTagInfo();
            if (curTag.getLevel() == 1) {
                lev1Node = curNode;
                newTreeList.add(lev1Node);
            } else if (!curNode.isNodeEmpty() && curElement != null && curElement.isClassType()) {
                if (iNumOut > 0) {
                    curFile.setTagTreeList(newTreeList);
                    this.processFunctions(psOut, curFile, sOutfile, sPreFmt, clsNode);
                }
                newTreeList = new ArrayList();
                newTreeList.add(lev1Node);
                newTreeList.add(curNode);
                clsNode = curNode;
                iNumOut = 0;
            } else {
                if (curTag.getLevel() == 3) {
                    ++iNumOut;
                }
                newTreeList.add(curNode);
            }
            ++i;
        }
        if (iNumOut > 0) {
            curFile.setTagTreeList(newTreeList);
            this.processFunctions(psOut, curFile, sOutfile, sPreFmt, clsNode);
        }
    }

    public void processFunctions(PrintStream psOut, AutoDocFile curFile, String sOutfile, String sPreFmt, Tree clsNode) {
        String sXrefTagName = this.createFilenameXRef(curFile);
        String sCurClass = "";
        if (clsNode != null) {
            AutoDocTag clsTag = (AutoDocTag)clsNode.getData();
            String sDescription = "";
            AutoDocTagParameterList curParms = this.getParameters(clsTag, curFile, sOutfile);
            int iParaSize = curParms.size();
            if (iParaSize >= 1) {
                sCurClass = curParms.get(0).toString().trim();
            }
            if (iParaSize >= 2) {
                sDescription = curParms.get(1).toString().trim();
            }
            String sClassLabel = clsTag.getLabel();
            this.processClassHeader(psOut, sCurClass, sDescription, sClassLabel, sOutfile);
            this.processSubTags(psOut, curFile, 2, "", 0, clsNode, sOutfile);
            this.processEmptyParagraph(psOut);
        }
        ArrayList vVars = this.createAndSortVarFuncArray(curFile, sCurClass, sXrefTagName, 1);
        ArrayList vFuncs = this.createAndSortVarFuncArray(curFile, sCurClass, sXrefTagName, 0);
        ArrayList vLibnames = this.createAndSortVarFuncArray(curFile, sCurClass, sXrefTagName, 2);
        this.processLibnameSummary(psOut, vLibnames);
        this.processVarSummary(psOut, vVars);
        this.processFuncSummary(psOut, sOutfile, vFuncs);
        this.processFunctionDetails(psOut, sOutfile, vFuncs, sXrefTagName, sPreFmt);
        if (vFuncs.size() > 0) {
            this.processEmptyParagraph(psOut);
        }
    }

    public void sortIndex() {
        Collections.sort(this.IndexEntries);
    }

    public AutoDocIndexInfo findIndexEntry(String sAbsFileName) {
        AutoDocIndexInfo retIndexInfo = null;
        String sSearch = sAbsFileName.replaceAll("\\\\", "/");
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curIndexInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sCurFilename = curIndexInfo.OrgAbsFilename.replaceAll("\\\\", "/");
            if (sCurFilename.equals(sSearch)) {
                retIndexInfo = curIndexInfo;
                break;
            }
            ++i;
        }
        return retIndexInfo;
    }

    public int findIndexEntryIndex(String sAbsFileName) {
        int iReturn = -1;
        String sSearch = sAbsFileName.replaceAll("\\\\", "/");
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curIndexInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sCurFilename = curIndexInfo.OrgAbsFilename.replaceAll("\\\\", "/");
            if (sCurFilename.equals(sSearch)) {
                iReturn = i;
                break;
            }
            ++i;
        }
        return iReturn;
    }

    public int findIndexEntryIndex(int iOrgIndex) {
        int iReturn = -1;
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curIndexInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            if (curIndexInfo.iOrgIndex == iOrgIndex) {
                iReturn = i;
                break;
            }
            ++i;
        }
        return iReturn;
    }

    public static AutoDocOutput getOutputClass(AutoDocDocument Document, AutoDocSettings mySettings) {
        AutoDocOutput myOut = null;
        if (mySettings.getDocType() == 3) {
            myOut = new AutoDocHTMLOutTreeFrames(Document, mySettings);
        } else if (mySettings.getDocType() == 1) {
            myOut = new AutoDocHTMLOutFrames(Document, mySettings);
        } else if (mySettings.getDocType() == 0) {
            myOut = new AutoDocHTMLOutNoFrames(Document, mySettings);
        } else if (mySettings.getDocType() == 2) {
            myOut = new AutoDocHTMLOutSingle(Document, mySettings);
        } else if (mySettings.getDocType() == 4) {
            myOut = new AutoDocHTMLOutIFrames(Document, mySettings);
        } else if (mySettings.getDocType() == 5) {
            myOut = new AutoDocHTMLOutITreeFrames(Document, mySettings);
        } else if (mySettings.getDocType() == 50) {
            myOut = new AutoDocLaTeXOutSimple(Document, mySettings);
        } else if (mySettings.getDocType() == 51) {
            myOut = new AutoDocLaTeXOutPDFLaTeX(Document, mySettings);
        } else if (mySettings.getDocType() == 61) {
            myOut = new AutoDocEpubOut(Document, mySettings);
        }
        return myOut;
    }

    public AutoDocTagParameterList getParameters(AutoDocTag curTag, AutoDocFile curFile, String sOutFil) {
        AutoDocTagParameterList curList = curTag.getParameters();
        AutoDocTagParameterList vReturn = new AutoDocTagParameterList();
        int iParaSize = curList.size();
        int i = 0;
        while (i < iParaSize) {
            AutoDocTagParameter curPara = curList.get(i);
            ArrayList curInlineTags = curPara.getInlineTags();
            int iNumInline = curInlineTags.size();
            String sCurPara = curPara.getParamString();
            int j = 0;
            while (j < iNumInline) {
                AutoDocTag curInlineTag = (AutoDocTag)curInlineTags.get(j);
                String sCurInlineOut = this.processInlineTag(curInlineTag, curFile, sOutFil);
                sCurPara = AutoDocStringUtils.replaceFirst(sCurPara, AutoDocTagParameter.InlinePlaceHolder, sCurInlineOut);
                ++j;
            }
            vReturn.add(new AutoDocTagParameter(this.mySettings, curFile.getTagCharacter(), curFile.getQuoteCharacter(), sCurPara, curFile.getFilename()));
            ++i;
        }
        return vReturn;
    }

    public boolean isItemList(ArrayList vItems) {
        boolean bResult = false;
        if (vItems.size() > 1) {
            int iCount = 0;
            int i = 0;
            while (i < vItems.size()) {
                AutoDocListItem curItem = (AutoDocListItem)vItems.get(i);
                if (curItem.iItemType > 0) {
                    if (++iCount > 1) {
                        bResult = true;
                        break;
                    }
                } else {
                    iCount = 0;
                }
                ++i;
            }
        }
        return bResult;
    }

    public ArrayList extractItemList(String s) {
        ArrayList<AutoDocListItem> vItems = new ArrayList<AutoDocListItem>();
        String sCurItem = "";
        String sCurItemNum = "";
        int iMaxType = 0;
        String sSplit = "\\n";
        String[] saLines = s.split(sSplit);
        int iNumItems = 0;
        int iType = 0;
        int i = 0;
        while (i < saLines.length) {
            String sText;
            int iPos;
            String sCurLine = saLines[i].trim();
            if ((iMaxType == 0 || iMaxType == 1) && sCurLine.matches("^\\p{Digit}+\\.[ \\t\\x0B\\f]+.+")) {
                if (!sCurItem.equals("")) {
                    vItems.add(new AutoDocListItem(iType, sCurItemNum, sCurItem));
                }
                iPos = sCurLine.indexOf(".");
                sCurItemNum = sCurLine.substring(0, iPos).trim();
                sCurItem = sText = String.valueOf(sCurLine.substring(iPos + 1, sCurLine.length()).trim()) + " ";
                String sTempNum = "" + (iNumItems + 1);
                if (sCurItemNum.equals(sTempNum)) {
                    ++iNumItems;
                    iType = 1;
                    iMaxType = 1;
                }
            } else if ((iMaxType == 0 || iMaxType == 2) && sCurLine.matches("^-[ \\t\\x0B\\f]+.+")) {
                if (!sCurItem.equals("")) {
                    vItems.add(new AutoDocListItem(iType, sCurItemNum, sCurItem));
                }
                iPos = sCurLine.indexOf("-");
                sCurItem = sText = String.valueOf(sCurLine.substring(iPos + 1, sCurLine.length()).trim()) + " ";
                sCurItemNum = "";
                ++iNumItems;
                iType = 2;
                iMaxType = 2;
            } else if (iType == 0) {
                sCurItem = String.valueOf(sCurItem) + this.SysNewLine + sCurLine;
            } else if (sCurLine.equals("")) {
                if (!sCurItem.equals("")) {
                    vItems.add(new AutoDocListItem(iType, sCurItemNum, sCurItem));
                }
                sCurItem = "";
                iType = 0;
            } else {
                sCurItem = String.valueOf(sCurItem) + this.SysNewLine + sCurLine;
            }
            ++i;
        }
        if (!sCurItem.equals("")) {
            vItems.add(new AutoDocListItem(iType, sCurItemNum, sCurItem));
        }
        return vItems;
    }

    public String processParam(String s, boolean bDetails, boolean bPreFormatted) {
        String sResult = s;
        if (!bPreFormatted) {
            if (bDetails) {
                ArrayList vItems = this.extractItemList(s);
                if (this.isItemList(vItems)) {
                    s = this.convertItemList(vItems);
                }
                if (s.indexOf("\n") >= 0) {
                    sResult = this.convertParagraphs(s);
                }
            } else if (s.indexOf("\n") >= 0) {
                String[] saTmp = s.split("\\n[ \\t\\x0B\\f]*\\n");
                sResult = AutoDocStringUtils.replaceAll(saTmp[0], this.SysNewLine, "\n");
                if (!this.SysNewLine.equals("\n")) {
                    sResult = AutoDocStringUtils.replaceAll(sResult, "\n", this.SysNewLine);
                }
            }
        } else {
            sResult = this.convertCode(s, true);
        }
        return sResult.trim();
    }

    public Tree buildGroupTree(ArrayList vGroupInfo, AutoDocGroupingDefinition groupDef) {
        Tree groupTree;
        String sMsgID = groupDef.getMsgID();
        String sSplitChar = groupDef.getSplitChar();
        String sLabel = this.mySettings.getMsgHandler().getTexts().getMessageText(sMsgID);
        if (sLabel.equals("")) {
            sLabel = sMsgID;
        }
        if (sSplitChar.equals(".")) {
            sSplitChar = "\\" + sSplitChar;
        }
        String sSplitEx = "\\s*" + sSplitChar + "\\s*";
        Tree curNode = groupTree = new Tree(new AutoDocGroupInfo(sLabel));
        int i = 0;
        while (i < vGroupInfo.size()) {
            AutoDocGroupInfo curGroupInfo = (AutoDocGroupInfo)vGroupInfo.get(i);
            String sCurGroup = curGroupInfo.Group;
            String[] saGrps = null;
            saGrps = sSplitEx.equals("") ? new String[]{sCurGroup} : sCurGroup.split(sSplitEx);
            int j = 0;
            while (j < saGrps.length) {
                ArrayList curChilds = (ArrayList)curNode.getChildren();
                int iPos = -1;
                int k = 0;
                while (k < curChilds.size()) {
                    Tree tChild = (Tree)curChilds.get(k);
                    String sChildGroup = ((AutoDocGroupInfo)tChild.getData()).Group;
                    if (sChildGroup.equals(saGrps[j])) {
                        iPos = k;
                        break;
                    }
                    ++k;
                }
                if (iPos < 0) {
                    AutoDocGroupInfo newGroupInfo = new AutoDocGroupInfo(saGrps[j]);
                    curNode.addChild(new Tree(newGroupInfo));
                    curNode = curNode.getLastChild();
                } else {
                    curNode = (Tree)curNode.getChildren().get(iPos);
                }
                ++j;
            }
            if (saGrps.length > 0) {
                AutoDocGroupInfo extGroupInfo = (AutoDocGroupInfo)curNode.getData();
                extGroupInfo.vIndexInfo.addAll(curGroupInfo.vIndexInfo);
            }
            curNode = groupTree;
            ++i;
        }
        return groupTree;
    }

    public Tree getAllofGroup(AutoDocGroupingDefinition defGroup, int iIndex) {
        ArrayList<AutoDocGroupInfo> vList = new ArrayList<AutoDocGroupInfo>();
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            ArrayList vValues = curInfo.getGrouping(iIndex);
            int j = 0;
            while (j < vValues.size()) {
                String sCurGrp = (String)vValues.get(j);
                if (!sCurGrp.equals("")) {
                    AutoDocGroupInfo newGroupInfo = new AutoDocGroupInfo(sCurGrp);
                    newGroupInfo.add(curInfo);
                    int iPos = vList.indexOf(newGroupInfo);
                    if (iPos < 0) {
                        vList.add(newGroupInfo);
                    } else {
                        AutoDocGroupInfo curGroupInfo = (AutoDocGroupInfo)vList.get(iPos);
                        curGroupInfo.add(curInfo);
                    }
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(vList);
        Tree tReturn = this.buildGroupTree(vList, defGroup);
        return tReturn;
    }

    public ArrayList generateIncludeTreeList() {
        ArrayList<Tree> incTreeList = new ArrayList<Tree>();
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            AutoDocInclude rootInclude = new AutoDocInclude(curInfo.OrgAbsFilename, curInfo.OrgAbsFilename, curInfo.Description, curInfo.Filename);
            Tree curTree = new Tree(rootInclude);
            int j = 0;
            while (j < curInfo.vIncludes.size()) {
                AutoDocInclude curInclude = (AutoDocInclude)curInfo.vIncludes.get(j);
                AutoDocIndexInfo curIdxEntr = this.findIndexEntry(curInclude.sAbsFilename);
                if (curIdxEntr != null) {
                    curInclude.sOutFilename = curIdxEntr.Filename;
                    if (curInclude.sDescription.equals("")) {
                        curInclude.sDescription = curIdxEntr.Description;
                    }
                }
                Tree curNode = new Tree(curInclude);
                ArrayList vHist = new ArrayList();
                String sNormCurFile = curInfo.OrgAbsFilename.replaceAll("\\\\", "/");
                this.buildIncludeTreeFromEntry(curNode, sNormCurFile, vHist);
                curTree.addChild(curNode);
                ++j;
            }
            incTreeList.add(curTree);
            ++i;
        }
        return incTreeList;
    }

    public void buildIncludeTreeFromEntry(Tree curNode, String sCurParent, ArrayList vHist) {
        AutoDocInclude curInc = (AutoDocInclude)curNode.getData();
        ArrayList<String> vIncHist = new ArrayList<String>(vHist);
        vIncHist.add(sCurParent);
        AutoDocIndexInfo curInfo = this.findIncludeFile(sCurParent, curInc.sIncludeStr);
        if (curInfo != null) {
            String sNormCurFile = curInfo.OrgAbsFilename.replaceAll("\\\\", "/");
            int j = 0;
            while (j < curInfo.vIncludes.size()) {
                AutoDocInclude curInclude = (AutoDocInclude)curInfo.vIncludes.get(j);
                Tree newNode = new Tree(curInclude);
                int iHistFound = vIncHist.indexOf(curInclude.sAbsFilename);
                if (iHistFound < 0) {
                    this.buildIncludeTreeFromEntry(newNode, sNormCurFile, vIncHist);
                } else {
                    String sCInclude = curInclude.sIncludeStr;
                    String sCIncludeFile = sCurParent;
                    String[] saMsgPara = new String[]{sCInclude, sCIncludeFile};
                    this.mySettings.getMsgHandler().outputWarning("WARN_OUTCIRCINCLUDE", saMsgPara);
                }
                if (!sNormCurFile.equals(sCurParent)) {
                    curNode.addChild(newNode);
                }
                ++j;
            }
        }
    }

    public void addFileToIndex(AutoDocFile curFile, String sOutFil, int iOrgIndex) {
        String sFilename = curFile.getFilename();
        File fOrgFile = new File(sFilename);
        String sOrgFile = fOrgFile.getName();
        String sFileType = "";
        String sFileDescription = "";
        int iSortIndex = 0;
        boolean bFirstLevel1 = true;
        ArrayList treeList = curFile.getTagTreeList();
        int iTreeListSize = treeList.size();
        int i = 0;
        while (i < iTreeListSize) {
            int curLevel;
            Tree curTree = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curTree.getData();
            if (curTag != null && (curLevel = curTag.getLevel()) == 1 && bFirstLevel1) {
                iSortIndex = curTag.getSortIndex();
                AutoDocTagParameterList curParms = curTag.getParameters();
                int iCurParmsSize = curParms.size();
                sFileType = curTag.getLabel();
                if (iCurParmsSize >= 1) {
                    sFileDescription = this.processParam(curParms.get(0).toString(), false, false).trim();
                }
                bFirstLevel1 = false;
            }
            ++i;
        }
        if (sFileDescription.equals("")) {
            sFileDescription = "-";
        }
        if (sFileType.equals("")) {
            sFileType = "File";
        }
        AutoDocIndexInfo curInfo = new AutoDocIndexInfo(sOutFil, sFileType, sOrgFile, curFile.getAbsoluteFilename(), sFileDescription, iSortIndex, iOrgIndex);
        this.IndexEntries.add(curInfo);
    }

    protected void addBibEntry(AutoDocFile curFile, AutoDocTag curTag, ArrayList vBibentries) {
        String sCurFilename = curFile.getAbsoluteFilename();
        AutoDocBibEntry curBib = new AutoDocBibEntry(curFile, curTag);
        int iFound = this.findBibRef(curBib.getKey(), vBibentries);
        if (iFound < 0) {
            vBibentries.add(curBib);
        } else {
            AutoDocBibEntry foundEntry = (AutoDocBibEntry)vBibentries.get(iFound);
            String sFoundValue = foundEntry.getEntry().trim();
            String sFoundFilename = foundEntry.getFilename();
            if (!curBib.getEntry().equals(sFoundValue)) {
                String[] saMsg = new String[]{curBib.getKey(), sCurFilename, sFoundFilename};
                this.mySettings.getMsgHandler().outputWarning("WARN_REFERENCE_DUPLICATE", saMsg);
            }
        }
    }

    public ArrayList preprocessBibEntries(AutoDocFile curFile, String sOutFil) {
        ArrayList vCurBibEntries = new ArrayList();
        ArrayList treeList = curFile.getTagTreeList();
        int iTreeListSize = treeList.size();
        int i = 0;
        while (i < iTreeListSize) {
            List curChilds;
            Tree curTree = (Tree)treeList.get(i);
            if (curTree != null && (curChilds = curTree.getChildren()) != null) {
                int iNumChilds = curChilds.size();
                int j = 0;
                while (j < iNumChilds) {
                    AutoDocTagParameterList curParms;
                    AutoDocTagListElement curTagInfo;
                    Tree curChild = (Tree)curChilds.get(j);
                    AutoDocTag curTag = (AutoDocTag)curChild.getData();
                    if (curTag != null && (curTagInfo = curTag.getTagInfo()).isBibentry() && (curParms = this.getParameters(curTag, curFile, sOutFil)).size() > 1) {
                        this.addBibEntry(curFile, curTag, vCurBibEntries);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return vCurBibEntries;
    }

    public int[] preprocessFile(AutoDocFile curFile, String sOutFil, int iFilenum) {
        int[] iaNumLevel = new int[3];
        ArrayList treeList = curFile.getTagTreeList();
        String sFilename = curFile.getFilename();
        String sClass = "";
        File fOrgFile = new File(sFilename);
        String sOrgFile = fOrgFile.getName();
        String sExt = FileUtils.getFileNameExtension(sOrgFile);
        AutoDocFileExtInfo myFilter = new AutoDocFileExtInfo(this.mySettings.getFileFilter(), this.mySettings.getExclude(), this.mySettings.getExtDefaultsList(), this.mySettings.getExtDefParaList());
        String sProgLang = myFilter.getProgLanguage(sExt);
        if (sProgLang.equals("")) {
            sProgLang = "[" + sExt + "]";
        }
        ArrayList<AutoDocInclude> vIncludes = new ArrayList<AutoDocInclude>();
        ArrayList<AutoDocFunctionInfo> vFuncs = new ArrayList<AutoDocFunctionInfo>();
        ArrayList<AutoDocFunctionInfo> vVars = new ArrayList<AutoDocFunctionInfo>();
        ArrayList<AutoDocFunctionInfo> vLibnames = new ArrayList<AutoDocFunctionInfo>();
        ArrayList vGroupDef = this.mySettings.getGroupDef();
        int iGroupDefSize = vGroupDef.size();
        ArrayList vAllGroupings = new ArrayList();
        int g = 0;
        while (g < iGroupDefSize) {
            AutoDocGroupingDefinition groupDef = (AutoDocGroupingDefinition)vGroupDef.get(g);
            ArrayList<String> vCurGroupings = new ArrayList<String>();
            if (groupDef.getName().equalsIgnoreCase("Language")) {
                vCurGroupings.add(sProgLang);
            } else if (groupDef.getProcType().equalsIgnoreCase("Simple")) {
                vCurGroupings.add("");
            }
            vAllGroupings.add(vCurGroupings);
            ++g;
        }
        int iTreeListSize = treeList.size();
        int i = 0;
        while (i < iTreeListSize) {
            Tree curTree = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curTree.getData();
            if (curTag != null) {
                String sVarDef;
                AutoDocFunctionInfo curFuncInfo;
                String sDescription;
                int curLevel = curTag.getLevel();
                if (curLevel == 1) {
                    iaNumLevel[0] = iaNumLevel[0] + 1;
                } else if (curLevel == 2) {
                    iaNumLevel[1] = iaNumLevel[1] + 1;
                } else if (curLevel == 3) {
                    iaNumLevel[2] = iaNumLevel[2] + 1;
                }
                AutoDocTagParameterList curParms = this.getParameters(curTag, curFile, sOutFil);
                int iCurParmsSize = curParms.size();
                if (curTag.getTagInfo().isInclude()) {
                    if (iCurParmsSize > 0) {
                        String sIncludeFilename = curParms.get(0).toString().trim();
                        String sDescription2 = "";
                        if (iCurParmsSize > 1) {
                            sDescription2 = curParms.get(1).toString().trim();
                        }
                        String sAbsname = this.generateAbsoluteIncludeName(curFile.getAbsoluteFilename(), sIncludeFilename);
                        vIncludes.add(new AutoDocInclude(sIncludeFilename, sAbsname, sDescription2, ""));
                    }
                } else if (curTag.getTagInfo().isClassType()) {
                    if (iCurParmsSize > 0) {
                        sClass = curParms.get(0).toString().trim();
                    }
                } else if (curTag.getTagInfo().isFunc()) {
                    if (iCurParmsSize > 0) {
                        sDescription = "";
                        String sFuncDef = curParms.get(0).toString().trim();
                        if (iCurParmsSize > 1) {
                            sDescription = curParms.get(1).toString().trim();
                        }
                        curFuncInfo = new AutoDocFunctionInfo(curTag, sFuncDef, sDescription, sClass, 0);
                        vFuncs.add(curFuncInfo);
                    }
                } else if (curTag.getTagInfo().isVar()) {
                    if (iCurParmsSize > 0) {
                        sDescription = "";
                        sVarDef = curParms.get(0).toString().trim();
                        if (iCurParmsSize > 1) {
                            sDescription = curParms.get(1).toString().trim();
                        }
                        curFuncInfo = new AutoDocFunctionInfo(curTag, sVarDef, sDescription, sClass, 1);
                        vVars.add(curFuncInfo);
                    }
                } else if (curTag.getTagInfo().isLibname()) {
                    sDescription = "";
                    if (iCurParmsSize > 0) {
                        sVarDef = curParms.get(0).toString().trim();
                        if (iCurParmsSize > 1) {
                            sVarDef = String.valueOf(sVarDef) + "=" + curParms.get(1).toString().trim();
                        }
                        if (iCurParmsSize > 2) {
                            sDescription = curParms.get(2).toString().trim();
                        }
                        curFuncInfo = new AutoDocFunctionInfo(curTag, sVarDef, sDescription, sClass, 2);
                        vLibnames.add(curFuncInfo);
                    }
                }
                this.preprocessAllGroupings(curFile, sOutFil, curTag, curTree, vAllGroupings, vGroupDef);
            }
            ++i;
        }
        AutoDocIndexInfo lastIndex = (AutoDocIndexInfo)this.IndexEntries.get(iFilenum);
        lastIndex.vAllGroupings = vAllGroupings;
        lastIndex.vIncludes = vIncludes;
        lastIndex.vFunc = vFuncs;
        lastIndex.vVars = vVars;
        lastIndex.vLibnames = vLibnames;
        return iaNumLevel;
    }

    public void preprocessAllGroupings(AutoDocFile curFile, String sOutFil, AutoDocTag curTag, Tree curTree, ArrayList vAllGroupings, ArrayList vGroupDef) {
        int curLevel = curTag.getLevel();
        ArrayList curChilds = (ArrayList)curTree.getChildren();
        int iCurChildsSize = curChilds.size();
        int j = 0;
        while (j < iCurChildsSize) {
            AutoDocTagListElement curElem;
            Tree curChild = (Tree)curChilds.get(j);
            AutoDocTag curChildTag = (AutoDocTag)curChild.getData();
            if (curChildTag != null && (curElem = curChildTag.getTagInfo()) != null) {
                AutoDocTagParameterList vPara = this.getParameters(curChildTag, curFile, sOutFil);
                if (curElem.isGrouping()) {
                    ArrayList vElemGroupings = curElem.getGroupings();
                    int iNumGroup = vElemGroupings.size();
                    int g = 0;
                    while (g < iNumGroup) {
                        AutoDocGroupingDefinition curElemGroup = (AutoDocGroupingDefinition)vElemGroupings.get(g);
                        int iPos = vGroupDef.indexOf(curElemGroup);
                        if (iPos >= 0) {
                            String sLabel = curElem.getLabel().trim();
                            ArrayList vCurGroups = (ArrayList)vAllGroupings.get(iPos);
                            this.preprocessGrouping(vCurGroups, curElemGroup, curLevel, vPara, sLabel);
                        }
                        ++g;
                    }
                }
                if (curElem.getLevel() == 4) {
                    int iFound = -1;
                    int k = j - 1;
                    while (k >= 0) {
                        AutoDocTagListElement prevElem;
                        Tree prevChild = (Tree)curChilds.get(k);
                        AutoDocTag prevChildTag = (AutoDocTag)prevChild.getData();
                        if (prevChildTag != null && (prevElem = prevChildTag.getTagInfo()) != null && curElem.getName().equals(prevElem.getName())) {
                            iFound = k;
                            break;
                        }
                        --k;
                    }
                    if (iFound >= 0 && iFound < j - 1) {
                        curChilds.remove(j);
                        curChilds.add(iFound + 1, curChild);
                    }
                }
            }
            ++j;
        }
    }

    public void preprocessGrouping(ArrayList vGroups, AutoDocGroupingDefinition groupDef, int curLevel, AutoDocTagParameterList vPara, String sLabel) {
        if (vPara.size() > 0 && (groupDef.getLevelRestriction() == 0 || groupDef.getLevelRestriction() == curLevel)) {
            String sGroup = vPara.get(0).toString().trim();
            if (groupDef.getProcType().equalsIgnoreCase("Group")) {
                if (groupDef.getCleanWordDelim()) {
                    sGroup = this.removeGrpWordDelim(sGroup);
                }
                if (vGroups.indexOf(sGroup) < 0) {
                    vGroups.add(sGroup);
                }
            } else if (groupDef.getProcType().equalsIgnoreCase("Simple")) {
                if (groupDef.getCleanWordDelim()) {
                    sGroup = this.removeGrpWordDelim(sGroup);
                }
                if (vGroups.size() == 0) {
                    vGroups.add(sGroup);
                } else if (((String)vGroups.get(0)).equals("")) {
                    vGroups.set(0, sGroup);
                }
            } else {
                String sMainGrp = sLabel.trim();
                String sSplitChar = groupDef.getSplitChar();
                if (groupDef.getCleanWordDelim()) {
                    sGroup = this.removeGrpWordDelim(sGroup);
                }
                if (vGroups.indexOf(sGroup = String.valueOf(sMainGrp) + sSplitChar + sGroup) < 0) {
                    vGroups.add(sGroup);
                }
            }
        }
    }

    public String removeGrpWordDelim(String s) {
        int iLast;
        char cLast;
        String sReturn = s;
        int iNameLen = s.length();
        if (iNameLen > 1 && ((cLast = s.charAt(iNameLen - 1)) == '.' || cLast == ';' || cLast == '!' || cLast == '?') && (iLast = s.indexOf(cLast)) == iNameLen - 1) {
            sReturn = s.substring(0, iNameLen - 1);
        }
        String[] saTmp = sReturn.split("[,;\\r\\n]");
        sReturn = saTmp[0].trim();
        return sReturn;
    }

    public void processIndexListFileTree(PrintStream psOut) {
        String sHeading = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILES");
        this.processGroupingTreeBegin(psOut, this.getIDOfIndexList(-1), 0);
        this.processGroupingTreeItemBegin(psOut, 0);
        this.processGroupingTreeEntry(psOut, sHeading, true);
        this.processGroupingTreeBegin(psOut, this.getIDOfIndexList(-1), 2);
        String sLastType = "";
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            if (!curInfo.FileType.equals(sLastType)) {
                if (!sLastType.equals("")) {
                    this.processGroupingTreeEnd(psOut, 5);
                    this.processGroupingTreeItemEnd(psOut, 2);
                }
                this.processGroupingTreeItemBegin(psOut, 2);
                this.processGroupingTreeEntry(psOut, curInfo.FileType, true);
                this.processGroupingTreeBegin(psOut, this.getIDOfIndexList(-1), 5);
            }
            this.processGroupingTreeItemBegin(psOut, 4);
            String sLink = this.convertLinkToStringNavigation(this.createXRefLabel(curInfo.Filename, ""), curInfo.OrgFilename, false);
            this.processGroupingTreeEntry(psOut, sLink, false);
            this.processGroupingTreeItemEnd(psOut, -1);
            sLastType = curInfo.FileType;
            ++i;
        }
        if (!sLastType.equals("")) {
            this.processGroupingTreeEnd(psOut, 5);
            this.processGroupingTreeItemEnd(psOut, 2);
        }
        this.processGroupingTreeEnd(psOut, 2);
        this.processGroupingTreeItemEnd(psOut, 0);
        this.processGroupingTreeEnd(psOut, 0);
    }

    public void processIndexGroupNode(PrintStream psOut, Tree curNode) {
        int iOffset = curNode.getNestingDepth() + 2;
        if (!curNode.isNodeEmpty()) {
            AutoDocGroupInfo curGroupInfo = (AutoDocGroupInfo)curNode.getData();
            this.processGroupingTreeItemBegin(psOut, iOffset - 1);
            this.processGroupingTreeEntry(psOut, curGroupInfo.Group, true);
            this.processGroupingTreeBegin(psOut, "Group", iOffset + 1);
            ArrayList vEntries = curGroupInfo.vIndexInfo;
            int i = 0;
            while (i < vEntries.size()) {
                AutoDocIndexInfo curInfo = (AutoDocIndexInfo)vEntries.get(i);
                this.processGroupingTreeItemBegin(psOut, iOffset);
                String sLink = this.convertLinkToStringNavigation(this.createXRefLabel(curInfo.Filename, ""), curInfo.OrgFilename, false);
                this.processGroupingTreeEntry(psOut, sLink, false);
                this.processGroupingTreeItemEnd(psOut, -1);
                ++i;
            }
        }
        ArrayList curChilds = (ArrayList)curNode.getChildren();
        int i = 0;
        while (i < curChilds.size()) {
            this.processIndexGroupNode(psOut, (Tree)curChilds.get(i));
            ++i;
        }
        this.processGroupingTreeEnd(psOut, iOffset + 1);
        this.processGroupingTreeItemEnd(psOut, iOffset - 1);
    }

    public void processIndexListGroupTree(PrintStream psOut, int iType, Tree groupTree) {
        String sID = this.getIDOfIndexList(iType);
        String sHeading = ((AutoDocGroupInfo)groupTree.getData()).Group;
        this.processGroupingTreeBegin(psOut, sID, 0);
        this.processGroupingTreeItemBegin(psOut, 0);
        this.processGroupingTreeEntry(psOut, sHeading, true);
        this.processGroupingTreeBegin(psOut, this.getIDOfIndexList(-1), 2);
        int iNode = 0;
        while (iNode < groupTree.numChildren()) {
            Tree curNode = (Tree)groupTree.getChildren().get(iNode);
            this.processIndexGroupNode(psOut, curNode);
            ++iNode;
        }
        this.processGroupingTreeEnd(psOut, 2);
        this.processGroupingTreeItemEnd(psOut, 0);
        this.processGroupingTreeEnd(psOut, 0);
    }

    public void processIndexListTreeContent(PrintStream psOut) {
        this.processIndexListFileTree(psOut);
        ArrayList vGroupDefs = this.mySettings.getGroupDef();
        int iGroupdefSize = vGroupDefs.size();
        int iGroupingSize = this.vGroupings.size();
        int i = 0;
        while (i < iGroupdefSize) {
            Tree curTree;
            if (i < iGroupingSize && (curTree = (Tree)this.vGroupings.get(i)).numChildren() > 0) {
                this.processIndexListGroupTree(psOut, i, curTree);
            }
            ++i;
        }
    }

    public String getIDOfIndexList(int iIndex) {
        int iNewIndex = iIndex + 2;
        String sID = "";
        sID = "IndexTree" + iNewIndex;
        return sID;
    }

    public ArrayList createAndSortFuncVarIndex() {
        ArrayList<AutoDocFuncSortElement> vSortArray = new ArrayList<AutoDocFuncSortElement>();
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocFuncSortElement curSort;
            AutoDocFunctionInfo curFunc;
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            AutoDocFile curFile = this.findProcFileByAbsName(curInfo.OrgAbsFilename);
            int j = 0;
            while (j < curInfo.vFunc.size()) {
                curFunc = (AutoDocFunctionInfo)curInfo.vFunc.get(j);
                curSort = new AutoDocFuncSortElement(curFunc, curFile, true);
                vSortArray.add(curSort);
                ++j;
            }
            j = 0;
            while (j < curInfo.vVars.size()) {
                curFunc = (AutoDocFunctionInfo)curInfo.vVars.get(j);
                curSort = new AutoDocFuncSortElement(curFunc, curFile, true);
                vSortArray.add(curSort);
                ++j;
            }
            ++i;
        }
        Collections.sort(vSortArray);
        ArrayList<AutoDocFuncIndexElement> vResult = new ArrayList<AutoDocFuncIndexElement>();
        int i2 = 0;
        while (i2 < vSortArray.size()) {
            AutoDocFuncSortElement curSort = (AutoDocFuncSortElement)vSortArray.get(i2);
            AutoDocIndexInfo curInfo = this.findIndexEntry(curSort.getFileInfo().getAbsoluteFilename());
            String sFuncText = curSort.getFuncInfo().getSignature();
            String sOutFile = curInfo.Filename;
            sOutFile = this.createXRefLabel(sOutFile, sFuncText);
            AutoDocFuncIndexElement curElem = new AutoDocFuncIndexElement(sOutFile, sFuncText);
            vResult.add(curElem);
            ++i2;
        }
        return vResult;
    }

    public void outputOverView(PrintStream psOut) {
        this.processOverviewHeading(psOut);
        int i = 0;
        while (i < this.IndexEntries.size()) {
            AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sLink = this.convertLinkToStringInternal(this.createXRefLabel(curInfo.Filename, ""), String.valueOf(curInfo.FileType) + ": " + curInfo.OrgFilename, false);
            String sDescription = curInfo.Description;
            this.processOverviewEntry(psOut, sLink, sDescription);
            ++i;
        }
        this.processOverviewEnd(psOut);
    }

    public String createXRefLabel(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(sOutfile) + "#" + sMarker;
        }
        return sOutfile;
    }

    public String createXRefLabelLocal(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return "#" + sMarker;
        }
        return "";
    }

    public String createXRefAnchor(String sOutfile, String sMarker) {
        return sMarker;
    }

    public String createFilenameXRef(AutoDocFile curFile) {
        String sOrgFilename = curFile.getLevel1TagFilename();
        String sXrefTagName = sOrgFilename.replaceAll("\\s+", "_");
        return sXrefTagName;
    }

    public void processAllBibEntries(PrintStream psOut, String sBibHead, String sOutFile) {
        this.processBibHeading(psOut, sBibHead);
        this.processBibBegin(psOut);
        int iNumEntries = this.bibrefList.size();
        int i = 0;
        while (i < iNumEntries) {
            AutoDocBibEntry curEntry = (AutoDocBibEntry)this.bibrefList.get(i);
            String sKey = curEntry.getKey();
            String sEntry = this.resolveBibEntry(curEntry, sOutFile);
            int iEntryIndex = i + 1;
            this.processBibEntry(psOut, iEntryIndex, sKey, sEntry);
            ++i;
        }
        this.processBibEnd(psOut);
        this.processEmptyParagraph(psOut);
    }

    public String resolveBibEntry(AutoDocBibEntry bibEntry, String sOutFile) {
        String sReturn = "";
        AutoDocTagParameterList para = this.getParameters(bibEntry.getTag(), bibEntry.getFile(), sOutFile);
        if (para.size() >= 2) {
            sReturn = para.get(1).getParamString().trim();
        }
        return sReturn;
    }

    public void processAllVarEntries(PrintStream psOut, String sOutFile) {
        int iNumEntries = this.varFuncList.size();
        boolean bAny = false;
        int i = 0;
        while (i < iNumEntries) {
            AutoDocFuncSortElement curEntry = (AutoDocFuncSortElement)this.varFuncList.get(i);
            AutoDocFunctionInfo curInfo = curEntry.getFuncInfo();
            if (curInfo.iType == 1) {
                bAny = true;
                break;
            }
            ++i;
        }
        if (bAny) {
            String sNewHead = this.createVarIndexTableHeader();
            psOut.print(sNewHead);
            int i2 = 0;
            while (i2 < iNumEntries) {
                AutoDocFuncSortElement curEntry = (AutoDocFuncSortElement)this.varFuncList.get(i2);
                AutoDocFunctionInfo curInfo = curEntry.getFuncInfo();
                if (curInfo.iType == 1) {
                    AutoDocFile curFile = curEntry.getFileInfo();
                    AutoDocIndexInfo curInxInfo = this.findIndexEntry(curFile.getAbsoluteFilename());
                    String sInFileName = curInxInfo.OrgFilename;
                    String sOutFileName = curInxInfo.Filename;
                    String sFuncDef = curInfo.sFuncDef;
                    String sDecritpion = this.processParam(curInfo.sDescription, false, false);
                    AutoDocTag curTag = curInfo.getCurTag();
                    String sType = curTag.getLabel();
                    String sLinkLabel = this.generateSectionLinkLabel(sOutFileName, "sec3");
                    this.processSimpleRowBegin(psOut);
                    this.processRefTableCell(psOut, sOutFileName, sLinkLabel, sFuncDef, 4, 0);
                    this.processSimpleTableCell(psOut, sType, 4, 1);
                    this.processSimpleTableCell(psOut, this.processParam(sDecritpion, false, false), 4, 2);
                    this.processSimpleTableCell(psOut, sInFileName, 4, 3);
                    this.processSimpleRowEnd(psOut);
                }
                ++i2;
            }
            this.processSummaryTableEnd(psOut);
            this.processEmptyParagraph(psOut);
        }
    }

    public void processAllFuncEntries(PrintStream psOut, String sOutFile) {
        int iNumEntries = this.varFuncList.size();
        boolean bAny = false;
        int i = 0;
        while (i < iNumEntries) {
            AutoDocFuncSortElement curEntry = (AutoDocFuncSortElement)this.varFuncList.get(i);
            AutoDocFunctionInfo curInfo = curEntry.getFuncInfo();
            if (curInfo.iType == 0) {
                bAny = true;
                break;
            }
            ++i;
        }
        if (bAny) {
            String sHead = this.createFuncIndexTableHeader();
            psOut.print(sHead);
            int i2 = 0;
            while (i2 < iNumEntries) {
                AutoDocFuncSortElement curEntry = (AutoDocFuncSortElement)this.varFuncList.get(i2);
                AutoDocFunctionInfo curInfo = curEntry.getFuncInfo();
                if (curInfo.iType == 0) {
                    AutoDocFile curFile = curEntry.getFileInfo();
                    AutoDocIndexInfo curInxInfo = this.findIndexEntry(curFile.getAbsoluteFilename());
                    String sInFileName = curInxInfo.OrgFilename;
                    String sOutFileName = curInxInfo.Filename;
                    String sFuncDef = curInfo.sFuncDef;
                    String sDecritpion = this.processParam(curInfo.sDescription, false, false);
                    AutoDocTag curTag = curInfo.getCurTag();
                    String sType = curTag.getLabel();
                    String sFuncSig = curInfo.getSignature();
                    String sLinkLabel = sFuncSig.replaceAll("\\s+", "_");
                    this.processSimpleRowBegin(psOut);
                    this.processRefTableCell(psOut, sOutFileName, sLinkLabel, sFuncDef, 4, 0);
                    this.processSimpleTableCell(psOut, sType, 4, 1);
                    this.processSimpleTableCell(psOut, this.processParam(sDecritpion, false, false), 4, 2);
                    this.processSimpleTableCell(psOut, sInFileName, 4, 3);
                    this.processSimpleRowEnd(psOut);
                }
                ++i2;
            }
            this.processSummaryTableEnd(psOut);
            this.processEmptyParagraph(psOut);
        }
    }

    public String processInlineTag(AutoDocTag curTag, AutoDocFile curFile, String sOutFil) {
        String sReturn = "";
        AutoDocTagListElement curElem = curTag.getTagInfo();
        if (curElem != null && curElem.isExtLink()) {
            sReturn = this.processExtLink(curTag);
        } else if (curElem != null && curElem.isLink()) {
            sReturn = this.processInternalLink(curTag, curFile, sOutFil);
        } else if (curElem != null && curElem.isCode()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertCode(sContent, false);
        } else if (curElem != null && curElem.isSingleQuote()) {
            sReturn = this.convertSingleQuote();
        } else if (curElem != null && curElem.isDoubleQuote()) {
            sReturn = this.convertDoubleQuote();
        } else if (curElem != null && curElem.isBold()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertBold(sContent.trim());
            if (curElem.isItalic()) {
                sReturn = this.convertItalic(sReturn);
            }
            if (curElem.isTypeWriter()) {
                sReturn = this.convertTrueType(sReturn);
            }
            if (curElem.isStrike()) {
                sReturn = this.convertStrikeThrough(sReturn);
            }
            if (curElem.isUnderline()) {
                sReturn = this.convertUnderline(sReturn);
            }
        } else if (curElem != null && curElem.isItalic()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertItalic(sContent.trim());
            if (curElem.isBold()) {
                sReturn = this.convertBold(sReturn);
            }
            if (curElem.isTypeWriter()) {
                sReturn = this.convertTrueType(sReturn);
            }
            if (curElem.isStrike()) {
                sReturn = this.convertStrikeThrough(sReturn);
            }
            if (curElem.isUnderline()) {
                sReturn = this.convertUnderline(sReturn);
            }
        } else if (curElem != null && curElem.isTypeWriter()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertTrueType(sContent.trim());
            if (curElem.isBold()) {
                sReturn = this.convertBold(sReturn);
            }
            if (curElem.isItalic()) {
                sReturn = this.convertItalic(sReturn);
            }
            if (curElem.isStrike()) {
                sReturn = this.convertStrikeThrough(sReturn);
            }
            if (curElem.isUnderline()) {
                sReturn = this.convertUnderline(sReturn);
            }
        } else if (curElem != null && curElem.isEmphasized()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertEmphasized(sContent.trim());
            if (curElem.isStrike()) {
                sReturn = this.convertStrikeThrough(sReturn);
            }
            if (curElem.isUnderline()) {
                sReturn = this.convertUnderline(sReturn);
            }
        } else if (curElem != null && curElem.isStrike()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertStrikeThrough(sContent.trim());
        } else if (curElem != null && curElem.isUnderline()) {
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString();
            }
            sReturn = this.convertUnderline(sContent.trim());
        } else if (curElem != null && curElem.isNewLine()) {
            sReturn = this.convertNewLine();
        } else if (curElem != null && curElem.isImage()) {
            sReturn = this.processImage(curTag, curFile);
        } else if (curElem != null && curElem.isCite()) {
            AutoDocIndexInfo found;
            String sDefault;
            int iLen;
            String sContent = "";
            AutoDocTagParameterList vPara = curTag.getParameters();
            if (vPara.size() > 0) {
                sContent = vPara.get(0).toString().trim();
            }
            if ((iLen = sContent.length()) > 1 && sContent.charAt(0) == '\"' && sContent.charAt(iLen - 1) == '\"') {
                sContent = sContent.substring(1, iLen - 1);
            }
            if ((sReturn = this.convertCitation(sContent, this.bibrefList, this.sRefFileName, true)).equals(sDefault = this.convertCitation(sContent, null, this.sRefFileName, true)) && (found = this.findIndexEntry(curFile.getAbsoluteFilename())) != null) {
                sReturn = this.convertCitation(sContent.trim(), found.vBibentries, sOutFil, false);
            }
        }
        return sReturn;
    }

    public String processExtLink(AutoDocTag curTag) {
        String sReturn = "";
        AutoDocTagParameterList vPara = curTag.getParameters();
        String sLink = "";
        int iParaSize = vPara.size();
        if (iParaSize > 0) {
            sLink = vPara.get(0).toString();
        }
        String sDescription = sLink;
        if (iParaSize > 1) {
            sDescription = vPara.get(1).toString().trim();
        }
        if (!sLink.equals("")) {
            sReturn = this.convertLinkToStringExternal(sLink, sDescription, true);
        }
        return sReturn;
    }

    public String processInternalLink(AutoDocTag curTag, AutoDocFile curFile, String sOutFil) {
        String sReturn = "";
        AutoDocTagParameterList vPara = curTag.getParameters();
        String sXref = "";
        if (vPara.size() > 0) {
            sXref = vPara.get(0).toString().trim();
        }
        String sMarker = "";
        String[] saComp = sXref.split("#");
        String sOrgFileName = curFile.getLevel1TagFilename();
        if (saComp.length > 0) {
            String sFile = saComp[0].trim();
            if (saComp.length == 1 && !sXref.endsWith("#")) {
                sFile = sOrgFileName;
                sMarker = saComp[0].trim();
            } else {
                if (saComp.length > 1) {
                    sMarker = saComp[1].trim();
                }
                int i = 0;
                while (i < this.IndexEntries.size()) {
                    AutoDocIndexInfo curInfo = (AutoDocIndexInfo)this.IndexEntries.get(i);
                    String sLev1Tag = curInfo.OrgFilename;
                    if (sFile.equals(sLev1Tag)) {
                        sOutFil = curInfo.Filename;
                        break;
                    }
                    ++i;
                }
            }
        }
        AutoDocFunctionInfo ci = AutoDocFunctionInfo.constructFromCallString(sMarker);
        sMarker = ci.getSignature();
        String sLink = "";
        sLink = !sMarker.equals("") ? this.createXRefLabel(sOutFil, sMarker) : sOutFil;
        String sDescription = sXref;
        if (vPara.size() > 1) {
            sDescription = vPara.get(1).toString().trim();
        }
        if (!sLink.equals("")) {
            sReturn = this.convertLinkToStringInternal(sLink, sDescription, false);
        }
        return sReturn;
    }

    public String processImage(AutoDocTag curTag, AutoDocFile curFile) {
        String sReturn = "";
        String sAbsFileName = curFile.getAbsoluteFilename();
        File f = new File(sAbsFileName);
        String sDir = f.getParent();
        AutoDocTagParameterList vPara = curTag.getParameters();
        int iParaSize = vPara.size();
        String sOrgPara = "";
        if (iParaSize > 0) {
            sOrgPara = vPara.get(0).toString();
        }
        String sImgFile = sOrgPara.trim();
        String sOrientation = "block";
        if (iParaSize > 1) {
            sOrientation = vPara.get(1).toString();
        }
        String sSourceFile = FileUtils.convertRelativetoAbsolutePath(sDir, sImgFile);
        File fOutFile = new File(sSourceFile);
        String sImgFileName = fOutFile.getName();
        String sImgOutPath = String.valueOf(this.Outpath) + "/images";
        File fOutDir = new File(sImgOutPath);
        if (!fOutDir.exists()) {
            fOutDir.mkdir();
        }
        try {
            FileUtils.copy(sSourceFile, String.valueOf(sImgOutPath) + "/" + sImgFileName);
        }
        catch (IOException e) {
            String[] saMsg = new String[]{sSourceFile, sImgOutPath};
            this.mySettings.getMsgHandler().outputError("ERR_OUTCOPYFILE", saMsg);
        }
        sReturn = this.convertImage("images/" + sImgFileName, sOrientation);
        return sReturn;
    }

    public int processSubTags(PrintStream psOut, AutoDocFile curFile, int iLevel, String sPreFmt, int iCurIdx, Tree curNode, String sOutfile) {
        String sLastName2 = "";
        boolean bTableOpen = false;
        if (curNode == null) {
            return iCurIdx;
        }
        ArrayList curChilds = (ArrayList)curNode.getChildren();
        int iNumChilds = curChilds.size();
        int j = 0;
        while (j < iNumChilds) {
            Tree curNode2 = (Tree)curChilds.get(j);
            AutoDocTag curTag2 = (AutoDocTag)curNode2.getData();
            if (curTag2 != null) {
                boolean bSupressOutput;
                AutoDocTagListElement curElem2 = curTag2.getTagInfo();
                AutoDocTagParameterList curParms2 = this.getParameters(curTag2, curFile, sOutfile);
                String curName2 = curTag2.getName();
                String curLabel2 = curTag2.getLabel();
                boolean bl = bSupressOutput = curElem2 == null;
                if (curElem2.isComment()) {
                    bSupressOutput = true;
                }
                if (curElem2.isEndSrcQuote()) {
                    bSupressOutput = true;
                }
                if (curElem2 != null && curElem2.isBibentry() && curElem2.isGlobal()) {
                    AutoDocTagParameter par1 = curParms2.get(0);
                    String sKey = par1.getParamString();
                    String sLabel = this.convertReferenceTag(sKey, this.bibrefList, this.sRefFileName, true);
                    par1.setParamString(sLabel);
                    bSupressOutput = true;
                }
                if (!bSupressOutput) {
                    String sDir;
                    File fDir;
                    int iNumPara2 = curParms2.size();
                    if (curElem2.isUserSection()) {
                        curLabel2 = curName2 = curParms2.get(0).getParamString();
                        curParms2.remove(0);
                        iNumPara2 = curParms2.size();
                    }
                    if (curElem2.isDirectory() && iNumPara2 > 1) {
                        String sDir_Org;
                        String sDir2 = sDir_Org = curParms2.get(1).getParamString();
                        File fDir2 = new File(sDir2);
                        if (!FileUtils.isAbsolutePath(sDir2)) {
                            File fCur = new File(curFile.getAbsoluteFilename());
                            String sBase = fCur.getParent();
                            if (sBase == null) {
                                sBase = "";
                            }
                            fDir2 = new File(FileUtils.convertRelativetoAbsolutePath(sBase, sDir2));
                            sDir2 = FileUtils.toCanonicalPath(fDir2);
                        }
                        if (fDir2.exists()) {
                            sDir2 = this.convertLinkToStringExternal(sDir2, sDir_Org, true);
                            curParms2.get(1).setParamString(sDir2);
                        }
                    }
                    if (curElem2.isLibname() && iNumPara2 > 1 && (fDir = new File(sDir = curParms2.get(1).getParamString())).exists()) {
                        sDir = this.convertLinkToStringExternal(sDir, sDir, true);
                        curParms2.get(1).setParamString(sDir);
                    }
                    if (curElem2.isBibentry() && iNumPara2 > 1) {
                        String sGlobalRef;
                        AutoDocTagParameter par1 = curParms2.get(0);
                        String sKey = par1.getParamString();
                        String sGlobalLabel = this.convertReferenceTag(sKey, this.bibrefList, this.sRefFileName, true);
                        if (sGlobalLabel.equals(sGlobalRef = this.convertReferenceTag(sKey, null, this.sRefFileName, true))) {
                            AutoDocIndexInfo fInfo = this.findIndexEntry(curFile.getAbsoluteFilename());
                            if (fInfo != null) {
                                String sAnchor = this.generateLinkAnchor(this.createXRefAnchor(sOutfile, sKey));
                                String sLabel = this.convertReferenceTag(sKey, fInfo.vBibentries, "", false);
                                par1.setParamString(String.valueOf(sAnchor) + sLabel);
                            }
                        } else {
                            par1.setParamString(sGlobalLabel);
                        }
                    }
                    if (!curName2.equals(sLastName2)) {
                        if (!sLastName2.equals("")) {
                            if (bTableOpen) {
                                this.processParamTableEnd(psOut);
                            }
                            this.processSubTagEnd(psOut);
                            bTableOpen = false;
                        }
                        this.processSubTagBegin(psOut, curName2);
                        this.processSubTagHeading(psOut, curLabel2);
                        if (iNumPara2 > 1) {
                            this.processParamTableBegin(psOut, iNumPara2);
                            bTableOpen = true;
                        }
                        iCurIdx = 1;
                    }
                    if (bTableOpen) {
                        this.processParamRowBegin(psOut);
                    }
                    if (!sPreFmt.equals("")) {
                        String sText = sPreFmt;
                        if (sPreFmt.equals("0")) {
                            sText = String.valueOf(iCurIdx) + ".";
                        }
                        if (iNumPara2 > 1) {
                            this.processParamCell(psOut, sText, iNumPara2, -1);
                        } else {
                            this.processParamSimple(psOut, sText);
                        }
                    }
                    int k = 0;
                    while (k < iNumPara2) {
                        String sText = "";
                        sText = curElem2.isBeginSrcQuote() ? this.processParam(curParms2.get(k).toString(), true, true) : this.processParam(curParms2.get(k).toString(), true, false);
                        if (k == 0 && curElem2.isCall()) {
                            sText = this.processCall(curFile, sText);
                        }
                        if (iNumPara2 > 1) {
                            this.processParamCell(psOut, sText, iNumPara2, k);
                        } else {
                            this.processParamSimple(psOut, sText);
                        }
                        ++k;
                    }
                    if (bTableOpen) {
                        this.processParamRowEnd(psOut);
                    }
                    ++iCurIdx;
                    sLastName2 = curName2;
                }
            }
            ++j;
        }
        if (iNumChilds > 0) {
            if (bTableOpen) {
                this.processParamTableEnd(psOut);
            }
            this.processSubTagEnd(psOut);
            bTableOpen = false;
        }
        return iCurIdx;
    }

    public String processCall(AutoDocFile curFile, String sCall) {
        String sReturn = sCall;
        String sAbsFilename = curFile.getAbsoluteFilename();
        AutoDocIndexInfo curInfo = this.findIndexEntry(sAbsFilename);
        AutoDocIndexInfo foundInfo = this.findFunctionInIndexList(curInfo, sCall);
        if (foundInfo == null) {
            ArrayList<AutoDocIndexInfo> vFoundCandidates = new ArrayList<AutoDocIndexInfo>();
            int i = 0;
            while (i < this.IndexEntries.size()) {
                AutoDocIndexInfo foundNextInfo;
                AutoDocIndexInfo curInfo2 = (AutoDocIndexInfo)this.IndexEntries.get(i);
                if (curInfo2.vFunc != null && curInfo2.vFunc.size() > 0 && !curInfo2.OrgAbsFilename.equals(sAbsFilename) && (foundNextInfo = this.findFunctionInIndexList(curInfo2, sCall)) != null) {
                    vFoundCandidates.add(foundNextInfo);
                }
                ++i;
            }
            foundInfo = this.findMatchingCallCandidate(curInfo, vFoundCandidates);
        }
        if (foundInfo != null) {
            AutoDocFunctionInfo ci = AutoDocFunctionInfo.constructFromCallString(sCall);
            String sMarker = ci.getSignature();
            String sLink = this.createXRefLabel(foundInfo.Filename, sMarker);
            sReturn = this.convertLinkToStringInternal(sLink, sCall, false);
        }
        return sReturn;
    }

    public AutoDocIndexInfo findFunctionInIndexList(AutoDocIndexInfo curInfo, String sCall) {
        AutoDocIndexInfo foundInfo = null;
        ArrayList vFunc = curInfo.vFunc;
        int iNumFunc = vFunc.size();
        int i = 0;
        while (i < iNumFunc) {
            AutoDocFunctionInfo curFuncInfo = (AutoDocFunctionInfo)vFunc.get(i);
            if (curFuncInfo.callMatch(sCall)) {
                foundInfo = curInfo;
                break;
            }
            ++i;
        }
        return foundInfo;
    }

    public AutoDocIndexInfo findMatchingCallCandidate(AutoDocIndexInfo curInfo, ArrayList vFoundCandidates) {
        AutoDocIndexInfo foundInfo = null;
        Tree tCurTree = this.getIncludeTreeFromIndexInfo(curInfo);
        int iMatchScore = 0;
        int i = 0;
        while (i < vFoundCandidates.size()) {
            AutoDocIndexInfo curFoundInfo = (AutoDocIndexInfo)vFoundCandidates.get(i);
            Tree tFoundTree = this.getIncludeTreeFromIndexInfo(curFoundInfo);
            int iCurMatchScore = this.calcCallMatchScore(tCurTree, tFoundTree);
            if (iCurMatchScore > iMatchScore) {
                iMatchScore = iCurMatchScore;
                foundInfo = curFoundInfo;
            }
            ++i;
        }
        return foundInfo;
    }

    public Tree getIncludeTreeFromIndexInfo(AutoDocIndexInfo curInfo) {
        Tree tCurTree = new Tree();
        int iCurFileIdx = this.findIndexEntryIndex(curInfo.OrgAbsFilename);
        if (iCurFileIdx >= 0) {
            tCurTree = (Tree)this.includeTreeList.get(iCurFileIdx);
        }
        return tCurTree;
    }

    public int calcCallMatchScore(Tree tCurTree, Tree tFoundTree) {
        int iCurMatchScore = 1;
        AutoDocInclude curFoundInc = (AutoDocInclude)tFoundTree.getData();
        ArrayList vIncludes = (ArrayList)tCurTree.getChildren();
        int i = 0;
        while (i < vIncludes.size()) {
            Tree curEntry = (Tree)vIncludes.get(i);
            int iNd = curEntry.findDepthOf(curFoundInc);
            if (iNd >= 0) {
                int iCurScore = 1000000000 - iNd;
                if (iCurScore > iCurMatchScore) {
                    iCurMatchScore = iCurScore;
                }
                if (iNd <= 1) break;
            }
            ++i;
        }
        if (iCurMatchScore <= 1) {
            AutoDocInclude curFileInc = (AutoDocInclude)tCurTree.getData();
            ArrayList vFoundIncludes = (ArrayList)tFoundTree.getChildren();
            int i2 = 0;
            while (i2 < vFoundIncludes.size()) {
                Tree curEntry = (Tree)vFoundIncludes.get(i2);
                int iNd = curEntry.findDepthOf(curFileInc);
                if (iNd >= 0) {
                    int iCurScore = 100000 - iNd;
                    if (iCurScore > iCurMatchScore) {
                        iCurMatchScore = iCurScore;
                    }
                    if (iNd <= 1) break;
                }
                ++i2;
            }
        }
        return iCurMatchScore;
    }
}

