/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class AutoDocMessageTexts {
    private HashMap mTexts = new HashMap();
    private String sError = "Error";
    private String sWarning = "Warning";
    private String sNote = "Note";

    public AutoDocMessageTexts() {
        this.initBasic();
    }

    private void initBasic() {
        this.mTexts.put("ERR_ERROR", "Error");
        this.mTexts.put("ERR_ERRORS", "Errors");
        this.mTexts.put("NOTE_NOTE", "Note");
        this.mTexts.put("NOTE_NOTES", "Notes");
        this.mTexts.put("WARN_WARNING", "Warning");
        this.mTexts.put("WARN_WARNINGS", "Warnings");
        this.mTexts.put("MSG_FINISHED", "Output finished");
        this.mTexts.put("MSG_SUMMARY", "Processing summary");
        this.mTexts.put("NOTE_RESLOAD", "Could not load resource file %1% using default %2% instead");
        this.mTexts.put("ERR_FATAL", "Fatal error encountered. Please contact %1% for support. %2%");
        this.mTexts.put("ERR_SETTINGSNCORR", "Settings not correct. %1%.");
        this.mTexts.put("ERR_INITDICT", "Cannot initialize AutoDoc tag dictionary: %1%.");
        this.mTexts.put("ERR_INITEXTDEF", "Cannot initialize extension defaults.");
        this.mTexts.put("ERR_INITGROUPDEF", "Cannot initialize groupings.");
        this.mTexts.put("ERR_INITUSERGROUPDEF", "Cannot initialize user group definitions.");
        this.mTexts.put("ERR_PARINPUTNOTSET", "Input path parameter not set.");
        this.mTexts.put("ERR_WORKDIRDOESNOTEXIST", "Work directory '%1%' does not exist.");
        this.mTexts.put("MSG_FINISHED", "Output finished");
        this.mTexts.put("WARN_PARAMDEPRECATED", "Parameter %1% is deprecated, please use %2% instead.");
        this.mTexts.put("WARN_PARAMUNKNOWN", "Unknown parameter '%1%'.");
        this.mTexts.put("WARN_CSSDEPRECATED", "Parameter -css is deprecated, use -styledef instead.");
        this.mTexts.put("MSG_AUTODOC_HEADER", "\nDE Autodoc %1% - Automated documentation, (c) 2008-%2% by Daniel Enache\n\n  This program comes with ABSOLUTELY NO WARRANTY.\n  This is free software, and you are welcome to redistribute it under\n  certain conditions. See \"LICENCE_GPL_V_3_0.txt\" for details.\n\n");
    }

    public void initMessages(InputStream isMessages, String sMsgEnc) throws Error {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(isMessages, sMsgEnc));
            String sLine = br.readLine();
            while (sLine != null) {
                sLine = sLine.trim();
                if (sMsgEnc.equals("UTF-8")) {
                    sLine = FileUtils.removeUTF_8_BOM(sLine);
                }
                if (!sLine.equals("") && !sLine.startsWith("//")) {
                    this.parseMessageLine(sLine);
                }
                sLine = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            throw new Error("Cannot load message texts.");
        }
        this.sError = this.getMessageText("ERR_ERROR");
        this.sWarning = this.getMessageText("WARN_WARNING");
        this.sNote = this.getMessageText("NOTE_NOTE");
    }

    protected void parseMessageLine(String sLine) {
        String sTmp = AutoDocStringUtils.replaceAll(sLine, "\\n", "%NL%");
        String[] saEntry = AutoDocStringUtils.splitQuoted(sTmp, ',');
        String sID = "";
        String sLabel = "";
        if (saEntry.length > 0) {
            sID = saEntry[0].trim();
        }
        if (saEntry.length > 1) {
            sLabel = AutoDocStringUtils.replaceAll(saEntry[1].trim(), "%NL%", "\n");
        }
        this.mTexts.put(sID, sLabel);
    }

    public String getMessageText(String sKey) {
        String sReturn = (String)this.mTexts.get(sKey);
        if (sReturn != null) {
            return sReturn;
        }
        return "";
    }

    public String getMessageText(String sKey, String[] saParam) {
        String sResult = this.getMessageText(sKey);
        int i = 0;
        while (i < saParam.length) {
            String sFind = "%" + (i + 1) + "%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, saParam[i]);
            ++i;
        }
        return sResult;
    }

    public String getMessageText(String sKey, String sParam) {
        String sResult = this.getMessageText(sKey);
        if (sParam != null) {
            String sFind = "%1%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, sParam);
        }
        return sResult;
    }

    public String getErrorText(String sKey) {
        String sReturn = (String)this.mTexts.get(sKey);
        if (sReturn != null) {
            return "  " + this.sError + ": " + sReturn;
        }
        return "  " + this.sError + ": ";
    }

    public String getErrorText(String sKey, String sParam) {
        String sResult = this.getErrorText(sKey);
        if (sParam != null) {
            String sFind = "%1%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, sParam);
        }
        return sResult;
    }

    public String getErrorText(String sKey, String[] saParam) {
        String sResult = this.getErrorText(sKey);
        int i = 0;
        while (i < saParam.length) {
            String sFind = "%" + (i + 1) + "%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, saParam[i]);
            ++i;
        }
        return sResult;
    }

    public String getWarnText(String sKey) {
        String sReturn = (String)this.mTexts.get(sKey);
        if (sReturn != null) {
            return "  " + this.sWarning + ": " + sReturn;
        }
        return "  " + this.sWarning + ": ";
    }

    public String getWarnText(String sKey, String sParam) {
        String sResult = this.getWarnText(sKey);
        if (sParam != null) {
            String sFind = "%1%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, sParam);
        }
        return sResult;
    }

    public String getWarnText(String sKey, String[] saParam) {
        String sResult = this.getWarnText(sKey);
        int i = 0;
        while (i < saParam.length) {
            String sFind = "%" + (i + 1) + "%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, saParam[i]);
            ++i;
        }
        return sResult;
    }

    public String getNoteText(String sKey) {
        String sReturn = (String)this.mTexts.get(sKey);
        if (sReturn != null) {
            return "  " + this.sNote + ": " + sReturn;
        }
        return "  " + this.sNote + ": ";
    }

    public String getNoteText(String sKey, String sParam) {
        String sResult = this.getNoteText(sKey);
        if (sParam != null) {
            String sFind = "%1%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, sParam);
        }
        return sResult;
    }

    public String getNoteText(String sKey, String[] saParam) {
        String sResult = this.getNoteText(sKey);
        int i = 0;
        while (i < saParam.length) {
            String sFind = "%" + (i + 1) + "%";
            sResult = AutoDocStringUtils.replaceFirst(sResult, sFind, saParam[i]);
            ++i;
        }
        return sResult;
    }

    public String getMessageTextDef(String sKey, String sDef) {
        String sReturn = sDef;
        String sLoaded = this.getMessageText(sKey);
        if (!sLoaded.equals("")) {
            sReturn = sLoaded;
        }
        return sReturn;
    }

    HashMap getTextMap() {
        return this.mTexts;
    }
}

