/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocStringUtils;

public class AutoDocGroupingDefinition {
    private String sName = "";
    private String sKey = "";
    private String sSplit = "";
    private String sMsgID = "";
    private String sProcType = "";
    private int iOnlyLevel = 0;
    private boolean bCleanWordDelim = false;

    public AutoDocGroupingDefinition(String sName, String sKey, String sSplit, String sProcType, String sOnlyLevel, String sCleanWordDelim, String sMsgID) {
        this.sName = sName;
        this.sKey = sKey;
        this.sSplit = sSplit;
        this.sProcType = sProcType;
        this.iOnlyLevel = Integer.parseInt(sOnlyLevel);
        if (sCleanWordDelim.equalsIgnoreCase("1") || sCleanWordDelim.equalsIgnoreCase("Y")) {
            this.bCleanWordDelim = true;
        }
        this.sMsgID = sMsgID;
    }

    public AutoDocGroupingDefinition(String sLine) {
        String sCleanWordDelim = "";
        String[] saEntry = AutoDocStringUtils.splitQuoted(sLine, ',');
        if (saEntry.length > 0) {
            this.sName = saEntry[0].trim();
        }
        if (saEntry.length > 1) {
            this.sKey = saEntry[1].trim();
        }
        if (saEntry.length > 2) {
            this.sSplit = saEntry[2].trim();
        }
        if (saEntry.length > 3) {
            this.sProcType = saEntry[3].trim();
        }
        if (saEntry.length > 4) {
            this.iOnlyLevel = Integer.parseInt(saEntry[4].trim());
        }
        if (saEntry.length > 5) {
            sCleanWordDelim = saEntry[5].trim();
        }
        if (saEntry.length > 6) {
            this.sMsgID = saEntry[6].trim();
        }
        if (sCleanWordDelim.equalsIgnoreCase("1") || sCleanWordDelim.equalsIgnoreCase("Y")) {
            this.bCleanWordDelim = true;
        }
    }

    public boolean equals(AutoDocGroupingDefinition o2) {
        boolean bReturn = false;
        if (o2 != null) {
            bReturn = true;
            if (this.sName.equals(o2.sName)) {
                bReturn = false;
            } else if (!this.sKey.equals(o2.sKey)) {
                bReturn = false;
            } else if (!this.sSplit.equals(o2.sSplit)) {
                bReturn = false;
            } else if (!this.sProcType.equals(o2.sProcType)) {
                bReturn = false;
            } else if (this.iOnlyLevel != o2.iOnlyLevel) {
                bReturn = false;
            } else if (this.bCleanWordDelim != o2.bCleanWordDelim) {
                bReturn = false;
            } else if (!this.sMsgID.equals(o2.sMsgID)) {
                bReturn = false;
            }
        }
        return bReturn;
    }

    public String getName() {
        return this.sName;
    }

    public String getMsgID() {
        return this.sMsgID;
    }

    public String getKey() {
        return this.sKey;
    }

    public String getSplitChar() {
        return this.sSplit;
    }

    public String getProcType() {
        return this.sProcType;
    }

    public int getLevelRestriction() {
        return this.iOnlyLevel;
    }

    public boolean getCleanWordDelim() {
        return this.bCleanWordDelim;
    }
}

