/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocExtDefaults;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public class AutoDocFileExtInfo
implements FilenameFilter {
    private String sInExt = "";
    private String[] Ext = null;
    private ArrayList vExtDef = null;
    private String sBlockBeginDefault = "";
    private String sBlockEndDefault = "";
    private String sBorderCharsDefault = "";
    private String sQuoteDefault = "";
    private String sProgLangDefault = "";
    private boolean RecurseDir = true;
    private String sExcl = "";
    private String[] Excl = null;
    private boolean isCaseSensitive = true;

    public AutoDocFileExtInfo(String sExt, String sExcl, ArrayList vExtDef, ArrayList vExtParaDef) {
        this.sInExt = sExt;
        this.sExcl = sExcl;
        this.Ext = sExt.toLowerCase().split("\\s*,\\s*");
        this.Excl = sExcl.split("\\s*" + File.pathSeparator + "\\s*");
        this.isCaseSensitive = FileUtils.isCaseSensitivePath();
        this.vExtDef = this.createJointExtDef(vExtDef, vExtParaDef);
    }

    public ArrayList createJointExtDef(ArrayList vExtDef, ArrayList vExtParaDef) {
        AutoDocExtDefaults newDef;
        String sProgLang;
        String sQuoteChar;
        String sBorderChars;
        String sBlockEnd;
        String sBlockBegin;
        int k;
        String[] saExtList;
        String sCurExts;
        AutoDocExtDefaults curDef;
        int i;
        ArrayList<AutoDocExtDefaults> vResult = new ArrayList<AutoDocExtDefaults>();
        if (vExtDef != null) {
            i = 0;
            while (i < vExtDef.size()) {
                curDef = (AutoDocExtDefaults)vExtDef.get(i);
                sCurExts = curDef.getExt();
                saExtList = sCurExts.toLowerCase().split("\\s*,\\s*");
                k = 0;
                while (k < saExtList.length) {
                    sBlockBegin = curDef.getBlockBegin();
                    sBlockEnd = curDef.getBlockEnd();
                    sBorderChars = curDef.getBorderChars();
                    sQuoteChar = curDef.getQuoteChar();
                    sProgLang = curDef.getProgLanguage();
                    if (saExtList[k].equals("*")) {
                        this.sBlockBeginDefault = sBlockBegin;
                        this.sBlockEndDefault = sBlockEnd;
                        this.sBorderCharsDefault = sBorderChars;
                        this.sQuoteDefault = sQuoteChar;
                        this.sProgLangDefault = sProgLang;
                    }
                    newDef = new AutoDocExtDefaults(saExtList[k], sBlockBegin, sBlockEnd, sBorderChars, sQuoteChar, sProgLang);
                    vResult.add(newDef);
                    ++k;
                }
                ++i;
            }
        }
        if (vExtParaDef != null) {
            i = 0;
            while (i < vExtParaDef.size()) {
                curDef = (AutoDocExtDefaults)vExtParaDef.get(i);
                sCurExts = curDef.getExt();
                saExtList = sCurExts.toLowerCase().split("\\s*,\\s*");
                k = 0;
                while (k < saExtList.length) {
                    sBlockBegin = curDef.getBlockBegin();
                    sBlockEnd = curDef.getBlockEnd();
                    sBorderChars = curDef.getBorderChars();
                    sQuoteChar = curDef.getQuoteChar();
                    sProgLang = curDef.getProgLanguage();
                    if (saExtList[k].equals("*")) {
                        this.sBlockBeginDefault = sBlockBegin;
                        this.sBlockEndDefault = sBlockEnd;
                        this.sBorderCharsDefault = sBorderChars;
                        this.sQuoteDefault = sQuoteChar;
                        this.sProgLangDefault = sProgLang;
                    }
                    newDef = new AutoDocExtDefaults(saExtList[k], sBlockBegin, sBlockEnd, sBorderChars, sQuoteChar, sProgLang);
                    boolean bFound = false;
                    int j = 0;
                    while (j < vResult.size()) {
                        AutoDocExtDefaults searchDef = (AutoDocExtDefaults)vResult.get(j);
                        String sSearchExt = searchDef.getExt();
                        if (sSearchExt.equalsIgnoreCase(saExtList[k])) {
                            if (sProgLang.equals("")) {
                                String sOrgLang = searchDef.getProgLanguage();
                                newDef.setProgLanguage(sOrgLang);
                            }
                            vResult.set(j, newDef);
                            bFound = true;
                        }
                        ++j;
                    }
                    if (!bFound) {
                        vResult.add(newDef);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return vResult;
    }

    public String getBlockBegin(String sExt) {
        String sReturn = this.sBlockBeginDefault;
        if (this.vExtDef != null) {
            int i = 0;
            while (i < this.vExtDef.size()) {
                AutoDocExtDefaults curDef = (AutoDocExtDefaults)this.vExtDef.get(i);
                if (curDef.getExt().equalsIgnoreCase(sExt)) {
                    sReturn = curDef.getBlockBegin();
                    break;
                }
                ++i;
            }
        }
        return sReturn;
    }

    public String getBlockEnd(String sExt) {
        String sReturn = this.sBlockEndDefault;
        if (this.vExtDef != null) {
            int i = 0;
            while (i < this.vExtDef.size()) {
                AutoDocExtDefaults curDef = (AutoDocExtDefaults)this.vExtDef.get(i);
                if (curDef.getExt().equalsIgnoreCase(sExt)) {
                    sReturn = curDef.getBlockEnd();
                    break;
                }
                ++i;
            }
        }
        return sReturn;
    }

    public String getBorderChars(String sExt) {
        String sReturn = this.sBorderCharsDefault;
        if (this.vExtDef != null) {
            int i = 0;
            while (i < this.vExtDef.size()) {
                AutoDocExtDefaults curDef = (AutoDocExtDefaults)this.vExtDef.get(i);
                if (curDef.getExt().equalsIgnoreCase(sExt)) {
                    sReturn = curDef.getBorderChars();
                    break;
                }
                ++i;
            }
        }
        return sReturn;
    }

    public String getQuoteChar(String sExt) {
        String sReturn = this.sQuoteDefault;
        if (this.vExtDef != null) {
            int i = 0;
            while (i < this.vExtDef.size()) {
                AutoDocExtDefaults curDef = (AutoDocExtDefaults)this.vExtDef.get(i);
                if (curDef.getExt().equalsIgnoreCase(sExt)) {
                    sReturn = curDef.getQuoteChar();
                    break;
                }
                ++i;
            }
        }
        return sReturn;
    }

    public String getProgLanguage(String sExt) {
        String sReturn = this.sProgLangDefault;
        if (this.vExtDef != null) {
            int i = 0;
            while (i < this.vExtDef.size()) {
                AutoDocExtDefaults curDef = (AutoDocExtDefaults)this.vExtDef.get(i);
                if (curDef.getExt().equalsIgnoreCase(sExt)) {
                    sReturn = curDef.getProgLanguage();
                    break;
                }
                ++i;
            }
        }
        return sReturn;
    }

    public boolean accept(File dir, String name) {
        File al = new File(dir, name);
        String sAbsName = FileUtils.toCanonicalPath(al);
        boolean bResult = false;
        if (al.isDirectory()) {
            if (this.RecurseDir) {
                bResult = true;
            }
            if (bResult && !this.sExcl.equals("")) {
                bResult = this.acceptExcludes(String.valueOf(sAbsName) + File.separator);
            }
            return bResult;
        }
        if (this.Ext != null && !this.sInExt.equals("") && !this.sInExt.equals("*")) {
            int i = 0;
            while (i < this.Ext.length) {
                if (name.toLowerCase().endsWith("." + this.Ext[i])) {
                    bResult = true;
                    break;
                }
                ++i;
            }
            if (bResult && !this.sExcl.equals("")) {
                bResult = this.acceptExcludes(sAbsName);
            }
            return bResult;
        }
        if (!this.sExcl.equals("")) {
            bResult = this.acceptExcludes(sAbsName);
            return bResult;
        }
        return true;
    }

    public boolean acceptExcludes(String sCurName) {
        boolean bResult = true;
        int i = 0;
        while (i < this.Excl.length) {
            String sPat = this.Excl[i];
            if (!this.isCaseSensitive) {
                sPat = sPat.toUpperCase();
                sCurName = sCurName.toUpperCase();
            }
            if (AutoDocStringUtils.isMatch(sCurName, sPat)) {
                bResult = false;
                break;
            }
            ++i;
        }
        return bResult;
    }
}

