/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocPluginInterface;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagDictionary;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.AutoDocTagParameter;
import de.enache.AutoDoc.AutoDocTagParameterList;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class AutoDocFile {
    private AutoDocSettings mySettings;
    private String Filename = "";
    private AutoDocTagDictionary Dict;
    private String BlockBegin = "/*!";
    private String BlockEnd = "*/";
    private String BorderChars = "*";
    private String AbsoluteFilename = "";
    private ArrayList TreeList = new ArrayList();
    private String TagCharacter = "";
    private String QuoteCharacter = "\"";
    private String sStartLineRem = "";
    private AutoDocPluginInterface activePlugin = null;
    protected String sRealFilename = "";
    private String SysNewLine = System.getProperty("line.separator");

    public AutoDocFile(AutoDocSettings mySettings, String sFilename, String sBlockBegin, String sBlockEnd, String sBorderChars, String sQuoteChar, AutoDocPluginInterface activePlugin, String sRealFilename) throws Error {
        int iRemLen;
        this.Filename = sFilename;
        this.mySettings = mySettings;
        this.Dict = mySettings.getDict();
        this.BlockBegin = sBlockBegin;
        this.BlockEnd = sBlockEnd;
        this.BorderChars = sBorderChars;
        this.QuoteCharacter = sQuoteChar;
        this.AbsoluteFilename = FileUtils.toCanonicalPath(sFilename);
        this.activePlugin = activePlugin;
        this.sRealFilename = sRealFilename;
        this.sStartLineRem = "";
        if (this.BlockBegin.matches("[a-zA-Z]+ .+") && (iRemLen = this.BlockBegin.indexOf(32)) >= 0) {
            this.sStartLineRem = this.BlockBegin.substring(0, iRemLen + 1).toLowerCase();
        }
        this.process();
    }

    public String getFilename() {
        return this.Filename;
    }

    public String getAbsoluteFilename() {
        return this.AbsoluteFilename;
    }

    public String getAbsoluteFilenameForOutput() {
        String sOutFilename = this.AbsoluteFilename;
        if (this.activePlugin != null) {
            sOutFilename = this.activePlugin.getAbsoluteFilenameForOutput(this.AbsoluteFilename);
        }
        return sOutFilename;
    }

    public String getAbsoluteFilenameLabelForOutput() {
        String sOutFilename = this.AbsoluteFilename;
        if (this.activePlugin != null) {
            sOutFilename = this.activePlugin.getAbsoluteFilenameLabelForOutput(this.AbsoluteFilename);
        }
        return sOutFilename;
    }

    public ArrayList getTagTreeList() {
        return this.TreeList;
    }

    public void setTagTreeList(ArrayList vTree) {
        this.TreeList = vTree;
    }

    public void process() throws Error {
        try {
            String sRealName = this.Filename;
            if (!this.sRealFilename.equals("")) {
                sRealName = this.sRealFilename;
            }
            BufferedReader in = new BufferedReader(AutoDoc.getInputStreamReader(sRealName));
            String sFiller = "" + this.BlockBegin.charAt(0);
            if (!this.sStartLineRem.equals("")) {
                sFiller = this.sStartLineRem;
            }
            boolean bOpenBlock = false;
            boolean bBorderEnd = true;
            String sCurBlock = "";
            String sSource = "";
            String sCurLine = null;
            while ((sCurLine = in.readLine()) != null) {
                String sTemp2;
                if (sCurLine.toLowerCase().indexOf(this.BlockBegin.toLowerCase()) >= 0 || this.startsWithBorder(sCurLine)) {
                    sCurLine = sCurLine.trim();
                }
                int iBeginIndex = sCurLine.toLowerCase().indexOf(this.BlockBegin.toLowerCase());
                int iEndIndex = sCurLine.toLowerCase().indexOf(this.BlockEnd.toLowerCase());
                if (iBeginIndex >= 0) {
                    bOpenBlock = true;
                    bBorderEnd = true;
                }
                if (bOpenBlock && iBeginIndex < 0 && iEndIndex < 0) {
                    if (!this.endsWithBorder(sCurLine)) {
                        bBorderEnd = false;
                    }
                    sCurBlock = String.valueOf(sCurBlock) + this.stripBorder(sCurLine, bBorderEnd) + "\n";
                } else if (bOpenBlock && iBeginIndex >= 0 && iEndIndex >= 0) {
                    if (iEndIndex <= iBeginIndex) {
                        iEndIndex = sCurLine.toLowerCase().indexOf(this.BlockEnd.toLowerCase(), iBeginIndex + this.BlockBegin.length());
                    }
                    int iStart = iBeginIndex + this.BlockBegin.length();
                    String sTemp = "";
                    if (iStart <= iEndIndex) {
                        sTemp = String.valueOf(sFiller) + sCurLine.substring(iStart, iEndIndex);
                    }
                    String sTemp22 = sCurLine;
                    if (iStart <= iEndIndex) {
                        sTemp22 = sCurLine.substring(this.BlockBegin.length(), iStart);
                    }
                    sCurBlock = String.valueOf(sCurBlock) + this.stripBorder(sTemp, bBorderEnd);
                    sSource = String.valueOf(sSource) + this.stripBorder(sTemp22, bBorderEnd).replaceAll("[\\n\\r]+", "") + this.SysNewLine;
                } else if (bOpenBlock && iBeginIndex >= 0 && iEndIndex < 0) {
                    String sTemp = String.valueOf(sFiller) + sCurLine.substring(iBeginIndex + this.BlockBegin.length());
                    sCurBlock = String.valueOf(sCurBlock) + this.stripBorder(sTemp, bBorderEnd) + "\n";
                    sTemp2 = sCurLine.substring(this.BlockBegin.length(), iBeginIndex + this.BlockBegin.length());
                    sSource = String.valueOf(sSource) + this.stripBorder(sTemp2, bBorderEnd).replaceAll("[\\n\\r]+", "") + this.SysNewLine;
                } else if (bOpenBlock && iBeginIndex < 0 && iEndIndex >= 0) {
                    String sTemp = sCurLine.substring(0, iEndIndex);
                    sTemp2 = sCurLine.substring(iEndIndex);
                    sCurBlock = String.valueOf(sCurBlock) + this.stripBorder(sTemp, bBorderEnd);
                    sSource = String.valueOf(sSource) + this.stripBorder(sTemp2, bBorderEnd).replaceAll("[\\n\\r]+", "") + this.SysNewLine;
                } else {
                    sSource = String.valueOf(sSource) + sCurLine.replaceAll("[\\n\\r]+", "") + this.SysNewLine;
                }
                if (iEndIndex >= 0) {
                    bOpenBlock = false;
                }
                if (bOpenBlock || sCurBlock.equals("")) continue;
                this.processBlock(sCurBlock, sSource);
                sCurBlock = "";
                sSource = "";
            }
            if (!sCurBlock.equals("")) {
                this.processBlock(sCurBlock, sSource);
            }
            in.close();
        }
        catch (IOException e) {
            String sError = this.mySettings.getMsgHandler().getTexts().getErrorText("ERR_READFAILED", this.AbsoluteFilename);
            throw new Error(sError);
        }
    }

    public boolean startsWithBorder(String s) {
        boolean bResult = false;
        String sBorderchars = "";
        if (this.sStartLineRem.equals("")) {
            sBorderchars = String.valueOf(sBorderchars) + this.BlockBegin.charAt(0);
        }
        sBorderchars = String.valueOf(sBorderchars) + this.BorderChars;
        String sTmp = s.trim();
        int iLen = sTmp.length();
        if (iLen > 0 && sBorderchars.indexOf(sTmp.charAt(0)) >= 0) {
            bResult = true;
        }
        return bResult;
    }

    public boolean endsWithBorder(String s) {
        boolean bResult = false;
        String sBorderchars = "";
        sBorderchars = String.valueOf(sBorderchars) + this.BlockBegin.charAt(0);
        sBorderchars = String.valueOf(sBorderchars) + this.BorderChars;
        String sTmp = s.trim();
        int iLen = sTmp.length();
        if (iLen > 0 && sBorderchars.indexOf(sTmp.charAt(iLen - 1)) >= 0) {
            bResult = true;
        }
        return bResult;
    }

    public void printAllTags() {
        int i = 0;
        while (i < this.TreeList.size()) {
            SystemUtils.println("Tree " + i);
            Tree curTree = (Tree)this.TreeList.get(i);
            curTree.print();
            ++i;
        }
    }

    public boolean isInlineTag(String s) {
        boolean bReturn = false;
        if (s.trim().startsWith(this.TagCharacter)) {
            bReturn = true;
        }
        return bReturn;
    }

    public void processBlock(String sCurBlock, String sSource) throws Error {
        String sTmp = sCurBlock.trim();
        String sFirst = "";
        if (!sTmp.equals("")) {
            sFirst = sTmp.substring(0, 1);
        }
        if (this.TagCharacter.equals("") && (sFirst.equals("@") || sFirst.equals("\\"))) {
            this.TagCharacter = sFirst;
        }
        if (this.TagCharacter.equals("")) {
            return;
        }
        String sTagChar = this.TagCharacter;
        String[] saSpt = AutoDocFile.splitAtTagChar(sCurBlock, sTagChar, this.Dict);
        saSpt = this.processIncludeADTags(saSpt);
        int iLastIndex = this.TreeList.size() - 1;
        int i = 0;
        while (i < saSpt.length) {
            if (!saSpt[i].trim().equals("")) {
                String sCurRest = saSpt[i];
                String[] saPara = AutoDocStringUtils.splitBraces(sCurRest, this.QuoteCharacter.charAt(0));
                String sCurrTag = saPara[0].trim();
                AutoDocTagListElement curElem = this.Dict.getElementByName(sCurrTag);
                if (curElem != null) {
                    if (curElem.isBeginSrcQuote()) {
                        sSource = "";
                    } else if (curElem.isEndSrcQuote()) {
                        Tree tPrev = (Tree)this.TreeList.get(iLastIndex);
                        ArrayList vChilds = (ArrayList)tPrev.getChildren();
                        int iChildSize = vChilds.size();
                        int j = 0;
                        while (j < iChildSize) {
                            Tree tChild = (Tree)vChilds.get(iChildSize - j - 1);
                            AutoDocTag childTag = (AutoDocTag)tChild.getData();
                            if (childTag.getTagInfo().isBeginSrcQuote()) {
                                AutoDocTagParameterList childList = childTag.getParameters();
                                AutoDocTagParameter newPara = new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, sSource, this.Filename);
                                childList.add(newPara);
                                break;
                            }
                            ++j;
                        }
                    }
                    iLastIndex = this.addCurElement(curElem, saPara, iLastIndex);
                } else if (!sCurrTag.equals("") && saSpt.length > 1) {
                    String[] saMsgPara = new String[]{sCurrTag, this.AbsoluteFilename};
                    this.mySettings.getMsgHandler().outputWarning("WARN_FILEUNSUPPORTEDTAG", saMsgPara);
                    if (iLastIndex >= 0 && i > 0) {
                        Tree lastMainNode = (Tree)this.TreeList.get(iLastIndex);
                        Tree currentNode = lastMainNode.getLastChild();
                        if (currentNode != null) {
                            currentNode.remove();
                            String s2 = sCurRest.substring(sCurrTag.length());
                            String sLastEntry = String.valueOf(saSpt[i - 1]) + " " + sTagChar + sCurrTag + s2;
                            String[] saLastPara = AutoDocStringUtils.splitBraces(sLastEntry, this.QuoteCharacter.charAt(0));
                            String sLastTag = saLastPara[0].trim();
                            saLastPara[1] = String.valueOf(this.QuoteCharacter) + saLastPara[1];
                            AutoDocTagListElement lastElem = this.Dict.getElementByName(sLastTag);
                            iLastIndex = this.addCurElement(lastElem, saLastPara, iLastIndex);
                        } else {
                            currentNode = lastMainNode;
                            if (currentNode != null) {
                                AutoDocTag tmpTag = (AutoDocTag)currentNode.getData();
                                int iNumPara = tmpTag.getNumParameters();
                                AutoDocTagParameter curPara = tmpTag.getParameter(iNumPara - 1);
                                String sLastVal = curPara.getParamString().trim();
                                String sNewVal = String.valueOf(sLastVal) + " " + sTagChar + sCurRest;
                                curPara.setParamString(sNewVal);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private String[] processIncludeADTags(String[] saSpt) throws Error {
        boolean bFoundIncludeAd = false;
        ArrayList<String> lCopySpt = new ArrayList<String>();
        int i = 0;
        while (i < saSpt.length) {
            if (!saSpt[i].trim().equals("")) {
                String sCurRest = saSpt[i];
                String[] saPara = AutoDocStringUtils.splitBraces(sCurRest, this.QuoteCharacter.charAt(0));
                String sCurrTag = saPara[0].trim();
                AutoDocTagListElement curElem = this.Dict.getElementByName(sCurrTag);
                if (curElem != null) {
                    if (curElem.isIncludeAD()) {
                        AutoDocTagParameterList vPara = new AutoDocTagParameterList();
                        if (saPara.length > 1) {
                            int j = 1;
                            while (j < saPara.length) {
                                String sPara = saPara[j];
                                vPara.add(new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, sPara, this.Filename));
                                ++j;
                            }
                        }
                        vPara = vPara.reduceParamsToSize(this.Dict, sCurrTag);
                        String sFileName = "";
                        if (vPara.size() > 0) {
                            sFileName = vPara.get(0).getParamString().trim();
                        }
                        String[] saReplacement = new String[]{""};
                        if (!sFileName.equals("")) {
                            File fParent = new File(this.AbsoluteFilename).getParentFile();
                            File fNew = new File(fParent, sFileName);
                            String sFullFilename = FileUtils.toCanonicalPath(fNew);
                            saReplacement = this.readIncludeADFile(sFullFilename);
                            System.out.println(sFullFilename);
                        }
                        int j = 0;
                        while (j < saReplacement.length) {
                            lCopySpt.add(saReplacement[j]);
                            ++j;
                        }
                        bFoundIncludeAd = true;
                    } else {
                        lCopySpt.add(saSpt[i]);
                    }
                }
            } else {
                lCopySpt.add(saSpt[i]);
            }
            ++i;
        }
        if (bFoundIncludeAd) {
            String[] saSptNew = new String[lCopySpt.size()];
            saSptNew = lCopySpt.toArray(saSptNew);
            return saSptNew;
        }
        return saSpt;
    }

    private String[] readIncludeADFile(String sFullFilename) throws Error {
        String[] res = new String[]{};
        if (sFullFilename != null && !sFullFilename.equals("")) {
            String sCurBlock = "";
            File f = new File(sFullFilename);
            if (f.exists()) {
                if (f.canRead()) {
                    try {
                        BufferedReader in = new BufferedReader(AutoDoc.getInputStreamReader(sFullFilename));
                        String sCurLine = null;
                        while ((sCurLine = in.readLine()) != null) {
                            if ((sCurLine = sCurLine.trim()).equals("")) continue;
                            sCurBlock = String.valueOf(sCurBlock) + sCurLine + this.SysNewLine;
                        }
                        in.close();
                    }
                    catch (IOException e) {
                        String sError = this.mySettings.getMsgHandler().getTexts().getErrorText("ERR_READFAILED", sFullFilename);
                        throw new Error(sError);
                    }
                    String sTagChar = this.TagCharacter;
                    res = AutoDocFile.splitAtTagChar(sCurBlock, sTagChar, this.Dict);
                } else {
                    this.mySettings.getMsgHandler().outputWarning("WARN_OUTREADFAILED", sFullFilename);
                }
            } else {
                this.mySettings.getMsgHandler().outputWarning("WARN_OUTREADFAILED", sFullFilename);
            }
        }
        return res;
    }

    public int addCurElement(AutoDocTagListElement curElem, String[] saPara, int iLastIndex) {
        if (curElem != null) {
            String[] saMsg;
            String sCurrTag = saPara[0].trim();
            int iLevel = curElem.getLevel();
            AutoDocTagParameterList vPara = new AutoDocTagParameterList();
            if (saPara.length > 1) {
                int j = 1;
                while (j < saPara.length) {
                    String sPara = saPara[j];
                    vPara.add(new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, sPara, this.Filename));
                    ++j;
                }
            }
            vPara = vPara.reduceParamsToSize(this.Dict, sCurrTag);
            if (curElem.isGroup() && vPara.size() > 0) {
                AutoDocTagParameter oldPara = vPara.get(0);
                String sOldValue = oldPara.getParamString();
                String sNewValue = this.mySettings.findUserGroupReplacement(sOldValue);
                if (sNewValue.equals("")) {
                    sNewValue = sOldValue;
                }
                AutoDocTagParameter newPara = new AutoDocTagParameter(this.mySettings, oldPara.TagCharacter, oldPara.QuoteCharacter, sNewValue, oldPara.Filename);
                vPara.set(0, newPara);
            }
            AutoDocTag curTag = new AutoDocTag(curElem, vPara);
            if (curElem.getNumParms() > 0 && vPara.size() == 0 && (curElem.isInclude() || curElem.isClassType() || curElem.isFunc() || curElem.isVar() || curElem.isLibname() || curElem.isGrouping())) {
                String[] saWarnPara = new String[]{curTag.getName(), this.Filename};
                this.mySettings.getMsgHandler().outputWarning("WARN_PARAMMISSING", saWarnPara);
                return iLastIndex;
            }
            if (curElem.isExperimental()) {
                saMsg = new String[]{curElem.getName(), this.Filename};
                this.mySettings.getMsgHandler().outputWarning("WARN_FILETAGEXPERIMENTAL", saMsg);
            }
            if (curElem.isDeprecated()) {
                saMsg = new String[]{curElem.getName(), this.Filename};
                this.mySettings.getMsgHandler().outputWarning("WARN_FILETAGDEPRECATED", saMsg);
            }
            if (iLevel <= 3) {
                this.TreeList.add(new Tree(curTag));
                ++iLastIndex;
            } else if (iLastIndex >= 0) {
                Tree currentNode = (Tree)this.TreeList.get(iLastIndex);
                if (curElem.isBrief() || curElem.isDetails()) {
                    AutoDocTag parentTag = (AutoDocTag)currentNode.getData();
                    AutoDocTagParameterList vNewPara = this.generateBriefDetailParams(curTag, parentTag);
                    parentTag.setParameters(vNewPara);
                } else {
                    currentNode.addChild(new Tree(curTag));
                }
            }
        }
        return iLastIndex;
    }

    public static String[] splitAtTagChar(String sCurBlock, String sTagChar, AutoDocTagDictionary Dict) {
        String[] saReturn = new String[]{""};
        ArrayList<String> vReturn = new ArrayList<String>();
        String sReserve = "";
        String sCurEntry = "";
        if (sTagChar != null && sTagChar.length() > 0) {
            char cTagChar = sTagChar.charAt(0);
            int iStrLen = sCurBlock.length();
            int i = 0;
            while (i < iStrLen) {
                char cCur = sCurBlock.charAt(i);
                char cPrevChar = ' ';
                if (i > 0) {
                    cPrevChar = sCurBlock.charAt(i - 1);
                }
                if (cCur == cTagChar && AutoDocStringUtils.isTagCandidate(sCurBlock.substring(i), cTagChar, cPrevChar)) {
                    vReturn.add(sCurEntry.trim());
                    sCurEntry = "";
                    sReserve = "";
                } else {
                    sCurEntry = String.valueOf(sCurEntry) + sReserve;
                    sCurEntry = String.valueOf(sCurEntry) + cCur;
                    sReserve = "";
                }
                ++i;
            }
            if (!(sCurEntry = String.valueOf(sCurEntry) + sReserve).equals("")) {
                vReturn.add(sCurEntry);
            }
            saReturn = new String[vReturn.size()];
            saReturn = vReturn.toArray(saReturn);
        }
        return saReturn;
    }

    public static String processSpecialEmphasis(String s, String sTagCharacter) {
        String sResult = "";
        String sStartPrev = " <{([,:;\n";
        String sEndPrev = " ({[<=+-\\@\n";
        String sRest = s;
        String sMarked = "";
        boolean bEmph = false;
        String sLastEmph = "";
        int iLastPos = 0;
        int iPos = AutoDocFile.findEmphMarker(s, 0);
        while (iPos >= 0) {
            String sWhich = "";
            sWhich = String.valueOf(sWhich) + s.charAt(iPos);
            int iMLen = 1;
            String sPrev = AutoDocStringUtils.getPrevCharStr(s, iPos);
            String sNext = AutoDocStringUtils.getNextCharStr(s, iPos);
            if (sNext.equals(sWhich)) {
                sWhich = String.valueOf(sWhich) + sNext;
                ++iMLen;
                sNext = AutoDocStringUtils.getNextCharStr(s, iPos + 1);
            }
            if (!bEmph && sStartPrev.indexOf(sPrev) >= 0 && sNext.matches("[a-zA-Z0-9]")) {
                bEmph = true;
                sLastEmph = sWhich;
                if (iPos > 0) {
                    sResult = String.valueOf(sResult) + s.substring(iLastPos, iPos);
                }
            } else if (sWhich.equals(sLastEmph) && sEndPrev.indexOf(sPrev) < 0 && !sNext.matches("[a-zA-Z0-9]")) {
                sMarked = String.valueOf(sMarked) + s.substring(iLastPos, iPos);
                String sTagName = AutoDocFile.getEmphTagName(sWhich);
                sResult = String.valueOf(sResult) + "{" + sTagCharacter + sTagName + " " + sMarked + "}";
                bEmph = false;
                sLastEmph = "";
                sMarked = "";
            } else if (bEmph) {
                sMarked = String.valueOf(sMarked) + s.substring(iLastPos, iPos + iMLen);
            } else {
                sResult = String.valueOf(sResult) + s.substring(iLastPos, iPos + iMLen);
            }
            iLastPos = iPos + iMLen;
            iPos = AutoDocFile.findEmphMarker(s, iLastPos);
            sRest = s.substring(iLastPos);
        }
        if (bEmph && !sRest.equals("")) {
            sMarked = String.valueOf(sMarked) + sRest;
            String sTagName = AutoDocFile.getEmphTagName(sLastEmph);
            sResult = String.valueOf(sResult) + "{" + sTagCharacter + sTagName + " " + sMarked + "}";
        } else {
            sResult = String.valueOf(sResult) + sRest;
        }
        return sResult;
    }

    public static String getEmphTagName(String sWhich) {
        String sTagName = "";
        if (sWhich.equals("_")) {
            sTagName = "i";
        } else if (sWhich.equals("*")) {
            sTagName = "b";
        } else if (sWhich.equals("__")) {
            sTagName = "tt";
        } else if (sWhich.equals("**")) {
            sTagName = "em";
        }
        return sTagName;
    }

    public static int findEmphMarker(String s, int iStartPos) {
        int iPos = -1;
        iPos = s.indexOf("__", iStartPos);
        if (iPos < 0 && (iPos = s.indexOf("**", iStartPos)) < 0 && (iPos = s.indexOf("_", iStartPos)) < 0) {
            iPos = s.indexOf("*", iStartPos);
        }
        return iPos;
    }

    protected AutoDocTagParameterList generateBriefDetailParams(AutoDocTag curTag, AutoDocTag parentTag) {
        AutoDocTagListElement curElem = curTag.getTagInfo();
        AutoDocTagParameterList vNewPara = parentTag.getParameters();
        int iCurNumPara = curTag.getNumParameters();
        int iCurMaxPara = curElem.getNumParms();
        AutoDocTagParameter curDesc = new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, "", this.Filename);
        if (iCurNumPara >= iCurMaxPara) {
            curDesc = curTag.getParameter(iCurMaxPara - 1);
        }
        AutoDocTagParameter curBrief = null;
        AutoDocTagParameter curDetails = null;
        if (curElem.isBrief()) {
            curBrief = curDesc;
        } else {
            curDetails = curDesc;
        }
        int iParentNumPara = vNewPara.size();
        int iMaxPara = parentTag.getTagInfo().getNumParms();
        while (iParentNumPara < iMaxPara) {
            vNewPara.add(new AutoDocTagParameter(this.mySettings, this.TagCharacter, this.QuoteCharacter, "", this.Filename));
            ++iParentNumPara;
        }
        AutoDocTagParameter curParentDescPara = vNewPara.get(iMaxPara - 1);
        String sDescr = curParentDescPara.getParamString();
        String[] saTmp = sDescr.split("\\n[ \\t\\x0B\\f]*\\n", 2);
        String sSep = "";
        if (saTmp.length > 1) {
            int iLenSep = sDescr.length() - saTmp[0].length() - saTmp[1].length();
            sSep = sDescr.substring(saTmp[0].length(), saTmp[0].length() + iLenSep);
        }
        String sParentBrief = "";
        String sParentDetails = "";
        if (saTmp.length > 0) {
            sParentBrief = String.valueOf(saTmp[0]);
        }
        if (saTmp.length > 1) {
            sParentDetails = String.valueOf(saTmp[1]);
        }
        if (curBrief != null) {
            sParentBrief = String.valueOf(sParentBrief) + " " + curBrief.getParamString();
        }
        if (curDetails != null) {
            sParentDetails = String.valueOf(sParentDetails) + " " + curDetails.getParamString();
        }
        if (sSep.equals("")) {
            sSep = "\n\n";
        }
        String sParentNewDescr = String.valueOf(sParentBrief) + sSep + sParentDetails;
        curParentDescPara.setParamString(sParentNewDescr);
        ArrayList vParentParaInline = curParentDescPara.getInlineTags();
        ArrayList vCurInline = curDesc.getInlineTags();
        int iInline = 0;
        while (iInline < vCurInline.size()) {
            vParentParaInline.add(vCurInline.get(iInline));
            ++iInline;
        }
        curParentDescPara.setInlineTags(vParentParaInline);
        vNewPara.set(iMaxPara - 1, curParentDescPara);
        return vNewPara;
    }

    public String stripBorder(String sCurLine, boolean bBorderEnd) {
        String sReturn = "";
        String sBorderchars = "";
        if (this.sStartLineRem.equals("")) {
            sBorderchars = String.valueOf(sBorderchars) + this.BlockBegin.charAt(0);
        }
        sBorderchars = String.valueOf(sBorderchars) + this.BorderChars;
        if (!this.sStartLineRem.equals("") && sCurLine.toLowerCase().startsWith(this.sStartLineRem)) {
            sCurLine = sCurLine.substring(this.sStartLineRem.length());
        }
        if (sCurLine.length() > 0 && sBorderchars.indexOf(sCurLine.charAt(0)) >= 0) {
            int iStart = -1;
            int i = 0;
            while (i < sCurLine.length()) {
                if (sBorderchars.indexOf(sCurLine.charAt(i)) < 0) {
                    iStart = i;
                    break;
                }
                ++i;
            }
            int iEnd = sCurLine.length() - 1;
            if (bBorderEnd) {
                int i2 = sCurLine.length() - 1;
                while (i2 >= 0) {
                    if (sBorderchars.indexOf(sCurLine.charAt(i2)) < 0) {
                        iEnd = i2;
                        break;
                    }
                    --i2;
                }
            }
            if (iStart >= 0 && iStart <= iEnd) {
                sReturn = String.valueOf(sCurLine.substring(iStart, iEnd + 1)) + " ";
            }
        } else {
            sReturn = sCurLine;
        }
        return sReturn;
    }

    public String getLevel1TagFilename() {
        String sOrgFilename = "";
        AutoDocTag rootTag = this.getLevel1Tag();
        if (rootTag != null && rootTag.getNumParameters() > 0) {
            sOrgFilename = rootTag.getParameter(0).toString().trim();
        }
        return sOrgFilename;
    }

    public AutoDocTag getLevel1Tag() {
        AutoDocTag rootTag = null;
        ArrayList treeList = this.getTagTreeList();
        int i = 0;
        while (i < treeList.size()) {
            Tree curNode = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curNode.getData();
            if (!curNode.isNodeEmpty() && curTag.getLevel() == 1) {
                rootTag = curTag;
                break;
            }
            ++i;
        }
        return rootTag;
    }

    public AutoDocTagDictionary getDictionary() {
        return this.Dict;
    }

    public String getTagCharacter() {
        return this.TagCharacter;
    }

    public void setTagCharacter(String TagCharacter) {
        this.TagCharacter = TagCharacter;
    }

    public String getQuoteCharacter() {
        return this.QuoteCharacter;
    }

    public void setQuoteCharacter(String QuoteCharacter) {
        this.QuoteCharacter = QuoteCharacter;
    }
}

