/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocFileExtInfo;
import de.enache.AutoDoc.AutoDocPluginInfo;
import de.enache.AutoDoc.AutoDocPluginInputPackaged;
import de.enache.AutoDoc.AutoDocPluginInterface;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.Tree;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class AutoDocDocument {
    private AutoDocSettings mySettings;
    private AutoDocFileExtInfo myFilter;
    private ArrayList ProcFiles = new ArrayList();

    public AutoDocDocument(AutoDocSettings mySettings) {
        this.mySettings = mySettings;
        String sExt = mySettings.getFileFilter();
        ArrayList vExtDef = mySettings.getExtDefaultsList();
        ArrayList vExtDefPara = mySettings.getExtDefParaList();
        String sExcludes = mySettings.getExclude();
        sExcludes = this.extendExcludeFromPlugins(sExcludes);
        this.myFilter = new AutoDocFileExtInfo(sExt, sExcludes, vExtDef, vExtDefPara);
    }

    private String extendExcludeFromPlugins(String sExcludes) {
        ArrayList lPlugins = this.mySettings.getPluginList();
        int iNumPlugins = lPlugins.size();
        int i = 0;
        while (i < iNumPlugins) {
            AutoDocPluginInterface curPlugin = ((AutoDocPluginInfo)lPlugins.get(i)).getPluginObject();
            String sEx = curPlugin.getExcludePattern();
            if (sExcludes.indexOf(sEx) < 0) {
                sExcludes = sExcludes.trim().equals("") ? sEx : String.valueOf(sExcludes) + "; " + sEx;
            }
            ++i;
        }
        return sExcludes;
    }

    public void doProcess(String sDirPath) {
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_DOCSTARTPROCESSING"));
        SystemUtils.println();
        this.processAllFiles(sDirPath, "", null);
    }

    public void debugDumpFileTagTree(String sInFileName, String sOutFilename) {
        String sAbsIn = FileUtils.toCanonicalPath(sInFileName);
        int i = 0;
        while (i < this.ProcFiles.size()) {
            AutoDocFile curFile = (AutoDocFile)this.ProcFiles.get(i);
            ArrayList curTreeList = curFile.getTagTreeList();
            if (curFile.getFilename().equals(sAbsIn)) {
                AutoDocDocument.dumpTree(sOutFilename, curTreeList);
            }
            ++i;
        }
    }

    public static void dumpTree(String sFilename, ArrayList TreeList) {
        try {
            PrintStream treeOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFilename)), true, "UTF-8");
            int i = 0;
            while (i < TreeList.size()) {
                treeOut.println("Tree " + i);
                Tree curTree = (Tree)TreeList.get(i);
                curTree.print(treeOut);
                ++i;
            }
            treeOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getProcFiles() {
        return this.ProcFiles;
    }

    public String getExtension(String sFilename) {
        String sReturn = "";
        int iPos = sFilename.lastIndexOf(46);
        if (iPos > 0 && iPos + 1 < sFilename.length()) {
            sReturn = sFilename.substring(iPos + 1);
        }
        return sReturn;
    }

    protected void processFile(String sFilename, String sVirtualFile, AutoDocPluginInterface activePlugin) throws Error {
        AutoDocFile curFile;
        ArrayList treeList;
        String sExt = this.getExtension(sFilename);
        String sRealName = "";
        if (!sVirtualFile.equals("")) {
            sRealName = sFilename;
        }
        if (sVirtualFile.equals("")) {
            sVirtualFile = sFilename;
        }
        if ((treeList = (curFile = new AutoDocFile(this.mySettings, sVirtualFile, this.myFilter.getBlockBegin(sExt), this.myFilter.getBlockEnd(sExt), this.myFilter.getBorderChars(sExt), this.myFilter.getQuoteChar(sExt), activePlugin, sRealName)).getTagTreeList()).size() > 0) {
            int iNumLevel1 = 0;
            boolean bExclude = false;
            String sExtTagName = "";
            int i = 0;
            while (i < treeList.size()) {
                Tree curTree = (Tree)treeList.get(i);
                AutoDocTag curTag = (AutoDocTag)curTree.getData();
                AutoDocTagListElement curElem = curTag.getTagInfo();
                if (curTag != null && curElem != null) {
                    if (curElem.isExclude()) {
                        sExtTagName = curTag.getName();
                        bExclude = true;
                    }
                    if (curTag.getLevel() == 1) {
                        ++iNumLevel1;
                    }
                }
                ++i;
            }
            if (!bExclude && iNumLevel1 == 0) {
                bExclude = true;
            }
            if (!bExclude) {
                this.ProcFiles.add(curFile);
            } else {
                String[] saEx = new String[]{curFile.getFilename(), sExtTagName};
                if (iNumLevel1 == 0) {
                    this.mySettings.getMsgHandler().outputNote("NOTE_DOCEXCLNOLEVEL1", curFile.getFilename());
                } else {
                    this.mySettings.getMsgHandler().outputNote("NOTE_DOCEXCLEXCLTAG", saEx);
                }
            }
        } else {
            this.mySettings.getMsgHandler().outputNote("NOTE_DOCEXCLNOTAG", curFile.getFilename());
        }
    }

    protected void processFileWithPlugins(String sFilename, String sVirtualFile, AutoDocPluginInterface activePlugin) throws Error {
        AutoDocPluginInterface matchingPlugin = this.findMatchingPlugin(sFilename);
        if (matchingPlugin != null && activePlugin == null) {
            try {
                matchingPlugin.setStringParameter("Input", sFilename);
                matchingPlugin.process();
                String sOut = matchingPlugin.getStringParameter("Output");
                String sVirtualOut = matchingPlugin.getStringParameter("VirtualOutput");
                if (matchingPlugin.isOutputDirectory()) {
                    this.processAllFiles(sOut, sVirtualOut, matchingPlugin);
                } else {
                    this.processFile(sOut, sVirtualOut, matchingPlugin);
                }
                matchingPlugin.cleanup();
            }
            catch (Error e) {
                String[] saMsgPara = new String[]{matchingPlugin.getPluginName(), e.getMessage()};
                String sError = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_PLUGINMSG", saMsgPara);
                throw new Error(sError);
            }
            catch (Exception e) {
                String[] saMsgPara = new String[]{matchingPlugin.getPluginName(), e.getMessage()};
                String sError = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_PLUGINMSG", saMsgPara);
                throw new Error(sError);
            }
        } else {
            this.processFile(sFilename, sVirtualFile, activePlugin);
        }
    }

    protected void processAllFiles(String sDirPath, String sVirtualDir, AutoDocPluginInterface activePlugin) throws Error {
        boolean bRecurse = this.mySettings.getRecurse();
        String[] aDirList = FileUtils.splitDirectories(sDirPath);
        String sAbsOutdir = FileUtils.toCanonicalPath(this.mySettings.getOutPath()).trim();
        int i = 0;
        while (i < aDirList.length) {
            if (aDirList[i].equalsIgnoreCase(sAbsOutdir)) {
                String sError = this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTDIRISINPUT", sAbsOutdir);
                throw new Error(sError);
            }
            ++i;
        }
        if (aDirList != null) {
            int iCurDir = 0;
            while (iCurDir < aDirList.length) {
                String sProgPath = aDirList[iCurDir];
                File fProgPath = new File(sProgPath);
                if (fProgPath.exists()) {
                    if (fProgPath.isDirectory()) {
                        if (!fProgPath.isHidden()) {
                            String sOutPathOut = sProgPath;
                            if (!sVirtualDir.equals("")) {
                                sOutPathOut = sVirtualDir;
                            }
                            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_DOCPROCESSINGDIR", sOutPathOut));
                            File[] fList = fProgPath.listFiles(this.myFilter);
                            int i2 = 0;
                            while (i2 < fList.length) {
                                String sCurrFil = fList[i2].getPath();
                                String sVirtual2 = "";
                                if (!sVirtualDir.equals("")) {
                                    File fNew = new File(sVirtualDir, fList[i2].getName());
                                    sVirtual2 = FileUtils.toCanonicalPath(fNew);
                                }
                                if (fList[i2].isDirectory()) {
                                    if (bRecurse) {
                                        this.processAllFiles(sCurrFil, sVirtual2, activePlugin);
                                    }
                                } else if (!fList[i2].isHidden()) {
                                    this.processFileWithPlugins(sCurrFil, sVirtual2, activePlugin);
                                }
                                ++i2;
                            }
                        }
                    } else if (!fProgPath.isHidden()) {
                        this.processFileWithPlugins(sProgPath, sVirtualDir, activePlugin);
                    }
                }
                Thread.yield();
                ++iCurDir;
            }
        }
    }

    private AutoDocPluginInterface findMatchingPlugin(String sCurrFil) {
        AutoDocPluginInterface matchingPlugin = null;
        ArrayList lPlugins = this.mySettings.getPluginList();
        int iNumPlugins = lPlugins.size();
        int j = 0;
        while (j < iNumPlugins) {
            AutoDocPluginInfo info = (AutoDocPluginInfo)lPlugins.get(j);
            AutoDocPluginInterface plug = info.getPluginObject();
            if (plug instanceof AutoDocPluginInputPackaged && plug.checkValidInput(sCurrFil)) {
                matchingPlugin = plug;
                break;
            }
            ++j;
        }
        return matchingPlugin;
    }
}

