/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagParameterList;

public class AutoDocBibEntry {
    private AutoDocFile file;
    private AutoDocTag tag;
    private String sKey;
    private String sEntry;
    private String sFilename;
    private boolean bGlobal;

    public AutoDocBibEntry(AutoDocFile file, AutoDocTag tag) {
        this.file = file;
        this.tag = tag;
        AutoDocTagParameterList curChildParms = tag.getParameters();
        this.sKey = curChildParms.get(0).toString().trim();
        this.sEntry = curChildParms.get(1).toString().trim();
        this.bGlobal = tag.getTagInfo().isGlobal();
        this.sFilename = file.getAbsoluteFilename();
    }

    public AutoDocFile getFile() {
        return this.file;
    }

    public AutoDocTag getTag() {
        return this.tag;
    }

    public String getKey() {
        return this.sKey;
    }

    public String getEntry() {
        return this.sEntry;
    }

    public String getFilename() {
        return this.sFilename;
    }

    public boolean isGlobal() {
        return this.bGlobal;
    }

    public String toString() {
        return "[" + this.sKey + "],[" + this.sEntry + "]";
    }
}

