/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocMsgHandler;
import de.enache.AutoDoc.AutoDocMsgParams;
import de.enache.AutoDoc.AutoDocOutput;
import de.enache.AutoDoc.AutoDocPluginUtils;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class AutoDoc {
    public static String Version = "1.2.11";
    public static String Date = "04.08.2022";
    public static String BaseProgName = "AutoDoc";
    public static String ContactAddr = "AutoDoc@Enache.de";
    public static String ProgDir = "";
    public static String CopyRightYear = Date.substring(6);
    public static String PluginSite = "http://www.enache.de/AutoDocPlugins";
    private static AutoDocSettings mySettings = null;
    private static String SysNewLine = System.getProperty("line.separator");
    private static boolean bCheckOutOfSynch = true;
    public static boolean bTestCase = false;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        try {
            AutoDoc.mainRoutine(args, AutoDoc.getProgramDir());
            System.exit(0);
        }
        catch (Error e) {
            SystemUtils.println(e.getMessage());
            System.exit(-1);
        }
        catch (Exception e) {
            String sErr = e.getMessage();
            if (sErr != null && mySettings != null) {
                String sMsg = "Fatal error encountered. Please contact " + ContactAddr + " for support. " + sErr;
                AutoDocMsgHandler mHdl = mySettings.getMsgHandler();
                if (mHdl == null) {
                    mHdl = new AutoDocMsgHandler();
                }
                if (mHdl.getTexts() != null) {
                    String[] saErr = new String[]{ContactAddr, sErr};
                    mHdl.outputError("ERR_FATAL", saErr);
                } else {
                    SystemUtils.println(sMsg);
                }
                SystemUtils.println(SystemUtils.getStackTrace(e));
            } else {
                SystemUtils.println("Fatal error encountered. Please contact " + ContactAddr + " for support.");
                SystemUtils.println(SystemUtils.getStackTrace(e));
            }
            System.exit(-1);
        }
    }

    public static String genHeaderMsg(AutoDocMessageTexts mtTexts) {
        String sReturn = "";
        String[] sa = new String[]{Version, CopyRightYear};
        if (mtTexts == null) {
            mtTexts = new AutoDocMessageTexts();
        }
        sReturn = mtTexts.getMessageText("MSG_AUTODOC_HEADER", sa);
        sReturn = AutoDocStringUtils.replaceAll(sReturn, "\n", SysNewLine);
        return sReturn;
    }

    public static void mainRoutine(String[] args, String sProgDir) throws Error, Exception {
        ProgDir = sProgDir;
        mySettings = new AutoDocSettings();
        String sUsageDefEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/en/Usage.txt", "/en/Usage.txt"));
        String sUsageDefJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/en/Usage.txt", "/en/Usage.txt"));
        InputStream isUsage = AutoDoc.getResourceAsStream("/en/Usage.txt", "/en/Usage.txt");
        InputStream isJarUsage = AutoDoc.getResourceAsStreamFromJar("/en/Usage.txt", "/en/Usage.txt");
        mySettings.initUsage(isUsage, sUsageDefEnc, isJarUsage, sUsageDefJarEnc);
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-workdir")) {
                if (++i >= args.length || args[i].equals("")) break;
                File fDir = new File(args[i]);
                if (fDir.exists() && fDir.isDirectory()) {
                    System.setProperty("user.dir", args[i]);
                    break;
                }
                AutoDocMsgHandler mHdl = mySettings.getMsgHandler();
                if (mHdl == null) {
                    mHdl = new AutoDocMsgHandler();
                    mySettings.setMsgHandler(mHdl);
                }
                mHdl.incNumErrors();
                AutoDocMessageTexts mtTexts = mHdl.getTexts();
                SystemUtils.print(AutoDoc.genHeaderMsg(mtTexts));
                if (mtTexts == null) {
                    mtTexts = new AutoDocMessageTexts();
                }
                String sError = mtTexts.getErrorText("ERR_WORKDIRDOESNOTEXIST", args[i]);
                throw new Error(sError);
            }
            ++i;
        }
        if (args.length >= 1) {
            AutoDocMessageTexts myTexts = new AutoDocMessageTexts();
            try {
                mySettings.getMsgHandler().setTexts(myTexts);
                mySettings.setProgPath(sProgDir);
                String sCfgFile = AutoDoc.getCfgFileName(args);
                ArrayList lWarnings = new ArrayList();
                ArrayList lWarnings1 = mySettings.processCfgFile(sCfgFile, ProgDir);
                lWarnings.addAll(lWarnings1);
                ArrayList lWarnings2 = mySettings.processSettings(args, ProgDir, true);
                lWarnings.addAll(lWarnings2);
                AutoDoc.applyDefaultSettings();
                String sLocale = mySettings.getLocale();
                String sUsageEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/" + sLocale + "/Usage.txt", "/en/Usage.txt"));
                String sUsageJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/Usage.txt", "/en/Usage.txt"));
                isUsage = AutoDoc.getResourceAsStream("/" + sLocale + "/Usage.txt", "/en/Usage.txt");
                isJarUsage = AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/Usage.txt", "/en/Usage.txt");
                mySettings.initUsage(isUsage, sUsageEnc, isJarUsage, sUsageJarEnc);
                String sMsgEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/" + sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt"));
                String sMsgJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt"));
                InputStream isMessages = AutoDoc.getResourceAsStream("/" + sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt");
                InputStream isJarMessages = AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/AutoDocMessages.txt", "/en/AutoDocMessages.txt");
                mySettings.initMessages(isMessages, sMsgEnc, isJarMessages, sMsgJarEnc, bCheckOutOfSynch);
                String sGroupFileEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/AutoDocGroupings.txt", ""));
                String sGroupJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/AutoDocGroupings.txt", ""));
                InputStream isGroupDef = AutoDoc.getResourceAsStream("/AutoDocGroupings.txt", "");
                InputStream isGroupJarDef = AutoDoc.getResourceAsStreamFromJar("/AutoDocGroupings.txt", "");
                mySettings.initGroupings(isGroupDef, sGroupFileEnc, isGroupJarDef, sGroupJarEnc);
                String sTagFileEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/AutoDocTagDictionary.txt", ""));
                String sLabelFileEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/" + sLocale + "/TagTexts.txt", "/en/TagTexts.txt"));
                String sTagJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/AutoDocTagDictionary.txt", ""));
                String sLabelJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/TagTexts.txt", "/en/TagTexts.txt"));
                InputStream isDict = AutoDoc.getResourceAsStream("/AutoDocTagDictionary.txt", "");
                InputStream isText = AutoDoc.getResourceAsStream("/" + sLocale + "/TagTexts.txt", "/en/TagTexts.txt");
                InputStream isJarDict = AutoDoc.getResourceAsStreamFromJar("/AutoDocTagDictionary.txt", "");
                InputStream isJarText = AutoDoc.getResourceAsStreamFromJar("/" + sLocale + "/TagTexts.txt", "/en/TagTexts.txt");
                mySettings.initDictionary(isDict, sTagFileEnc, isText, sLabelFileEnc, isJarDict, sTagJarEnc, isJarText, sLabelJarEnc, bCheckOutOfSynch);
                String sExtDefEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/AutoDocFileExtensionDefaults.txt", ""));
                String sExtDefJarEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStreamFromJar("/AutoDocFileExtensionDefaults.txt", ""));
                InputStream isExtDef = AutoDoc.getResourceAsStream("/AutoDocFileExtensionDefaults.txt", "");
                InputStream isJarExtDef = AutoDoc.getResourceAsStreamFromJar("/AutoDocFileExtensionDefaults.txt", "");
                mySettings.initExtDefaults(isExtDef, sExtDefEnc, isJarExtDef, sExtDefJarEnc);
                String sUserGroupDefEnc = AutoDoc.detectUTFCharset(AutoDoc.getResourceAsStream("/AutoDocUserGroupDefs.txt", ""));
                InputStream isUserGroupDef = AutoDoc.getResourceAsStream("/AutoDocUserGroupDefs.txt", "");
                mySettings.initUserGroupDef(isUserGroupDef, sUserGroupDefEnc);
                SystemUtils.print(AutoDoc.genHeaderMsg(myTexts));
                AutoDoc.outputPendingWarnings(lWarnings);
                SystemUtils.println();
                mySettings.print();
                String sConsist = mySettings.checkConsitency();
                if (!sConsist.equals("")) {
                    SystemUtils.println(sConsist);
                }
            }
            catch (Error e) {
                SystemUtils.print(AutoDoc.genHeaderMsg(myTexts));
                String sError = "  " + mySettings.getMsgHandler().getTexts().getMessageText("ERR_ERROR") + ": " + e.getMessage() + SysNewLine;
                sError = String.valueOf(sError) + SysNewLine;
                sError = String.valueOf(sError) + mySettings.generateUsage(AutoDoc.genJarFilename());
                throw new Error(sError);
            }
            try {
                AutoDoc.initPlugins();
                AutoDoc.doProcess(mySettings);
                SystemUtils.println();
                SystemUtils.println(mySettings.getMsgHandler().getTexts().getMessageText("MSG_FINISHED"));
                SystemUtils.println();
                AutoDoc.outputSummary();
                SystemUtils.println();
            }
            catch (Error e) {
                String sError = "  " + mySettings.getMsgHandler().getTexts().getMessageText("ERR_ERROR") + ": " + e.getMessage() + SysNewLine;
                sError = String.valueOf(sError) + SysNewLine;
                throw new Error(sError);
            }
        }
        SystemUtils.print(AutoDoc.genHeaderMsg(mySettings.getMsgHandler().getTexts()));
        SystemUtils.print(mySettings.generateUsage(AutoDoc.genJarFilename()));
    }

    private static void outputPendingWarnings(ArrayList lWarnings) {
        AutoDocMsgHandler msgHandler = mySettings.getMsgHandler();
        int iLen = lWarnings.size();
        int i = 0;
        while (i < iLen) {
            AutoDocMsgParams msgParam = (AutoDocMsgParams)lWarnings.get(i);
            String sMsgkey = msgParam.getkey();
            Object oMsgParam = msgParam.getParams();
            if (oMsgParam == null) {
                msgHandler.outputWarning(sMsgkey);
            } else if (oMsgParam instanceof String) {
                msgHandler.outputWarning(sMsgkey, (String)oMsgParam);
            } else if (oMsgParam instanceof String[]) {
                msgHandler.outputWarning(sMsgkey, (String[])oMsgParam);
            }
            ++i;
        }
    }

    public static void mainRoutineTestCase(String[] args, String sProgDir) throws Error, Exception {
        bTestCase = true;
        AutoDoc.mainRoutine(args, sProgDir);
    }

    public static String detectUTFCharset(InputStream inFile) {
        return FileUtils.detectUTFCharset(inFile, 4, 2);
    }

    public static String detectUTFCharset(String sFilename) {
        return FileUtils.detectUTFCharset(sFilename, 4, 2);
    }

    public static InputStreamReader getInputStreamReader(String sFilename) throws FileNotFoundException {
        return FileUtils.getInputStreamReader(sFilename, 4, 2);
    }

    public static void outputSummary() {
        AutoDocMsgHandler hMsg = mySettings.getMsgHandler();
        String[][] saTable = new String[][]{{mySettings.getMsgHandler().getTexts().getMessageText("NOTE_NOTES"), "" + hMsg.getNumNotes()}, {mySettings.getMsgHandler().getTexts().getMessageText("WARN_WARNINGS"), "" + hMsg.getNumWarnings()}, {mySettings.getMsgHandler().getTexts().getMessageText("ERR_ERRORS"), "" + hMsg.getNumErrors()}};
        int iMaxLabel = 0;
        int iMaxValue = 0;
        int i = 0;
        while (i < saTable.length) {
            int iCurLen = saTable[i][0].length();
            if (iCurLen > iMaxLabel) {
                iMaxLabel = iCurLen;
            }
            if ((iCurLen = saTable[i][1].length()) > iMaxValue) {
                iMaxValue = iCurLen;
            }
            ++i;
        }
        SystemUtils.println(String.valueOf(mySettings.getMsgHandler().getTexts().getMessageText("MSG_SUMMARY")) + ":");
        SystemUtils.println();
        i = 0;
        while (i < saTable.length) {
            String sPadLabel = "";
            String sPadValue = "";
            int iCurLen = saTable[i][0].length();
            if (iCurLen < iMaxLabel) {
                sPadLabel = AutoDocStringUtils.repeat(" ", iMaxLabel - iCurLen);
            }
            if ((iCurLen = saTable[i][1].length()) < iMaxValue) {
                sPadValue = AutoDocStringUtils.repeat(" ", iMaxValue - iCurLen);
            }
            SystemUtils.println(String.valueOf(saTable[i][0]) + sPadLabel + ": " + sPadValue + saTable[i][1]);
            ++i;
        }
    }

    public static AutoDocSettings getSettings() {
        return mySettings;
    }

    public static void applyDefaultSettings() {
        String sTmp = "";
        sTmp = mySettings.getOutPath();
        if (!sTmp.equals("")) {
            mySettings.setOutPath(FileUtils.toCanonicalPath(sTmp), false);
        }
        if (!(sTmp = mySettings.getTemplateDir()).equals("")) {
            mySettings.setTemplateDir(FileUtils.toCanonicalPath(sTmp), false);
        }
        if (!(sTmp = mySettings.getStyleDefFile()).equals("")) {
            String sTmp2 = FileUtils.toCanonicalPath(sTmp);
            if (!mySettings.isHTMLType() && !FileUtils.fileExist(sTmp2)) {
                sTmp2 = sTmp;
            }
            mySettings.setStyleDefFile(sTmp2, false);
        }
        if (!(sTmp = mySettings.getHeaderInsFile()).equals("")) {
            mySettings.setHeaderInsFile(FileUtils.toCanonicalPath(sTmp));
        }
        if (!(sTmp = mySettings.getFootInsFile()).equals("")) {
            mySettings.setFootInsFile(FileUtils.toCanonicalPath(sTmp));
        }
        if (mySettings.getResDir().equals("")) {
            mySettings.setResDir(String.valueOf(ProgDir) + "/res", false);
        }
        if (mySettings.getTemplateDir().equals("")) {
            mySettings.setTemplateDir(String.valueOf(ProgDir) + "/templates", false);
        }
        if (mySettings.getTitle().equals("")) {
            mySettings.setTitle("Documentation");
        }
        if (mySettings.getLocale().equals("")) {
            mySettings.setLocale("en");
        }
        if (mySettings.getOrgDocTypeString().equals("")) {
            mySettings.setDocType("itreeframes");
        }
        String sTemplFile = "";
        if (mySettings.isHTMLType() && mySettings.getStyleDefFile().equals("")) {
            sTemplFile = mySettings.isEpubType() ? String.valueOf(mySettings.getTemplateDir()) + "/Autodoc_Epub.css" : String.valueOf(mySettings.getTemplateDir()) + "/Autodoc.css";
        }
        if (mySettings.getStyleDefFile().equals("") && !sTemplFile.equals("")) {
            mySettings.setStyleDefFile(sTemplFile, false);
        }
    }

    public static InputStream getResourceAsStream(String sName, String sDefault) {
        InputStream isDict = null;
        String sLocDict = String.valueOf(mySettings.getResDir()) + sName;
        String sDefDict = String.valueOf(mySettings.getResDir()) + sDefault;
        File fLocDict = FileUtils.getAbsoluteFile(sLocDict);
        File fDefDict = FileUtils.getAbsoluteFile(sDefDict);
        if (FileUtils.fileExist(sLocDict)) {
            try {
                isDict = new FileInputStream(fLocDict);
            }
            catch (IOException iOException) {}
        } else if (!sDefault.equals("") && FileUtils.fileExist(sDefDict)) {
            try {
                isDict = new FileInputStream(fDefDict);
                String[] saNotePara = new String[]{sLocDict, sDefDict};
                mySettings.getMsgHandler().outputNote("NOTE_RESLOAD", saNotePara);
            }
            catch (IOException iOException) {}
        } else {
            isDict = AutoDoc.getResourceAsStreamFromJar(sName, sDefault);
        }
        return isDict;
    }

    public static InputStream getResourceAsStreamFromJar(String sName, String sDefault) {
        InputStream isDict;
        String sResName = "/res" + sName;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.enache.AutoDoc.AutoDoc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((isDict = clazz.getResourceAsStream(sResName)) == null && !sDefault.equals("")) {
            sResName = "/res" + sDefault;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("de.enache.AutoDoc.AutoDoc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            isDict = clazz2.getResourceAsStream(sResName);
        }
        if (isDict == null) {
            String sLocDict = String.valueOf(ProgDir) + "/res" + sName;
            String sDefDict = String.valueOf(ProgDir) + "/res" + sDefault;
            File fLocDict = FileUtils.getAbsoluteFile(sLocDict);
            File fDefDict = FileUtils.getAbsoluteFile(sDefDict);
            if (FileUtils.fileExist(sLocDict)) {
                try {
                    isDict = new FileInputStream(fLocDict);
                }
                catch (IOException iOException) {}
            } else if (!sDefault.equals("") && FileUtils.fileExist(sDefDict)) {
                try {
                    isDict = new FileInputStream(fDefDict);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return isDict;
    }

    public static String genJarFilename() {
        int iSecond;
        String sJarFilename = Version;
        int iFirst = sJarFilename.indexOf(46);
        if (iFirst >= 0 && iFirst < sJarFilename.length() - 1 && (iSecond = sJarFilename.indexOf(46, iFirst + 1)) >= 0) {
            sJarFilename = sJarFilename.substring(0, iSecond);
        }
        sJarFilename = String.valueOf(BaseProgName) + "_" + sJarFilename.replaceAll("\\.", "_") + ".jar";
        return sJarFilename;
    }

    public static String getCfgFileName(String[] args) {
        String sCfgFile = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-cfg")) {
                if (++i >= args.length) break;
                sCfgFile = FileUtils.toCanonicalPath(args[i]);
                break;
            }
            ++i;
        }
        return sCfgFile;
    }

    public static String getProgramDir() {
        String sResult = "";
        try {
            String decodedPath;
            URL url;
            String sURL;
            URI uri;
            String sFilename = "";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.enache.AutoDoc.AutoDoc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((uri = new URI(sURL = (url = clazz.getProtectionDomain().getCodeSource().getLocation()).toString())).getAuthority() != null && uri.getAuthority().length() > 0) {
                URL url2 = new URL("file://" + sURL.substring("file:".length()));
                String sURL2 = url2.toString();
                uri = new URI(sURL2);
                sFilename = uri.getPath();
            } else {
                sFilename = uri.getPath();
            }
            File jarfile = new File(sFilename);
            sResult = decodedPath = FileUtils.toCanonicalPath(jarfile.getParentFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sResult;
    }

    public static void doProcess(AutoDocSettings mySettings) {
        AutoDocDocument myDoc = new AutoDocDocument(mySettings);
        myDoc.doProcess(mySettings.getInputPath());
        AutoDocOutput myOut = AutoDocOutput.getOutputClass(myDoc, mySettings);
        if (myOut != null) {
            myOut.doOutput();
        }
    }

    public static void initPlugins() {
        ArrayList lPlugins = AutoDocPluginUtils.loadAllPlugins(ProgDir, mySettings, Version, true);
        mySettings.setPluginList(lPlugins);
    }
}

