/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zipDirectory(String sZipFile, String sDir, boolean isRoot) throws IOException {
        ZipUtils.zipDirectory(sZipFile, sDir, isRoot, 8);
    }

    public static void zipDirectory(String sZipFile, String sDir, boolean isRoot, int iMethod) throws IOException {
        File fOut = new File(sZipFile);
        File fDir = new File(sDir);
        String sRoot = "";
        if (!isRoot) {
            sRoot = String.valueOf(fDir.getName()) + "/";
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fOut));
        ZipUtils.addDirectory(out, sDir, sRoot, iMethod);
        out.close();
    }

    public static void unzipDirectory(String sZipFile, String sDir, boolean isRoot) throws IOException {
        byte[] buffer = new byte[1024];
        File fDir = new File(sDir);
        if (!isRoot) {
            String sTmp = "~" + sZipFile;
            int iPos = sZipFile.lastIndexOf(46);
            if (iPos >= 0 && iPos < sZipFile.length() - 1) {
                sTmp = sZipFile.substring(0, iPos);
            }
            File fTmp = new File(sTmp);
            fDir = new File(fDir, fTmp.getName());
            sDir = fDir.getAbsolutePath();
        }
        if (!fDir.exists()) {
            fDir.mkdirs();
        }
        ZipFile fZip = new ZipFile(new File(sZipFile));
        Enumeration<? extends ZipEntry> en1 = fZip.entries();
        while (en1.hasMoreElements()) {
            ZipEntry ze = en1.nextElement();
            InputStream zis = fZip.getInputStream(ze);
            String fileName = ze.getName();
            File newFile = new File(String.valueOf(sDir) + "/" + fileName);
            if (fileName.endsWith("/")) {
                newFile.mkdirs();
                continue;
            }
            File parent = new File(newFile.getParent());
            parent.mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            int len = zis.read(buffer);
            while (len > 0) {
                fos.write(buffer, 0, len);
                len = zis.read(buffer);
            }
            fos.close();
        }
        fZip.close();
    }

    public static long getNumZipEntries(String sZipFile) {
        long lResult = 0L;
        try {
            ZipFile f = new ZipFile(new File(sZipFile));
            Enumeration<? extends ZipEntry> en = f.entries();
            while (en.hasMoreElements()) {
                en.nextElement();
                ++lResult;
            }
            f.close();
        }
        catch (IOException e) {
            lResult = -1L;
        }
        return lResult;
    }

    public static String compareZipFilesEqual(String sZipFile1, String sZipFile2) {
        long lNum2;
        long lNum1;
        boolean bTmp;
        String sResult;
        block11: {
            block10: {
                sResult = "";
                bTmp = true;
                lNum1 = ZipUtils.getNumZipEntries(sZipFile1);
                lNum2 = ZipUtils.getNumZipEntries(sZipFile2);
                if (lNum1 >= 0L) break block10;
                return "An error occurred reading from first file.";
            }
            if (lNum2 >= 0L) break block11;
            return "An error occurred reading from second file.";
        }
        try {
            if (lNum1 != lNum2) {
                return "First file has " + lNum1 + " entries but second file has " + lNum2 + " entries.";
            }
            ZipFile f1 = new ZipFile(new File(sZipFile1));
            Enumeration<? extends ZipEntry> en1 = f1.entries();
            while (bTmp && en1.hasMoreElements()) {
                ZipEntry ze1 = en1.nextElement();
                String sCur1 = ze1.getName();
                InputStream is1 = f1.getInputStream(ze1);
                ZipFile f2 = new ZipFile(new File(sZipFile2));
                InputStream is2 = null;
                String sCur2 = "";
                Enumeration<? extends ZipEntry> en2 = f2.entries();
                while (en2.hasMoreElements()) {
                    ZipEntry ze2 = en2.nextElement();
                    sCur2 = ze2.getName();
                    if (!sCur1.equals(sCur2)) continue;
                    is2 = f2.getInputStream(ze2);
                    break;
                }
                if (sCur1.equals(sCur2)) {
                    bTmp = ZipUtils.compareISEqual(is1, is2);
                    is2.close();
                    if (!bTmp) {
                        sResult = "Zip entries \"" + sCur1 + "\" are not equal.";
                    }
                } else {
                    sResult = "Zip entry \"" + sCur1 + "\" not found in second file.";
                }
                f2.close();
            }
            f1.close();
        }
        catch (IOException e) {
            sResult = "Error reading from file.";
        }
        return sResult;
    }

    public static String compareZipFilesEqualStrict(String sZipFile1, String sZipFile2) {
        String sResult = "";
        try {
            boolean bTmp = true;
            ZipFile f1 = new ZipFile(new File(sZipFile1));
            ZipFile f2 = new ZipFile(new File(sZipFile2));
            Enumeration<? extends ZipEntry> en1 = f1.entries();
            Enumeration<? extends ZipEntry> en2 = f2.entries();
            while (bTmp && en1.hasMoreElements() && en2.hasMoreElements()) {
                ZipEntry ze1 = en1.nextElement();
                ZipEntry ze2 = en2.nextElement();
                bTmp = ZipUtils.compareISEqual(f1.getInputStream(ze1), f2.getInputStream(ze2));
                if (bTmp) continue;
                sResult = "Zip entries " + ze1.getName() + " and " + ze2.getName() + " are not equal.";
            }
            if (bTmp) {
                if (en1.hasMoreElements()) {
                    sResult = "First file has more elements than second file.";
                } else if (en2.hasMoreElements()) {
                    sResult = "Second file has more elements than first file.";
                }
            }
            f1.close();
            f2.close();
        }
        catch (IOException e) {
            sResult = "Error reading from file.";
        }
        return sResult;
    }

    public static void addDirectory(ZipOutputStream out, String sDir, String sParent, int iMethod) throws IOException {
        File fDir = new File(sDir);
        if (fDir.exists() && fDir.isDirectory()) {
            File[] fa = fDir.listFiles();
            if (fa.length > 0) {
                int i = 0;
                while (i < fa.length) {
                    File fCur = fa[i];
                    if (fCur.isDirectory()) {
                        ZipUtils.addDirectory(out, fCur.getAbsolutePath(), String.valueOf(sParent) + fCur.getName() + "/", iMethod);
                    } else {
                        ZipUtils.addToZipOutputStream(out, String.valueOf(sParent) + fCur.getName(), fCur, iMethod);
                    }
                    ++i;
                }
            } else {
                out.putNextEntry(new ZipEntry(sParent));
            }
        }
    }

    public static void addToZipOutputStream(ZipOutputStream out, String sEntry, File f, int iMethod) throws IOException {
        ZipEntry curEntry = new ZipEntry(sEntry);
        if (iMethod == 0) {
            long lSize = f.length();
            curEntry.setSize(lSize);
            curEntry.setCompressedSize(lSize);
            CRC32 checksum = ZipUtils.getCRC32(f);
            curEntry.setCrc(checksum.getValue());
        }
        curEntry.setMethod(iMethod);
        out.putNextEntry(curEntry);
        ZipUtils.writeFileToOutputStream(out, f);
        out.closeEntry();
    }

    public static CRC32 getCRC32(File f) throws IOException {
        CRC32 checksum = new CRC32();
        checksum.reset();
        if (f.exists() && f.isFile()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                checksum.update(buf, 0, len);
            }
            ((InputStream)in).close();
        }
        return checksum;
    }

    public static void writeFileToOutputStream(OutputStream out, File f) throws IOException {
        if (f.exists() && f.isFile()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            byte[] buf = new byte[1024];
            int len = ((InputStream)in).read(buf);
            while (len > 0) {
                out.write(buf, 0, len);
                len = ((InputStream)in).read(buf);
            }
            ((InputStream)in).close();
        }
    }

    public static boolean compareISEqual(InputStream in1, InputStream in2) throws IOException {
        boolean bResult = true;
        int iBuffSize = 1024;
        byte[] buff1 = new byte[1024];
        byte[] buff2 = new byte[1024];
        int iNumRead1 = in1.read(buff1, 0, 1024);
        int iNumRead2 = in2.read(buff2, 0, 1024);
        while (iNumRead1 > 0 || iNumRead2 > 0) {
            if (iNumRead1 != iNumRead2) {
                bResult = false;
                break;
            }
            int i = 0;
            while (i < iNumRead1) {
                if (buff1[i] != buff2[i]) {
                    bResult = false;
                    break;
                }
                ++i;
            }
            iNumRead1 = in1.read(buff1, 0, 1024);
            iNumRead2 = in2.read(buff2, 0, 1024);
        }
        return bResult;
    }
}

