/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class SystemUtils {
    public static synchronized void print(String s) {
        if (Thread.currentThread().isInterrupted()) {
            throw new Error("Thread interupted");
        }
        System.out.print(s);
        Thread.yield();
    }

    public static synchronized void println() {
        if (Thread.currentThread().isInterrupted()) {
            throw new Error("Thread interupted");
        }
        System.out.println();
        Thread.yield();
    }

    public static synchronized void println(String s) {
        if (Thread.currentThread().isInterrupted()) {
            throw new Error("Thread interupted");
        }
        System.out.println(s);
        Thread.yield();
    }

    public static String getStackTrace(Throwable e) {
        String sResult = "";
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sResult = sw.toString();
        }
        return sResult;
    }

    public static void downloadFile(String sURL, String sOutDir, int iConnectTimeout, int iReadTimeout) throws Error {
        File fOutDir;
        String sFilename = "";
        int iLastSep = sURL.lastIndexOf(47);
        if (iLastSep >= 0) {
            sFilename = sURL.substring(iLastSep + 1);
        }
        if (!(fOutDir = new File(sOutDir)).exists()) {
            fOutDir.mkdirs();
        }
        if (fOutDir.exists() && fOutDir.isDirectory()) {
            try {
                URL url = new URL(sURL);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                HttpURLConnection.setFollowRedirects(false);
                huc.setConnectTimeout(iConnectTimeout);
                huc.setReadTimeout(iReadTimeout * 1000);
                huc.connect();
                File fOut = new File(sOutDir, sFilename);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fOut));
                InputStream in = huc.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                byte[] buf = new byte[1024];
                int iNumRead = bin.read(buf);
                while (iNumRead > 0) {
                    out.write(buf, 0, iNumRead);
                    iNumRead = bin.read(buf);
                }
                in.close();
                huc.disconnect();
                out.close();
            }
            catch (IOException e) {
                throw new Error("Error downloading file " + sURL + ".");
            }
        } else {
            throw new Error("Invalid output directory " + sOutDir + ".");
        }
    }
}

