/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.HTML;

import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocListItem;
import de.enache.AutoDoc.AutoDocOutput;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public abstract class AutoDocHTMLOut
extends AutoDocOutput {
    protected String HeadInsFileStr = "";
    protected String FootInsFileStr = "";
    protected String CSSFile = "";
    protected String FileTemplateStr = "";
    protected String IndexTemplateStr = "";
    protected String CHMProj = "";
    protected ArrayList vDeletePattern = new ArrayList();
    protected String TargetWinMain = "Main";
    protected String TargetWinExt = "_NEW_";
    protected String sListStandaloneClass = "ListTreeStandalone";

    protected AutoDocHTMLOut(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
        this.CSSFile = mySettings.getStyleDefFile();
        this.HeadInsFileStr = this.ascFileToString(mySettings.getHeaderInsFile());
        this.FootInsFileStr = this.ascFileToString(mySettings.getFootInsFile());
        this.FileTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_File.htm"));
        this.IndexTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_Index.htm"));
        this.sRefFileName = "Autodoc_Ref.htm";
        this.sFuncIndexFileName = "Autodoc_Func.htm";
        this.CHMProj = mySettings.getCHMProj();
        this.declareDeletePatterns();
    }

    public void declareDeletePatterns() {
        String sResDir;
        File fRes;
        String sTemplate;
        this.vDeletePattern.add("index.htm");
        this.vDeletePattern.add("Autodoc_*.htm");
        this.vDeletePattern.add("Autodoc.css");
        this.vDeletePattern.add(this.sRefFileName);
        this.vDeletePattern.add("TreeExpanded.gif");
        this.vDeletePattern.add("TreeCollapsed.gif");
        this.vDeletePattern.add("Treeview.js");
        this.vDeletePattern.add("*.hhp");
        this.vDeletePattern.add("*.hhc");
        this.vDeletePattern.add("*.hhk");
        String sLogo = this.mySettings.getLogo();
        if (!sLogo.equals("")) {
            File fLogo = new File(sLogo);
            this.vDeletePattern.add(fLogo.getName());
        }
        if (!(sTemplate = this.mySettings.getTemplateDir()).equals("") && (fRes = new File(sResDir = String.valueOf(sTemplate = FileUtils.toCanonicalPath(sTemplate)) + "/res")).exists() && fRes.isDirectory()) {
            File[] fList = fRes.listFiles();
            int i = 0;
            while (i < fList.length) {
                this.vDeletePattern.add(fList[i].getName());
                ++i;
            }
        }
    }

    protected void prepareOutputLoop() {
        File fDir = new File(this.Outpath);
        if (!fDir.exists()) {
            fDir.mkdirs();
        } else {
            if (!fDir.isDirectory()) {
                throw new Error(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTDIRINVALID", this.Outpath));
            }
            this.cleanOutDir();
        }
        this.copyResources();
        this.copyTemplateFiles();
    }

    public void copyTemplateFile(String sTemplateName, String sOutpath) {
        String sTemplFilename = this.getTemplatePath(sTemplateName);
        try {
            FileUtils.copy(sTemplFilename, String.valueOf(sOutpath) + "/" + sTemplateName);
        }
        catch (Exception e) {
            SystemUtils.println(e.getMessage());
        }
    }

    public void copyResources() {
        String sResDir = String.valueOf(this.mySettings.getTemplateDir()) + "/res";
        try {
            FileUtils.copyDir(sResDir, this.Outpath);
        }
        catch (IOException e) {
            SystemUtils.println(e.getMessage());
        }
    }

    public void copyTemplateFiles() {
        String sCSS = "Autodoc.css";
        try {
            FileUtils.copy(this.CSSFile, String.valueOf(this.Outpath) + "/" + sCSS);
        }
        catch (Exception e) {
            if (!this.mySettings.getOrgStyleDefFile().equals("")) {
                this.mySettings.getMsgHandler().outputNote("NOTE_OUTCOPYTEMPLATEFAILED", this.CSSFile);
            }
            this.copyTemplateFile(sCSS, this.Outpath);
        }
        String sLogo = this.mySettings.getLogo();
        try {
            if (!sLogo.equals("")) {
                File fTmp = new File(sLogo);
                String sShortName = fTmp.getName();
                String sAbsName = FileUtils.toCanonicalPath(fTmp);
                FileUtils.copy(sAbsName, String.valueOf(this.Outpath) + "/" + sShortName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mySettings.getMsgHandler().outputNote("WARN_OUTCOPYFILEFAILED", sLogo);
            this.copyTemplateFile(sCSS, this.Outpath);
        }
        this.CSSFile = sCSS;
    }

    public String convertCode(String s, boolean bPreserve) {
        int iCr = s.indexOf("\n");
        String sReturn = !bPreserve && iCr >= 0 ? String.valueOf(this.SysNewLine) + "<code class=\"block\">" + s.replaceFirst("\\s*\\n", "") + this.SysNewLine + "</code>" + this.SysNewLine : (bPreserve ? "<code class=\"block\">" + s.trim() + "</code>" : "<code class=\"inline\">" + s.trim() + "</code>");
        return sReturn;
    }

    public String convertBold(String s) {
        return "<b>" + s + "</b>";
    }

    public String convertItalic(String s) {
        return "<i>" + s + "</i>";
    }

    public String convertEmphasized(String s) {
        return "<em>" + s + "</em>";
    }

    public String convertTrueType(String s) {
        return "<tt>" + s + "</tt>";
    }

    public String convertStrikeThrough(String s) {
        return "<s>" + s + "</s>";
    }

    public String convertUnderline(String s) {
        return "<u>" + s + "</u>";
    }

    public String convertNewLine() {
        return "<br />";
    }

    public String convertSingleQuote() {
        return "'";
    }

    public String convertDoubleQuote() {
        return "&quot;";
    }

    public String convertImage(String sImgFileName, String sOrientation) {
        String sReturn = "<img src=\"" + sImgFileName + "\" class=\"" + sOrientation + "\" />";
        return sReturn;
    }

    protected String convertLinkToString(String sLink, String sLabel, String sTarget, boolean bURL) {
        if (bURL) {
            try {
                URL url = new URL(sLink);
                sLink = url.toString();
            }
            catch (MalformedURLException e) {
                sLink = "file:///" + sLink.replaceAll("\\\\", "/");
            }
        }
        if (sTarget.equals("")) {
            return "<a href=\"" + sLink + "\">" + sLabel + "</a>";
        }
        return "<a href=\"" + sLink + "\" target=\"" + sTarget + "\">" + sLabel + "</a>";
    }

    public String convertLinkToStringInternal(String sLink, String sLabel, boolean bURL) {
        return this.convertLinkToString(sLink, sLabel, "", bURL);
    }

    public String convertLinkToStringNavigation(String sLink, String sLabel, boolean bURL) {
        return this.convertLinkToString(sLink, sLabel, this.TargetWinMain, bURL);
    }

    public String convertLinkToStringExternal(String sLink, String sLabel, boolean bURL) {
        return this.convertLinkToString(sLink, sLabel, this.TargetWinExt, bURL);
    }

    public String generateLinkAnchor(String sName) {
        return "<a id=\"" + sName + "\" name=\"" + sName + "\"></a>";
    }

    public String generateSectionLinkLabel(String sOutFileName, String sSectionName) {
        return String.valueOf(sOutFileName) + "_" + sSectionName;
    }

    public String convertParagraphs(String s) {
        String sTmp = s;
        if (!this.SysNewLine.equals("\n")) {
            sTmp = AutoDocStringUtils.replaceAll(s, this.SysNewLine, "\n");
        }
        String sResult = sTmp.replaceAll("[ \\t\\x0B\\f\\r]*\\n[ \\t\\x0B\\f\\r]*\\n[ \\t\\x0B\\f\\r]*", "</p><p>");
        if (!this.SysNewLine.equals("\n")) {
            sResult = AutoDocStringUtils.replaceAll(sResult, "\n", this.SysNewLine);
        }
        return sResult;
    }

    public String convertItemList(ArrayList vItems) {
        String sReturn = "";
        boolean bListOpen = false;
        int iType = 0;
        int i = 0;
        while (i < vItems.size()) {
            AutoDocListItem curItem = (AutoDocListItem)vItems.get(i);
            if (curItem.iItemType == 0) {
                if (bListOpen) {
                    sReturn = iType == 1 ? String.valueOf(sReturn) + "</ol>" + this.SysNewLine : String.valueOf(sReturn) + "</ul>" + this.SysNewLine;
                    bListOpen = false;
                }
                sReturn = String.valueOf(sReturn) + curItem.sValue + this.SysNewLine;
            } else if (curItem.iItemType == 1) {
                iType = 1;
                if (!bListOpen) {
                    sReturn = String.valueOf(sReturn) + "<ol>" + this.SysNewLine;
                    bListOpen = true;
                }
                sReturn = String.valueOf(sReturn) + "<li value=\"" + curItem.sMarker + "\">" + curItem.sValue + "</li>" + this.SysNewLine;
            } else {
                iType = 2;
                if (!bListOpen) {
                    sReturn = String.valueOf(sReturn) + "<ul>" + this.SysNewLine;
                    bListOpen = true;
                }
                sReturn = String.valueOf(sReturn) + "<li>" + curItem.sValue + "</li>" + this.SysNewLine;
            }
            ++i;
        }
        if (bListOpen) {
            sReturn = iType == 1 ? String.valueOf(sReturn) + "</ol>" + this.SysNewLine : String.valueOf(sReturn) + "</ul>" + this.SysNewLine;
            bListOpen = false;
        }
        return sReturn;
    }

    public void outputFile(byte[] baRes, String sFullOutFil, String sOrgFile) throws FileNotFoundException, IOException {
        String s1 = this.FileTemplateStr;
        String sCont = new String(baRes);
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sOrgFile;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
        if (this.mySettings.getEnableSearch()) {
            File fTmp = new File(sFullOutFil);
            this.appendToSearchIndex(sCont, fTmp.getName());
        }
    }

    protected void appendToSearchIndex(String s, String sOutFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
    }

    public void processFileHeading(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType) {
        String sLogo = "";
        String sParaLogo = this.mySettings.getLogo();
        if (!sParaLogo.equals("")) {
            File fTmp = new File(sParaLogo);
            sLogo = "<img src=\"" + fTmp.getName() + "\" class=\"logo\" />";
        }
        psOut.println(this.generateLinkAnchor(sOutFil));
        psOut.println(String.valueOf(sLogo) + "<h1 class=\"docsection\">" + this.mySettings.getTitle() + "</h1>");
        if (!sOrgFile.equals("") && !sFileType.equals("")) {
            psOut.println("<h1 class=\"fileheading, clearall\">" + sFileType + ": " + sOrgFile + "</h1>");
        }
    }

    public void processOverview(PrintStream psOut, String sOutFil, int[] iaNumLevel) {
        psOut.println("<h2 class=\"docsection\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_OVERVIEW") + "</h2>");
        psOut.println("<ul>");
        if (iaNumLevel[0] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec1\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_GENERALINFO") + "</a></li>");
        }
        if (iaNumLevel[1] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec2\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTURE") + "</a></li>");
        }
        if (iaNumLevel[2] > 0) {
            psOut.println("<li><a href=\"#" + sOutFil + "_sec3\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONS") + "</a></li>");
        }
        psOut.println("</ul>");
        psOut.println("<p>&nbsp;</p>");
    }

    public String generateOutputFileName(int iIndex) {
        String sOutFil = "Autodoc_" + iIndex + ".htm";
        return sOutFil;
    }

    public void outputIndexFile(String sOutFil) throws IOException {
        String sLogo = "";
        String sParaLogo = this.mySettings.getLogo();
        if (!sParaLogo.equals("")) {
            File fTmp = new File(sParaLogo);
            sLogo = "<img src=\"" + fTmp.getName() + "\" class=\"logo\" />";
        }
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEINDEX", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.IndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        psOut.println(String.valueOf(sLogo) + "<h1 class=\"docsection\">" + this.mySettings.getTitle() + "</h1>");
        this.outputOverView(psOut);
        psOut.println("<hr class=\"docsection\"/>");
        String sCont = baOut.toString();
        psOut.close();
        String sHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sHead;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%INDEXCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void processOverviewHeading(PrintStream psOut) {
        psOut.println("<h2 class=\"docsection, clearall\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_OVERVIEW") + "</h2>");
        psOut.println("<p>");
        psOut.println("<table class=\"index\">");
    }

    public void processOverviewEntry(PrintStream psOut, String sLink, String sDescription) {
        psOut.println("<tr class=\"index\">");
        psOut.print("<td class=\"index\">&bull; " + sLink + "</td>");
        psOut.print("<td class=\"index\">" + sDescription + "</td>");
        psOut.println("</tr>");
    }

    public void processOverviewEnd(PrintStream psOut) {
        psOut.println("</table>");
        psOut.println("</p>");
        psOut.println("<p>&nbsp;</p>");
    }

    public void processStructureHeader(PrintStream psOut, String sTitle, String sTagName, String sRootLabel, String sRootFilnam, String sRootDescription) {
        psOut.println("<hr class=\"docsection\"/>");
        psOut.println(this.generateLinkAnchor(String.valueOf(sTagName) + "_sec2"));
        psOut.println("<h1 class=\"docsection\">" + sTitle + "</h1>");
        psOut.println("<h2>" + sRootLabel + ": " + sRootFilnam + "</h2>");
        psOut.println("<p>" + this.processParam(sRootDescription, true, false) + "</p>");
    }

    public void processStructDetailHead(PrintStream psOut, String curLabel, String sShort, String sDescription) {
        psOut.println("<h3>" + curLabel + ": " + sShort + "</h3>");
        psOut.println("<p>" + this.processParam(sDescription, true, false) + "</p>");
    }

    public void processStructDetailBegin(PrintStream psOut) {
        psOut.println("<div class=\"structdetail\">");
    }

    public void processStructDetailEnd(PrintStream psOut) {
        psOut.println("</div>");
    }

    public void processStructureDetailsHeading(PrintStream psOut) {
        psOut.println("<h2>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_STRUCTUREDETAIL") + "</h2>");
    }

    public void processParamTableBegin(PrintStream psOut, int iNumPara) {
        psOut.println("<table class=\"param\">");
    }

    public void processParamTableEnd(PrintStream psOut) {
        psOut.println("</table>");
    }

    public void processParamRowBegin(PrintStream psOut) {
        psOut.println("<tr class=\"param\">");
    }

    public void processParamCell(PrintStream psOut, String sText, int iNumPara, int iIndex) {
        psOut.print("<td class=\"param\"><p>" + sText + "</p></td>");
    }

    public void processParamSimple(PrintStream psOut, String sText) {
        psOut.println("<p class=\"param\">" + sText + "</p>");
    }

    public void processParamRowEnd(PrintStream psOut) {
        psOut.println("</tr>");
    }

    public void processGroupingTreeTitle(PrintStream psOut, String sTitle) {
        psOut.println("<h2 class=\"docsection\">" + sTitle + "</h2>");
    }

    public void processGroupingTreeBegin(PrintStream psOut, String sIDOrg, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        String sID = "";
        if (iDepth == 0) {
            sID = sIDOrg;
        }
        if (sID.equals("")) {
            psOut.println(String.valueOf(sPad) + "<ul class=\"indexTree\">");
        } else {
            psOut.println(String.valueOf(sPad) + "<ul id=\"" + sID + "\" class=\"indexTree\">");
        }
    }

    public void processGroupingTreeEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + "</ul>");
    }

    public void processGroupingTreeItemBegin(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.print(String.valueOf(sPad) + "<li>");
    }

    public void processGroupingTreeItemEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "</li>");
    }

    public void processGroupingTreeEntry(PrintStream psOut, String sText, boolean bNewLine) {
        if (bNewLine) {
            psOut.println(sText);
        } else {
            psOut.print(sText);
        }
    }

    public void processStructListBegin(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + "<ul class=\"struct\">");
    }

    public void processStructListEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth);
        psOut.println(String.valueOf(sPad) + "</ul>");
    }

    public void processStructItemBegin(PrintStream psOut, String sType, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "<li class=\"struct" + sType + "\">");
    }

    public void processStructItemEnd(PrintStream psOut, String sType, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "</li>");
    }

    public void processStructEntry(PrintStream psOut, String sText, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "  " + sText);
    }

    public void processEmptyParagraph(PrintStream psOut) {
        psOut.println("<p>&nbsp;</p>");
    }

    public String getDoubleQuote() {
        return "&quot;";
    }

    public void processFileLink(PrintStream psOut, AutoDocFile curFile) {
        try {
            String sAbsName = curFile.getAbsoluteFilenameForOutput();
            String sLabel = curFile.getAbsoluteFilenameLabelForOutput();
            URI uri = new File(sAbsName).toURI();
            psOut.println("<p id=\"linktocode\">" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LINKTOCODE") + ": " + this.convertLinkToString(uri.toString(), sLabel, "", false) + "</p>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processFileInfoOutput(PrintStream psOut, String curLabel, String sFilnam, String sDescrOut) {
        psOut.println("<h2>" + curLabel + ": " + sFilnam + "</h2>");
        psOut.println("<p>" + sDescrOut + "</p>");
    }

    public void processFileInfoHeading(PrintStream psOut, String sTitle, String sTagName) {
        psOut.println("<hr class=\"docsection\"/>");
        psOut.println(this.generateLinkAnchor(String.valueOf(sTagName) + "_sec1"));
        psOut.println("<h1 class=\"docsection\">" + sTitle + "</h1>");
    }

    public void processSimpleRowBegin(PrintStream psOut) {
        psOut.print("<tr>");
    }

    public void processSimpleRowEnd(PrintStream psOut) {
        psOut.println("</tr>");
    }

    public void processSimpleTableCell(PrintStream psOut, String sText, int iNumPara, int iIndex) {
        psOut.print("<td>" + sText + "</td>");
    }

    public String createVarSummaryTableHeader() {
        String sHead = "<h2>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARSUM") + "</h2>" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<table class=\"varsum\">" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<tr><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARFIELD") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARTYPE") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + "</th></tr>" + this.SysNewLine;
        return sHead;
    }

    public String createVarIndexTableHeader() {
        String sHead = "<h1>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARINDEX") + "</h1>" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<table class=\"funcsum\">" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<tr><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARFIELD") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_VARTYPE") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILE") + "</th>" + "</tr>" + this.SysNewLine;
        return sHead;
    }

    public String createLibnameSummaryTableHeader() {
        String sHead = "<h2>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMESUM") + "</h2>" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<table class=\"varsum\">" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<tr><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMELOCATION") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMENAME") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_LIBNAMEDEF") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + "</th></tr>" + this.SysNewLine;
        return sHead;
    }

    public void processSummaryTableEnd(PrintStream psOut) {
        psOut.println("</table>");
    }

    public void processIndexListEntryStandalone(PrintStream psOut, String sFilename, String sLabel, String sCSSClass) {
        String sClassIns = "";
        if (!sCSSClass.equals("")) {
            sClassIns = " class=\"" + sCSSClass + "\"";
        }
        psOut.println("<ul" + sClassIns + ">");
        psOut.println("<li>" + this.convertLinkToStringNavigation(sFilename, sLabel, false) + "</li>");
        psOut.println("</ul>");
    }

    public String createFuncSummaryTableHeader() {
        String sHead = "<h2>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONSSUM") + "</h2>" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<table class=\"funcsum\">" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<tr><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCMETHMAC") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTYPE") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + "</th></tr>" + this.SysNewLine;
        return sHead;
    }

    public String createFuncIndexTableHeader() {
        String sHead = "<h1>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFUNCINDEX") + "</h1>" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<table class=\"funcsum\">" + this.SysNewLine;
        sHead = String.valueOf(sHead) + "<tr><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCMETHMAC") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTYPE") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_DESCRIPTION") + "</th><th>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILE") + "</th>" + "</tr>" + this.SysNewLine;
        return sHead;
    }

    public void processLocalRefTableCell(PrintStream psOut, String sLink, String sText, int iNumPara, int iIndex) {
        psOut.print("<td><a href=\"" + sLink + "\">" + sText + "</a></td>");
    }

    public void processRefTableCell(PrintStream psOut, String sOutFile, String sLink, String sText, int iNumPara, int iIndex) {
        psOut.print("<td><a href=\"" + sOutFile + "#" + sLink + "\">" + sText + "</a></td>");
    }

    public void processFuncDetailFuncHead(PrintStream psOut, String curLabel, String sFuncDef, String sDescription, String sLinkLabel) {
        psOut.println(this.generateLinkAnchor(sLinkLabel));
        psOut.println("<h3>" + curLabel + ": " + sFuncDef + "</h3>");
        psOut.println("<p>" + this.processParam(sDescription, true, false) + "</p>");
    }

    public void processFuncDetailBegin(PrintStream psOut) {
        psOut.println("<div class=\"funcdetail\">");
    }

    public void processFuncDetailEnd(PrintStream psOut) {
        psOut.println("</div>");
    }

    public void processFunctionDetailsHeading(PrintStream psOut) {
        psOut.println("<h2>" + this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTLABEL_FUNCTIONSDETAIL") + "</h2>");
    }

    public void processFuncSectionHeader(PrintStream psOut, String sTitle, String sTagName) {
        psOut.println("<hr class=\"docsection\"/>");
        psOut.println(this.generateLinkAnchor(String.valueOf(sTagName) + "_sec3"));
        psOut.println("<h1 class=\"docsection\">" + sTitle + "</h1>");
    }

    public void processClassHeader(PrintStream psOut, String sCurClass, String sDescription, String sClassLabel, String sTagName) {
        String sDescOut = this.processParam(sDescription, true, false);
        psOut.println(this.generateLinkAnchor(sCurClass));
        psOut.println("<h2 class=\"docsection\">" + sClassLabel + ": " + sCurClass + "</h2>");
        psOut.println("<p>" + sDescOut + "</p>");
    }

    public void processSubTagHeading(PrintStream psOut, String curLabel) {
        psOut.println("<h4>" + curLabel + "</h4>");
    }

    public void processSubTagBegin(PrintStream psOut, String curTag) {
        psOut.println("<div class=\"subtag " + curTag + "\">");
    }

    public void processSubTagEnd(PrintStream psOut) {
        psOut.println("</div>");
    }

    public void outputBibFile(String sOutFil) throws IOException {
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEBIB", sOutFil));
            String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
            String s1 = this.FileTemplateStr;
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream(baOut);
            this.processFileHeading(psOut, sOutFil, "", "");
            String sBibHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
            this.processAllBibEntries(psOut, sBibHead, sOutFil);
            String sCont = baOut.toString();
            psOut.close();
            String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sBibHead;
            s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
            s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
            s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENT%", sCont);
            s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
            psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
            psOut.print(s1);
            psOut.close();
            if (psOut.checkError()) {
                throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
            }
        }
    }

    public void processBibHeading(PrintStream psOut, String sBibHead) {
        psOut.println("<h1>" + sBibHead + "</h1>");
    }

    public void processBibBegin(PrintStream psOut) {
        psOut.println("<div class=\"bib param\">");
        psOut.println("  <table class=\"param\">");
    }

    public void processBibEnd(PrintStream psOut) {
        psOut.println("  </table>");
        psOut.println("</div>");
    }

    public void processBibEntry(PrintStream psOut, int iEntryIndex, String sKey, String sEntry) {
        psOut.println("    " + this.generateLinkAnchor(this.createXRefAnchor(this.sRefFileName, sKey)));
        psOut.print("    <tr class=\"param\">");
        psOut.print("<td class=\"param\"><p>[" + iEntryIndex + "]</p>" + "</td>");
        psOut.print("<td class=\"param\"><p>" + sEntry + " {" + sKey + "}" + "</p>" + "</td>");
        psOut.println("</tr>");
    }

    public void outputFuncIndexFile(String sOutFil) throws IOException {
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEFUNCINDEX", sOutFil));
            String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
            String s1 = this.FileTemplateStr;
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream(baOut);
            this.processFileHeading(psOut, sOutFil, "", "");
            this.processAllVarEntries(psOut, sOutFil);
            this.processAllFuncEntries(psOut, sOutFil);
            String sCont = baOut.toString();
            psOut.close();
            String sIndexHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
            String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sIndexHead;
            s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
            s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
            s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENT%", sCont);
            s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
            psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
            psOut.print(s1);
            psOut.close();
            if (psOut.checkError()) {
                throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
            }
        }
    }

    public void cleanOutDir() {
        SystemUtils.println();
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCLEANOUTDIR", this.Outpath));
        this.cleanDir(this.Outpath);
    }

    public void cleanDir(String sDir) {
        File fOutPath = new File(sDir);
        if (fOutPath.exists() && fOutPath.isDirectory()) {
            File[] fList = fOutPath.listFiles();
            int i = 0;
            while (i < fList.length) {
                String sSimpleFileName = fList[i].getName();
                if (!fList[i].isDirectory() && !fList[i].isHidden()) {
                    boolean bMatching = false;
                    int j = 0;
                    while (j < this.vDeletePattern.size()) {
                        if (AutoDocStringUtils.isMatch(sSimpleFileName, (String)this.vDeletePattern.get(j))) {
                            bMatching = true;
                            break;
                        }
                        ++j;
                    }
                    if (bMatching) {
                        fList[i].delete();
                    } else {
                        this.mySettings.getMsgHandler().outputNote("NOTE_UNKNOWNDELETEFILE", sSimpleFileName);
                    }
                } else {
                    String sCurFile = FileUtils.toCanonicalPath(fList[i]);
                    if (sSimpleFileName.equals("images")) {
                        FileUtils.cleanDir(sCurFile);
                    }
                    fList[i].delete();
                }
                ++i;
            }
        }
    }
}

