/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Hashtable;

public class FileUtils {
    public static void copy(String src, String dest) throws FileNotFoundException, IOException {
        int len;
        File f1 = new File(src);
        File f2 = new File(dest);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f1));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f2));
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void copyDir(String sSrcDir, String sOutDir) throws IOException {
        File fTempl = new File(sSrcDir);
        File fOut = new File(sOutDir);
        if (!fOut.exists()) {
            fOut.mkdirs();
        }
        if (fTempl.exists() && fTempl.isDirectory()) {
            File[] aFiles = fTempl.listFiles();
            int i = 0;
            while (i < aFiles.length) {
                String sCurFile;
                if (!aFiles[i].isDirectory() && !aFiles[i].isHidden()) {
                    sCurFile = FileUtils.toCanonicalPath(aFiles[i]);
                    FileUtils.copy(sCurFile, String.valueOf(sOutDir) + "/" + aFiles[i].getName());
                } else if (!aFiles[i].isHidden()) {
                    sCurFile = FileUtils.toCanonicalPath(aFiles[i]);
                    FileUtils.copyDir(sCurFile, String.valueOf(sOutDir) + "/" + aFiles[i].getName());
                }
                ++i;
            }
        }
    }

    public static String toAbsolutePath(String s) {
        String sResult = "";
        if (!s.equals("")) {
            File f = new File(s);
            sResult = f.getAbsolutePath();
        }
        return sResult;
    }

    public static String toAbsolutePath(File f) {
        String sResult = "";
        if (f != null) {
            sResult = f.getAbsolutePath();
        }
        return sResult;
    }

    public static String toCanonicalPath(String s) {
        String sResult = "";
        if (!s.equals("")) {
            File f = new File(s);
            sResult = FileUtils.toCanonicalPath(f);
        }
        return sResult;
    }

    public static String toCanonicalPath(File f) {
        String sResult = "";
        if (f != null) {
            try {
                sResult = f.getCanonicalPath();
            }
            catch (IOException e) {
                sResult = f.getAbsolutePath();
            }
        }
        return sResult;
    }

    public static void cleanDir(String sDir) {
        File fOutPath = new File(sDir);
        if (fOutPath.exists() && fOutPath.isDirectory()) {
            File[] fList = fOutPath.listFiles();
            int i = 0;
            while (i < fList.length) {
                File fCur = fList[i];
                if (!fCur.isDirectory()) {
                    fCur.delete();
                } else {
                    String sCurFile = FileUtils.toCanonicalPath(fCur);
                    if (!sCurFile.equals("")) {
                        FileUtils.cleanDir(sCurFile);
                    }
                    fList[i].delete();
                }
                ++i;
            }
        }
    }

    public static void deleteDir(String sDir) {
        File fDir = new File(sDir);
        if (fDir.exists() && fDir.isDirectory()) {
            FileUtils.cleanDir(sDir);
            fDir.delete();
        }
    }

    public static void deleteFile(String sFile) {
        File fTmp = new File(sFile);
        fTmp.delete();
    }

    public static String getFileNameExtension(String sFilename) {
        String sReturn = "";
        int iPos = sFilename.lastIndexOf(46);
        if (iPos >= 0 && iPos < sFilename.length() - 1) {
            sReturn = sFilename.substring(iPos + 1, sFilename.length());
        }
        return sReturn;
    }

    public static String removeFileNameExtension(String sFilename) {
        String sReturn = "";
        int iPos = sFilename.lastIndexOf(46);
        if (iPos >= 0) {
            sReturn = sFilename.substring(0, iPos);
        }
        return sReturn;
    }

    public static File getAbsoluteFile(String sFilename) {
        return new File(sFilename).getAbsoluteFile();
    }

    public static boolean fileExist(String sFilename) {
        boolean bResult = false;
        File f = FileUtils.getAbsoluteFile(sFilename);
        try {
            FileInputStream is = new FileInputStream(f);
            bResult = true;
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bResult;
    }

    public static boolean dirExist(String sFilename) {
        boolean bResult = false;
        File f = FileUtils.getAbsoluteFile(sFilename);
        if (f.exists() && f.isDirectory()) {
            bResult = true;
        }
        return bResult;
    }

    public static boolean isCaseSensitivePath() {
        boolean bResult = true;
        String sDir = System.getProperty("user.dir");
        File f1 = new File(sDir.toLowerCase());
        File f2 = new File(sDir.toUpperCase());
        if (f1.exists() && f2.exists()) {
            bResult = false;
        }
        return bResult;
    }

    public static String ascFileToString(String sFile, String sCharset) throws IOException {
        String sReturn = "";
        if (!sFile.equals("")) {
            InputStreamReader fi = new InputStreamReader(new FileInputStream(sFile));
            if (sCharset != null && !sCharset.equals("")) {
                fi.close();
                fi = new InputStreamReader((InputStream)new FileInputStream(sFile), sCharset);
            }
            BufferedReader in = new BufferedReader(fi);
            String sCurLine = null;
            while ((sCurLine = in.readLine()) != null) {
                sReturn = String.valueOf(sReturn) + sCurLine + System.getProperty("line.separator");
            }
            in.close();
        }
        return sReturn;
    }

    public static String ascFileToString(String sFile) throws IOException {
        return FileUtils.ascFileToString(sFile, "");
    }

    public static String ascFileToString(InputStream isFile, String sCharset) throws IOException {
        String sReturn = "";
        if (isFile != null) {
            InputStreamReader isR = new InputStreamReader(isFile);
            if (sCharset != null && !sCharset.equals("")) {
                isR = new InputStreamReader(isFile, sCharset);
            }
            BufferedReader in = new BufferedReader(isR);
            String sCurLine = null;
            while ((sCurLine = in.readLine()) != null) {
                sReturn = String.valueOf(sReturn) + sCurLine + System.getProperty("line.separator");
            }
            in.close();
            if (sCharset.equals("UTF-8")) {
                sReturn = FileUtils.removeUTF_8_BOM(sReturn);
            }
        }
        return sReturn;
    }

    public static String ascFileToString(InputStream isFile) throws IOException {
        return FileUtils.ascFileToString(isFile, "");
    }

    public static String removeUTF_8_BOM(String s) {
        char cFirst;
        String sReturn = s;
        if (s != null && s.length() > 0 && (cFirst = s.charAt(0)) == '\ufeff') {
            sReturn = s.substring(1);
        }
        return sReturn;
    }

    public static String convertAbsolutetoRelativePath(String sBase, String sPath) {
        String[] saPath;
        String[] saBase;
        String sFileSep = System.getProperty("file.separator");
        boolean bCaseSensitive = FileUtils.isCaseSensitivePath();
        String sBaseNorm = FileUtils.toCanonicalPath(sBase);
        String sPathNorm = FileUtils.toCanonicalPath(sPath);
        if (sFileSep.equals("\\")) {
            sBaseNorm = sBaseNorm.replaceAll("\\\\", "/");
            sPathNorm = sPathNorm.replaceAll("\\\\", "/");
            if (sBaseNorm.startsWith("//")) {
                sBaseNorm = sBaseNorm.replaceFirst("//", "\\?\\?");
            }
            if (sPathNorm.startsWith("//")) {
                sPathNorm = sPathNorm.replaceFirst("//", "\\?\\?");
            }
        }
        if (!(saBase = sBaseNorm.split("/"))[0].equalsIgnoreCase((saPath = sPathNorm.split("/"))[0])) {
            return sPath;
        }
        int iMinLen = saBase.length;
        String sReturn = "";
        boolean bBase = true;
        int iFirstNeq = -1;
        int i = 0;
        while (i < saBase.length) {
            if (bBase && i < iMinLen) {
                boolean bCurEqual = false;
                if (bCaseSensitive && saBase[i].equals(saPath[i])) {
                    bCurEqual = true;
                } else if (!bCaseSensitive && saBase[i].equalsIgnoreCase(saPath[i])) {
                    bCurEqual = true;
                }
                if (!bCurEqual) {
                    iFirstNeq = i;
                    bBase = false;
                    sReturn = "..";
                }
            } else {
                sReturn = String.valueOf(sReturn) + sFileSep + "..";
            }
            ++i;
        }
        int iRest = iFirstNeq;
        if (iFirstNeq < 0 && saBase.length < saPath.length) {
            iRest = saBase.length;
        }
        if (iRest >= 0) {
            int i2 = iRest;
            while (i2 < saPath.length) {
                sReturn = sReturn.equals("") ? String.valueOf(sReturn) + saPath[i2] : String.valueOf(sReturn) + sFileSep + saPath[i2];
                ++i2;
            }
        }
        if (sBaseNorm.startsWith("??")) {
            sBaseNorm = sBaseNorm.replaceFirst("\\?\\?", "//");
        }
        if (sPathNorm.startsWith("??")) {
            sPathNorm = sPathNorm.replaceFirst("\\?\\?", "//");
        }
        return sReturn;
    }

    public static String convertRelativetoAbsolutePath(String sBase, String sPath) {
        String sFileSep = System.getProperty("file.separator");
        String sReturn = "";
        String sNormPath = sPath;
        if (sFileSep.equals("\\")) {
            sNormPath = sNormPath.replaceAll("\\\\", "/");
        }
        if (sNormPath.startsWith("/") || sNormPath.length() > 1 && sNormPath.charAt(1) == ':') {
            File fPath = new File(sPath);
            sReturn = FileUtils.toCanonicalPath(fPath);
        } else if (sBase.equals("")) {
            sReturn = sPath;
        } else {
            File fBase = new File(sBase);
            File fComp = new File(fBase, sPath);
            sReturn = FileUtils.toCanonicalPath(fComp);
        }
        return sReturn;
    }

    public static boolean isAbsolutePath(String sPath) {
        boolean bResult = false;
        String sFileSep = System.getProperty("file.separator");
        if ((sPath = sPath.trim()).startsWith(sFileSep) || sPath.startsWith("/") || sFileSep.equals("\\") && sPath.length() > 1 && sPath.charAt(1) == ':') {
            bResult = true;
        }
        return bResult;
    }

    public static String[] splitDirectories(String sInPath) {
        String sSplitChar = File.pathSeparator;
        String[] InputDirs = null;
        if (sInPath != null) {
            InputDirs = sInPath.split("\\s*" + sSplitChar + "\\s*");
        }
        int i = 0;
        while (i < InputDirs.length) {
            InputDirs[i] = FileUtils.toCanonicalPath(InputDirs[i].trim());
            ++i;
        }
        return InputDirs;
    }

    public static byte[] readToByteArray(InputStream inFile, int iNumBytes) {
        byte[] bufResult = null;
        try {
            byte[] buf = new byte[iNumBytes];
            BufferedInputStream in = new BufferedInputStream(inFile);
            int len = in.read(buf, 0, iNumBytes);
            in.close();
            if (len > 0) {
                bufResult = new byte[len];
                int i = 0;
                while (i < len) {
                    bufResult[i] = buf[i];
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufResult;
    }

    public static byte[] readToByteArray(String sFile, int iNumBytes) {
        byte[] bufResult = null;
        try {
            FileInputStream in = new FileInputStream(sFile);
            bufResult = FileUtils.readToByteArray(in, iNumBytes);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bufResult;
    }

    public static String detectUTFCharset(byte[] ba, int iTresh) {
        String sReturn = "";
        if (ba != null) {
            if (ba.length >= 3 && ba[0] == -17 && ba[1] == -69 && ba[2] == -65) {
                return "UTF-8";
            }
            if (ba.length >= 2) {
                if (ba[0] == -2 && ba[1] == -1) {
                    return "UTF-16BE";
                }
                if (ba[0] == -1 && ba[1] == -2) {
                    return "UTF-16LE";
                }
            }
            if (ba.length >= 4) {
                if (ba[0] == 0 && ba[1] == 0 && ba[2] == -2 && ba[3] == -1) {
                    return "UTF-32BE";
                }
                if (ba[0] == -1 && ba[1] == -2 && ba[2] == 0 && ba[3] == 0) {
                    return "UTF-32LE";
                }
            }
            int iCount = 0;
            int i = 0;
            while (i < ba.length) {
                if ((ba[i] == -62 || ba[i] == -61) && ++iCount >= iTresh) {
                    return "UTF-8";
                }
                ++i;
            }
            sReturn = Charset.defaultCharset().name();
        } else {
            sReturn = Charset.defaultCharset().name();
        }
        return sReturn;
    }

    public static String detectUTFCharset(String sFilename, int iMaxBuffer, int iTresh) {
        String sReturn = "";
        byte[] ba = FileUtils.readToByteArray(sFilename, iMaxBuffer);
        sReturn = FileUtils.detectUTFCharset(ba, iTresh);
        return sReturn;
    }

    public static String detectUTFCharset(InputStream inFile, int iMaxBuffer, int iTresh) {
        String sReturn = "";
        byte[] ba = FileUtils.readToByteArray(inFile, iMaxBuffer);
        sReturn = FileUtils.detectUTFCharset(ba, iTresh);
        return sReturn;
    }

    public static InputStreamReader getInputStreamReader(String sFilename, int iMaxBuffer, int iTresh) throws FileNotFoundException {
        String sCharset = FileUtils.detectUTFCharset(sFilename, iMaxBuffer, iTresh);
        InputStreamReader isR = null;
        try {
            isR = new InputStreamReader((InputStream)new FileInputStream(sFilename), sCharset);
        }
        catch (UnsupportedEncodingException e) {
            isR = new InputStreamReader(new FileInputStream(sFilename));
        }
        return isR;
    }

    public static InputStreamReader getInputStreamReader(String sFilename, String sCharset) throws FileNotFoundException {
        InputStreamReader isR = null;
        try {
            isR = new InputStreamReader((InputStream)new FileInputStream(sFilename), sCharset);
        }
        catch (UnsupportedEncodingException e) {
            isR = new InputStreamReader(new FileInputStream(sFilename));
        }
        return isR;
    }

    public static Hashtable readParamsFromFile(InputStream in) {
        Hashtable<String, String> params = null;
        if (in != null) {
            try {
                params = new Hashtable<String, String>();
                BufferedReader bin = new BufferedReader(new InputStreamReader(in));
                String sCurLine = null;
                while ((sCurLine = bin.readLine()) != null) {
                    int iPos;
                    String sKey = "";
                    String sValue = "";
                    if (sCurLine.trim().equals("") || sCurLine.trim().startsWith("#") || (iPos = sCurLine.indexOf("=")) < 0) continue;
                    sKey = sCurLine.substring(0, iPos).trim();
                    if (iPos < sCurLine.length() + 1) {
                        sValue = sCurLine.substring(iPos + 1).trim();
                    }
                    params.put(sKey, sValue);
                }
                bin.close();
            }
            catch (IOException e) {
                params = null;
            }
        }
        return params;
    }

    public static File createTempDirectory(String sPrefix) throws IOException {
        File temp = null;
        try {
            temp = sPrefix != null && !sPrefix.equals("") ? File.createTempFile(sPrefix, Long.toString(System.nanoTime())) : File.createTempFile("temp", Long.toString(System.nanoTime()));
            temp.delete();
            temp.mkdirs();
        }
        catch (IOException e) {
            throw new IOException("Cannot create temporary directory: " + e.getMessage() + ".");
        }
        return temp;
    }

    public static boolean checkDirCanWrite(File f) {
        boolean bResult = false;
        if (f != null && f.isDirectory() && f.canWrite()) {
            try {
                File fTmp = File.createTempFile("_checkDirCanWrite_", null, f);
                if (fTmp.exists()) {
                    bResult = true;
                    fTmp.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bResult;
    }
}

