/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.Epub;

import de.enache.AutoDoc.AutoDoc;
import de.enache.AutoDoc.AutoDocDocument;
import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocIndexInfo;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTag;
import de.enache.AutoDoc.AutoDocTagParameterList;
import de.enache.AutoDoc.Epub.AutoDocEpubMimeTypes;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.HTML.AutoDocHTMLOut;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.Tree;
import de.enache.AutoDoc.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AutoDocEpubOut
extends AutoDocHTMLOut {
    protected String OutFile = "AutoDoc.epub";
    protected String ListIndexTemplateStr = "";
    protected String MimeTypeTemplateStr = "";
    protected String ContainerTemplateStr = "";
    protected String TitlePageTemplateStr = "";
    protected String ContentOpfTemplateStr = "";
    protected String Outpath_Org = "";
    protected String sIndexFileName = "Autodoc_Index.xhtml";
    protected int iNavPoint = 0;
    protected ArrayList vAuthors = new ArrayList();

    public AutoDocEpubOut(AutoDocDocument Document, AutoDocSettings mySettings) {
        super(Document, mySettings);
        this.FileTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_File_Epub.htm"));
        this.IndexTemplateStr = this.ascFileToString(this.getTemplatePath("Templ_Index_Epub.htm"));
        this.ListIndexTemplateStr = this.generateListIndexTemplateStr();
        this.MimeTypeTemplateStr = this.generateMimeType();
        this.ContainerTemplateStr = this.generateContainer();
        this.TitlePageTemplateStr = this.generateTitlepageTemplate();
        this.ContentOpfTemplateStr = this.generateContentOpfTemplateStr();
        this.Outpath_Org = this.Outpath;
        this.sRefFileName = "Autodoc_Ref.xhtml";
        this.sFuncIndexFileName = "Autodoc_Func.xhtml";
        this.Outpath = String.valueOf(this.Outpath) + "/tmp";
    }

    public String generateContentOpfTemplateStr() {
        String sRet = "";
        sRet = String.valueOf(sRet) + "<?xml version=\"1.0\"  encoding=\"UTF-8\"?>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<package xmlns=\"http://www.idpf.org/2007/opf\" unique-identifier=\"BookID\" version=\"2.0\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <metadata xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:opf=\"http://www.idpf.org/2007/opf\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:creator opf:role=\"aut\" opf:file-as=\"%AUTHORFILEAS%\">%AUTHOR%</dc:creator>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:title>%TITLE%</dc:title>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:identifier id=\"BookID\" opf:scheme=\"ISBN\">%IDENTIFIER%</dc:identifier>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:date opf:event=\"publication\">%PUBDATE%</dc:date>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:publisher>%PUBLISHER%</dc:publisher>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"cover\" content=\"%COVER%\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"AutoDoc\" content=\"%ADVERSION%\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <dc:language>%LANG%</dc:language>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </metadata>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <manifest>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <item id=\"ncx\" href=\"toc.ncx\" media-type=\"application/x-dtbncx+xml\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "%CONTENTSLIST1%";
        sRet = String.valueOf(sRet) + "    <item id=\"title.xhtml\" href=\"title.xhtml\" media-type=\"application/xhtml+xml\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </manifest>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <spine toc=\"ncx\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <itemref idref=\"title.xhtml\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "%CONTENTSLIST2%";
        sRet = String.valueOf(sRet) + "  </spine>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <guide>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <reference type=\"cover\" title=\"Title Page\" href=\"title.xhtml\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </guide>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</package>" + this.SysNewLine;
        return sRet;
    }

    public String generateListIndexTemplateStr() {
        String sRet = "";
        sRet = String.valueOf(sRet) + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<!DOCTYPE ncx PUBLIC \"-//NISO//DTD ncx 2005-1//EN\" \"http://www.daisy.org/z3986/2005/ncx-2005-1.dtd\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<ncx xmlns=\"http://www.daisy.org/z3986/2005/ncx/\" version=\"2005-1\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <head>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"dtb:uid\" content=\"%IDENTIFIER%\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"dtb:depth\" content=\"5\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"dtb:totalPageCount\" content=\"0\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <meta name=\"dtb:maxPageNumber\" content=\"0\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </head>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <docTitle>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <text>%TITLE%</text>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </docTitle>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <navMap>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "%LISTCONTENT%";
        sRet = String.valueOf(sRet) + "  </navMap>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</ncx>" + this.SysNewLine;
        return sRet;
    }

    public String generateMimeType() {
        return "application/epub+zip";
    }

    public String generateContainer() {
        String sRet = "";
        sRet = String.valueOf(sRet) + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<container version=\"1.0\" xmlns=\"urn:oasis:names:tc:opendocument:xmlns:container\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <rootfiles>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "    <rootfile full-path=\"OEBPS/content.opf\" media-type=\"application/oebps-package+xml\"/>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </rootfiles>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</container>" + this.SysNewLine;
        return sRet;
    }

    public String generateTitlepageTemplate() {
        String sRet = "";
        sRet = String.valueOf(sRet) + "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<html xmlns=\"http://www.w3.org/1999/xhtml\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<head>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <title>cover</title>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <style type=\"text/css\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "/*<![CDATA[*/" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  body.sgc-2 {margin-top:0px; margin-left: 0px; margin-right: 0px; margin-bottom: 0px; text-align: center;}" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  /*]]>*/" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  </style>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</head>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "<body class=\"sgc-2\">" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "  <div><img alt=\"cover\" src=\"%COVER%\" /><h1>%TITLE%</h1></div>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</body>" + this.SysNewLine;
        sRet = String.valueOf(sRet) + "</html>" + this.SysNewLine;
        return sRet;
    }

    public int[] preprocessFile(AutoDocFile curFile, String sOutFil, int iFilenum) {
        int[] iaNumLevel = super.preprocessFile(curFile, sOutFil, iFilenum);
        ArrayList treeList = curFile.getTagTreeList();
        int iTreeListSize = treeList.size();
        int i = 0;
        while (i < iTreeListSize) {
            int curLevel;
            Tree curTree = (Tree)treeList.get(i);
            AutoDocTag curTag = (AutoDocTag)curTree.getData();
            ArrayList curChilds = (ArrayList)curTree.getChildren();
            if (curTag != null && (curLevel = curTag.getLevel()) == 1 && curChilds != null) {
                int iNumChilds = curChilds.size();
                int j = 0;
                while (j < iNumChilds) {
                    AutoDocTagParameterList curParms;
                    String sAuthor;
                    int iPos;
                    Tree curChildNode = (Tree)curChilds.get(j);
                    AutoDocTag curChildTag = (AutoDocTag)curChildNode.getData();
                    if (curChildTag.getTagInfo().isAuthor() && (iPos = this.vAuthors.indexOf(sAuthor = this.removeGrpWordDelim((curParms = this.getParameters(curChildTag, curFile, sOutFil)).get(0).toString().trim()))) < 0) {
                        this.vAuthors.add(sAuthor);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        Collections.sort(this.vAuthors);
        return iaNumLevel;
    }

    public void declareDeletePatterns() {
        String sResDir;
        File fRes;
        String sTemplate;
        this.vDeletePattern.add("Autodoc_*.htm");
        this.vDeletePattern.add("Autodoc_*.xhtml");
        this.vDeletePattern.add("Autodoc.css");
        this.vDeletePattern.add("mimetype");
        this.vDeletePattern.add("container.xml");
        this.vDeletePattern.add("content.opf");
        this.vDeletePattern.add("toc.ncx");
        this.vDeletePattern.add("title.xhtml");
        this.vDeletePattern.add("AutoDoc.epub");
        String sLogo = this.mySettings.getLogo();
        if (!sLogo.equals("")) {
            File fLogo = new File(sLogo);
            String sLogoFile = fLogo.getName();
            this.vDeletePattern.add(sLogoFile);
            this.vDeletePattern.add("cover.jpg");
        }
        if (!(sTemplate = this.mySettings.getTemplateDir()).equals("") && (fRes = new File(sResDir = String.valueOf(sTemplate = FileUtils.toCanonicalPath(sTemplate)) + "/res")).exists() && fRes.isDirectory()) {
            File[] fList = fRes.listFiles();
            int i = 0;
            while (i < fList.length) {
                this.vDeletePattern.add(fList[i].getName());
                ++i;
            }
        }
    }

    protected String getCoverFilename() {
        String sCovername = "";
        String sLogo = this.mySettings.getLogo();
        if (!sLogo.equals("")) {
            File fLogo = new File(sLogo);
            String sLogoName = fLogo.getName();
            String sExt = FileUtils.getFileNameExtension(sLogoName);
            sCovername = "cover." + sExt.toLowerCase();
        }
        return sCovername;
    }

    protected void postprocessOutput() {
        try {
            this.outputMimeType("mimetype");
            this.outputContainer("container.xml");
            this.outputIndexFile(this.sIndexFileName);
            this.outputBibFile(this.sRefFileName);
            this.outputFuncIndexFile(this.sFuncIndexFileName);
            this.outputTitlePage("title.xhtml");
            this.outputIndexListFile("toc.ncx");
            this.outputContentOpf("content.opf");
            String sLogo = this.mySettings.getLogo();
            String sCoverName = this.getCoverFilename();
            if (!sLogo.equals("")) {
                File fLogo = new File(sLogo);
                String sLogoName = fLogo.getName();
                File fLogoOut = new File(String.valueOf(this.Outpath) + "/" + sLogoName);
                if (fLogoOut.exists() && fLogoOut.isFile()) {
                    String sLogoFile = fLogoOut.getCanonicalPath();
                    File fCover = new File(fLogoOut.getParentFile(), sCoverName);
                    FileUtils.copy(sLogoFile, fCover.getCanonicalPath());
                }
            }
            this.writeToEpubFile();
            FileUtils.deleteDir(this.Outpath);
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    protected void writeToEpubFile() {
        File fEpubDir = new File(this.Outpath_Org);
        File fOutDir = new File(this.Outpath);
        File fOut = new File(fEpubDir, this.OutFile);
        try {
            File fRes;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fOut));
            File fCur = new File(fOutDir, "mimetype");
            ZipUtils.addToZipOutputStream(out, "mimetype", fCur, 0);
            fCur = new File(fOutDir, "container.xml");
            ZipUtils.addToZipOutputStream(out, "META-INF/container.xml", fCur, 8);
            fCur = new File(fOutDir, "content.opf");
            ZipUtils.addToZipOutputStream(out, "OEBPS/content.opf", fCur, 8);
            fCur = new File(fOutDir, "toc.ncx");
            ZipUtils.addToZipOutputStream(out, "OEBPS/toc.ncx", fCur, 8);
            fCur = new File(fOutDir, "title.xhtml");
            ZipUtils.addToZipOutputStream(out, "OEBPS/title.xhtml", fCur, 8);
            String sLogo = this.mySettings.getLogo();
            if (!sLogo.equals("")) {
                File fLogo = new File(sLogo);
                String sLogoName = fLogo.getName();
                String sCover = this.getCoverFilename();
                fCur = new File(fOutDir, sLogoName);
                ZipUtils.addToZipOutputStream(out, "OEBPS/" + sLogoName, fCur, 8);
                fCur = new File(fOutDir, sCover);
                ZipUtils.addToZipOutputStream(out, "OEBPS/" + sCover, fCur, 8);
            }
            File fCSS = new File(this.CSSFile);
            fCur = new File(fOutDir, fCSS.getName());
            ZipUtils.addToZipOutputStream(out, "OEBPS/" + this.CSSFile, fCur, 8);
            fCur = new File(fOutDir, this.sIndexFileName);
            ZipUtils.addToZipOutputStream(out, "OEBPS/" + this.sIndexFileName, fCur, 8);
            if (this.bibrefList != null && this.bibrefList.size() > 0) {
                fCur = new File(fOutDir, this.sRefFileName);
                ZipUtils.addToZipOutputStream(out, "OEBPS/" + this.sRefFileName, fCur, 8);
            }
            if (this.varFuncList != null && this.varFuncList.size() > 0) {
                fCur = new File(fOutDir, this.sFuncIndexFileName);
                ZipUtils.addToZipOutputStream(out, "OEBPS/" + this.sFuncIndexFileName, fCur, 8);
            }
            int iEntries = this.IndexEntries.size();
            int i = 0;
            while (i < iEntries) {
                AutoDocIndexInfo cur = (AutoDocIndexInfo)this.IndexEntries.get(i);
                String sFilename = cur.Filename;
                fCur = new File(fOutDir, sFilename);
                ZipUtils.addToZipOutputStream(out, "OEBPS/" + sFilename, fCur, 8);
                ++i;
            }
            File fImg = new File(fOutDir, "images");
            if (fImg.exists() && fImg.isDirectory()) {
                this.addDirToZipOutputStream(out, "OEBPS/", fImg, 8);
            }
            if ((fRes = new File(fOutDir, "res")).exists() && fRes.isDirectory()) {
                this.addDirToZipOutputStream(out, "OEBPS/", fRes, 8);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addDirToZipOutputStream(ZipOutputStream out, String sParentEntry, File fDir, int iMethod) throws IOException {
        String sDirname = fDir.getName();
        File[] saList = fDir.listFiles();
        if (saList.length == 0) {
            ZipEntry ze = new ZipEntry(String.valueOf(sParentEntry) + sDirname + "/");
            out.putNextEntry(ze);
            out.closeEntry();
        } else {
            int i = 0;
            while (i < saList.length) {
                File fCur = saList[i];
                if (!fCur.isDirectory()) {
                    this.addDirToZipOutputStream(out, String.valueOf(sParentEntry) + sDirname + "/", fCur, iMethod);
                } else {
                    ZipUtils.addToZipOutputStream(out, String.valueOf(sParentEntry) + sDirname + "/", fCur, iMethod);
                }
                ++i;
            }
        }
    }

    public void cleanOutDir() {
        SystemUtils.println();
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCLEANOUTDIR", this.Outpath_Org));
        this.cleanDir(this.Outpath);
        this.cleanDir(this.Outpath_Org);
    }

    public void processGroupingTreeTitle(PrintStream psOut, String sTitle) {
        sTitle = "Index";
        psOut.println("  <navPoint id=\"navPoint-" + this.iNavPoint++ + "\">");
        psOut.println("    <navLabel><text>Cover</text></navLabel>");
        psOut.println("    <content src=\"title.xhtml\"/>");
        psOut.println("  </navPoint>");
        psOut.println("  <navPoint id=\"navPoint-" + this.iNavPoint++ + "\">");
        psOut.println("    <navLabel><text>" + sTitle + "</text></navLabel>");
        psOut.println("    <content src=\"" + this.sIndexFileName + "\"/>");
        psOut.println("  </navPoint>");
    }

    public void processGroupingTreeFinish(PrintStream psOut, String sTitle, String sFilename) {
        psOut.println("  <navPoint id=\"navPoint-" + this.iNavPoint++ + "\">");
        psOut.println("    <navLabel><text>" + sTitle + "</text></navLabel>");
        psOut.println("    <content src=\"" + sFilename + "\"/>");
        psOut.println("  </navPoint>");
    }

    public void processGroupingTreeBegin(PrintStream psOut, String sIDOrg, int iDepth) {
    }

    public void processGroupingTreeEnd(PrintStream psOut, int iDepth) {
    }

    public void processGroupingTreeItemBegin(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.print(String.valueOf(sPad) + "<navPoint id=\"navPoint->" + this.iNavPoint++ + "\">");
    }

    public void processGroupingTreeItemEnd(PrintStream psOut, int iDepth) {
        String sPad = AutoDocStringUtils.repeat("  ", iDepth + 1);
        psOut.println(String.valueOf(sPad) + "</navPoint>");
    }

    public void processGroupingTreeEntry(PrintStream psOut, String sText, boolean bNewLine) {
        if (!sText.startsWith("<navLabel>")) {
            sText = "<navLabel><text>" + sText + "</text></navLabel>";
        }
        if (bNewLine) {
            psOut.println(sText);
        } else {
            psOut.print(sText);
        }
    }

    public String convertLinkToStringNavigation(String sLink, String sLabel, boolean bURL) {
        return "<navLabel><text>" + sLabel + "</text></navLabel>" + "<content src=\"" + sLink + "\"/>";
    }

    public void outputMimeType(String sOutFil) throws IOException {
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.MimeTypeTemplateStr;
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputContainer(String sOutFil) throws IOException {
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.ContainerTemplateStr;
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputTitlePage(String sOutFil) throws IOException {
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.TitlePageTemplateStr;
        String sTitle = this.mySettings.getTitle();
        String sCoverName = this.getCoverFilename();
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%COVER%", sCoverName);
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputContentOpf(String sOutFil) throws IOException {
        File fRes;
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.ContentOpfTemplateStr;
        String sTitle = this.mySettings.getTitle();
        String sCoverName = this.getCoverFilename();
        String sAuthor = "";
        String sID = "9999999999999";
        String sPub = "AutoDoc";
        String sPubDate = "";
        if (AutoDoc.bTestCase) {
            String sDay = AutoDoc.Date.substring(0, 2);
            String sMonth = AutoDoc.Date.substring(3, 5);
            String sYear = AutoDoc.Date.substring(6);
            sPubDate = String.valueOf(sYear) + "-" + sMonth + "-" + sDay + "T" + "00:00:00+00:00";
        } else {
            Calendar cal = Calendar.getInstance();
            sPubDate = this.formatDate(cal);
        }
        int iNum = this.vAuthors.size();
        if (iNum == 1) {
            sAuthor = (String)this.vAuthors.get(0);
        } else if (iNum > 1) {
            sAuthor = String.valueOf((String)this.vAuthors.get(0)) + " et al.";
        }
        String sCont1 = "";
        String sCont2 = "";
        sCont1 = String.valueOf(sCont1) + "    <item id=\"" + this.sIndexFileName + "\" href=\"" + this.sIndexFileName + "\" media-type=\"" + this.getMediaType(this.sIndexFileName) + "\"/>" + this.SysNewLine;
        sCont2 = String.valueOf(sCont2) + "    <itemref idref=\"" + this.sIndexFileName + "\"/>" + this.SysNewLine;
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + this.sRefFileName + "\" href=\"" + this.sRefFileName + "\" media-type=\"" + this.getMediaType(this.sRefFileName) + "\"/>" + this.SysNewLine;
            sCont2 = String.valueOf(sCont2) + "    <itemref idref=\"" + this.sRefFileName + "\"/>" + this.SysNewLine;
        }
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + this.sFuncIndexFileName + "\" href=\"" + this.sFuncIndexFileName + "\" media-type=\"" + this.getMediaType(this.sFuncIndexFileName) + "\"/>" + this.SysNewLine;
            sCont2 = String.valueOf(sCont2) + "    <itemref idref=\"" + this.sFuncIndexFileName + "\"/>" + this.SysNewLine;
        }
        int iEntries = this.IndexEntries.size();
        int i = 0;
        while (i < iEntries) {
            AutoDocIndexInfo cur = (AutoDocIndexInfo)this.IndexEntries.get(i);
            String sFilename = cur.Filename;
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + sFilename + "\" href=\"" + sFilename + "\" media-type=\"" + this.getMediaType(sFilename) + "\"/>" + this.SysNewLine;
            sCont2 = String.valueOf(sCont2) + "    <itemref idref=\"" + sFilename + "\"/>" + this.SysNewLine;
            ++i;
        }
        File fCSS = new File(this.CSSFile);
        sCont1 = String.valueOf(sCont1) + "    <item id=\"" + fCSS.getName() + "\" href=\"" + fCSS.getName() + "\" media-type=\"" + this.getMediaType(fCSS.getName()) + "\"/>" + this.SysNewLine;
        String sLogo = this.mySettings.getLogo();
        if (!sLogo.equals("")) {
            File fLogo = new File(sLogo);
            String sLogoName = fLogo.getName();
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + sLogoName + "\" href=\"" + sLogoName + "\" media-type=\"" + this.getMediaType(sLogoName) + "\"/>" + this.SysNewLine;
            String sCover = this.getCoverFilename();
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + sCover + "\" href=\"" + sCover + "\" media-type=\"" + this.getMediaType(sLogoName) + "\"/>" + this.SysNewLine;
        }
        ArrayList vOtherFiles = new ArrayList();
        File fImg = new File(this.Outpath, "images");
        if (fImg.exists() && fImg.isDirectory()) {
            this.addDirEntriesToList(vOtherFiles, "", fImg);
        }
        if ((fRes = new File(this.Outpath, "res")).exists() && fRes.isDirectory()) {
            this.addDirEntriesToList(vOtherFiles, "", fRes);
        }
        int iNumOthers = vOtherFiles.size();
        int i2 = 0;
        while (i2 < iNumOthers) {
            String sCurOth = (String)vOtherFiles.get(i2);
            String sOthID = AutoDocStringUtils.replaceAll(sCurOth, "/", "_");
            sCont1 = String.valueOf(sCont1) + "    <item id=\"" + sOthID + "\" href=\"" + sCurOth + "\" media-type=\"" + this.getMediaType(sOthID) + "\"/>" + this.SysNewLine;
            ++i2;
        }
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%AUTHOR%", sAuthor);
        s1 = AutoDocStringUtils.replaceAll(s1, "%AUTHORFILEAS%", sAuthor);
        s1 = AutoDocStringUtils.replaceAll(s1, "%COVER%", sCoverName);
        s1 = AutoDocStringUtils.replaceAll(s1, "%IDENTIFIER%", sID);
        s1 = AutoDocStringUtils.replaceAll(s1, "%PUBLISHER%", sPub);
        s1 = AutoDocStringUtils.replaceAll(s1, "%PUBDATE%", sPubDate);
        s1 = AutoDocStringUtils.replaceAll(s1, "%LANG%", this.mySettings.getLocale());
        s1 = AutoDocStringUtils.replaceAll(s1, "%ADVERSION%", AutoDoc.Version);
        s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENTSLIST1%", sCont1);
        s1 = AutoDocStringUtils.replaceAll(s1, "%CONTENTSLIST2%", sCont2);
        PrintStream psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    protected void addDirEntriesToList(List list, String sParent, File fDir) {
        File[] saList = fDir.listFiles();
        int i = 0;
        while (i < saList.length) {
            File fCur = saList[i];
            if (!fCur.isDirectory()) {
                list.add(String.valueOf(sParent) + "/" + fDir.getName() + "/" + fCur);
            } else {
                this.addDirEntriesToList(list, String.valueOf(sParent) + "/" + fDir.getName(), fCur);
            }
            ++i;
        }
    }

    public String formatDate(Calendar cal) {
        String sSec;
        String sMin;
        String sHour;
        String sDay;
        String sYear = "" + cal.get(1);
        String sMon = "" + (cal.get(2) + 1);
        if (sMon.length() == 1) {
            sMon = "0" + sMon;
        }
        if ((sDay = "" + cal.get(5)).length() == 1) {
            sDay = "0" + sDay;
        }
        if ((sHour = "" + cal.get(11)).length() == 1) {
            sHour = "0" + sHour;
        }
        if ((sMin = "" + cal.get(12)).length() == 1) {
            sMin = "0" + sMin;
        }
        if ((sSec = "" + cal.get(13)).length() == 1) {
            sSec = "0" + sSec;
        }
        return String.valueOf(sYear) + "-" + sMon + "-" + sDay + "T" + sHour + ":" + sMin + ":" + sSec + "+00:00";
    }

    protected String getMediaType(String sFilename) {
        String sExt;
        String sReturn = "";
        if (!sFilename.equals("") && (sReturn = AutoDocEpubMimeTypes.findMimeType(sExt = FileUtils.getFileNameExtension(sFilename).toLowerCase())).length() == 0) {
            sReturn = "application/octet-stream";
        }
        return sReturn;
    }

    public void outputIndexListFile(String sOutFil) throws IOException {
        String sID = "9999999999999";
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEFRAMESETLIST", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.ListIndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        String sIndex = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTINDEX");
        this.processGroupingTreeTitle(psOut, sIndex);
        this.processIndexListTreeContent(psOut);
        if (this.bibrefList != null && this.bibrefList.size() > 0) {
            String sBibText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTBIB");
            this.processGroupingTreeFinish(psOut, sBibText, this.sRefFileName);
        }
        if (this.varFuncList != null && this.varFuncList.size() > 0) {
            String sIdxText = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTVARFUNCINDEX");
            this.processGroupingTreeFinish(psOut, sIdxText, this.sFuncIndexFileName);
        }
        String sCont = baOut.toString();
        psOut.close();
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sIndex;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%LISTCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%IDENTIFIER%", sID);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void outputIndexFile(String sOutFil) throws IOException {
        SystemUtils.println(this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTCREATEINDEX", sOutFil));
        String sFullOutFil = String.valueOf(this.Outpath) + "/" + sOutFil;
        String s1 = this.IndexTemplateStr;
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(baOut);
        this.outputOverView(psOut);
        psOut.println("<hr class=\"docsection\"/>");
        String sCont = baOut.toString();
        psOut.close();
        String sHead = this.mySettings.getMsgHandler().getTexts().getMessageText("MSG_OUTFILEINDEX");
        String sTitle = String.valueOf(this.mySettings.getTitle()) + " - " + sHead;
        s1 = AutoDocStringUtils.replaceAll(s1, "%TITLE%", sTitle);
        s1 = AutoDocStringUtils.replaceAll(s1, "%HEADINS%", this.HeadInsFileStr);
        s1 = AutoDocStringUtils.replaceAll(s1, "%INDEXCONTENT%", sCont);
        s1 = AutoDocStringUtils.replaceAll(s1, "%FOOTINS%", this.FootInsFileStr);
        psOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sFullOutFil)), true, "UTF-8");
        psOut.print(s1);
        psOut.close();
        if (psOut.checkError()) {
            throw new IOException(this.mySettings.getMsgHandler().getTexts().getMessageText("ERR_OUTWRITEERROR", sFullOutFil));
        }
    }

    public void processFileHeading(PrintStream psOut, String sOutFil, String sOrgFile, String sFileType) {
        psOut.println("<a name=\"" + sOutFil + "\"></a>");
        if (!sOrgFile.equals("") && !sFileType.equals("")) {
            psOut.println("<h1 class=\"fileheading, clearall\">" + sFileType + ": " + sOrgFile + "</h1>");
        }
    }

    public String createXRefLabel(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(sOutfile) + "#" + this.correctMarker(sMarker);
        }
        return sOutfile;
    }

    public String createXRefLabelLocal(String sOutfile, String sMarker) {
        if (!sMarker.equals("")) {
            return String.valueOf(sOutfile) + "#" + this.correctMarker(sMarker);
        }
        return sOutfile;
    }

    public String generateLinkAnchor(String sName) {
        return "<a id=\"" + this.correctMarker(sName) + "\" name=\"" + this.correctMarker(sName) + "\"></a>";
    }

    public String correctMarker(String sMarker) {
        String s = AutoDocStringUtils.replaceAll(sMarker, "*", "x");
        s = AutoDocStringUtils.replaceAll(s, "(", "_");
        s = AutoDocStringUtils.replaceAll(s, ")", "_");
        s = AutoDocStringUtils.replaceAll(s, ",", "_");
        return s;
    }

    public String generateOutputFileName(int iIndex) {
        String sOutFil = "Autodoc_" + iIndex + ".xhtml";
        return sOutFil;
    }
}

