/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocMessageTexts;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.AutoDocTagListElement;
import de.enache.AutoDoc.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class AutoDocTagDictionary {
    protected AutoDocMessageTexts myTexts = null;
    protected ArrayList TagList = new ArrayList();
    protected InputStream TagFileStream = null;
    protected InputStream LabelFileStream = null;
    protected ArrayList vGroupDefs = new ArrayList();
    protected String sTagFileEnc = "";
    protected String sLabelFileEnc = "";

    public AutoDocTagDictionary(InputStream TagFileStream, String sTagFileEnc, InputStream LabelFileStream, String sLabelFileEnc, AutoDocMessageTexts myTexts, ArrayList vGroupDefs) throws Exception {
        this.TagFileStream = TagFileStream;
        this.sTagFileEnc = sTagFileEnc;
        this.LabelFileStream = LabelFileStream;
        this.sLabelFileEnc = sLabelFileEnc;
        this.myTexts = myTexts;
        if (vGroupDefs != null) {
            this.vGroupDefs = vGroupDefs;
        }
        this.initDict();
        this.initDictLabels();
    }

    protected void initDict() throws IOException {
        ArrayList<AutoDocTagListElement> TagListUnique = new ArrayList<AutoDocTagListElement>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.TagFileStream, this.sTagFileEnc));
        String sLine = br.readLine();
        while (sLine != null) {
            AutoDocTagListElement curElem;
            sLine = sLine.trim();
            if (this.sTagFileEnc.equals("UTF-8")) {
                sLine = FileUtils.removeUTF_8_BOM(sLine);
            }
            if (!sLine.equals("") && !sLine.startsWith("//") && (curElem = this.parseTagListElement(sLine)) != null) {
                int iPos = this.findUniqueTag(TagListUnique, curElem.getID());
                if (iPos >= 0) {
                    if (!curElem.isOverwrite()) {
                        AutoDocTagListElement uniqElem = (AutoDocTagListElement)TagListUnique.get(iPos);
                        curElem.setAliasName(uniqElem.getName());
                    } else {
                        TagListUnique.set(iPos, curElem);
                    }
                } else if (curElem.isOverwrite()) {
                    AutoDocTagListElement newElem;
                    int iPosAltUnique;
                    int iPosAlt = this.findTag(curElem.getName());
                    if (iPosAlt >= 0 && (iPosAltUnique = this.findUniqueTag(TagListUnique, (newElem = (AutoDocTagListElement)this.TagList.get(iPosAlt)).getID())) >= 0) {
                        AutoDocTagListElement uniqElem = (AutoDocTagListElement)TagListUnique.get(iPosAltUnique);
                        uniqElem.setName(String.valueOf(curElem.getName()) + "_@\\overwrite");
                    }
                    TagListUnique.add(curElem);
                } else {
                    TagListUnique.add(curElem);
                }
                int iPos2 = this.findUniqueTag(this.TagList, curElem.getID());
                if (iPos2 >= 0 && curElem.isOverwrite()) {
                    this.TagList.set(iPos2, curElem);
                } else {
                    this.TagList.add(curElem);
                }
            }
            sLine = br.readLine();
        }
        br.close();
    }

    protected void initDictLabels() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.LabelFileStream, this.sLabelFileEnc));
        String sLine = br.readLine();
        while (sLine != null) {
            sLine = sLine.trim();
            if (this.sLabelFileEnc.equals("UTF-8")) {
                sLine = FileUtils.removeUTF_8_BOM(sLine);
            }
            if (!sLine.equals("") && !sLine.startsWith("//")) {
                this.parseLabel(sLine);
            }
            sLine = br.readLine();
        }
        br.close();
    }

    protected AutoDocTagListElement parseTagListElement(String sLine) {
        String[] saEntry = AutoDocStringUtils.splitQuoted(sLine, ',');
        String sID = "";
        String sName = "";
        String sLevel = "";
        String sNumParms = "";
        String sLabel = "";
        String sSortIndex = "";
        String sTypes = "";
        if (saEntry.length > 0) {
            sID = saEntry[0].trim();
        }
        if (saEntry.length > 1) {
            sName = saEntry[1].trim();
        }
        if (saEntry.length > 2) {
            sLevel = saEntry[2].trim();
        }
        if (saEntry.length > 3) {
            sNumParms = saEntry[3].trim();
        }
        if (saEntry.length > 4) {
            sSortIndex = saEntry[4].trim();
        }
        if (saEntry.length > 5) {
            sTypes = saEntry[5].trim();
        }
        int iLevel = AutoDocStringUtils.toInt(sLevel, 0);
        int iNumParms = AutoDocStringUtils.toInt(sNumParms, 0);
        int iSortIndex = AutoDocStringUtils.toInt(sSortIndex, 0);
        AutoDocTagListElement curElem = null;
        if (!sName.equals("")) {
            curElem = new AutoDocTagListElement(sID, sName, iLevel, iNumParms, sLabel, iSortIndex, sTypes, this.vGroupDefs);
        }
        return curElem;
    }

    protected void parseLabel(String sLine) throws Exception {
        String[] saEntry = AutoDocStringUtils.splitQuoted(sLine, ',');
        String sID = "";
        String sLabel = "";
        if (saEntry.length > 0) {
            sID = saEntry[0].trim();
        }
        if (saEntry.length > 1) {
            sLabel = saEntry[1].trim();
        }
        if (!sID.equals("")) {
            boolean bFound = false;
            int i = 0;
            while (i < this.TagList.size()) {
                AutoDocTagListElement curElem = (AutoDocTagListElement)this.TagList.get(i);
                if (curElem.getID().trim().equalsIgnoreCase(sID)) {
                    curElem.setLabel(sLabel);
                    this.TagList.set(i, curElem);
                    bFound = true;
                }
                ++i;
            }
            if (!bFound) {
                throw new Exception(this.myTexts.getMessageText("ERR_DICTLABELNOTMATCHED", sID));
            }
        }
    }

    public int findTag(String sTagName) {
        int iResult = -1;
        int i = 0;
        while (i < this.TagList.size()) {
            if (((AutoDocTagListElement)this.TagList.get(i)).getName().equals(sTagName)) {
                return i;
            }
            ++i;
        }
        return iResult;
    }

    protected int findUniqueTag(ArrayList TagListUnique, String sID) {
        int iResult = -1;
        int i = 0;
        while (i < TagListUnique.size()) {
            if (((AutoDocTagListElement)TagListUnique.get(i)).getID().equals(sID)) {
                return i;
            }
            ++i;
        }
        return iResult;
    }

    public AutoDocTagListElement getElementByID(String sID) {
        AutoDocTagListElement eResult = null;
        int i = 0;
        while (i < this.TagList.size()) {
            AutoDocTagListElement curElem = (AutoDocTagListElement)this.TagList.get(i);
            if (curElem.getID().equals(sID)) {
                eResult = curElem;
                break;
            }
            ++i;
        }
        return eResult;
    }

    public AutoDocTagListElement getElementByName(String sTagName) {
        AutoDocTagListElement eResult = null;
        int i = 0;
        while (i < this.TagList.size()) {
            AutoDocTagListElement curElem = (AutoDocTagListElement)this.TagList.get(i);
            if (curElem.getName().equals(sTagName)) {
                eResult = curElem;
                break;
            }
            ++i;
        }
        return eResult;
    }

    public AutoDocTagListElement getElement(int iTagIndex) {
        AutoDocTagListElement ret = null;
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            ret = (AutoDocTagListElement)this.TagList.get(iTagIndex);
        }
        return ret;
    }

    public int getLevel(int iTagIndex) {
        int iResult = -1;
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            iResult = ((AutoDocTagListElement)this.TagList.get(iTagIndex)).getLevel();
        }
        return iResult;
    }

    public int getNumParms(int iTagIndex) {
        int iResult = -1;
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            iResult = ((AutoDocTagListElement)this.TagList.get(iTagIndex)).getNumParms();
        }
        return iResult;
    }

    public String getLabel(int iTagIndex) {
        String sResult = "";
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            sResult = ((AutoDocTagListElement)this.TagList.get(iTagIndex)).getLabel();
        }
        return sResult;
    }

    public int getSortIndex(int iTagIndex) {
        int iResult = 0;
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            iResult = ((AutoDocTagListElement)this.TagList.get(iTagIndex)).getSortIndex();
        }
        return iResult;
    }

    public String getAliasName(int iTagIndex) {
        String sResult = "";
        if (iTagIndex >= 0 && iTagIndex < this.TagList.size()) {
            sResult = ((AutoDocTagListElement)this.TagList.get(iTagIndex)).getAliasName();
        }
        return sResult;
    }

    public ArrayList getTagList() {
        return this.TagList;
    }
}

