/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocPluginInfo;
import de.enache.AutoDoc.AutoDocPluginInterface;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.AutoDocStringUtils;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.SystemUtils;
import de.enache.AutoDoc.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class AutoDocPluginUtils {
    static /* synthetic */ Class class$0;

    public static AutoDocPluginInterface loadPlugin(File fPlugin) {
        AutoDocPluginInterface curPlugin = null;
        try {
            String sPathToJar = FileUtils.toCanonicalPath(fPlugin);
            sPathToJar = sPathToJar.replaceAll("\\\\", "/");
            URL[] urls = new URL[]{new URL("jar:file:" + FileUtils.toCanonicalPath(fPlugin) + "!/")};
            URLClassLoader cl = URLClassLoader.newInstance(urls);
            JarFile jarFile = new JarFile(sPathToJar);
            Enumeration<JarEntry> e = jarFile.entries();
            Class<?> cPlugin = null;
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                String className = je.getName().substring(0, je.getName().length() - 6);
                className = className.replace('/', '.');
                Class<?> c = cl.loadClass(className);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("de.enache.AutoDoc.AutoDocPluginInterface");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(c)) continue;
                cPlugin = c;
            }
            jarFile.close();
            cl.close();
            if (cPlugin != null) {
                curPlugin = (AutoDocPluginInterface)cPlugin.newInstance();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return curPlugin;
    }

    public static ArrayList loadAllPlugins(String sProgDir, AutoDocSettings mySettings, String sAutoDocVersion, boolean bPrintInfo) {
        ArrayList lPluginFiles = AutoDocPluginUtils.listAllPluginsFiles(sProgDir);
        ArrayList<AutoDocPluginInfo> lPlugins = new ArrayList<AutoDocPluginInfo>();
        int iNumPluginFiles = lPluginFiles.size();
        if (iNumPluginFiles > 0) {
            if (bPrintInfo) {
                String sHeaderTmp;
                String sHeader = "Loading plugins...";
                if (mySettings != null && !(sHeaderTmp = mySettings.getMsgHandler().getTexts().getMessageText("MSG_LOADPLUGINS")).equals("")) {
                    sHeader = sHeaderTmp;
                }
                SystemUtils.println(sHeader);
            }
            int i = 0;
            while (i < iNumPluginFiles) {
                File fCur = (File)lPluginFiles.get(i);
                AutoDocPluginInterface cPlugin = AutoDocPluginUtils.loadPlugin(fCur);
                if (cPlugin != null) {
                    String sFilename = FileUtils.toCanonicalPath(fCur);
                    AutoDocPluginInfo pgInfo = new AutoDocPluginInfo(cPlugin, sFilename);
                    cPlugin.init(FileUtils.toCanonicalPath(fCur), mySettings);
                    pgInfo.updateInfo();
                    String sClassName = String.valueOf(cPlugin.getPluginName()) + " " + cPlugin.getPluginVersion();
                    if (!sAutoDocVersion.equals("") && !pgInfo.isCompatibleWith(sAutoDocVersion)) {
                        if (bPrintInfo) {
                            String sCompat = pgInfo.getCompatibleWith();
                            String sNotComp = "not loaded because incompatible, AutoDoc version " + sCompat + " is needed";
                            if (mySettings != null) {
                                String sNotCompTmp = mySettings.getMsgHandler().getTexts().getMessageText("MSG_PLUGINNOTCOMP", sCompat);
                                if (!sNotComp.equals("")) {
                                    sNotComp = sNotCompTmp;
                                }
                            }
                            SystemUtils.println("  " + sClassName + " (" + sNotComp + ")");
                        }
                    } else {
                        if (bPrintInfo) {
                            SystemUtils.println("  " + sClassName);
                        }
                        lPlugins.add(pgInfo);
                    }
                }
                ++i;
            }
            if (bPrintInfo) {
                SystemUtils.println();
            }
        }
        return lPlugins;
    }

    public static ArrayList listAllPluginsFiles(String sProgDir) {
        ArrayList<File> lPluginFiles = new ArrayList<File>();
        File fPluginDir = new File(sProgDir, "plugins");
        if (fPluginDir.exists() && fPluginDir.isDirectory()) {
            File[] fl = fPluginDir.listFiles();
            int i = 0;
            while (i < fl.length) {
                File fCur = fl[i];
                if (fCur.isDirectory()) {
                    File[] fl2 = fCur.listFiles();
                    int j = 0;
                    while (j < fl2.length) {
                        File fCur2 = fl2[j];
                        String ext = FileUtils.getFileNameExtension(FileUtils.toCanonicalPath(fCur2));
                        if (ext.equalsIgnoreCase("jar")) {
                            lPluginFiles.add(fCur2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return lPluginFiles;
    }

    public static ArrayList loadInstalledPluginsStandalone(String sProgDir) {
        ArrayList lPlugins = new ArrayList();
        if (sProgDir != null && !sProgDir.equals("")) {
            lPlugins = AutoDocPluginUtils.loadAllPlugins(sProgDir, null, "", false);
            int iNumPlugins = lPlugins.size();
            int i = 0;
            while (i < iNumPlugins) {
                AutoDocPluginInfo plug_info = (AutoDocPluginInfo)lPlugins.get(i);
                File fCur = new File(plug_info.getFilename());
                AutoDocPluginInterface cPlugin = plug_info.getPluginObject();
                cPlugin.init(FileUtils.toCanonicalPath(fCur), null);
                plug_info.updateInfo();
                ++i;
            }
        }
        return lPlugins;
    }

    public static List getPluginListFromServer(String sURL) throws IOException {
        ArrayList<AutoDocPluginInfo> lRet = new ArrayList<AutoDocPluginInfo>();
        URL url = new URL(sURL);
        InputStream in = url.openStream();
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        String sLine = "";
        while ((sLine = bin.readLine()) != null) {
            String sFilename = "";
            String sName = "";
            String sVersion = "";
            String sCompatibleWith = "";
            String sDescription = "";
            if ((sLine = sLine.trim()).startsWith("#")) continue;
            String[] saLine = sLine.split(";");
            int iNum = saLine.length;
            if (iNum > 0) {
                sFilename = saLine[0];
            }
            if (iNum > 1) {
                sName = saLine[1];
            }
            if (iNum > 2) {
                sVersion = saLine[2];
            }
            if (iNum > 3) {
                sCompatibleWith = saLine[3];
            }
            if (iNum > 4) {
                sDescription = saLine[4];
            }
            if (sFilename.equals("") || sName.equals("") || sVersion.equals("")) continue;
            AutoDocPluginInfo pinfo = new AutoDocPluginInfo(sFilename, sName, sVersion, sCompatibleWith, sDescription);
            lRet.add(pinfo);
        }
        bin.close();
        return lRet;
    }

    public static List getInstallablePlugins(List pluginList, List installed, String sCurVersion, boolean bSort) {
        Hashtable<String, AutoDocPluginInfo> ht = new Hashtable<String, AutoDocPluginInfo>();
        int iLen = pluginList.size();
        int i = 0;
        while (i < iLen) {
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)pluginList.get(i);
            String sName = curInfo.getName();
            String sCurPluginVersion = curInfo.getVersion();
            String sCompat = curInfo.getCompatibleWith();
            int iCompCmp = AutoDocStringUtils.compareVersions(sCompat, sCurVersion);
            if (iCompCmp <= 0) {
                AutoDocPluginInfo curAutoDocInfo = AutoDocPluginUtils.findMatchingPluginFromList(installed, curInfo);
                boolean bValidToBeAdded = false;
                if (curAutoDocInfo != null && AutoDocStringUtils.compareVersions(curAutoDocInfo.getVersion(), sCurPluginVersion) <= 0) {
                    bValidToBeAdded = true;
                } else if (curAutoDocInfo == null) {
                    bValidToBeAdded = true;
                }
                if (bValidToBeAdded) {
                    AutoDocPluginInfo existing = (AutoDocPluginInfo)ht.get(sName);
                    if (existing != null) {
                        String exVersion = existing.getVersion();
                        int iCmpEx = AutoDocStringUtils.compareVersions(exVersion, sCurPluginVersion);
                        if (iCmpEx < 0) {
                            ht.put(sName, curInfo);
                        }
                    } else {
                        ht.put(sName, curInfo);
                    }
                }
            }
            ++i;
        }
        ArrayList<AutoDocPluginInfo> matching = new ArrayList<AutoDocPluginInfo>();
        Enumeration keys = ht.keys();
        while (keys.hasMoreElements()) {
            String sKey = (String)keys.nextElement();
            AutoDocPluginInfo curInfo = (AutoDocPluginInfo)ht.get(sKey);
            matching.add(curInfo);
        }
        if (bSort) {
            Collections.sort(matching);
        }
        return matching;
    }

    public static AutoDocPluginInfo findMatchingPluginFromList(List list, AutoDocPluginInfo curInfo) {
        AutoDocPluginInfo foundInfo = null;
        if (list != null && curInfo != null) {
            int iNumPlugins = list.size();
            int j = 0;
            while (j < iNumPlugins) {
                AutoDocPluginInfo plug_info = (AutoDocPluginInfo)list.get(j);
                if (plug_info.compareByName(curInfo)) {
                    foundInfo = plug_info;
                    break;
                }
                ++j;
            }
        }
        return foundInfo;
    }

    public static void installPlugin(String sURLBase, AutoDocPluginInfo pluginInfo, String sProgDir, boolean bCreateBak) throws Error {
        File fProgDir = new File(sProgDir);
        File fOutDir = new File(sProgDir, "plugins");
        if (!FileUtils.checkDirCanWrite(fProgDir)) {
            throw new Error("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION: " + sProgDir);
        }
        if (!FileUtils.checkDirCanWrite(fOutDir)) {
            throw new Error("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION: " + FileUtils.toCanonicalPath(fOutDir));
        }
        String sFilename = pluginInfo.getFilename();
        String sURL = String.valueOf(sURLBase) + "/" + sFilename;
        String sBaseName = FileUtils.removeFileNameExtension(sFilename);
        int iVersSep = sBaseName.lastIndexOf(95);
        if (iVersSep >= 0) {
            sBaseName = sBaseName.substring(0, iVersSep);
        }
        File fTargetDir = new File(fOutDir, sBaseName);
        String sTargetDir = FileUtils.toCanonicalPath(fTargetDir);
        if (fTargetDir.exists() && !fTargetDir.isDirectory()) {
            throw new Error("MSG_GUI_PLUGMGR_ERR_FAILCREATPGDIR");
        }
        File fBackup = null;
        String sBackup = "";
        String sVersion = "";
        String sTempDir = "";
        boolean bBackupSuccessful = false;
        try {
            File fTempDir = FileUtils.createTempDirectory("AutoDocTmp");
            sTempDir = FileUtils.toCanonicalPath(fTempDir);
            SystemUtils.downloadFile(sURL, sTempDir, 5, 5);
            if (fTargetDir.exists()) {
                File fPlugin = new File(fTargetDir, String.valueOf(sBaseName) + ".jar");
                AutoDocPluginInterface instPlugin = AutoDocPluginUtils.loadPlugin(fPlugin);
                instPlugin.init(FileUtils.toCanonicalPath(fPlugin), null);
                sVersion = "_" + instPlugin.getPluginVersion();
                File fBackupBase = new File(fOutDir, "Backup");
                if (!fBackupBase.exists()) {
                    fBackupBase.mkdirs();
                }
                fBackup = new File(fBackupBase, sBaseName);
                sBackup = FileUtils.toCanonicalPath(fBackup);
                if (fBackup.exists()) {
                    if (fBackup.isDirectory()) {
                        FileUtils.deleteDir(sBackup);
                    } else {
                        FileUtils.deleteFile(sBackup);
                    }
                }
                FileUtils.copyDir(sTargetDir, sBackup);
                FileUtils.cleanDir(sTargetDir);
                bBackupSuccessful = true;
            }
            File fZip = new File(fTempDir, sFilename);
            String sZip = FileUtils.toCanonicalPath(fZip);
            String sNewOutdir = FileUtils.toCanonicalPath(fOutDir);
            ZipUtils.unzipDirectory(sZip, sNewOutdir, true);
            FileUtils.deleteDir(sTempDir);
            if (fBackup != null) {
                if (bCreateBak) {
                    ZipUtils.zipDirectory(String.valueOf(sBackup) + sVersion + ".zip", sBackup, false);
                }
                FileUtils.deleteDir(sBackup);
            }
        }
        catch (IOException e) {
            if (bBackupSuccessful) {
                try {
                    File fTempDir = new File(sTempDir);
                    if (!sTempDir.equals("") && fTempDir.exists()) {
                        FileUtils.deleteDir(sTempDir);
                    }
                    FileUtils.cleanDir(sTargetDir);
                    FileUtils.copyDir(sBackup, sTargetDir);
                    FileUtils.deleteDir(sBackup);
                }
                catch (IOException fTempDir) {
                    // empty catch block
                }
            }
            throw new Error(e.getMessage());
        }
        catch (Error e) {
            if (bBackupSuccessful) {
                try {
                    File fTempDir = new File(sTempDir);
                    if (!sTempDir.equals("") && fTempDir.exists()) {
                        FileUtils.deleteDir(sTempDir);
                    }
                    FileUtils.cleanDir(sTargetDir);
                    FileUtils.copyDir(sBackup, sTargetDir);
                    FileUtils.deleteDir(sBackup);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new Error(e.getMessage());
        }
    }

    public static void removePlugin(AutoDocPluginInfo pluginInfo, String sProgDir, boolean bRemoveBak) throws Error {
        File fTargetDir;
        File fProgDir = new File(sProgDir);
        File fOutDir = new File(sProgDir, "plugins");
        if (!FileUtils.checkDirCanWrite(fProgDir)) {
            throw new Error("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION: " + sProgDir);
        }
        if (!FileUtils.checkDirCanWrite(fOutDir)) {
            throw new Error("MSG_GUI_PLUGMGR_ERR_NOWRITEPERMISSION: " + FileUtils.toCanonicalPath(fOutDir));
        }
        String sFilename = pluginInfo.getFilename();
        String sBaseName = FileUtils.removeFileNameExtension(sFilename);
        int iVersSep = sBaseName.lastIndexOf(95);
        if (iVersSep >= 0) {
            sBaseName = sBaseName.substring(0, iVersSep);
        }
        if ((fTargetDir = new File(fOutDir, sBaseName)).exists() && fTargetDir.isDirectory()) {
            File fBackupBase;
            String sTargetDir = FileUtils.toCanonicalPath(fTargetDir);
            FileUtils.deleteDir(sTargetDir);
            if (bRemoveBak && (fBackupBase = new File(fOutDir, "Backup")).exists() && fBackupBase.isDirectory()) {
                String[] saList = fBackupBase.list();
                int i = 0;
                while (i < saList.length) {
                    String sCurfile = saList[i];
                    File fCurFile = new File(fBackupBase, sCurfile);
                    if (!fCurFile.isDirectory() && sCurfile.startsWith(sBaseName) && sCurfile.endsWith(".zip")) {
                        FileUtils.deleteFile(FileUtils.toCanonicalPath(fCurFile));
                    }
                    ++i;
                }
            }
        }
    }
}

