/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocPluginInterface;
import de.enache.AutoDoc.AutoDocStringUtils;

public class AutoDocPluginInfo
implements Comparable {
    private AutoDocPluginInterface cPlugin = null;
    private String sName = "";
    private String sVersion = "";
    private String sDescription = "";
    private String sFilename = "";
    private String sCompatibleWith = "";

    public AutoDocPluginInfo(AutoDocPluginInterface cPlugin, String sFilename) {
        this.cPlugin = cPlugin;
        this.sFilename = sFilename;
        this.sName = this.cPlugin.getPluginName();
        this.sVersion = this.cPlugin.getPluginVersion();
        this.sCompatibleWith = this.cPlugin.getCompatibleWithVersion();
        this.sDescription = this.cPlugin.getPluginDescription();
    }

    public AutoDocPluginInfo(String sFilename, String sName, String sVersion, String sCompatibleWith, String sDescription) {
        this.cPlugin = null;
        this.sFilename = sFilename;
        this.sName = sName;
        this.sVersion = sVersion;
        this.sCompatibleWith = sCompatibleWith;
        this.sDescription = sDescription;
    }

    public void updateInfo() {
        if (this.cPlugin != null) {
            this.sName = this.cPlugin.getPluginName();
            this.sVersion = this.cPlugin.getPluginVersion();
            this.sCompatibleWith = this.cPlugin.getCompatibleWithVersion();
            this.sDescription = this.cPlugin.getPluginDescription();
        }
    }

    public AutoDocPluginInterface getPluginObject() {
        return this.cPlugin;
    }

    public String getName() {
        return this.sName;
    }

    public String getFilename() {
        return this.sFilename;
    }

    public String getVersion() {
        return this.sVersion;
    }

    public String getCompatibleWith() {
        return this.sCompatibleWith;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public int compareTo(Object o) {
        if (o != null) {
            return this.sName.compareTo(((AutoDocPluginInfo)o).sName);
        }
        return 1;
    }

    public boolean compareByName(AutoDocPluginInfo info2) {
        return this.sName.equals(info2.sName);
    }

    public int compareVersion(String sCmpVersion) {
        return AutoDocStringUtils.compareVersions(this.sVersion, sCmpVersion);
    }

    public boolean isCompatibleWith(String sCmpVersion) {
        boolean bRes = false;
        if (AutoDocStringUtils.compareVersions(this.sCompatibleWith, sCmpVersion) <= 0) {
            bRes = true;
        }
        return bRes;
    }

    public String toString() {
        String sRes = "";
        sRes = String.valueOf(sRes) + "Name: " + this.sName + ", ";
        sRes = String.valueOf(sRes) + "Version: " + this.sVersion + ", ";
        sRes = String.valueOf(sRes) + "Description: " + this.sDescription + ", ";
        sRes = String.valueOf(sRes) + "Filename: " + this.sFilename + ", ";
        sRes = String.valueOf(sRes) + "CompatibleWith: " + this.sCompatibleWith;
        return sRes;
    }
}

