/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc;

import de.enache.AutoDoc.AutoDocTag;
import java.util.ArrayList;

public class AutoDocFunctionInfo {
    protected String sFuncName = "";
    protected String sFuncArgs = "";
    protected ArrayList vModifiers = new ArrayList();
    protected int iType = 0;
    protected String FuncArgsNorm = "";
    protected String Signature = "";
    protected String sFuncDef = "";
    protected String sFuncNameLong = "";
    protected String sParent = "";
    protected String sDescription = "";
    protected boolean bKeepPre = false;
    protected AutoDocTag curTag = null;

    public AutoDocFunctionInfo(AutoDocTag curTag, String sFuncDef, String sDescription, String sParent, int iType) {
        this.curTag = curTag;
        this.sFuncDef = sFuncDef;
        this.sParent = sParent;
        this.iType = iType;
        this.sDescription = sDescription;
        this.bKeepPre = curTag.getTagInfo().isKeepPre();
        this.parseFuncDef(sFuncDef);
        this.Signature = this.toSignature();
    }

    private AutoDocFunctionInfo(String sFuncDef, String sParent, int iType) {
        this.curTag = null;
        this.sFuncDef = sFuncDef;
        this.sParent = sParent;
        this.iType = iType;
        this.sDescription = "";
        this.bKeepPre = iType == 1;
        this.parseFuncDef(sFuncDef);
        this.Signature = this.toSignature();
    }

    public static AutoDocFunctionInfo constructFromCallString(String sCall) {
        String[] saComp = sCall.split("\\.", 2);
        String sClass = "";
        String sFuncDef = "";
        if (saComp.length > 1) {
            sClass = saComp[0];
            sFuncDef = saComp[1];
        } else {
            sFuncDef = saComp[0];
        }
        AutoDocFunctionInfo ci = new AutoDocFunctionInfo(sFuncDef, sClass, 0);
        return ci;
    }

    public AutoDocTag getCurTag() {
        return this.curTag;
    }

    public String getName() {
        return this.sFuncName;
    }

    public String getArgs() {
        return this.sFuncArgs;
    }

    public ArrayList getModifiers() {
        return this.vModifiers;
    }

    public String getsDescription() {
        return this.sDescription;
    }

    public String getsFuncDef() {
        return this.sFuncDef;
    }

    public int getType() {
        return this.iType;
    }

    public boolean isConstructor() {
        boolean bResult = false;
        if (this.iType == 0 && !this.sParent.equals("") && this.sParent.equals("sFuncName")) {
            bResult = true;
        }
        return bResult;
    }

    protected void parseFuncDef(String sFuncDefOrg) {
        if (this.iType != 2) {
            if (!this.bKeepPre) {
                String[] saNameDef;
                int iOpenArgs;
                String sFuncDefMod = sFuncDefOrg;
                int iCppSep = sFuncDefOrg.indexOf("::");
                if (iCppSep >= 0) {
                    String sClass = sFuncDefOrg.substring(0, iCppSep);
                    sFuncDefMod = sFuncDefOrg.substring(iCppSep + 2);
                    if (!sClass.equals(this.sParent)) {
                        this.sParent = sClass;
                    }
                    this.sFuncDef = sFuncDefMod;
                }
                if ((iOpenArgs = sFuncDefMod.indexOf(40)) >= 0) {
                    int iCloseArgs;
                    this.sFuncNameLong = sFuncDefMod.substring(0, iOpenArgs);
                    String sRest = "";
                    if (iOpenArgs + 1 < sFuncDefMod.length()) {
                        sRest = sFuncDefMod.substring(iOpenArgs + 1);
                    }
                    if ((iCloseArgs = sRest.lastIndexOf(41)) >= 0) {
                        this.sFuncArgs = sRest.substring(0, iCloseArgs);
                    }
                } else {
                    this.sFuncNameLong = sFuncDefMod;
                }
                if ((saNameDef = this.sFuncNameLong.split("\\s+")).length > 0) {
                    int i = 0;
                    while (i < saNameDef.length - 1) {
                        this.vModifiers.add(saNameDef[i]);
                        ++i;
                    }
                    this.sFuncName = saNameDef[saNameDef.length - 1];
                } else {
                    this.sFuncName = this.sFuncNameLong;
                }
                this.parseArguments();
            } else {
                this.sFuncName = sFuncDefOrg;
            }
        } else {
            this.sFuncName = "";
            this.sFuncDef = sFuncDefOrg;
            int iPos = sFuncDefOrg.indexOf(61);
            if (iPos >= 0) {
                this.sFuncName = sFuncDefOrg.substring(0, iPos);
                this.sFuncDef = sFuncDefOrg.substring(iPos + 1);
            }
        }
    }

    protected void parseArguments() {
        if (!this.sFuncArgs.equals("")) {
            String[] saArgs = this.sFuncArgs.split("\\s*,\\s*");
            int i = 0;
            while (i < saArgs.length) {
                String sType;
                String sArgRes = saArgs[i];
                String sArg = saArgs[i].replaceAll("\\s+", " ").trim();
                int iAs = sArg.toUpperCase().indexOf(" AS ");
                if (iAs >= 0) {
                    sArgRes = sType = sArg.substring(iAs + 4).trim();
                } else {
                    sType = "";
                    int iLastSpc = sArg.lastIndexOf(" ");
                    sArgRes = iLastSpc >= 0 ? (sType = sArg.substring(0, iLastSpc).trim()) : "*";
                }
                if (!sArgRes.equals("")) {
                    this.FuncArgsNorm = this.FuncArgsNorm.equals("") ? sArgRes : String.valueOf(this.FuncArgsNorm) + "," + sArgRes;
                }
                ++i;
            }
        }
    }

    public String toString() {
        String sReturn = "";
        int iMod = this.vModifiers.size();
        if (iMod > 0) {
            sReturn = String.valueOf(sReturn);
            int i = 0;
            while (i < iMod) {
                sReturn = String.valueOf(sReturn) + (String)this.vModifiers.get(i);
                if (i < iMod - 1) {
                    sReturn = String.valueOf(sReturn) + " ";
                }
                ++i;
            }
            sReturn = String.valueOf(sReturn) + " ";
        }
        String sClassPre = "";
        if (!this.sParent.equals("")) {
            sClassPre = String.valueOf(this.sParent) + ".";
        }
        String sFuncArgOut = "";
        if (!this.sFuncArgs.equals("")) {
            sFuncArgOut = "(" + this.sFuncArgs + ")";
        }
        sReturn = String.valueOf(sReturn) + sClassPre + this.sFuncName + sFuncArgOut;
        return sReturn;
    }

    private String toSignature() {
        String sReturn = "";
        String sClassPre = "";
        if (!this.sParent.equals("")) {
            sClassPre = String.valueOf(this.sParent) + ".";
        }
        String sFuncArgOut = "";
        if (!this.sFuncArgs.equals("")) {
            sFuncArgOut = "(" + this.FuncArgsNorm + ")";
        }
        sReturn = String.valueOf(sReturn) + sClassPre + this.sFuncName + sFuncArgOut;
        return sReturn;
    }

    public String getSignature() {
        return this.Signature;
    }

    public boolean callMatch(String sCall) {
        AutoDocFunctionInfo ci = AutoDocFunctionInfo.constructFromCallString(sCall);
        return ci.Signature.equals(this.Signature);
    }
}

