/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.Plugin.ZippedCode;

import de.enache.AutoDoc.AutoDocPluginInputPackaged;
import de.enache.AutoDoc.AutoDocSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZippedCode_Plugin
extends AutoDocPluginInputPackaged {
    public void init(String sPathToJar, AutoDocSettings mySettings) {
        super.init(sPathToJar, mySettings);
    }

    public void process() throws Error {
        String sOutDir;
        String sFileName = this.sInput;
        this.sVirtualOutput = sOutDir = sFileName.substring(0, sFileName.length() - 4);
        this.sOutput = ZippedCode_Plugin.createTempDirectoryName();
        File fOutDir = new File(this.sOutput);
        try {
            boolean bIsUsedDir = this.isUsedDirectory(fOutDir);
            if (bIsUsedDir) {
                throw new Error("Temporary directory " + sOutDir + " exists already and is not empty. Please delete it, if it is left over from a previous failed run.");
            }
        }
        catch (SecurityException e) {
            throw new Error("Temporary directory " + sOutDir + " exists already and is not empty. Please delete it, if it is left over from a previous failed run.");
        }
        try {
            ZippedCode_Plugin.unzipDirectory(sFileName, this.sOutput, true);
        }
        catch (IOException e) {
            throw new Error("Error unzipping file " + sFileName + ". Message: " + e.getMessage());
        }
    }

    public void cleanup() throws Error {
        ZippedCode_Plugin.deleteDir(this.sOutput);
    }

    public boolean checkValidInput(String sFilename) {
        boolean bResult = false;
        String ext = ZippedCode_Plugin.getFileNameExtension(sFilename);
        if (ext.equalsIgnoreCase("zip")) {
            try {
                ZipFile zipFile = new ZipFile(sFilename);
                bResult = true;
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bResult;
    }

    public String getExcludePattern() {
        return "";
    }

    public String getAbsoluteFilenameForOutput(String sAbsFilename) {
        String sRes = sAbsFilename;
        String sOutDir = this.sVirtualOutput;
        if (!sOutDir.equals("")) {
            sOutDir = new File(sOutDir).getAbsolutePath();
            sRes = String.valueOf(sOutDir) + ".zip";
        }
        return sRes;
    }

    public String getAbsoluteFilenameLabelForOutput(String sAbsFilename) {
        String sRes = sAbsFilename;
        String sOutDir = this.sVirtualOutput;
        if (!sOutDir.equals("")) {
            String sRest = sAbsFilename.substring(sOutDir.length() + 1);
            sOutDir = new File(sOutDir).getAbsolutePath();
            sRes = String.valueOf(sOutDir) + ".zip#" + sRest;
        }
        return sRes;
    }

    private boolean isUsedDirectory(File fOutDir) throws SecurityException {
        File[] fList;
        boolean bIsUsedDir = false;
        if (fOutDir.exists() && fOutDir.isDirectory() && (fList = fOutDir.listFiles()) != null && fList.length > 0) {
            bIsUsedDir = true;
        }
        return bIsUsedDir;
    }

    public static void unzipDirectory(String sZipFile, String sDir, boolean isRoot) throws IOException {
        byte[] buffer = new byte[1024];
        File fDir = new File(sDir);
        if (!isRoot) {
            String sTmp = "~" + sZipFile;
            int iPos = sZipFile.lastIndexOf(46);
            if (iPos >= 0 && iPos < sZipFile.length() - 1) {
                sTmp = sZipFile.substring(0, iPos);
            }
            File fTmp = new File(sTmp);
            fDir = new File(fDir, fTmp.getName());
            sDir = fDir.getAbsolutePath();
        }
        if (!fDir.exists()) {
            fDir.mkdirs();
        }
        ZipFile fZip = new ZipFile(new File(sZipFile));
        Enumeration<? extends ZipEntry> en1 = fZip.entries();
        while (en1.hasMoreElements()) {
            ZipEntry ze = en1.nextElement();
            InputStream zis = fZip.getInputStream(ze);
            String fileName = ze.getName();
            File newFile = new File(String.valueOf(sDir) + "/" + fileName);
            if (fileName.endsWith("/")) {
                newFile.mkdirs();
                continue;
            }
            File parent = new File(newFile.getParent());
            parent.mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            int len = zis.read(buffer);
            while (len > 0) {
                fos.write(buffer, 0, len);
                len = zis.read(buffer);
            }
            fos.close();
        }
        fZip.close();
    }

    public static String getFileNameExtension(String sFilename) {
        String sReturn = "";
        int iPos = sFilename.lastIndexOf(46);
        if (iPos >= 0 && iPos < sFilename.length() - 1) {
            sReturn = sFilename.substring(iPos + 1, sFilename.length());
        }
        return sReturn;
    }

    public static void cleanDir(String sDir) {
        File fOutPath = new File(sDir);
        if (fOutPath.exists() && fOutPath.isDirectory()) {
            File[] fList = fOutPath.listFiles();
            int i = 0;
            while (i < fList.length) {
                File fCur = fList[i];
                if (!fCur.isDirectory()) {
                    fCur.delete();
                } else {
                    String sCurFile = fCur.getAbsolutePath();
                    try {
                        sCurFile = fCur.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!sCurFile.equals("")) {
                        ZippedCode_Plugin.cleanDir(sCurFile);
                    }
                    fList[i].delete();
                }
                ++i;
            }
        }
    }

    public static void deleteDir(String sDir) {
        File fDir = new File(sDir);
        if (fDir.exists() && fDir.isDirectory()) {
            ZippedCode_Plugin.cleanDir(sDir);
            fDir.delete();
        }
    }
}

