/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.Plugin.SAS_EG;

import de.enache.AutoDoc.AutoDocFile;
import de.enache.AutoDoc.AutoDocFileExtInfo;
import de.enache.AutoDoc.AutoDocPluginInputPackaged;
import de.enache.AutoDoc.AutoDocSettings;
import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.Plugin.SAS_EG.EGPFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SAS_EG_Plugin
extends AutoDocPluginInputPackaged {
    private String sDateFmt = "dd.MM.yyyy";
    private String sNameFmt = "First Last";
    private AutoDocFileExtInfo myFilter = null;

    public void init(String sPathToJar, AutoDocSettings mySettings) {
        super.init(sPathToJar, mySettings);
        String sExt = "";
        String sExcludes = "";
        ArrayList vExtDef = new ArrayList();
        ArrayList vExtDefPara = new ArrayList();
        if (mySettings != null) {
            sExt = mySettings.getFileFilter();
            vExtDef = mySettings.getExtDefaultsList();
            vExtDefPara = mySettings.getExtDefParaList();
            sExcludes = mySettings.getExclude();
        }
        this.myFilter = new AutoDocFileExtInfo(sExt, sExcludes, vExtDef, vExtDefPara);
        this.readParameters();
    }

    public String getExcludePattern() {
        return "*.egp_header";
    }

    public boolean checkValidInput(String sFilename) {
        boolean bResult = false;
        String ext = FileUtils.getFileNameExtension((String)sFilename);
        if (ext.equalsIgnoreCase("egp")) {
            try {
                ZipFile zipFile = new ZipFile(sFilename);
                ZipEntry ze = zipFile.getEntry("project.xml");
                if (ze != null) {
                    bResult = true;
                }
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bResult;
    }

    public String getStringParameter(String sParamName) {
        String sRes = "";
        if (sParamName.equals("Input")) {
            sRes = this.sInput;
        } else if (sParamName.equals("Output")) {
            sRes = this.sOutput;
        } else if (sParamName.equals("VirtualOutput")) {
            sRes = this.sVirtualOutput;
        } else if (sParamName.equals("DateFormat")) {
            sRes = this.sDateFmt;
        } else if (sParamName.equals("NameFormat")) {
            sRes = this.sNameFmt;
        }
        return sRes;
    }

    public void setStringParameter(String sParamName, String sValue) {
        if (sParamName.equals("Input")) {
            this.sInput = sValue;
        } else if (sParamName.equals("Output")) {
            this.sOutput = sValue;
        } else if (sParamName.equals("VirtualOutput")) {
            this.sVirtualOutput = sValue;
        } else if (sParamName.equals("DateFormat")) {
            this.sDateFmt = sValue;
        } else if (sParamName.equals("NameFormat")) {
            this.sNameFmt = sValue;
        }
    }

    public void process() throws Error {
        String sOutDir;
        String sFileName = this.sInput;
        this.sVirtualOutput = sOutDir = sFileName.substring(0, sFileName.length() - 4);
        this.sOutput = SAS_EG_Plugin.createTempDirectoryName();
        File fOutDir = new File(this.sOutput);
        try {
            boolean bIsUsedDir = this.isUsedDirectory(fOutDir);
            if (bIsUsedDir) {
                throw new Error("Temporary directory " + sOutDir + " exists already and is not empty. Please delete it, if it is left over from a previous failed run.");
            }
        }
        catch (SecurityException e) {
            throw new Error("Temporary directory " + sOutDir + " exists already and is not empty. Please delete it, if it is left over from a previous failed run.");
        }
        String sHeaderIndexFile = String.valueOf(sFileName.substring(0, sFileName.length() - 4)) + ".egp_header";
        File fHead = new File(sHeaderIndexFile);
        if (!fHead.exists() || !fHead.isFile()) {
            sHeaderIndexFile = "";
        }
        String sTagChar = this.autoDetectTagChar(sHeaderIndexFile, "@");
        String sExt = "sas";
        EGPFile egpFile = new EGPFile(sFileName, sTagChar, this.myFilter.getBlockBegin(sExt), this.myFilter.getBlockEnd(sExt), this.myFilter.getBorderChars(sExt), this.sDateFmt, this.sNameFmt);
        egpFile.setMyParent(this);
        egpFile.extractCodeTasks(fOutDir, this.sVirtualOutput, true, sHeaderIndexFile);
    }

    public void cleanup() throws Error {
        FileUtils.deleteDir((String)this.sOutput);
    }

    public String getAbsoluteFilenameForOutput(String sAbsFilename) {
        String sRes = sAbsFilename;
        String sOutDir = this.sVirtualOutput;
        if (!sOutDir.equals("")) {
            sOutDir = FileUtils.toAbsolutePath((String)sOutDir);
            sRes = String.valueOf(sOutDir) + ".egp";
        }
        return sRes;
    }

    public String getAbsoluteFilenameLabelForOutput(String sAbsFilename) {
        String sRes = sAbsFilename;
        String sOutDir = this.sVirtualOutput;
        if (!sOutDir.equals("")) {
            String sRest = sAbsFilename.substring(sOutDir.length() + 1);
            sOutDir = FileUtils.toAbsolutePath((String)sOutDir);
            sRes = String.valueOf(sOutDir) + ".egp#" + sRest;
        }
        return sRes;
    }

    private void readParameters() {
        String sPluginPath = this.sPathToJar.substring(0, this.sPathToJar.length() - 4);
        String sPluginIniName = String.valueOf(sPluginPath) + ".plug_ini";
        FileInputStream fin2 = null;
        try {
            fin2 = new FileInputStream(sPluginIniName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Hashtable tab2 = FileUtils.readParamsFromFile(fin2);
        if (tab2 != null) {
            this.sDateFmt = (String)tab2.get("DateFormat");
            this.sNameFmt = (String)tab2.get("NameFormat");
        } else {
            this.outputNote("Plugin parameters cannot be read from file " + sPluginIniName + ".");
        }
    }

    private boolean isUsedDirectory(File fOutDir) throws SecurityException {
        File[] fList;
        boolean bIsUsedDir = false;
        if (fOutDir.exists() && fOutDir.isDirectory() && (fList = fOutDir.listFiles()) != null && fList.length > 0) {
            bIsUsedDir = true;
        }
        return bIsUsedDir;
    }

    private String autoDetectTagChar(String sFilename, String sDefTagChar) throws Error {
        File fHead;
        String sRes = sDefTagChar;
        if (this.mySettings != null && (fHead = new File(sFilename)).exists() && fHead.isFile()) {
            String sExt = "sas";
            AutoDocFile af = new AutoDocFile(this.mySettings, sFilename, this.myFilter.getBlockBegin(sExt), this.myFilter.getBlockEnd(sExt), this.myFilter.getBorderChars(sExt), this.myFilter.getQuoteChar(sExt), null, "");
            sRes = af.getTagCharacter();
        }
        return sRes;
    }
}

