/*
 * Decompiled with CFR 0.152.
 */
package de.enache.AutoDoc.Plugin.SAS_EG;

import de.enache.AutoDoc.FileUtils;
import de.enache.AutoDoc.Plugin.SAS_EG.CodeTaskEntry;
import de.enache.AutoDoc.Plugin.SAS_EG.ConversionFormatUtils;
import de.enache.AutoDoc.Plugin.SAS_EG.SAS_EG_Plugin;
import de.enache.AutoDoc.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EGPFile {
    private SAS_EG_Plugin myParent = null;
    public String sFilename = "";
    public File f = null;
    public Document xmlDoc = null;
    private ArrayList lProcessID = new ArrayList();
    private ArrayList lMeta = new ArrayList();
    private ArrayList lMetaNotFound = new ArrayList();
    private ArrayList lMetaCode = new ArrayList();
    private int iUnnamedCounter = 0;
    private String TagCharacter = "";
    private String BlockBegin = "/*!";
    private String BlockEnd = "*/";
    private String BorderChars = "*";
    public String sDateFmt = "";
    public String sNameFmt = "";
    private static String SysNewLine = System.getProperty("line.separator");

    public EGPFile(String sFilename, String TagCharacter, String BlockBegin, String BlockEnd, String BorderChars, String sDateFmt, String sNameFmt) {
        this.sFilename = sFilename;
        this.TagCharacter = TagCharacter;
        this.BlockBegin = BlockBegin;
        this.BlockEnd = BlockEnd;
        this.BorderChars = BorderChars;
        this.sDateFmt = sDateFmt;
        this.sNameFmt = sNameFmt;
        this.f = new File(sFilename);
        this.readMetaData();
    }

    public void readMetaData() {
        try {
            ZipFile fZip = new ZipFile(this.f);
            Enumeration<? extends ZipEntry> en1 = fZip.entries();
            while (en1.hasMoreElements()) {
                ZipEntry ze = en1.nextElement();
                String fileName = ze.getName();
                if (!fileName.equals("project.xml")) continue;
                InputStream zis = fZip.getInputStream(ze);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                this.xmlDoc = dBuilder.parse(zis);
                this.xmlDoc.getDocumentElement().normalize();
                break;
            }
            fZip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (this.xmlDoc != null) {
            this.parseProcessList(this.xmlDoc);
            this.parseCodeTaskMetaData(this.xmlDoc);
            this.sortProcesses();
        }
    }

    private void sortProcesses() {
        ArrayList<CodeTaskEntry> lMetaSorted = new ArrayList<CodeTaskEntry>();
        ArrayList lMetaNotFound = new ArrayList();
        int iLenProc = this.lProcessID.size();
        int iLenMeta = this.lMeta.size();
        boolean[] aMetaIDMatch = new boolean[iLenMeta];
        int j = 0;
        while (j < iLenMeta) {
            aMetaIDMatch[j] = false;
            ++j;
        }
        int i = 0;
        while (i < iLenProc) {
            String sCurID = (String)this.lProcessID.get(i);
            CodeTaskEntry metaEntry = null;
            int j2 = 0;
            while (j2 < iLenMeta) {
                CodeTaskEntry curEntry = (CodeTaskEntry)this.lMeta.get(j2);
                if (curEntry.getID().equals(sCurID)) {
                    metaEntry = curEntry;
                    aMetaIDMatch[j2] = true;
                    break;
                }
                ++j2;
            }
            if (metaEntry == null) {
                metaEntry = new CodeTaskEntry("", sCurID, "", "");
            }
            lMetaSorted.add(metaEntry);
            ++i;
        }
        j = 0;
        while (j < iLenMeta) {
            if (!aMetaIDMatch[j]) {
                lMetaNotFound.add(this.lMeta.get(j));
            }
            ++j;
        }
        this.lMeta = lMetaSorted;
        this.lMetaNotFound = lMetaNotFound;
    }

    private void parseProcessList(Document xmlDoc) {
        Node nPFD = EGPFile.getNodeFromPath(xmlDoc, "ProjectCollection/PFD");
        if (nPFD != null) {
            this.retrieveIDFromPFDNode(nPFD);
        } else {
            Node nElements = EGPFile.getNodeFromPath(xmlDoc, "ProjectCollection/Elements");
            NodeList lElements = nElements.getChildNodes();
            int iNumElem = lElements.getLength();
            int i = 0;
            while (i < iNumElem) {
                String sCurElemType;
                Element eElement;
                Node curNode = lElements.item(i);
                if (curNode.getNodeType() == 1 && (eElement = (Element)curNode).getNodeName().equals("Element") && ((sCurElemType = eElement.getAttribute("Type")).equals("SAS.EG.ProjectElements.PFD") || sCurElemType.equals("SAS.EG.ProjectElements.ProcessFlowContainer")) && (nPFD = EGPFile.findChildElement(curNode, "PFD")) != null) {
                    this.retrieveIDFromPFDNode(nPFD);
                }
                ++i;
            }
        }
    }

    private void retrieveIDFromPFDNode(Node nElemSub) {
        NodeList lProcElements = nElemSub.getChildNodes();
        int iNumProcElem = lProcElements.getLength();
        int j = 0;
        while (j < iNumProcElem) {
            Element elemID;
            String sID;
            Node nElemID;
            Node nElem2;
            Node curProcNode = lProcElements.item(j);
            if (curProcNode.getNodeType() == 1 && (nElem2 = EGPFile.findChildElement(curProcNode, "Element")) != null && (nElemID = EGPFile.findChildElement(nElem2, "ID")) != null && (sID = (elemID = (Element)nElemID).getTextContent()) != null && !sID.equals("")) {
                this.addIDToList(sID);
            }
            ++j;
        }
    }

    private void addIDToList(String sID) {
        int iFound = EGPFile.findInStringList(this.lProcessID, sID);
        if (iFound < 0) {
            this.lProcessID.add(sID);
        }
    }

    private static int findIDInMetaList(List list, String s) {
        int iRet = -1;
        if (list != null) {
            int iLen = list.size();
            int i = 0;
            while (i < iLen) {
                CodeTaskEntry meta = (CodeTaskEntry)list.get(i);
                String sID = meta.getID();
                if (sID.equals(s)) {
                    iRet = i;
                    break;
                }
                ++i;
            }
        }
        return iRet;
    }

    private static int findInStringList(List list, String s) {
        int iRet = -1;
        if (list != null) {
            int iLen = list.size();
            int i = 0;
            while (i < iLen) {
                if (list.get(i).equals(s)) {
                    iRet = i;
                    break;
                }
                ++i;
            }
        }
        return iRet;
    }

    private void parseCodeTaskMetaData(Document xmlDoc) {
        Node nElements = EGPFile.getNodeFromPath(xmlDoc, "ProjectCollection/Elements");
        NodeList lElements = nElements.getChildNodes();
        int iNumElem = lElements.getLength();
        int i = 0;
        while (i < iNumElem) {
            Element eElement;
            Node curNode = lElements.item(i);
            if (curNode.getNodeType() == 1 && (eElement = (Element)curNode).getNodeName().equals("Element")) {
                CodeTaskEntry meta;
                Node nElemSub;
                String sCurElemType = eElement.getAttribute("Type");
                if (sCurElemType.equals("SAS.EG.ProjectElements.Code")) {
                    nElemSub = EGPFile.findChildElement(curNode, "Element");
                    if (nElemSub != null && (meta = this.retrieveCodeTaskMetaData(curNode, nElemSub, sCurElemType)) != null) {
                        this.lMetaCode.add(meta);
                    }
                } else {
                    nElemSub = EGPFile.findChildElement(curNode, "Element");
                    if (nElemSub != null && (meta = this.retrieveCodeTaskMetaData(curNode, nElemSub, sCurElemType)) != null) {
                        this.lMeta.add(meta);
                    }
                }
            }
            ++i;
        }
    }

    private CodeTaskEntry retrieveCodeTaskMetaData(Node nParent, Node nElemSub, String sCurElemType) {
        Node nID;
        String sID;
        CodeTaskEntry meta = null;
        Node nType = EGPFile.findChildElement(nElemSub, "Type");
        String sType = nType.getTextContent();
        if ((sType.equals("CODE") || sType.equals("TASK")) && !(sID = ((Element)(nID = EGPFile.findChildElement(nElemSub, "ID"))).getTextContent()).equals("")) {
            Node nCode;
            Node nLabel = EGPFile.findChildElement(nElemSub, "Label");
            String sLabel = ((Element)nLabel).getTextContent();
            meta = new CodeTaskEntry(sCurElemType, sID, sType, sLabel);
            meta.setContainer(this.getSubElementValue(nElemSub, "Container"));
            meta.setCreatedOnDateFromXMLString(this.getSubElementValue(nElemSub, "CreatedOn"));
            meta.setModifiedOnDateFromXMLString(this.getSubElementValue(nElemSub, "ModifiedOn"));
            meta.setModifiedBy(this.getSubElementValue(nElemSub, "ModifiedBy"));
            meta.setModifiedByEGID(this.getSubElementValue(nElemSub, "ModifiedByEGID"));
            meta.setModifiedByEGVer(this.getSubElementValue(nElemSub, "ModifiedByEGVer"));
            meta.setHasSerializationError(this.getSubElementValue(nElemSub, "HasSerializationError"));
            String sParent = "";
            sParent = this.getSubElementValue(nElemSub, "Parent");
            if (sParent.equals("")) {
                sParent = this.getSubElementValue(nElemSub, "InputIDs");
            }
            if (sParent.equals("") && (nCode = EGPFile.findChildElement(nParent, "Code")) != null && (sParent = this.getSubElementValue(nCode, "Parent")).equals("")) {
                sParent = this.getSubElementValue(nCode, "InputIDs");
            }
            meta.setParent(sParent);
            String sDNA = "";
            Node nCodeTask = EGPFile.findChildElement(nParent, "CodeTask");
            if (nCodeTask != null) {
                sDNA = this.getSubElementValue(nCodeTask, "DNA");
            }
            meta.setDNA(sDNA);
            Node nCode2 = EGPFile.findChildElement(nParent, "Code");
            if (nCode2 != null) {
                String sLibref = this.getSubElementValue(nCode2, "Libref_Code");
                String sBeginAppCode = this.getSubElementValue(nCode2, "BeginAppCode");
                String sBeginUserCode = this.getSubElementValue(nCode2, "BeginUserCode");
                String sTaskCode = this.getSubElementValue(nCode2, "TaskCode");
                String sEndUserCode = this.getSubElementValue(nCode2, "EndUserCode");
                String sEndAppCode = this.getSubElementValue(nCode2, "EndAppCode");
                String sLibrefCl_Code = this.getSubElementValue(nCode2, "LibrefCl_Code");
                String sCode = String.valueOf(sLibref) + SysNewLine + sBeginAppCode + SysNewLine + sBeginUserCode + SysNewLine + sTaskCode + SysNewLine + sEndUserCode + SysNewLine + sEndAppCode + SysNewLine + sLibrefCl_Code;
                meta.setCode(sCode);
            }
        }
        return meta;
    }

    private String getSubElementValue(Node node, String sKey) {
        String s;
        String sRet = "";
        Node foundNode = EGPFile.findChildElement(node, sKey);
        if (foundNode != null && (s = ((Element)foundNode).getTextContent()) != null) {
            sRet = s;
        }
        return sRet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extractCodeTasks(File fOutDir, String sVirtOutDir, boolean bExtractMissing, String sHeaderIndexFile) throws Error {
        byte[] buffer = new byte[1024];
        if (!this.f.exists() || !this.f.isFile()) throw new Error("Input file " + this.f.getName() + " does not exist.");
        if (fOutDir.exists() && fOutDir.isFile()) throw new Error("Output directory " + fOutDir.getName() + " exists as a file.");
        if (!fOutDir.exists()) {
            fOutDir.mkdirs();
        }
        ArrayList lMeta = this.createListOfEntriesToExtract(bExtractMissing);
        try {
            ZipFile fZip = new ZipFile(this.f);
            int iNumTasks = lMeta.size();
            if (iNumTasks == 0) {
                String sMsg = "No CodeTasks to be exctracted.";
                if (this.myParent != null) {
                    this.myParent.outputNote(sMsg);
                } else {
                    SystemUtils.println((String)sMsg);
                }
            }
            ArrayList<CodeTaskEntry> lWritten = new ArrayList<CodeTaskEntry>();
            int i = 0;
            while (i < iNumTasks) {
                Node nDNA;
                Document docDNA;
                String sDNA;
                CodeTaskEntry curEntry = (CodeTaskEntry)lMeta.get(i);
                String sID = curEntry.getID();
                String sZipDirName = String.valueOf(sID) + "/" + "code.sas";
                String sLabel = curEntry.getLabel();
                ZipEntry ze = fZip.getEntry(sZipDirName);
                if (ze != null) {
                    InputStream zis = fZip.getInputStream(ze);
                    String fileName = EGPFile.createNonExistingFilenameFromLabel(sLabel, fOutDir);
                    File newFile = new File(fOutDir, fileName);
                    FileOutputStream fos = new FileOutputStream(newFile);
                    int len = zis.read(buffer);
                    while (len > 0) {
                        fos.write(buffer, 0, len);
                        len = zis.read(buffer);
                    }
                    fos.close();
                    lWritten.add(curEntry);
                } else if (!sID.equals("") && !(sDNA = curEntry.getDNA()).equals("") && (docDNA = EGPFile.convertStringToXMLDocument(sDNA)) != null && (nDNA = EGPFile.getNodeFromPath(docDNA, "DNA")) != null) {
                    String sDNAType = this.getSubElementValue(nDNA, "Type");
                    if (sDNAType.equals("LocalFile") || sDNAType.equals("File")) {
                        lWritten.add(curEntry);
                    } else {
                        int iFound = EGPFile.findIDInMetaList(this.lMetaCode, sID);
                        int iFound2 = EGPFile.findIDInMetaList(lMeta, sID);
                        if (iFound < 0 && iFound2 < 0) {
                            this.createInlineCodeTask(fOutDir, curEntry);
                            lWritten.add(curEntry);
                        }
                    }
                }
                ++i;
            }
            fZip.close();
            this.createTaskIndex(fOutDir, sVirtOutDir, lWritten, sHeaderIndexFile);
            return;
        }
        catch (IOException e) {
            throw new Error("Error unzipping file " + this.f.getName() + ". Message: " + e.getMessage());
        }
    }

    private void createTaskIndex(File fOutDir, String sVirtOutDir, ArrayList lMeta, String sHeaderIndexFile) throws Error {
        if (this.f != null) {
            File fVirt = new File(sVirtOutDir);
            String sDirName = fVirt.getName();
            String sOutFilename = String.valueOf(sDirName) + "_Index.sas";
            File fOut = new File(fOutDir, sOutFilename);
            try {
                String fileName;
                int iFound;
                String sLabel;
                String sID;
                CodeTaskEntry curEntry;
                PrintStream psOut = new PrintStream(new FileOutputStream(fOut));
                String sBorder = "* ";
                if (this.BorderChars.length() > 0) {
                    sBorder = String.valueOf(this.BorderChars.substring(0, 1)) + " ";
                }
                if (sHeaderIndexFile.equals("")) {
                    String sMainLabel = "";
                    String sModifiedBy = "";
                    String sModifiedOn = "";
                    Node nMain = EGPFile.getNodeFromPath(this.xmlDoc, "ProjectCollection/Element");
                    if (nMain != null) {
                        sMainLabel = this.getSubElementValue(nMain, "Label");
                        sModifiedBy = this.getSubElementValue(nMain, "ModifiedBy");
                        sModifiedOn = this.getSubElementValue(nMain, "ModifiedOn");
                        if (!sModifiedOn.equals("")) {
                            sModifiedOn = ConversionFormatUtils.dateToString(ConversionFormatUtils.egpDateToCalendar(sModifiedOn), this.sDateFmt);
                        }
                    }
                    psOut.println(this.BlockBegin);
                    psOut.println(String.valueOf(sBorder) + this.TagCharacter + "program");
                    if (sMainLabel.equals("")) {
                        psOut.println(String.valueOf(sBorder) + this.TagCharacter + "brief  Enterprise Guide Project.");
                    } else {
                        psOut.println(String.valueOf(sBorder) + this.TagCharacter + "brief  Enterprise Guide Project " + sMainLabel + ".");
                    }
                    if (!sModifiedBy.equals("")) {
                        psOut.println(String.valueOf(sBorder) + this.TagCharacter + "author " + ConversionFormatUtils.formatName(sModifiedBy, this.sNameFmt));
                    }
                    if (!sModifiedBy.equals("")) {
                        psOut.println(String.valueOf(sBorder) + this.TagCharacter + "date   " + sModifiedOn);
                    }
                    psOut.println(sBorder);
                    psOut.println(String.valueOf(sBorder) + this.TagCharacter + "note   Automatically generated by EGP_Extractor.");
                    psOut.println(this.BlockEnd);
                } else {
                    try {
                        File fHead = new File(sHeaderIndexFile);
                        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fHead)));
                        String sLine = br.readLine();
                        while (sLine != null) {
                            psOut.println(sLine);
                            sLine = br.readLine();
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        throw new Error("Error reading EGP project header file " + sHeaderIndexFile + ".");
                    }
                }
                psOut.println();
                psOut.println(this.BlockBegin);
                int iLen = lMeta.size();
                int i = 0;
                while (i < iLen) {
                    curEntry = (CodeTaskEntry)lMeta.get(i);
                    sID = curEntry.getID();
                    sLabel = curEntry.getLabel();
                    iFound = EGPFile.findInStringList(this.lProcessID, sID);
                    if (iFound >= 0) {
                        fileName = this.getFilenameForLinks(curEntry, sLabel, false, fOutDir);
                        if (!fileName.toLowerCase().endsWith(".sas")) {
                            fileName = String.valueOf(fileName) + ".sas";
                        }
                        psOut.println(String.valueOf(sBorder) + this.TagCharacter + "includes \"" + fileName + "\"");
                    }
                    ++i;
                }
                psOut.println(this.BlockEnd);
                i = 0;
                while (i < iLen) {
                    curEntry = (CodeTaskEntry)lMeta.get(i);
                    sID = curEntry.getID();
                    sLabel = curEntry.getLabel();
                    iFound = EGPFile.findInStringList(this.lProcessID, sID);
                    if (iFound >= 0) {
                        fileName = this.getFilenameForLinks(curEntry, sLabel, true, fOutDir);
                        if (!fileName.toLowerCase().endsWith(".sas")) {
                            fileName = String.valueOf(fileName) + ".sas";
                        }
                        psOut.println("%include \"" + fileName + "\";");
                    }
                    ++i;
                }
                psOut.close();
            }
            catch (IOException e) {
                throw new Error("Unable to write to file " + sOutFilename);
            }
        }
    }

    public String getFilenameForLinks(CodeTaskEntry curEntry, String sDefault, boolean bAbsolute, File fOutDir) {
        String fileName = "";
        String sCurPath = this.f.getParentFile().getAbsolutePath();
        String sSep = sCurPath.indexOf(92) >= 0 ? "\\" : "/";
        String sDNA = curEntry.getDNA();
        String sDNAFullPath = "";
        boolean bIsLink = false;
        if (!sDNA.equals("")) {
            String sDNAType;
            Node nDNA;
            Document docDNA = EGPFile.convertStringToXMLDocument(sDNA);
            if (docDNA != null && (nDNA = EGPFile.getNodeFromPath(docDNA, "DNA")) != null && ((sDNAType = this.getSubElementValue(nDNA, "Type")).equals("LocalFile") || sDNAType.equals("File"))) {
                bIsLink = true;
                sDNAFullPath = this.getSubElementValue(nDNA, "FullPath");
                String sDNAParentName = this.getSubElementValue(nDNA, "ParentName");
                String sDNAName = this.getSubElementValue(nDNA, "Name");
                String sDNASep = this.getSubElementValue(nDNA, "Delimiter");
                if (!sDNAFullPath.equals("")) {
                    fileName = EGPFile.findExternalLinkEntry(sCurPath, sDNAFullPath, sDNAParentName, sDNAName, sDNASep);
                    if (!sSep.equals(sDNASep)) {
                        fileName = fileName.replace(sDNASep, sSep);
                    }
                }
            }
        } else {
            fileName = EGPFile.cleanFilename(sDefault, "_", 124);
        }
        if (bAbsolute && !fileName.equals(sDNAFullPath)) {
            File newFile;
            if (bIsLink) {
                newFile = new File(this.f.getParentFile(), fileName);
                fileName = FileUtils.toCanonicalPath((File)newFile);
            } else {
                newFile = new File(fOutDir, fileName);
                fileName = FileUtils.toCanonicalPath((File)newFile);
            }
        } else if (!bAbsolute && !fileName.equals(sDNAFullPath) && bIsLink) {
            fileName = ".." + sSep + fileName;
        }
        return fileName;
    }

    private void createInlineCodeTask(File fOutDir, CodeTaskEntry curEntry) {
        if (this.f != null && curEntry != null) {
            String sID = curEntry.getID();
            String sEGType = curEntry.getEGPElementType();
            String sLabel = curEntry.getLabel();
            String sTypeShort = curEntry.getShortType();
            if (sLabel.equals("")) {
                ++this.iUnnamedCounter;
                sLabel = String.valueOf(sTypeShort) + "_" + this.iUnnamedCounter;
            }
            String fileName = EGPFile.createNonExistingFilenameFromLabel(sLabel, fOutDir);
            File fOut = new File(fOutDir, fileName);
            try {
                PrintStream psOut = new PrintStream(new FileOutputStream(fOut));
                String sBorder = "* ";
                if (this.BorderChars.length() > 0) {
                    sBorder = String.valueOf(this.BorderChars.substring(0, 1)) + " ";
                }
                String sDate = curEntry.getModifiedOnAsString(this.sDateFmt);
                String sElemType = curEntry.getEGPElementType();
                psOut.println(this.BlockBegin);
                psOut.println(String.valueOf(sBorder) + this.TagCharacter + "subprogram");
                psOut.println(String.valueOf(sBorder) + this.TagCharacter + "brief " + sTypeShort + ": " + sLabel);
                psOut.println(sBorder);
                psOut.println(String.valueOf(sBorder) + this.TagCharacter + "author " + ConversionFormatUtils.formatName(curEntry.getModifiedBy(), this.sNameFmt));
                psOut.println(String.valueOf(sBorder) + this.TagCharacter + "date   " + sDate);
                psOut.println(sBorder);
                psOut.println(String.valueOf(sBorder) + this.TagCharacter + "note   Automatically generated by EGP_Extractor.");
                psOut.println(this.BlockEnd);
                psOut.println();
                if (!sElemType.equals("")) {
                    int iLenCode = this.lMetaCode.size();
                    CodeTaskEntry foundCodeEntry = null;
                    int i = 0;
                    while (i < iLenCode) {
                        CodeTaskEntry curCodeEntry = (CodeTaskEntry)this.lMetaCode.get(i);
                        String sParent = curCodeEntry.getParent();
                        if (!sID.equals("") && sParent.equals(sID)) {
                            foundCodeEntry = curCodeEntry;
                            break;
                        }
                        ++i;
                    }
                    if (foundCodeEntry != null) {
                        String sCode = foundCodeEntry.getCode();
                        if (!sCode.equals("")) {
                            psOut.println(sCode);
                        }
                    } else {
                        String sDNA = curEntry.getDNA();
                        if (!sDNA.equals("")) {
                            Document docDNA = EGPFile.convertStringToXMLDocument(sDNA);
                            if (docDNA != null) {
                                Node nDNA = EGPFile.getNodeFromPath(docDNA, "DNA");
                                if (nDNA != null) {
                                    String sDNAType = this.getSubElementValue(nDNA, "Type");
                                    if (sDNAType.equals("LocalFile")) {
                                        String sDNAFullPath = this.getSubElementValue(nDNA, "FullPath");
                                        if (!sDNAFullPath.equals("")) {
                                            psOut.println(this.BlockBegin);
                                            psOut.println(String.valueOf(sBorder) + this.TagCharacter + "includes \"" + sDNAFullPath + "\"");
                                            psOut.println(this.BlockEnd);
                                            psOut.println("%include \"" + sDNAFullPath + "\"");
                                        } else {
                                            psOut.println("Local file path empty!");
                                        }
                                    } else {
                                        psOut.println("Unknown DNA type " + sDNAType + ":");
                                        psOut.println(sDNA);
                                    }
                                } else {
                                    psOut.println("No DNA root element found:");
                                    psOut.println(sDNA);
                                }
                            } else {
                                psOut.println("DNA code cannot be parsed:");
                                psOut.println(sDNA);
                            }
                        } else {
                            psOut.println("No code found to extract here. ID: " + sID + ", Type: " + sEGType);
                        }
                    }
                }
                psOut.close();
            }
            catch (IOException e) {
                throw new Error("Unable to write to file " + fileName);
            }
        }
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    private ArrayList createListOfEntriesToExtract(boolean bExtractMissing) {
        ArrayList<CodeTaskEntry> lMeta = this.lMeta;
        if (bExtractMissing) {
            lMeta = new ArrayList<CodeTaskEntry>();
            int iLenFound = this.lMeta.size();
            int i = 0;
            while (i < iLenFound) {
                CodeTaskEntry curEntry = (CodeTaskEntry)this.lMeta.get(i);
                lMeta.add(curEntry);
                ++i;
            }
            int iLenMiss = this.lMetaNotFound.size();
            int i2 = 0;
            while (i2 < iLenMiss) {
                CodeTaskEntry curMiss = (CodeTaskEntry)this.lMetaNotFound.get(i2);
                String curLabel = curMiss.getLabel();
                String sMsg = "Code \"" + curLabel + "\" not found in task index list, but will be extracted anyway.";
                if (this.myParent != null) {
                    this.myParent.outputNote(sMsg);
                } else {
                    SystemUtils.println((String)sMsg);
                }
                lMeta.add(curMiss);
                ++i2;
            }
        } else {
            int iLenMiss = this.lMetaNotFound.size();
            int i = 0;
            while (i < iLenMiss) {
                CodeTaskEntry curMiss = (CodeTaskEntry)this.lMetaNotFound.get(i);
                String curLabel = curMiss.getLabel();
                String sMsg = "Code \"" + curLabel + "\" not found in task index list and will not be extracted.";
                if (this.myParent != null) {
                    this.myParent.outputNote(sMsg);
                } else {
                    SystemUtils.println((String)sMsg);
                }
                ++i;
            }
        }
        return lMeta;
    }

    public ArrayList getProcessIDList() {
        return this.lProcessID;
    }

    public ArrayList getMetaDataList() {
        return this.lMeta;
    }

    public ArrayList getMetaNotFound() {
        return this.lMetaNotFound;
    }

    public static String cleanFilename(String sFilename, String sRepChar, int iMaxLen) {
        String sForbitten = "*\\/:?\"<>|";
        String sRet = "";
        if (sFilename != null) {
            sFilename = sFilename.trim();
            int iLen = sFilename.length();
            if (iMaxLen >= 0 && iLen > iMaxLen) {
                iLen = iMaxLen;
            }
            int i = 0;
            while (i < iLen) {
                char c = sFilename.charAt(i);
                sRet = "*\\/:?\"<>|".indexOf(c) >= 0 ? String.valueOf(sRet) + sRepChar : String.valueOf(sRet) + c;
                ++i;
            }
        }
        return sRet;
    }

    public static String createNonExistingFilenameFromLabel(String sLabel, File fOutDir) {
        String fileName = EGPFile.cleanFilename(sLabel, "_", 124);
        if (!fileName.toLowerCase().endsWith(".sas")) {
            fileName = String.valueOf(fileName) + ".sas";
        }
        File newFile = new File(fOutDir, fileName);
        int iExtCounter = 0;
        boolean bExist = newFile.exists();
        while (bExist) {
            fileName = EGPFile.cleanFilename(String.valueOf(sLabel) + "_" + ++iExtCounter, "_", 124);
            if (!fileName.toLowerCase().endsWith(".sas")) {
                fileName = String.valueOf(fileName) + ".sas";
            }
            newFile = new File(fOutDir, fileName);
            bExist = newFile.exists();
        }
        return fileName;
    }

    public static Node findChildElement(Node baseNode, String sNodeName) {
        Node eResult = null;
        if (baseNode.hasChildNodes()) {
            NodeList curNodelist = baseNode.getChildNodes();
            int i = 0;
            while (i < curNodelist.getLength()) {
                Element eElement;
                Node curNode = curNodelist.item(i);
                if (curNode.getNodeType() == 1 && (eElement = (Element)curNode).getNodeName().equals(sNodeName)) {
                    eResult = curNode;
                    break;
                }
                ++i;
            }
        }
        return eResult;
    }

    public static Node getNodeFromPath(Node doc, String sPath) {
        Node nResult = null;
        String sTemp = "";
        if (doc != null) {
            Node baseElement = doc;
            sTemp = sPath.startsWith("/") ? sPath.substring(1) : sPath;
            String[] saPath = sTemp.split("/");
            boolean bFound = true;
            int i = 0;
            while (i < saPath.length) {
                Node currElement = EGPFile.findChildElement(baseElement, saPath[i]);
                if (currElement == null) {
                    bFound = false;
                    break;
                }
                baseElement = currElement;
                ++i;
            }
            if (bFound) {
                nResult = baseElement;
            }
        }
        return nResult;
    }

    public static String findExternalLinkEntry(String sCurPath, String sFullPath, String sParentName, String sName, String sSep) {
        String sRes = "";
        String sRel = String.valueOf(sParentName) + sSep + sName;
        boolean bFinished = false;
        while (!bFinished) {
            int iFound = sFullPath.indexOf(sRel);
            if (iFound >= 0) {
                String sTempEntry = sRel;
                File fRel = new File(sCurPath, sTempEntry);
                if (fRel.exists() && fRel.isFile()) {
                    sRes = sTempEntry;
                    bFinished = true;
                    continue;
                }
                if (iFound > 1) {
                    int iSepFound = sFullPath.lastIndexOf(sSep, iFound - 2);
                    if (iSepFound < 0) continue;
                    sRel = sFullPath.substring(iSepFound + 1);
                    continue;
                }
                bFinished = true;
                continue;
            }
            bFinished = true;
        }
        if (sRes.equals("")) {
            sRes = sFullPath;
        }
        return sRes;
    }

    public static String listToString(List list) {
        String sRes = "";
        int iLen = list.size();
        int i = 0;
        while (i < iLen) {
            sRes = String.valueOf(sRes) + list.get(i).toString() + SysNewLine;
            ++i;
        }
        return sRes;
    }

    public void setMyParent(SAS_EG_Plugin myParent) {
        this.myParent = myParent;
    }
}

